/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.utils;

import com.nuomi.Main;
import com.nuomi.data.GetVersion;
import com.nuomi.dialogs.MessageBox;
import com.nuomi.utils.Methods;
import com.nuomi.utils.UserInterface;
import com.sun.lwuit.Display;
import javax.microedition.io.ConnectionNotFoundException;

public class PhoneFunction {
    private static PhoneFunction s_PhoneFunction = null;
    private static final String[] company = new String[]{"nokia", "motorola", "siemens", "sonyericsson"};
    private static final String[] companyPropertyString = new String[]{"com.nokia.mid.imei", "phone.IMEI", "com.siemens.IMEI", "com.sonyericsson.imei"};

    public static void callNuomiServicePhone() {
        PhoneFunction.callTelePhone("4006-888-887");
    }

    public static void callSendSMS(String content) {
        if (s_PhoneFunction == null) {
            s_PhoneFunction = new PhoneFunction();
        }
        s_PhoneFunction.sendSMS(content);
    }

    public static void callTelePhone(String number) {
        if (s_PhoneFunction == null) {
            s_PhoneFunction = new PhoneFunction();
        }
        s_PhoneFunction.telePhone(PhoneFunction.parserPhoneNumber(number));
    }

    public static void callBrowser(String url) {
        if (s_PhoneFunction == null) {
            s_PhoneFunction = new PhoneFunction();
        }
        s_PhoneFunction.runBrowser(url);
    }

    public static String checkVersion(GetVersion getVersion) {
        if (getVersion != null) {
            if (Methods.checkHasNewVersion(PhoneFunction.getVersion(), getVersion.version)) {
                boolean needCompelUpdate;
                boolean bl = needCompelUpdate = getVersion.needCompelUpdate != null && getVersion.needCompelUpdate != false;
                if (!MessageBox.isShow) {
                    String msg = "\u6700\u65b0\u7248\u672c:" + getVersion.version + (needCompelUpdate ? "(\u5fc5\u9700\u66f4\u65b0)" : "");
                    if (!Methods.isNullOrWhitespace(getVersion.describe)) {
                        msg = String.valueOf(msg) + "\r\n" + getVersion.describe;
                    }
                    if (MessageBox.Show(msg, "\u7acb\u5373\u66f4\u65b0", needCompelUpdate ? null : "\u6682\u4e0d\u66f4\u65b0", UserInterface.FONT_NORMAL) == MessageBox.OK) {
                        PhoneFunction.callBrowser(getVersion.url);
                    }
                }
                return null;
            }
            return "\u5df2\u7ecf\u662f\u6700\u65b0\u7248\u672c";
        }
        return null;
    }

    public static boolean isPhoneNumber(String string) {
        if (string.length() == 11) {
            int i = 0;
            while (i < 11) {
                char ch = string.charAt(i);
                if (ch > '9' || ch < '0') {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static String parserPhoneNumber(String str) {
        if (str == null) {
            return null;
        }
        String b = new String();
        boolean startNum = false;
        int i = 0;
        while (i < str.length()) {
            if (str.charAt(i) <= '9' && str.charAt(i) >= '0') {
                startNum = true;
                b = String.valueOf(b) + str.charAt(i);
            } else if (startNum && (b.startsWith("400") || b.startsWith("800") ? b.length() >= 10 : b.length() >= 8)) break;
            ++i;
        }
        if (b.length() < 7) {
            return null;
        }
        return b;
    }

    public static String getModel() {
        String model = System.getProperty("microedition.platform");
        if (model == null) {
            return null;
        }
        int index = model.indexOf(47);
        if (index > -1) {
            return model.substring(0, index);
        }
        return model;
    }

    public static String getImei() {
        String model = PhoneFunction.getModel().toLowerCase();
        if (model == null) {
            return System.getProperty("imei");
        }
        int comCount = company.length;
        int i = 0;
        while (i < comCount) {
            if (model.startsWith(company[i])) {
                return System.getProperty(companyPropertyString[i]);
            }
            ++i;
        }
        return System.getProperty("imei");
    }

    public static String getChannel() {
        return Main.mainMIDlet.getAppProperty("Nuomi-Channel");
    }

    public static String getResolution() {
        return String.valueOf(Display.getInstance().getDisplayWidth()) + "x" + Display.getInstance().getDisplayHeight();
    }

    public static String getWidth() {
        return String.valueOf(Display.getInstance().getDisplayWidth());
    }

    public static String getHeight() {
        return String.valueOf(Display.getInstance().getDisplayHeight());
    }

    public static String getAppName() {
        return Main.mainMIDlet.getAppProperty("MIDlet-Name");
    }

    public static String getIp() {
        return "";
    }

    public static String getVersion() {
        return Main.mainMIDlet.getAppProperty("MIDlet-Version");
    }

    public static String getBuildDay() {
        return Main.mainMIDlet.getAppProperty("Build-Day");
    }

    private void sendSMS(String content) {
        if (Main.mainMIDlet != null && content != null) {
            try {
                Main.mainMIDlet.platformRequest("sms:?body=" + content);
            }
            catch (ConnectionNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    private void telePhone(String number) {
        if (Main.mainMIDlet != null && number != null) {
            try {
                Main.mainMIDlet.platformRequest("tel:" + number);
            }
            catch (ConnectionNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    private void runBrowser(String url) {
        if (Main.mainMIDlet != null && url != null && url.length() > 0) {
            try {
                Main.mainMIDlet.platformRequest(url);
            }
            catch (ConnectionNotFoundException e) {
                e.printStackTrace();
            }
        }
    }
}

