/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.utils;

import com.nuomi.usercontrol.Button;
import com.nuomi.utils.UserImages;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Display;
import com.sun.lwuit.Font;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.TextArea;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.layouts.CoordinateLayout;
import com.sun.lwuit.plaf.Border;
import com.sun.lwuit.plaf.Style;
import java.util.Hashtable;

public class UserInterface {
    public static int DISPLAY_WIDTH = 0;
    public static int DISPLAY_HEIGHT = 0;
    public static final int IMAGE_WIDTH = 165;
    public static final int IMAGE_HEIGHT = 99;
    public static final int TINY_IMAGE_WIDTH = 150;
    public static final int TINY_IMAGE_HEIGHT = 90;
    public static final int CONTENT_MARGIN = 5;
    public static final int BUTTON_PADDING = 5;
    public static final String SERVICE_PHONE_TITLE = "\u7cef\u7c73\u5ba2\u670d";
    public static final String SERVICE_PHONE_NUMBER = "4006-888-887";
    public static final String NO_BUSINESS_ADDRESS_STRING = "\u5546\u5bb6\u6682\u672a\u63d0\u4f9b\u5730\u5740\u4fe1\u606f";
    public static final String NO_BUSINESS_PHONE_STRING = "\u5546\u5bb6\u6682\u672a\u63d0\u4f9b\u7535\u8bdd\u4fe1\u606f";
    public static final String NO_BUSINESS_STRING = "\u5546\u5bb6\u6682\u672a\u63d0\u4f9b\u5e97\u9762\u4fe1\u606f";
    public static final int COLOR_TOPMORE_FG = 6059405;
    public static final int COLOR_HINT = 15492920;
    public static final int COLOR_FOCUS = 7641018;
    public static final int COLOR_TITLE_FG = 0xFFFFFF;
    public static final int COLOR_HIGHLIGHT = 5535643;
    public static final int COLOR_LOWLIGHT = 9084854;
    public static final int COLOR_UNFOCUSED = 0xD2D2D2;
    public static final int COLOR_CONTENT_FG = 6453130;
    public static final int COLOR_DISABLED_FG = 0x919191;
    public static final int COLOR_SUCCEED_FG = 6479476;
    public static final int COLOR_FAILED_FG = 0xFF5858;
    public static final int TRANSPARENCY_ZERO = 0;
    public static final int TRANSPARENCY_HALF = 128;
    public static final int TRANSPARENCY_OPAQUE = 255;
    public static final Font FONT_TITLEBAR = Font.createSystemFont(0, 1, 0);
    public static final Font FONT_NORMAL = Font.createSystemFont(0, 1, 8);
    public static Font FONT_LARGE = null;
    public static Font FONT_SMALL = null;
    public static Font FONT_STATIC_WORD = null;
    public static Font FONT_ABOUT_CONTENT = null;
    public static Font FONT_FEEDBACK = null;
    public static Font FONT_MESSAGEBOX = null;
    public static Font FONT_BUTTONTEXT = null;
    public static Font FONT_OPTION = null;

    public static void init() {
        DISPLAY_WIDTH = Display.getInstance().getDisplayWidth();
        DISPLAY_HEIGHT = Display.getInstance().getDisplayHeight();
    }

    public static Label createNuomiLogoLabel() {
        int logoWidth = UserImages.NUOMI_LOGO_BG_IMAGE.getWidth();
        int logoHeight = UserImages.NUOMI_LOGO_BG_IMAGE.getHeight();
        Label label = new Label();
        label.setPreferredW(logoWidth);
        label.setPreferredH(logoHeight);
        label.setEnabled(false);
        label.getDisabledStyle().setBgImage(UserImages.NUOMI_LOGO_BG_IMAGE);
        return label;
    }

    public static Label createAreaLabel(String text, int width) {
        Label areaLabel = new Label(text);
        areaLabel.setPreferredH(UserImages.NUOMI_AREA_BG_IMAGE.getHeight());
        areaLabel.setPreferredW(width);
        areaLabel.getStyle().setAlignment(4);
        areaLabel.getStyle().setFgColor(0xFFFFFF);
        areaLabel.getStyle().setBgImage(UserImages.NUOMI_AREA_BG_IMAGE);
        areaLabel.getStyle().setPadding(1, 13);
        areaLabel.getStyle().setPadding(3, 13);
        areaLabel.setEndsWith3Points(true);
        areaLabel.setTickerEnabled(false);
        return areaLabel;
    }

    public static Label createLongAreaLabel(String text, int width) {
        Label areaLabel = new Label(text);
        areaLabel.setPreferredH(UserImages.NUOMI_LONG_AREA_BG_IMAGE.getHeight());
        areaLabel.setPreferredW(width);
        areaLabel.getStyle().setAlignment(4);
        areaLabel.getStyle().setFgColor(0xFFFFFF);
        areaLabel.getStyle().setBgImage(UserImages.NUOMI_LONG_AREA_BG_IMAGE);
        areaLabel.getStyle().setPadding(1, 13);
        areaLabel.getStyle().setPadding(3, 13);
        areaLabel.setEndsWith3Points(true);
        areaLabel.setTickerEnabled(false);
        return areaLabel;
    }

    public static Button createListBoxItemButton() {
        Button button = new Button();
        Style[] styles = UserInterface.getComponentStyles(button);
        int i = 0;
        while (i < styles.length) {
            Style style = styles[i];
            style.setBorder(null);
            style.setBgImage(i == 4 ? UserImages.NUOMI_LISTBOXITEM_PRESSED_BG_IMAGE : UserImages.NUOMI_LISTBOXITEM_BG_IMAGE);
            ++i;
        }
        return button;
    }

    public static Button createEmptyButton() {
        Button button = new Button();
        Style[] styles = UserInterface.getComponentStyles(button);
        int i = 0;
        while (i < styles.length) {
            Style style = styles[i];
            style.setBorder(null);
            style.setAlignment(4);
            style.setBgTransparency(0);
            style.setFgColor(6453130);
            ++i;
        }
        return button;
    }

    public static Button createEmptyButton(Font font) {
        Button button = new Button();
        Style[] styles = UserInterface.getComponentStyles(button);
        int i = 0;
        while (i < styles.length) {
            Style style = styles[i];
            style.setBorder(null);
            style.setAlignment(4);
            style.setBgTransparency(0);
            style.setFgColor(6453130);
            style.setFont(font);
            ++i;
        }
        return button;
    }

    public static Button createIconOnlyButton(Image icon, Image pressedIcon) {
        Button button = new Button();
        if (icon != null) {
            button.setIcon(icon);
        }
        if (pressedIcon != null) {
            button.setPressedIcon(pressedIcon);
        }
        Style[] styles = UserInterface.getComponentStyles(button);
        int i = 0;
        while (i < styles.length) {
            Style style = styles[i];
            style.setBorder(null);
            style.setAlignment(4);
            style.setBgTransparency(0);
            ++i;
        }
        return button;
    }

    public static Button createSelectionItemButton(boolean showBorder) {
        Button button = new Button();
        Style[] styles = UserInterface.getComponentStyles(button);
        int i = 0;
        while (i < styles.length) {
            Style style = styles[i];
            style.setFont(FONT_NORMAL);
            style.setFgColor(6453130);
            style.setAlignment(4);
            style.setPadding(0, 5);
            style.setPadding(2, 5);
            if (i == 4) {
                style.setBgTransparency(255);
                style.setBgColor(7641018);
            } else {
                style.setBgTransparency(0);
            }
            if (showBorder) {
                style.setBorder(Border.createCompoundBorder(null, Border.createLineBorder(1, 0xC0C0C0), null, null));
            } else {
                style.setBorder(null);
            }
            ++i;
        }
        return button;
    }

    public static Button createSelectionItemButton() {
        return UserInterface.createSelectionItemButton(true);
    }

    public static Button createButton(String text) {
        Button button = new Button();
        if (text != null) {
            button.setText(text);
        }
        button.setEndsWith3Points(false);
        button.setPreferredW(UserImages.BUTTON_BG_IMAGE.getWidth());
        button.setPreferredH(UserImages.BUTTON_BG_IMAGE.getHeight());
        Style[] styles = UserInterface.getComponentStyles(button);
        int i = 0;
        while (i < styles.length) {
            Style style = styles[i];
            style.setBorder(null);
            style.setAlignment(4);
            style.setFont(FONT_BUTTONTEXT);
            switch (i) {
                case 0: 
                case 1: 
                case 2: {
                    style.setFgColor(0xFFFFFF);
                    style.setBgImage(UserImages.BUTTON_BG_IMAGE);
                    break;
                }
                case 3: {
                    style.setFgColor(0x919191);
                    style.setBgImage(UserImages.BUTTON_DISABLED_BG_IMAGE);
                    break;
                }
                case 4: {
                    style.setFgColor(0xFFFFFF);
                    style.setBgImage(UserImages.BUTTON_PRESSED_BG_IMAGE);
                    break;
                }
            }
            ++i;
        }
        return button;
    }

    public static Button createButton() {
        return UserInterface.createButton(null);
    }

    public static Button createBigButton(String text) {
        Button button = new Button();
        if (text != null) {
            button.setText(text);
        }
        button.setEndsWith3Points(false);
        button.setPreferredW(UserImages.BIG_BUTTON_BG_IMAGE.getWidth());
        button.setPreferredH(UserImages.BIG_BUTTON_BG_IMAGE.getHeight());
        Style[] styles = UserInterface.getComponentStyles(button);
        int i = 0;
        while (i < styles.length) {
            Style style = styles[i];
            style.setBorder(null);
            style.setAlignment(4);
            style.setFont(FONT_BUTTONTEXT);
            switch (i) {
                case 0: 
                case 1: 
                case 2: {
                    style.setFgColor(0xFFFFFF);
                    style.setBgImage(UserImages.BIG_BUTTON_BG_IMAGE);
                    break;
                }
                case 3: {
                    style.setFgColor(0x919191);
                    style.setBgImage(UserImages.BUTTON_DISABLED_BG_IMAGE);
                    break;
                }
                case 4: {
                    style.setFgColor(0xFFFFFF);
                    style.setBgImage(UserImages.BIG_BUTTON_PRESSED_BG_IMAGE);
                    break;
                }
            }
            ++i;
        }
        return button;
    }

    public static Button createBigButton() {
        return UserInterface.createBigButton(null);
    }

    public static TextArea createTextArea() {
        TextArea textArea = new TextArea(){

            public boolean isScrollableY() {
                return false;
            }
        };
        textArea.setPreferredH(textArea.getPreferredH() - 2);
        textArea.setScrollVisible(false);
        textArea.setWrapBySpace(false);
        textArea.setHint("");
        textArea.getHintLabel().getStyle().setFont(FONT_STATIC_WORD);
        textArea.getHintLabel().getStyle().setFgColor(0xD2D2D2);
        textArea.getHintLabel().getStyle().setMargin(1, 15);
        Style[] styles = UserInterface.getComponentStyles(textArea);
        int i = 0;
        while (i < styles.length) {
            styles[i].setBorder(null);
            styles[i].setBgTransparency(0);
            if (i == 3) {
                styles[i].setFgColor(0x919191);
            } else {
                styles[i].setFgColor(6453130);
            }
            ++i;
        }
        return textArea;
    }

    public static Container createRefundContainer(boolean daysOrExpired, boolean canRefund) {
        Image icon;
        int width = UserImages.DEALDETAIL_REFUND_BG_IMAGE.getWidth();
        int height = UserImages.DEALDETAIL_REFUND_BG_IMAGE.getHeight();
        Container layoutContainer = new Container(new BorderLayout());
        Container container = new Container(new CoordinateLayout(width, height));
        container.setPreferredW(width);
        container.setPreferredH(height);
        container.getStyle().setBgImage(UserImages.DEALDETAIL_REFUND_BG_IMAGE);
        Image image = daysOrExpired ? (canRefund ? UserImages.DEALDETAIL_REFUND_7DAY_IMAGE : UserImages.DEALDETAIL_REFUND_7DAY_NO_IMAGE) : (icon = canRefund ? UserImages.DEALDETAIL_REFUND_EXPIRED_IMAGE : UserImages.DEALDETAIL_REFUND_EXPIRED_NO_IMAGE);
        String text = daysOrExpired ? (canRefund ? "\u652f\u6301  \"7\u5929\u9000\u6b3e\"" : "\u4e0d\u652f\u6301  \"7\u5929\u9000\u6b3e\"") : (canRefund ? "\u652f\u6301  \"\u8fc7\u671f\u9000\u6b3e\"" : "\u4e0d\u652f\u6301  \"\u8fc7\u671f\u9000\u6b3e\"");
        int iconWidth = 52;
        Label iconLabel = new Label(icon);
        iconLabel.setPreferredW(iconWidth);
        iconLabel.setPreferredH(height);
        container.addComponent(iconLabel);
        iconLabel.setX(0);
        iconLabel.setY(0);
        Label textLabel = new Label(text);
        textLabel.setPreferredW(width - iconWidth);
        textLabel.setPreferredH(height);
        textLabel.getStyle().setFont(FONT_BUTTONTEXT);
        textLabel.getStyle().setAlignment(4);
        container.addComponent(textLabel);
        textLabel.setX(iconWidth);
        textLabel.setY(0);
        layoutContainer.setPreferredW(width);
        layoutContainer.setPreferredH(height);
        layoutContainer.addComponent("West", (Component)container);
        return layoutContainer;
    }

    public static Style[] getComponentStyles(Component component) {
        if (component instanceof Button) {
            Button button = (Button)component;
            Style[] styles = new Style[]{button.getStyle(), button.getSelectedStyle(), button.getUnselectedStyle(), button.getDisabledStyle(), button.getPressedStyle()};
            return styles;
        }
        Style[] styles = new Style[]{component.getStyle(), component.getSelectedStyle(), component.getUnselectedStyle(), component.getDisabledStyle()};
        return styles;
    }

    public static Hashtable getBundle() {
        Hashtable<String, String> resourceBundle = new Hashtable<String, String>();
        resourceBundle.put("ok", "\u786e\u5b9a");
        resourceBundle.put("cancel", "\u53d6\u6d88");
        resourceBundle.put("select", "\u9009\u62e9");
        resourceBundle.put("menu", "\u9009\u9879");
        resourceBundle.put("Sunday", "\u661f\u671f\u65e5");
        resourceBundle.put("Monday", "\u661f\u671f\u4e00");
        resourceBundle.put("Tuesday", "\u661f\u671f\u4e8c");
        resourceBundle.put("Wednesday", "\u661f\u671f\u4e09");
        resourceBundle.put("Thursday", "\u661f\u671f\u56db");
        resourceBundle.put("Friday", "\u661f\u671f\u4e94");
        resourceBundle.put("Saturday", "\u661f\u671f\u516d");
        resourceBundle.put("exit", "\u9000\u51fa");
        resourceBundle.put("back", "\u8fd4\u56de");
        return resourceBundle;
    }
}

