/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Command;
import com.sun.lwuit.Component;
import com.sun.lwuit.Display;
import com.sun.lwuit.Form;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.plaf.Border;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.plaf.UIManager;
import com.sun.lwuit.util.EventDispatcher;
import java.util.Vector;

public class Button
extends Label {
    public static final int STATE_ROLLOVER = 0;
    public static final int STATE_PRESSED = 1;
    public static final int STATE_DEFAULT = 2;
    private EventDispatcher dispatcher = new EventDispatcher();
    private int state = 2;
    private Image pressedIcon;
    private Image rolloverIcon;
    private Command cmd;
    private Style pressedStyle;

    public Button() {
        this("");
    }

    public Button(String text) {
        this(text, (Image)null);
    }

    public Button(Command cmd) {
        this(cmd.getCommandName(), cmd.getIcon());
        this.addActionListener(cmd);
        this.cmd = cmd;
    }

    public void setCommand(Command cmd) {
        if (this.cmd != null) {
            this.removeActionListener(this.cmd);
        }
        this.cmd = cmd;
        this.setText(cmd.getCommandName());
        this.setIcon(cmd.getIcon());
        this.addActionListener(cmd);
    }

    public Button(Image icon) {
        this("", icon);
    }

    public Button(String text, Image icon) {
        super(text);
        this.setUIID("Button");
        this.setFocusable(true);
        this.setIcon(icon);
        this.pressedIcon = icon;
        this.rolloverIcon = icon;
    }

    public void setUIID(String id) {
        super.setUIID(id);
        this.pressedStyle = null;
    }

    void focusGainedInternal() {
        super.focusGainedInternal();
        this.state = 0;
    }

    void focusLostInternal() {
        super.focusLostInternal();
        this.state = 2;
    }

    public int getState() {
        return this.state;
    }

    public Image getPressedIcon() {
        return this.pressedIcon;
    }

    public Image getRolloverIcon() {
        return this.rolloverIcon;
    }

    public void setRolloverIcon(Image rolloverIcon) {
        this.rolloverIcon = rolloverIcon;
        this.setShouldCalcPreferredSize(true);
        this.checkAnimation();
        this.repaint();
    }

    public void setPressedIcon(Image pressedIcon) {
        this.pressedIcon = pressedIcon;
        this.setShouldCalcPreferredSize(true);
        this.checkAnimation();
        this.repaint();
    }

    void checkAnimation() {
        Form parent;
        super.checkAnimation();
        if ((this.pressedIcon != null && this.pressedIcon.isAnimation() || this.rolloverIcon != null && this.rolloverIcon.isAnimation()) && (parent = this.getComponentForm()) != null) {
            parent.registerAnimated(this);
        }
    }

    public void addActionListener(ActionListener l) {
        this.dispatcher.addListener(l);
    }

    public void removeActionListener(ActionListener l) {
        this.dispatcher.removeListener(l);
    }

    public Image getIconFromState() {
        Image icon = null;
        switch (this.getState()) {
            case 2: {
                icon = this.getIcon();
                break;
            }
            case 1: {
                icon = this.getPressedIcon();
                if (icon != null) break;
                icon = this.getIcon();
                break;
            }
            case 0: {
                icon = this.getRolloverIcon();
                if (icon != null) break;
                icon = this.getIcon();
            }
        }
        return icon;
    }

    void fireActionEvent() {
        super.fireActionEvent();
        if (this.cmd != null) {
            Form f;
            ActionEvent ev = new ActionEvent(this.cmd);
            this.dispatcher.fireActionEvent(ev);
            if (!ev.isConsumed() && (f = this.getComponentForm()) != null) {
                f.actionCommandImpl(this.cmd);
            }
        } else {
            this.dispatcher.fireActionEvent(new ActionEvent(this));
        }
    }

    void pressed() {
        this.state = 1;
        this.repaint();
    }

    void released() {
        this.state = 0;
        this.repaint();
        this.fireActionEvent();
    }

    public void keyPressed(int keyCode) {
        if (Display.getInstance().getGameAction(keyCode) == 8) {
            this.pressed();
        }
    }

    public void keyReleased(int keyCode) {
        if (Display.getInstance().getGameAction(keyCode) == 8) {
            this.released();
        }
    }

    public void keyRepeated(int keyCode) {
    }

    protected void fireClicked() {
        this.pressed();
        this.released();
    }

    protected boolean isSelectableInteraction() {
        return true;
    }

    public void pointerHover(int[] x, int[] y) {
        this.requestFocus();
    }

    public void pointerHoverReleased(int[] x, int[] y) {
        this.requestFocus();
    }

    public void pointerPressed(int x, int y) {
        this.clearDrag();
        this.setDragActivated(false);
        this.pressed();
    }

    public void pointerReleased(int x, int y) {
        this.released();
    }

    protected void dragInitiated() {
        this.state = 0;
        this.repaint();
    }

    public void paint(Graphics g) {
        UIManager.getInstance().getLookAndFeel().drawButton(g, this);
    }

    protected Dimension calcPreferredSize() {
        return UIManager.getInstance().getLookAndFeel().getButtonPreferredSize(this);
    }

    protected Border getBorder() {
        return this.getStyle().getBorder();
    }

    public Style getPressedStyle() {
        if (this.pressedStyle == null) {
            this.pressedStyle = UIManager.getInstance().getComponentCustomStyle(this.getUIID(), "press");
            this.pressedStyle.addStyleListener(this);
            if (this.pressedStyle.getBgPainter() == null) {
                this.pressedStyle.setBgPainter(new Component.BGPainter());
            }
        }
        return this.pressedStyle;
    }

    public void setPressedStyle(Style style) {
        if (this.pressedStyle != null) {
            this.pressedStyle.removeStyleListener(this);
        }
        this.pressedStyle = style;
        this.pressedStyle.addStyleListener(this);
        if (this.pressedStyle.getBgPainter() == null) {
            this.pressedStyle.setBgPainter(new Component.BGPainter());
        }
        this.setShouldCalcPreferredSize(true);
        this.checkAnimation();
    }

    protected void refreshTheme(String id) {
        if (this.pressedStyle != null) {
            this.setPressedStyle(this.mergeStyle(this.pressedStyle, UIManager.getInstance().getComponentCustomStyle(id, "press")));
        }
        super.refreshTheme(id);
    }

    public Style getStyle() {
        if (this.state == 1) {
            return this.getPressedStyle();
        }
        return super.getStyle();
    }

    public Command getCommand() {
        return this.cmd;
    }

    public boolean isSelected() {
        throw new RuntimeException();
    }

    public void setAlignment(int align) {
        super.setAlignment(align);
        this.getPressedStyle().setAlignment(align);
    }

    public Vector getListenerVector() {
        return this.dispatcher.getListenerVector();
    }
}

