/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Button;
import com.sun.lwuit.ComboBox;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Label;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.events.DataChangedListener;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.layouts.FlowLayout;
import com.sun.lwuit.layouts.GridLayout;
import com.sun.lwuit.list.DefaultListModel;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.plaf.UIManager;
import com.sun.lwuit.util.EventDispatcher;
import java.util.Date;
import java.util.Hashtable;
import java.util.TimeZone;
import java.util.Vector;

public class Calendar
extends Container {
    private ComboBox month;
    private ComboBox year;
    private MonthView mv;
    private static final String[] MONTHS = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static final String[] DAYS = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
    private static final String[] LABELS = new String[]{"Su", "M", "Tu", "W", "Th", "F", "Sa"};
    static final long MINUTE = 60000L;
    static final long HOUR = 3600000L;
    static final long DAY = 86400000L;
    static final long WEEK = 604800000L;
    private EventDispatcher dispatcher = new EventDispatcher();
    private EventDispatcher dataChangeListeners = new EventDispatcher();
    private long[] dates = new long[42];

    public Calendar(long time) {
        super(new BorderLayout());
        this.setUIID("Calendar");
        Container upper = new Container(new FlowLayout(4));
        this.month = new ComboBox();
        this.year = new ComboBox();
        this.mv = new MonthView(time);
        Vector<String> months = new Vector<String>();
        int i = 0;
        while (i < MONTHS.length) {
            months.addElement(this.getLocalizedMonth(i));
            ++i;
        }
        DefaultListModel monthsModel = new DefaultListModel(months);
        int selected = months.indexOf(this.getLocalizedMonth(this.mv.getMonth()));
        this.month.setModel(monthsModel);
        this.month.setSelectedIndex(selected);
        this.month.addActionListener(this.mv);
        java.util.Calendar cal = java.util.Calendar.getInstance();
        cal.setTime(new Date(time));
        this.month.getStyle().setBgTransparency(0);
        int y = cal.get(1);
        Vector<String> years = new Vector<String>();
        int i2 = 2100;
        while (i2 > 1900) {
            years.addElement("" + i2);
            --i2;
        }
        DefaultListModel yearModel = new DefaultListModel(years);
        selected = years.indexOf("" + y);
        this.year.setModel(yearModel);
        this.year.setSelectedIndex(selected);
        this.year.getStyle().setBgTransparency(0);
        this.year.addActionListener(this.mv);
        Container cnt = new Container(new BoxLayout(1));
        cnt.setRTL(false);
        Container dateCnt = new Container(new BoxLayout(1));
        dateCnt.setUIID("CalendarDate");
        dateCnt.addComponent(this.month);
        dateCnt.addComponent(this.year);
        cnt.addComponent(dateCnt);
        upper.addComponent(cnt);
        this.addComponent("North", (Component)upper);
        this.addComponent("Center", (Component)this.mv);
    }

    public Calendar() {
        this(System.currentTimeMillis());
    }

    public long getSelectedDay() {
        return this.mv.getSelectedDay();
    }

    private String getLocalizedMonth(int i) {
        Object o;
        Hashtable t = UIManager.getInstance().getResourceBundle();
        String text = MONTHS[i];
        if (t != null && (o = t.get("Calendar." + text)) != null) {
            text = (String)o;
        }
        return text;
    }

    void componentChanged() {
        java.util.Calendar cal = java.util.Calendar.getInstance();
        cal.set(1, this.mv.getYear());
        cal.set(2, this.mv.getMonth());
        cal.set(5, this.mv.getDayOfMonth());
        this.month.getParent().revalidate();
    }

    public Date getDate() {
        return new Date(this.mv.getSelectedDay());
    }

    public void setDate(Date d) {
        this.mv.setSelectedDay(d.getTime());
        this.mv.setCurrentDay(this.mv.currentDay, true);
        this.componentChanged();
    }

    public void setSelectedDate(Date d) {
        this.mv.setSelectedDay(d.getTime());
    }

    public void setCurrentDate(Date d) {
        this.mv.setCurrentDay(d.getTime(), true);
        this.componentChanged();
    }

    public void paint(Graphics g) {
        super.paint(g);
    }

    public void setMonthViewSelectedStyle(Style s) {
        this.mv.setSelectedStyle(s);
    }

    public void setMonthViewUnSelectedStyle(Style s) {
        this.mv.setUnSelectedStyle(s);
    }

    public Style getMonthViewSelectedStyle() {
        return this.mv.getSelectedStyle();
    }

    public Style getMonthViewUnSelectedStyle() {
        return this.mv.getUnselectedStyle();
    }

    public void addActionListener(ActionListener l) {
        this.mv.addActionListener(l);
    }

    public void removeActionListener(ActionListener l) {
        this.mv.removeActionListener(l);
    }

    public void addDataChangeListener(DataChangedListener l) {
        this.mv.addDataChangeListener(l);
    }

    public void removeDataChangeListener(DataChangedListener l) {
        this.mv.removeDataChangeListener(l);
    }

    protected Button createDay() {
        Button day = new Button();
        day.setAlignment(4);
        day.setUIID("CalendarDay");
        day.setEndsWith3Points(false);
        day.setTickerEnabled(false);
        return day;
    }

    protected Label createDayTitle(int day) {
        String value = UIManager.getInstance().localize(DAYS[day], LABELS[day]);
        Label dayh = new Label(value, "CalendarTitle");
        dayh.setEndsWith3Points(false);
        dayh.setTickerEnabled(false);
        return dayh;
    }

    protected Button createIncrementButton() {
        Button btn = new Button(">>");
        btn.setUIID("CalendarNavigation");
        btn.setEndsWith3Points(false);
        btn.setTickerEnabled(false);
        return btn;
    }

    protected Button createDecrementButton() {
        Button btn = new Button("<<");
        btn.setUIID("CalendarNavigation");
        btn.setEndsWith3Points(false);
        btn.setTickerEnabled(false);
        return btn;
    }

    class MonthView
    extends Container
    implements ActionListener {
        private long currentDay;
        private Button[] buttons = new Button[42];
        private Style selectedStyle;
        private Button selected;
        private long selectedDay = -1L;

        public MonthView(long time) {
            super(new GridLayout(7, 7));
            this.setUIID("MonthView");
            this.selectedStyle = UIManager.getInstance().getComponentStyle("CalendarSelectedDay");
            int iter = 0;
            while (iter < DAYS.length) {
                this.addComponent(Calendar.this.createDayTitle(iter));
                ++iter;
            }
            iter = 0;
            while (iter < this.buttons.length) {
                this.buttons[iter] = Calendar.this.createDay();
                this.addComponent(this.buttons[iter]);
                if (iter <= 7) {
                    this.buttons[iter].setNextFocusUp(Calendar.this.year);
                }
                this.buttons[iter].addActionListener(this);
                ++iter;
            }
            this.setCurrentDay(time);
        }

        public void setCurrentDay(long day) {
            this.setCurrentDay(day, false);
        }

        private void setCurrentDay(long day, boolean force) {
            this.repaint();
            java.util.Calendar cal = java.util.Calendar.getInstance();
            cal.setTime(new Date(this.currentDay));
            cal.set(10, 1);
            cal.set(11, 1);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            int yearOld = cal.get(1);
            int monthOld = cal.get(2);
            int dayOld = cal.get(5);
            cal.setTime(new Date(day));
            cal.set(10, 1);
            cal.set(11, 1);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            int yearNew = cal.get(1);
            int monthNew = cal.get(2);
            int dayNew = cal.get(5);
            Calendar.this.year.setSelectedItem("" + yearNew);
            Calendar.this.month.setSelectedIndex(monthNew);
            if (yearNew != yearOld || monthNew != monthOld || dayNew != dayOld || force) {
                this.currentDay = cal.getTime().getTime();
                if (this.selectedDay == -1L) {
                    this.selectedDay = this.currentDay;
                }
                int month = cal.get(2);
                cal.set(5, 1);
                long startDate = cal.getTime().getTime();
                int dow = cal.get(7);
                cal.setTime(new Date(cal.getTime().getTime() - 86400000L));
                cal.set(10, 1);
                cal.set(11, 1);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                int lastDay = cal.get(5);
                int i = 0;
                Style unselected = Calendar.this.createDay().getUnselectedStyle();
                if (dow > 1) {
                    while (dow > 1) {
                        cal.setTime(new Date(cal.getTime().getTime() - 86400000L));
                        dow = cal.get(7);
                    }
                    int previousMonthSunday = cal.get(5);
                    while (i <= lastDay - previousMonthSunday) {
                        this.buttons[i].setUnselectedStyle(new Style(unselected));
                        this.buttons[i].setEnabled(false);
                        this.buttons[i].setText("" + (previousMonthSunday + i));
                        ++i;
                    }
                }
                cal.set(2, (month + 1) % 12);
                cal.set(5, 1);
                cal.setTime(new Date(cal.getTime().getTime() - 86400000L));
                lastDay = cal.get(5);
                int j = i;
                while (j < this.buttons.length && j - i + 1 <= lastDay) {
                    this.buttons[j].setEnabled(true);
                    this.buttons[j].setText("" + (j - i + 1));
                    ((Calendar)Calendar.this).dates[j] = startDate;
                    if (Calendar.this.dates[j] == this.selectedDay) {
                        this.buttons[j].setUnselectedStyle(new Style(this.selectedStyle));
                        this.selected = this.buttons[j];
                    } else {
                        this.buttons[j].setUnselectedStyle(new Style(unselected));
                    }
                    startDate += 86400000L;
                    ++j;
                }
                int d = 1;
                while (j < this.buttons.length) {
                    this.buttons[j].setUnselectedStyle(new Style(unselected));
                    this.buttons[j].setEnabled(false);
                    this.buttons[j].setText("" + d++);
                    ++j;
                }
            }
        }

        public int getDayOfMonth() {
            java.util.Calendar cal = java.util.Calendar.getInstance();
            cal.setTime(new Date(this.currentDay));
            return cal.get(5);
        }

        public int getMonth() {
            java.util.Calendar cal = java.util.Calendar.getInstance();
            cal.setTime(new Date(this.currentDay));
            return cal.get(2);
        }

        public void incrementMonth() {
            int month = this.getMonth();
            int year = this.getYear();
            if (++month > 11) {
                month = 0;
                ++year;
            }
            this.setMonth(year, month);
        }

        private long getSelectedDay() {
            return this.selectedDay;
        }

        public void setSelectedDay(long selectedDay) {
            java.util.Calendar cal = java.util.Calendar.getInstance();
            cal.setTime(new Date(selectedDay));
            cal.set(10, 1);
            cal.set(11, 1);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            this.selectedDay = cal.getTime().getTime();
        }

        private void setMonth(int year, int month) {
            java.util.Calendar cal = java.util.Calendar.getInstance();
            cal.setTimeZone(TimeZone.getDefault());
            cal.set(2, month);
            cal.set(5, 1);
            cal.set(1, year);
            Date date = cal.getTime();
            long d = date.getTime();
            while (cal.get(2) != month) {
                cal.setTime(new Date(d -= 86400000L));
            }
            this.setCurrentDay(d);
        }

        public void decrementMonth() {
            int month = this.getMonth();
            int year = this.getYear();
            if (--month < 0) {
                month = 11;
                --year;
            }
            this.setMonth(year, month);
        }

        public int getYear() {
            java.util.Calendar cal = java.util.Calendar.getInstance();
            cal.setTime(new Date(this.currentDay));
            return cal.get(1);
        }

        public void addActionListener(ActionListener l) {
            Calendar.this.dispatcher.addListener(l);
        }

        public void removeActionListener(ActionListener l) {
            Calendar.this.dispatcher.removeListener(l);
        }

        public void addDataChangeListener(DataChangedListener l) {
            Calendar.this.dataChangeListeners.addListener(l);
        }

        public void removeDataChangeListener(DataChangedListener l) {
            Calendar.this.dataChangeListeners.removeListener(l);
        }

        protected void fireActionEvent() {
            Calendar.this.componentChanged();
            super.fireActionEvent();
            Calendar.this.dispatcher.fireActionEvent(new ActionEvent(Calendar.this));
        }

        public void actionPerformed(ActionEvent evt) {
            Object src = evt.getSource();
            if (src instanceof ComboBox) {
                this.setMonth(Integer.parseInt((String)Calendar.this.year.getSelectedItem()), Calendar.this.month.getSelectedIndex());
                Calendar.this.componentChanged();
                return;
            }
            int iter = 0;
            while (iter < this.buttons.length) {
                if (src == this.buttons[iter]) {
                    this.selected.setUnselectedStyle(new Style(this.buttons[iter].getUnselectedStyle()));
                    this.buttons[iter].setUnselectedStyle(new Style(this.selectedStyle));
                    this.selectedDay = Calendar.this.dates[iter];
                    this.selected = this.buttons[iter];
                    this.fireActionEvent();
                    if (!this.getComponentForm().isSingleFocusMode()) {
                        this.setHandlesInput(false);
                    }
                    return;
                }
                ++iter;
            }
        }
    }
}

