/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Container;
import com.sun.lwuit.Display;
import com.sun.lwuit.Form;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.Painter;
import com.sun.lwuit.StaticAnimation;
import com.sun.lwuit.animations.Animation;
import com.sun.lwuit.animations.Motion;
import com.sun.lwuit.events.FocusListener;
import com.sun.lwuit.events.StyleListener;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.geom.Rectangle;
import com.sun.lwuit.plaf.Border;
import com.sun.lwuit.plaf.LookAndFeel;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.plaf.UIManager;
import com.sun.lwuit.util.EventDispatcher;
import java.lang.ref.WeakReference;
import java.util.Hashtable;

public class Component
implements Animation,
StyleListener {
    private String selectText = UIManager.getInstance().localize("select", "Select");
    private Component nextFocusDown;
    private Component nextFocusUp;
    private boolean enabled = true;
    private Component nextFocusRight;
    private Component nextFocusLeft;
    private String name;
    boolean hasLead;
    private boolean tensileDragEnabled = true;
    private boolean tactileTouch;
    public static final int BRB_CONSTANT_ASCENT = 1;
    public static final int BRB_CONSTANT_DESCENT = 2;
    public static final int BRB_CENTER_OFFSET = 3;
    public static final int BRB_OTHER = 4;
    private boolean visible = true;
    private boolean cellRenderer;
    private Rectangle bounds = new Rectangle(0, 0, new Dimension(0, 0));
    private WeakReference painterBounds;
    private int scrollX;
    private int scrollY;
    private boolean sizeRequestedByUser = false;
    private Dimension preferredSize;
    private boolean scrollSizeRequestedByUser = false;
    private Dimension scrollSize;
    private Style unSelectedStyle;
    private Style selectedStyle;
    private Style disabledStyle;
    private Container parent;
    private boolean focused = false;
    private boolean focusPainted = true;
    private EventDispatcher focusListeners = new EventDispatcher();
    private boolean handlesInput = false;
    boolean shouldCalcPreferredSize = true;
    boolean shouldCalcScrollSize = true;
    private boolean focusable = true;
    private boolean isScrollVisible = true;
    private boolean repaintPending;
    private boolean smoothScrolling;
    private int animationSpeed;
    private Motion animationMotion;
    private Motion draggedMotion;
    private int initialPressX;
    private int initialPressY;
    private boolean dragActivated;
    private int initialScrollY = -1;
    private int destScrollY = -1;
    private int lastScrollY;
    private int lastScrollX;
    private boolean initialized;
    public static final int CENTER = 4;
    public static final int TOP = 0;
    public static final int LEFT = 1;
    public static final int BOTTOM = 2;
    public static final int RIGHT = 3;
    private Hashtable clientProperties;
    private Rectangle dirtyRegion = null;
    private Object dirtyRegionLock = new Object();
    private Label componentLabel;
    private String id;
    private boolean rtl;

    protected Component() {
        LookAndFeel laf = UIManager.getInstance().getLookAndFeel();
        this.animationSpeed = laf.getDefaultSmoothScrollingSpeed();
        this.rtl = laf.isRTL();
        this.tactileTouch = this.isFocusable();
        this.tensileDragEnabled = laf.isDefaultTensileDrag();
    }

    private void initStyle() {
        this.unSelectedStyle = UIManager.getInstance().getComponentStyle(this.getUIID());
        if (this.unSelectedStyle != null) {
            this.unSelectedStyle.addStyleListener(this);
            if (this.unSelectedStyle.getBgPainter() == null) {
                this.unSelectedStyle.setBgPainter(new BGPainter());
            }
        }
        if (this.disabledStyle != null) {
            this.disabledStyle.addStyleListener(this);
            if (this.disabledStyle.getBgPainter() == null) {
                this.disabledStyle.setBgPainter(new BGPainter());
            }
        }
    }

    public int getX() {
        return this.bounds.getX();
    }

    public int getY() {
        return this.bounds.getY();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public Object getClientProperty(String key) {
        if (this.clientProperties == null) {
            return null;
        }
        return this.clientProperties.get(key);
    }

    Component getLeadComponent() {
        return this.getParent().getLeadComponent();
    }

    public void putClientProperty(String key, Object value) {
        if (this.clientProperties == null) {
            if (value == null) {
                return;
            }
            this.clientProperties = new Hashtable();
        }
        if (value == null) {
            this.clientProperties.remove(key);
            if (this.clientProperties.size() == 0) {
                this.clientProperties = null;
            }
        } else {
            this.clientProperties.put(key, value);
        }
    }

    public final Rectangle getDirtyRegion() {
        return this.dirtyRegion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setDirtyRegion(Rectangle dirty) {
        Object object = this.dirtyRegionLock;
        synchronized (object) {
            this.dirtyRegion = dirty;
        }
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public int getWidth() {
        return this.bounds.getSize().getWidth();
    }

    public int getHeight() {
        return this.bounds.getSize().getHeight();
    }

    public void setX(int x) {
        this.bounds.setX(x);
    }

    public void setY(int y) {
        this.bounds.setY(y);
    }

    public int getBaseline(int width, int height) {
        return height - this.getStyle().getPadding(false, 2);
    }

    public int getBaselineResizeBehavior() {
        return 4;
    }

    public void setPreferredSize(Dimension d) {
        if (d == null) {
            this.sizeRequestedByUser = false;
            this.preferredSize = null;
            this.shouldCalcPreferredSize = true;
            return;
        }
        Dimension dim = this.preferredSize();
        dim.setWidth(d.getWidth());
        dim.setHeight(d.getHeight());
        this.sizeRequestedByUser = true;
    }

    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    Dimension getPreferredSizeWithMargin() {
        Dimension d = this.preferredSize();
        Style s = this.getStyle();
        return new Dimension(d.getWidth() + s.getMargin(1) + s.getMargin(3), d.getHeight() + s.getMargin(0) + s.getMargin(2));
    }

    public Dimension getScrollDimension() {
        if (!this.scrollSizeRequestedByUser && (this.scrollSize == null || this.shouldCalcScrollSize)) {
            int x = Math.max(this.calcScrollSize().getWidth(), this.getWidth());
            int y = Math.max(this.calcScrollSize().getHeight(), this.getHeight());
            this.scrollSize = new Dimension(x, y);
            this.shouldCalcScrollSize = false;
        }
        return this.scrollSize;
    }

    protected Dimension calcScrollSize() {
        return this.calcPreferredSize();
    }

    public boolean isScrollSizeRequestedByUser() {
        return this.scrollSizeRequestedByUser;
    }

    public void setScrollSize(Dimension d) {
        this.scrollSize = d;
        this.scrollSizeRequestedByUser = d != null;
    }

    public void setPreferredW(int preferredW) {
        this.setPreferredSize(new Dimension(preferredW, this.getPreferredH()));
    }

    public void setPreferredH(int preferredH) {
        this.setPreferredSize(new Dimension(this.getPreferredW(), preferredH));
    }

    public int getPreferredW() {
        return this.getPreferredSize().getWidth();
    }

    public int getPreferredH() {
        return this.getPreferredSize().getHeight();
    }

    public void setWidth(int width) {
        this.bounds.getSize().setWidth(width);
    }

    public void setHeight(int height) {
        this.bounds.getSize().setHeight(height);
    }

    public void setSize(Dimension d) {
        Dimension d2 = this.bounds.getSize();
        d2.setWidth(d.getWidth());
        d2.setHeight(d.getHeight());
    }

    public String getUIID() {
        return this.id;
    }

    public void setUIID(String id) {
        String tmpId = this.id;
        this.id = id;
        if (tmpId != null && !tmpId.equals(id)) {
            this.initStyle();
        }
        this.selectedStyle = null;
        this.disabledStyle = null;
    }

    public Container getParent() {
        return this.parent;
    }

    void setParent(Container parent) {
        this.parent = parent;
    }

    public void addFocusListener(FocusListener l) {
        this.focusListeners.addListener(l);
    }

    public void removeFocusListener(FocusListener l) {
        this.focusListeners.removeListener(l);
    }

    protected void fireClicked() {
    }

    protected boolean isSelectableInteraction() {
        return false;
    }

    void fireFocusGained() {
        this.fireFocusGained(this);
    }

    void fireFocusLost() {
        this.fireFocusLost(this);
    }

    void fireFocusGained(Component cmp) {
        Form f;
        if (cmp.isCellRenderer()) {
            return;
        }
        this.focusListeners.fireFocus(cmp);
        this.focusGainedInternal();
        this.focusGained();
        if (this.isSelectableInteraction() && (f = this.getComponentForm()) != null) {
            f.getMenuBar().addSelectCommand(this.getSelectCommandText());
        }
    }

    public void setSelectCommandText(String selectText) {
        this.selectText = selectText;
    }

    public String getSelectCommandText() {
        return this.selectText;
    }

    void fireFocusLost(Component cmp) {
        Form f;
        if (cmp.isCellRenderer()) {
            return;
        }
        if (this.isSelectableInteraction() && (f = this.getComponentForm()) != null) {
            f.getMenuBar().removeSelectCommand();
        }
        this.focusListeners.fireFocus(cmp);
        this.focusLostInternal();
        this.focusLost();
    }

    void fireActionEvent() {
    }

    public void setLabelForComponent(Label componentLabel) {
        this.componentLabel = componentLabel;
    }

    public Label getLabelForComponent() {
        return this.componentLabel;
    }

    void focusGainedInternal() {
        this.startComponentLableTicker();
    }

    void startComponentLableTicker() {
        if (this.componentLabel != null && this.componentLabel.isTickerEnabled() && this.componentLabel.shouldTickerStart()) {
            this.componentLabel.startTicker(UIManager.getInstance().getLookAndFeel().getTickerSpeed(), true);
        }
    }

    void stopComponentLableTicker() {
        if (this.componentLabel != null && this.componentLabel.isTickerEnabled() && this.componentLabel.isTickerRunning()) {
            this.componentLabel.stopTicker();
        }
    }

    protected void focusGained() {
    }

    protected void focusLost() {
    }

    void focusLostInternal() {
        this.stopComponentLableTicker();
    }

    public void paintBackgrounds(Graphics g) {
        this.drawPainters(g, this.getParent(), this, this.getAbsoluteX() + this.getScrollX(), this.getAbsoluteY() + this.getScrollY(), this.getWidth(), this.getHeight());
    }

    public int getAbsoluteX() {
        int x = this.getX() - this.getScrollX();
        Container parent = this.getParent();
        if (parent != null) {
            x += parent.getAbsoluteX();
        }
        return x;
    }

    public int getAbsoluteY() {
        int y = this.getY() - this.getScrollY();
        Container parent = this.getParent();
        if (parent != null) {
            y += parent.getAbsoluteY();
        }
        return y;
    }

    final void paintInternal(Graphics g) {
        this.paintInternal(g, true);
    }

    final void paintInternal(Graphics g, boolean paintIntersects) {
        int oHeight;
        int oWidth;
        int oY;
        if (!this.isVisible()) {
            return;
        }
        int oX = g.getClipX();
        if (this.bounds.intersects(oX, oY = g.getClipY(), oWidth = g.getClipWidth(), oHeight = g.getClipHeight())) {
            g.clipRect(this.getX(), this.getY(), this.getWidth(), this.getHeight());
            this.paintBackground(g);
            if (this.isScrollable()) {
                int scrollX = this.getScrollX();
                int scrollY = this.getScrollY();
                g.translate(-scrollX, -scrollY);
                this.paint(g);
                g.translate(scrollX, scrollY);
                if (this.isScrollVisible) {
                    this.paintScrollbars(g);
                }
            } else {
                this.paint(g);
            }
            if (this.isBorderPainted()) {
                this.paintBorder(g);
            }
            if (paintIntersects && this.parent != null) {
                this.paintIntersectingComponentsAbove(g);
            }
            g.setClip(oX, oY, oWidth, oHeight);
        }
    }

    private void paintIntersectingComponentsAbove(Graphics g) {
        Container parent = this.getParent();
        Component component = this;
        int tx = g.getTranslateX();
        int ty = g.getTranslateY();
        g.translate(-tx, -ty);
        while (parent != null) {
            g.translate(parent.getAbsoluteX() + parent.getScrollX(), parent.getAbsoluteY() + parent.getScrollY());
            parent.paintIntersecting(g, component, this.getAbsoluteX() + this.getScrollX(), this.getAbsoluteY() + this.getScrollY(), this.getWidth(), this.getHeight(), true);
            g.translate(-parent.getAbsoluteX() - parent.getScrollX(), -parent.getAbsoluteY() - parent.getScrollY());
            component = parent;
            parent = parent.getParent();
        }
        g.translate(tx, ty);
    }

    protected void paintScrollbars(Graphics g) {
        if (this.isScrollableX()) {
            this.paintScrollbarX(g);
        }
        if (this.isScrollableY()) {
            this.paintScrollbarY(g);
        }
    }

    protected void paintScrollbarX(Graphics g) {
        float scrollW = this.getScrollDimension().getWidth();
        float block = (float)this.getWidth() / scrollW;
        float offset = (float)(this.getScrollX() + this.getWidth()) == scrollW ? 1.0f - block : ((float)this.getScrollX() + (float)this.getWidth()) / scrollW - block;
        UIManager.getInstance().getLookAndFeel().drawHorizontalScroll(g, this, offset, block);
    }

    protected void paintScrollbarY(Graphics g) {
        float scrollH = this.getScrollDimension().getHeight();
        float block = (float)this.getHeight() / scrollH;
        float offset = (float)(this.getScrollY() + this.getHeight()) == scrollH ? 1.0f - block : ((float)this.getScrollY() + (float)this.getHeight()) / scrollH - block;
        UIManager.getInstance().getLookAndFeel().drawVerticalScroll(g, this, offset, block);
    }

    public final void paintComponent(Graphics g) {
        this.repaintPending = false;
        this.paintComponent(g, true);
    }

    public final void paintComponent(Graphics g, boolean background) {
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipW = g.getClipWidth();
        int clipH = g.getClipHeight();
        Container parent = this.getParent();
        int translateX = 0;
        int translateY = 0;
        while (parent != null) {
            translateX += parent.getX();
            translateY += parent.getY();
            if (parent.isScrollableX()) {
                translateX -= parent.getScrollX();
            }
            if (parent.isScrollableY()) {
                translateY -= parent.getScrollY();
            }
            int parentX = parent.getAbsoluteX() + parent.getScrollX();
            if (this.isRTL()) {
                parentX += parent.getSideGap();
            }
            g.clipRect(parentX, parent.getAbsoluteY() + parent.getScrollY(), parent.getWidth() - parent.getSideGap(), parent.getHeight() - parent.getBottomGap());
            parent = parent.getParent();
        }
        g.clipRect(translateX + this.getX(), translateY + this.getY(), this.getWidth(), this.getHeight());
        if (background) {
            this.paintBackgrounds(g);
        }
        g.translate(translateX, translateY);
        this.paintInternal(g);
        g.translate(-translateX, -translateY);
        this.paintGlassImpl(g);
        g.setClip(clipX, clipY, clipW, clipH);
    }

    void paintGlassImpl(Graphics g) {
        if (this.parent != null) {
            this.parent.paintGlassImpl(g);
        }
    }

    private void drawPainters(Graphics g, Component par, Component c, int x, int y, int w, int h) {
        Border b;
        if (par == null) {
            return;
        }
        if (par.getStyle().getBgTransparency() != -1) {
            this.drawPainters(g, par.getParent(), par, x, y, w, h);
        }
        if (!par.isVisible()) {
            return;
        }
        int transX = par.getAbsoluteX() + par.getScrollX();
        int transY = par.getAbsoluteY() + par.getScrollY();
        g.translate(transX, transY);
        ((Container)par).paintIntersecting(g, c, x, y, w, h, false);
        if (par.isBorderPainted() && (b = par.getBorder()).isBackgroundPainter()) {
            g.translate(-par.getX(), -par.getY());
            b.paintBorderBackground(g, par);
            b.paint(g, par);
            g.translate(par.getX() - transX, par.getY() - transY);
            return;
        }
        Painter p = par.getStyle().getBgPainter();
        if (p != null) {
            Rectangle rect;
            if (this.painterBounds == null || this.painterBounds.get() == null) {
                rect = new Rectangle(0, 0, par.getWidth(), par.getHeight());
                this.painterBounds = new WeakReference<Rectangle>(rect);
            } else {
                rect = (Rectangle)this.painterBounds.get();
                rect.getSize().setWidth(par.getWidth());
                rect.getSize().setHeight(par.getHeight());
            }
            p.paint(g, rect);
        }
        g.translate(-transX, -transY);
    }

    protected Border getBorder() {
        return this.getStyle().getBorder();
    }

    protected void paintBackground(Graphics g) {
        Border b;
        if (this.isBorderPainted() && (b = this.getBorder()) != null && b.isBackgroundPainter()) {
            b.paintBorderBackground(g, this);
            return;
        }
        if (this.getStyle().getBgPainter() != null) {
            this.getStyle().getBgPainter().paint(g, this.bounds);
        }
    }

    public void paint(Graphics g) {
    }

    protected boolean isScrollable() {
        return this.isScrollableX() || this.isScrollableY();
    }

    public boolean isScrollableX() {
        return false;
    }

    public boolean isScrollableY() {
        return false;
    }

    public int getScrollX() {
        return this.scrollX;
    }

    public int getScrollY() {
        return this.scrollY;
    }

    public void setScrollX(int scrollX) {
        this.scrollX = scrollX;
        if (!this.isSmoothScrolling() || !this.isTensileDragEnabled()) {
            this.scrollX = Math.min(this.scrollX, this.getScrollDimension().getWidth() - this.getWidth());
            this.scrollX = Math.max(this.scrollX, 0);
        }
        if (this.isScrollableX()) {
            this.repaint();
        }
    }

    public void setScrollY(int scrollY) {
        this.scrollY = scrollY;
        if (!this.isSmoothScrolling() || !this.isTensileDragEnabled()) {
            this.scrollY = Math.min(this.scrollY, this.getScrollDimension().getHeight() - this.getHeight());
            this.scrollY = Math.max(this.scrollY, 0);
        }
        if (this.isScrollableY()) {
            this.repaint();
        }
    }

    public int getBottomGap() {
        if (this.isScrollableX() && this.isScrollVisible()) {
            return UIManager.getInstance().getLookAndFeel().getHorizontalScrollHeight();
        }
        return 0;
    }

    public int getSideGap() {
        if (this.isScrollableY() && this.isScrollVisible()) {
            return UIManager.getInstance().getLookAndFeel().getVerticalScrollWidth();
        }
        return 0;
    }

    public boolean contains(int x, int y) {
        int absX = this.getAbsoluteX() + this.getScrollX();
        int absY = this.getAbsoluteY() + this.getScrollY();
        return x >= absX && x < absX + this.getWidth() && y >= absY && y < absY + this.getHeight();
    }

    protected Dimension calcPreferredSize() {
        Dimension d = new Dimension(0, 0);
        return d;
    }

    private Dimension preferredSize() {
        if (!this.sizeRequestedByUser && (this.shouldCalcPreferredSize || this.preferredSize == null)) {
            this.shouldCalcPreferredSize = false;
            this.preferredSize = this.calcPreferredSize();
        }
        return this.preferredSize;
    }

    protected Rectangle getBounds() {
        return this.bounds;
    }

    protected Rectangle getVisibleBounds() {
        return this.bounds;
    }

    public boolean isFocusable() {
        return this.focusable && this.enabled && this.isVisible();
    }

    public void setFocusable(boolean focusable) {
        this.focusable = focusable;
        Form p = this.getComponentForm();
        if (p != null) {
            p.clearFocusVectors();
        }
    }

    public void setShouldCalcPreferredSize(boolean shouldCalcPreferredSize) {
        if (!this.shouldCalcScrollSize) {
            this.shouldCalcScrollSize = shouldCalcPreferredSize;
        }
        if (shouldCalcPreferredSize != this.shouldCalcPreferredSize) {
            this.shouldCalcPreferredSize = shouldCalcPreferredSize;
            this.shouldCalcScrollSize = shouldCalcPreferredSize;
            if (shouldCalcPreferredSize && this.getParent() != null) {
                this.shouldCalcPreferredSize = shouldCalcPreferredSize;
                this.getParent().setShouldLayout(shouldCalcPreferredSize);
            }
        }
    }

    public boolean isFocusPainted() {
        return this.focusPainted;
    }

    public void setFocusPainted(boolean focusPainted) {
        this.focusPainted = focusPainted;
    }

    public boolean handlesInput() {
        return this.handlesInput;
    }

    public void setHandlesInput(boolean handlesInput) {
        this.handlesInput = handlesInput;
    }

    public boolean hasFocus() {
        return this.focused;
    }

    public void setFocus(boolean focused) {
        this.focused = focused;
    }

    public Form getComponentForm() {
        Form retVal = null;
        Container parent = this.getParent();
        if (parent != null) {
            retVal = parent.getComponentForm();
        }
        return retVal;
    }

    void repaint(Component cmp) {
        if (this.isCellRenderer() || cmp.getWidth() <= 0 || cmp.getHeight() <= 0) {
            return;
        }
        Container parent = this.getParent();
        if (parent != null) {
            parent.repaint(cmp);
        }
    }

    public void repaint() {
        this.repaintPending = true;
        if (this.dirtyRegion != null) {
            this.setDirtyRegion(null);
        }
        this.repaint(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repaint(int x, int y, int w, int h) {
        Object object = this.dirtyRegionLock;
        synchronized (object) {
            if (this.dirtyRegion == null) {
                if (this.repaintPending) {
                    return;
                }
                Rectangle rect = new Rectangle(x, y, w, h);
                this.setDirtyRegion(rect);
            } else if (this.dirtyRegion.getX() != x || this.dirtyRegion.getY() != y || this.dirtyRegion.getSize().getWidth() != w || this.dirtyRegion.getSize().getHeight() != h) {
                Rectangle rect = new Rectangle(this.dirtyRegion);
                Dimension size = rect.getSize();
                int x1 = Math.min(rect.getX(), x);
                int y1 = Math.min(rect.getY(), y);
                int x2 = Math.max(x + w, rect.getX() + size.getWidth());
                int y2 = Math.max(y + h, rect.getY() + size.getHeight());
                rect.setX(x1);
                rect.setY(y1);
                size.setWidth(x2 - x1);
                size.setHeight(y2 - y1);
                this.setDirtyRegion(rect);
            }
        }
        this.repaint(this);
    }

    protected void longKeyPress(int keyCode) {
    }

    public void keyPressed(int keyCode) {
    }

    public void keyReleased(int keyCode) {
    }

    public void keyRepeated(int keyCode) {
        this.keyPressed(keyCode);
        this.keyReleased(keyCode);
    }

    private void setAnimationMotion(Motion motion) {
        this.animationMotion = motion;
    }

    private Motion getAnimationMotion() {
        return this.animationMotion;
    }

    public int getScrollAnimationSpeed() {
        return this.animationSpeed;
    }

    public void setScrollAnimationSpeed(int animationSpeed) {
        this.animationSpeed = animationSpeed;
    }

    public boolean isSmoothScrolling() {
        return this.smoothScrolling;
    }

    public void setSmoothScrolling(boolean smoothScrolling) {
        this.smoothScrolling = smoothScrolling;
    }

    public void pointerHover(int[] x, int[] y) {
        this.pointerDragged(x, y);
    }

    void clearDrag() {
        this.draggedMotion = null;
        Container parent = this.getParent();
        if (parent != null) {
            parent.clearDrag();
        }
    }

    public void pointerHoverReleased(int[] x, int[] y) {
        this.pointerReleaseImpl(x[0], y[0]);
    }

    public void pointerHoverPressed(int[] x, int[] y) {
        this.dragActivated = false;
        this.clearDrag();
    }

    public void pointerDragged(int[] x, int[] y) {
        this.pointerDragged(x[0], y[0]);
    }

    protected void dragInitiated() {
    }

    public void pointerDragged(int x, int y) {
        if (this.isScrollable() && this.isSmoothScrolling()) {
            if (!this.dragActivated) {
                this.dragActivated = true;
                this.lastScrollY = y;
                this.lastScrollX = x;
                Form p = this.getComponentForm();
                p.setDraggedComponent(this);
                p.registerAnimatedInternal(this);
                Component fc = p.getFocused();
                if (fc != null && fc != this) {
                    fc.dragInitiated();
                }
            }
            if (this.isScrollableY()) {
                int scroll;
                int tensileLength = this.getHeight() / 2;
                if (!this.isSmoothScrolling() || !this.isTensileDragEnabled()) {
                    tensileLength = 0;
                }
                if ((scroll = this.getScrollY() + (this.lastScrollY - y)) >= -tensileLength && scroll < this.getScrollDimension().getHeight() - this.getHeight() + tensileLength) {
                    this.setScrollY(scroll);
                }
            }
            if (this.isScrollableX()) {
                int scroll;
                int tensileLength = this.getWidth() / 2;
                if (!this.isSmoothScrolling() || !this.isTensileDragEnabled()) {
                    tensileLength = 0;
                }
                if ((scroll = this.getScrollX() + (this.lastScrollX - x)) >= -tensileLength && scroll < this.getScrollDimension().getWidth() - this.getWidth() + tensileLength) {
                    this.setScrollX(scroll);
                }
            }
            this.lastScrollY = y;
            this.lastScrollX = x;
        } else {
            Container parent = this.getParent();
            if (!(parent instanceof Form)) {
                parent.pointerDragged(x, y);
            }
        }
    }

    private void initScrollMotion() {
        Form f = this.getComponentForm();
        if (f != null) {
            f.registerAnimatedInternal(this);
        }
        Motion m = Motion.createLinearMotion(this.initialScrollY, this.destScrollY, this.getScrollAnimationSpeed());
        this.setAnimationMotion(m);
        m.start();
    }

    public void pointerPressed(int[] x, int[] y) {
        this.dragActivated = false;
        this.pointerPressed(x[0], y[0]);
        this.initialPressX = x[0];
        this.initialPressY = y[0];
    }

    public void pointerPressed(int x, int y) {
        this.clearDrag();
    }

    public void pointerReleased(int[] x, int[] y) {
        this.pointerReleased(x[0], y[0]);
    }

    protected void longPointerPress(int x, int y) {
    }

    public void pointerReleased(int x, int y) {
        this.pointerReleaseImpl(x, y);
    }

    public void setTensileDragEnabled(boolean tensileDragEnabled) {
        this.tensileDragEnabled = tensileDragEnabled;
    }

    public boolean isTensileDragEnabled() {
        return this.tensileDragEnabled;
    }

    private void startTensile(int offset, int dest) {
        if (this.tensileDragEnabled) {
            this.draggedMotion = Motion.createSplineMotion(offset, dest, 150);
            this.draggedMotion.start();
        } else {
            this.draggedMotion = Motion.createLinearMotion(offset, dest, 0);
            this.draggedMotion.start();
        }
        Form p = this.getComponentForm();
        if (p != null) {
            p.registerAnimatedInternal(this);
        }
    }

    private boolean chooseScrollXOrY(int x, int y) {
        boolean ix = this.isScrollableX();
        boolean iy = this.isScrollableY();
        if (ix && iy) {
            return Math.abs(this.initialPressX - x) > Math.abs(this.initialPressY - y);
        }
        return ix;
    }

    private void pointerReleaseImpl(int x, int y) {
        if (this.dragActivated) {
            int scroll = this.scrollY;
            this.dragActivated = false;
            boolean shouldScrollX = this.chooseScrollXOrY(x, y);
            if (shouldScrollX) {
                scroll = this.scrollX;
                if (scroll < 0) {
                    this.startTensile(scroll, 0);
                    return;
                }
                if (scroll > this.getScrollDimension().getWidth() - this.getWidth()) {
                    this.startTensile(scroll, this.getScrollDimension().getWidth() - this.getWidth());
                    return;
                }
            } else {
                if (scroll < 0) {
                    this.startTensile(scroll, 0);
                    return;
                }
                if (scroll > this.getScrollDimension().getHeight() - this.getHeight()) {
                    this.startTensile(scroll, this.getScrollDimension().getHeight() - this.getHeight());
                    return;
                }
            }
            float speed = Display.getInstance().getDragSpeed(!shouldScrollX);
            int tensileLength = this.getWidth() / 2;
            if (!this.isTensileDragEnabled()) {
                tensileLength = 0;
            }
            this.draggedMotion = !shouldScrollX ? (speed < 0.0f ? Motion.createFrictionMotion(scroll, -tensileLength, speed, 4.0E-4f) : Motion.createFrictionMotion(scroll, this.getScrollDimension().getHeight() - this.getHeight() + tensileLength, speed, 4.0E-4f)) : (speed < 0.0f ? Motion.createFrictionMotion(scroll, -tensileLength, speed, 4.0E-4f) : Motion.createFrictionMotion(scroll, this.getScrollDimension().getWidth() - this.getWidth() + tensileLength, speed, 4.0E-4f));
            this.draggedMotion.start();
        }
    }

    public Style getStyle() {
        if (this.unSelectedStyle == null) {
            this.initStyle();
        }
        if (!this.isEnabled()) {
            return this.getDisabledStyle();
        }
        if (this.hasFocus() && this.isFocusPainted() && Display.getInstance().shouldRenderSelection()) {
            return this.getSelectedStyle();
        }
        return this.unSelectedStyle;
    }

    public Style getUnselectedStyle() {
        if (this.unSelectedStyle == null) {
            this.initStyle();
        }
        return this.unSelectedStyle;
    }

    public Style getSelectedStyle() {
        if (this.selectedStyle == null) {
            this.selectedStyle = UIManager.getInstance().getComponentSelectedStyle(this.getUIID());
            this.selectedStyle.addStyleListener(this);
            if (this.selectedStyle.getBgPainter() == null) {
                this.selectedStyle.setBgPainter(new BGPainter());
            }
        }
        return this.selectedStyle;
    }

    public Style getDisabledStyle() {
        if (this.disabledStyle == null) {
            this.disabledStyle = UIManager.getInstance().getComponentCustomStyle(this.getUIID(), "dis");
            this.disabledStyle.addStyleListener(this);
            if (this.disabledStyle.getBgPainter() == null) {
                this.disabledStyle.setBgPainter(new BGPainter());
            }
        }
        return this.disabledStyle;
    }

    public void setStyle(Style style) {
        this.setUnSelectedStyle(style);
    }

    public void setUnSelectedStyle(Style style) {
        this.setUnselectedStyle(style);
    }

    public void setUnselectedStyle(Style style) {
        if (this.unSelectedStyle != null) {
            this.unSelectedStyle.removeStyleListener(this);
        }
        this.unSelectedStyle = style;
        this.unSelectedStyle.addStyleListener(this);
        if (this.unSelectedStyle.getBgPainter() == null) {
            this.unSelectedStyle.setBgPainter(new BGPainter());
        }
        this.setShouldCalcPreferredSize(true);
        this.checkAnimation();
    }

    public void setSelectedStyle(Style style) {
        if (this.selectedStyle != null) {
            this.selectedStyle.removeStyleListener(this);
        }
        this.selectedStyle = style;
        this.selectedStyle.addStyleListener(this);
        if (this.selectedStyle.getBgPainter() == null) {
            this.selectedStyle.setBgPainter(new BGPainter());
        }
        this.setShouldCalcPreferredSize(true);
        this.checkAnimation();
    }

    public void setDisabledStyle(Style style) {
        if (this.disabledStyle != null) {
            this.disabledStyle.removeStyleListener(this);
        }
        this.disabledStyle = style;
        this.disabledStyle.addStyleListener(this);
        if (this.disabledStyle.getBgPainter() == null) {
            this.disabledStyle.setBgPainter(new BGPainter());
        }
        this.setShouldCalcPreferredSize(true);
        this.checkAnimation();
    }

    public void requestFocus() {
        Form rootForm = this.getComponentForm();
        if (rootForm != null) {
            rootForm.requestFocus(this);
        }
    }

    public String toString() {
        String className = this.getClass().getName();
        className = className.substring(className.lastIndexOf(46) + 1);
        return String.valueOf(className) + "[" + this.paramString() + "]";
    }

    protected String paramString() {
        return "x=" + this.getX() + " y=" + this.getY() + " width=" + this.getWidth() + " height=" + this.getHeight();
    }

    public void refreshTheme() {
        this.refreshTheme(this.getUIID());
    }

    protected void refreshTheme(String id) {
        Style unSelected = this.getUnselectedStyle();
        this.setUnSelectedStyle(this.mergeStyle(unSelected, UIManager.getInstance().getComponentStyle(id)));
        if (this.selectedStyle != null) {
            this.setSelectedStyle(this.mergeStyle(this.selectedStyle, UIManager.getInstance().getComponentSelectedStyle(id)));
        }
        if (this.disabledStyle != null) {
            this.setDisabledStyle(this.mergeStyle(this.disabledStyle, UIManager.getInstance().getComponentCustomStyle(id, "dis")));
        }
        this.checkAnimation();
        UIManager.getInstance().getLookAndFeel().bind(this);
    }

    Style mergeStyle(Style toMerge, Style newStyle) {
        if (toMerge.isModified()) {
            toMerge.merge(newStyle);
            return toMerge;
        }
        return newStyle;
    }

    protected boolean isDragActivated() {
        return this.dragActivated;
    }

    void setDragActivated(boolean dragActivated) {
        this.dragActivated = dragActivated;
    }

    void checkAnimation() {
        Image bgImage = this.getStyle().getBgImage();
        if (bgImage != null && bgImage.isAnimation()) {
            Form pf = this.getComponentForm();
            if (pf != null) {
                pf.registerAnimated(this);
            }
        } else {
            Form pf;
            Painter p = this.getStyle().getBgPainter();
            if (p instanceof Animation && (pf = this.getComponentForm()) != null) {
                pf.registerAnimated(this);
            }
        }
    }

    void deregisterAnimatedInternal() {
        Form f = this.getComponentForm();
        if (f != null) {
            f.deregisterAnimatedInternal(this);
        }
    }

    public boolean animate() {
        Image bgImage = this.getStyle().getBgImage();
        boolean animateBackground = bgImage != null && bgImage.isAnimation() && bgImage.animate();
        Motion m = this.getAnimationMotion();
        if (m != null && this.destScrollY != -1 && this.destScrollY != this.getScrollY()) {
            this.setScrollY(m.getValue());
            if (this.destScrollY == this.scrollY) {
                this.destScrollY = -1;
                this.deregisterAnimatedInternal();
            }
            return true;
        }
        if (this.draggedMotion != null) {
            int dragVal = this.draggedMotion.getValue();
            if (this.draggedMotion.isFinished()) {
                if (dragVal < 0) {
                    this.startTensile(dragVal, 0);
                } else if (this.isScrollableY()) {
                    if (dragVal > this.getScrollDimension().getHeight() - this.getHeight()) {
                        this.startTensile(dragVal, this.getScrollDimension().getHeight() - this.getHeight());
                    } else {
                        this.draggedMotion = null;
                    }
                } else if (dragVal > this.getScrollDimension().getWidth() - this.getWidth()) {
                    this.startTensile(dragVal, this.getScrollDimension().getWidth() - this.getWidth());
                } else {
                    this.draggedMotion = null;
                }
            }
            if (this.isScrollableY()) {
                this.scrollY = dragVal;
                return true;
            }
            this.scrollX = dragVal;
            return true;
        }
        if (animateBackground) {
            if (bgImage instanceof StaticAnimation) {
                Rectangle dirty = ((StaticAnimation)bgImage).getDirtyRegion();
                if (dirty != null) {
                    dirty.setX(this.getAbsoluteX());
                    dirty.setY(this.getAbsoluteY() + dirty.getY());
                }
                this.setDirtyRegion(dirty);
            }
        } else {
            Painter bgp = this.getStyle().getBgPainter();
            boolean bl = animateBackground = bgp != null && bgp instanceof Animation && ((Animation)((Object)bgp)).animate();
        }
        if (!(animateBackground || this.destScrollY != -1 || animateBackground || m != null || this.draggedMotion != null || this.dragActivated)) {
            this.tryDeregisterAnimated();
        }
        return animateBackground;
    }

    void tryDeregisterAnimated() {
        this.deregisterAnimatedInternal();
    }

    protected void scrollRectToVisible(Rectangle rect, Component coordinateSpace) {
        this.scrollRectToVisible(rect.getX(), rect.getY(), rect.getSize().getWidth(), rect.getSize().getHeight(), coordinateSpace);
    }

    /*
     * Unable to fully structure code
     */
    public void scrollRectToVisible(int x, int y, int width, int height, Component coordinateSpace) {
        block22: {
            block20: {
                block21: {
                    if (!this.isScrollable()) break block20;
                    scrollPosition = this.getScrollY();
                    s = this.getStyle();
                    w = this.getWidth() - s.getPadding(this.isRTL(), 1) - s.getPadding(this.isRTL(), 3);
                    h = this.getHeight() - s.getPadding(false, 0) - s.getPadding(false, 2);
                    view = this.isSmoothScrolling() != false && this.destScrollY > -1 ? new Rectangle(this.getScrollX(), this.destScrollY, w, h) : new Rectangle(this.getScrollX(), this.getScrollY(), w, h);
                    relativeX = x;
                    relativeY = y;
                    parent = null;
                    if (coordinateSpace != null) {
                        parent = coordinateSpace.getParent();
                    }
                    if (parent != this) ** GOTO lbl22
                    if (!view.contains(x, y, width, height)) break block21;
                    return;
lbl-1000:
                    // 1 sources

                    {
                        if (parent == null) {
                            relativeX = x;
                            relativeY = y;
                            break;
                        }
                        relativeX += parent.getX();
                        relativeY += parent.getY();
                        parent = parent.getParent();
lbl22:
                        // 2 sources

                        ** while (parent != this)
                    }
lbl23:
                    // 2 sources

                    if (view.contains(relativeX, relativeY, width, height)) {
                        return;
                    }
                }
                if (this.isScrollableX()) {
                    if (this.getScrollX() > relativeX) {
                        this.setScrollX(relativeX);
                    }
                    rightX = relativeX + width - s.getPadding(1) - s.getPadding(3);
                    if (this.getScrollX() + w < rightX) {
                        this.setScrollX(this.getScrollX() + (rightX - (this.getScrollX() + w)));
                    } else if (this.getScrollX() > relativeX) {
                        this.setScrollX(relativeX);
                    }
                }
                if (this.isScrollableY()) {
                    if (this.getScrollY() > relativeY) {
                        scrollPosition = relativeY;
                    }
                    bottomY = relativeY + height - s.getPadding(0) - s.getPadding(2);
                    if (this.getScrollY() + h < bottomY) {
                        scrollPosition = this.getScrollY() + (bottomY - (this.getScrollY() + h));
                    } else if (this.getScrollY() > relativeY) {
                        scrollPosition = relativeY;
                    }
                    if (this.isSmoothScrolling()) {
                        this.initialScrollY = this.getScrollY();
                        this.destScrollY = scrollPosition;
                        this.initScrollMotion();
                    } else {
                        this.setScrollY(scrollPosition);
                    }
                }
                this.repaint();
                break block22;
            }
            parent = this.getParent();
            if (parent != null) {
                parent.scrollRectToVisible(this.getAbsoluteX() - parent.getAbsoluteX() + x, this.getAbsoluteY() - parent.getAbsoluteY() + y, width, height, parent);
            }
        }
    }

    private void setBorderPainted(boolean b) {
        if (!b) {
            this.getStyle().setBorder(null);
        } else {
            this.getStyle().setBorder(Border.getDefaultBorder());
        }
    }

    private boolean isBorderPainted() {
        return this.getStyle().getBorder() != null;
    }

    protected void paintBorder(Graphics g) {
        Border b = this.getBorder();
        if (b != null) {
            g.setColor(this.getStyle().getFgColor());
            b.paint(g, this);
        }
    }

    public void setCellRenderer(boolean cellRenderer) {
        this.cellRenderer = cellRenderer;
    }

    boolean isCellRenderer() {
        return this.cellRenderer;
    }

    public boolean isScrollVisible() {
        return this.isScrollVisible;
    }

    public void setScrollVisible(boolean isScrollVisible) {
        this.isScrollVisible = isScrollVisible;
    }

    public void setIsScrollVisible(boolean isScrollVisible) {
        this.isScrollVisible = isScrollVisible;
    }

    void initComponentImpl() {
        if (!this.initialized) {
            this.initialized = true;
            this.getStyle();
            UIManager.getInstance().getLookAndFeel().bind(this);
            this.checkAnimation();
            if (this.isRTL() && this.isScrollableX()) {
                this.setScrollX(this.getScrollDimension().getWidth());
            }
            this.initComponent();
        }
    }

    void deinitializeImpl() {
        if (this.isInitialized()) {
            this.setInitialized(false);
            this.setDirtyRegion(null);
            this.deinitialize();
        }
    }

    protected void laidOut() {
        if (this.isScrollableY() && this.getScrollY() > 0 && this.getScrollY() + this.getHeight() > this.getScrollDimension().getHeight()) {
            this.setScrollY(this.getScrollDimension().getHeight() - this.getHeight());
        }
        if (this.isScrollableX() && this.getScrollX() > 0 && this.getScrollX() + this.getWidth() > this.getScrollDimension().getWidth()) {
            this.setScrollX(this.getScrollDimension().getWidth() - this.getWidth());
        }
        if (!this.isScrollableY()) {
            this.setScrollY(0);
        }
        if (!this.isScrollableX()) {
            this.setScrollX(0);
        }
    }

    protected void deinitialize() {
    }

    protected void initComponent() {
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    protected void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public void styleChanged(String propertyName, Style source) {
        if (!this.shouldCalcPreferredSize && source == this.getStyle() && (propertyName.equals("font") || propertyName.equals("margin") || propertyName.equals("padding"))) {
            this.setShouldCalcPreferredSize(true);
            Container parent = this.getParent();
            if (parent != null && parent.getComponentForm() != null) {
                parent.revalidate();
            }
        }
    }

    public Component getNextFocusDown() {
        return this.nextFocusDown;
    }

    public void setNextFocusDown(Component nextFocusDown) {
        this.nextFocusDown = nextFocusDown;
    }

    public Component getNextFocusUp() {
        return this.nextFocusUp;
    }

    public void setNextFocusUp(Component nextFocusUp) {
        this.nextFocusUp = nextFocusUp;
    }

    public Component getNextFocusLeft() {
        return this.nextFocusLeft;
    }

    public void setNextFocusLeft(Component nextFocusLeft) {
        this.nextFocusLeft = nextFocusLeft;
    }

    public Component getNextFocusRight() {
        return this.nextFocusRight;
    }

    public void setNextFocusRight(Component nextFocusRight) {
        this.nextFocusRight = nextFocusRight;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    void onEditComplete(String text) {
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        Form f = this.getComponentForm();
        if (f != null) {
            f.clearFocusVectors();
            this.repaint();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    protected void initCustomStyle(Style s) {
        s.addStyleListener(this);
        if (s.getBgPainter() == null) {
            s.setBgPainter(new BGPainter());
        }
    }

    protected void deinitializeCustomStyle(Style s) {
        s.removeStyleListener(this);
    }

    public boolean isRTL() {
        return this.rtl;
    }

    public void setRTL(boolean rtl) {
        this.rtl = rtl;
    }

    protected boolean isTactileTouch(int x, int y) {
        return this.isTactileTouch();
    }

    public boolean isTactileTouch() {
        return this.tactileTouch;
    }

    public void setTactileTouch(boolean tactileTouch) {
        this.tactileTouch = tactileTouch;
    }

    public String[] getPropertyNames() {
        return null;
    }

    public Class[] getPropertyTypes() {
        return null;
    }

    public Object getPropertyValue(String name) {
        return null;
    }

    public String setPropertyValue(String name, Object value) {
        return "Unknown: " + name;
    }

    class BGPainter
    implements Painter {
        private Form previousTint;
        private Painter painter;

        public BGPainter() {
        }

        public BGPainter(Form parent, Painter p) {
            this.painter = p;
        }

        public void setPreviousForm(Form previous) {
            this.previousTint = previous;
        }

        public Form getPreviousForm() {
            return this.previousTint;
        }

        private void drawGradientBackground(Style s, Graphics g, int x, int y, int width, int height) {
            switch (s.getBackgroundType()) {
                case 7: {
                    g.fillLinearGradient(s.getBackgroundGradientStartColor(), s.getBackgroundGradientEndColor(), x, y, width, height, true);
                    return;
                }
                case 6: {
                    g.fillLinearGradient(s.getBackgroundGradientStartColor(), s.getBackgroundGradientEndColor(), x, y, width, height, false);
                    return;
                }
                case 8: {
                    g.fillRectRadialGradient(s.getBackgroundGradientStartColor(), s.getBackgroundGradientEndColor(), x, y, width, height, s.getBackgroundGradientRelativeX(), s.getBackgroundGradientRelativeY(), s.getBackgroundGradientRelativeSize());
                    return;
                }
            }
            g.setColor(s.getBgColor());
            g.fillRect(x, y, width, height, s.getBgTransparency());
        }

        public void paint(Graphics g, Rectangle rect) {
            if (this.painter != null) {
                if (this.previousTint != null) {
                    this.previousTint.paint(g);
                }
            } else {
                Style s = Component.this.getStyle();
                int x = rect.getX();
                int y = rect.getY();
                int width = rect.getSize().getWidth();
                int height = rect.getSize().getHeight();
                if (width <= 0 || height <= 0) {
                    return;
                }
                Image bgImage = s.getBgImage();
                if (bgImage == null) {
                    if (s.getBackgroundType() >= 6) {
                        this.drawGradientBackground(s, g, x, y, width, height);
                        return;
                    }
                    g.setColor(s.getBgColor());
                    g.fillRect(x, y, width, height, s.getBgTransparency());
                } else {
                    int iW = bgImage.getWidth();
                    int iH = bgImage.getHeight();
                    switch (s.getBackgroundType()) {
                        case 1: {
                            if (iW != width || iH != height) {
                                bgImage = bgImage.scaled(width, height);
                                s.setBgImage(bgImage, true);
                            }
                            g.drawImage(s.getBgImage(), x, y);
                            return;
                        }
                        case 2: {
                            int xPos = 0;
                            while (xPos <= width) {
                                int yPos = 0;
                                while (yPos <= height) {
                                    g.drawImage(s.getBgImage(), x + xPos, y + yPos);
                                    yPos += iH;
                                }
                                xPos += iW;
                            }
                            return;
                        }
                        case 4: {
                            int xPos = 0;
                            while (xPos <= width) {
                                g.drawImage(s.getBgImage(), x + xPos, y);
                                xPos += iW;
                            }
                            return;
                        }
                        case 3: {
                            int yPos = 0;
                            while (yPos <= height) {
                                g.drawImage(s.getBgImage(), x, y + yPos);
                                yPos += iH;
                            }
                            return;
                        }
                        case 5: {
                            switch (s.getBackgroundAlignment()) {
                                case -94: {
                                    g.drawImage(s.getBgImage(), x + width - iW, y + (height - iH));
                                    return;
                                }
                                case -95: {
                                    g.drawImage(s.getBgImage(), x + width - iW, y);
                                    return;
                                }
                                case -93: {
                                    g.drawImage(s.getBgImage(), x, y + (height / 2 - iH / 2));
                                    return;
                                }
                                case -92: {
                                    g.drawImage(s.getBgImage(), x + width - iW, y + (height / 2 - iH / 2));
                                    return;
                                }
                                case -91: {
                                    g.drawImage(s.getBgImage(), x + (width / 2 - iW / 2), y + (height / 2 - iH / 2));
                                    return;
                                }
                            }
                            return;
                        }
                        case 20: {
                            g.drawImage(s.getBgImage(), x + width - iW, y);
                            return;
                        }
                        case 21: {
                            g.drawImage(s.getBgImage(), x + width - iW, y + (height - iH));
                            return;
                        }
                        case 22: {
                            g.drawImage(s.getBgImage(), x, y + (height / 2 - iH / 2));
                            return;
                        }
                        case 23: {
                            g.drawImage(s.getBgImage(), x + width - iW, y + (height / 2 - iH / 2));
                            return;
                        }
                        case 24: {
                            g.drawImage(s.getBgImage(), x + (width / 2 - iW / 2), y + (height / 2 - iH / 2));
                            return;
                        }
                    }
                }
            }
        }
    }
}

