/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Display;
import com.sun.lwuit.Font;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import java.lang.ref.WeakReference;
import java.util.Hashtable;

class CustomFont
extends Font {
    private static final int COLOR_CACHE_SIZE = 20;
    private Hashtable colorCache = new Hashtable();
    private String charsets;
    private int color;
    Image cache;
    int[] cutOffsets;
    int[] charWidth;
    private int imageWidth;
    private int imageHeight;
    private WeakReference imageArrayRef;

    private int[] getImageArray() {
        int[] a;
        if (this.imageArrayRef != null && (a = (int[])this.imageArrayRef.get()) != null) {
            return a;
        }
        a = this.cache.getRGBCached();
        this.imageArrayRef = new WeakReference<int[]>(a);
        return a;
    }

    public CustomFont(Image bitmap, int[] cutOffsets, int[] charWidth, String charsets) {
        this.cutOffsets = cutOffsets;
        this.charWidth = charWidth;
        this.charsets = charsets;
        this.imageWidth = bitmap.getWidth();
        this.imageHeight = bitmap.getHeight();
        int[] imageArray = new int[this.imageWidth * this.imageHeight];
        bitmap.getRGB(imageArray, 0, 0, 0, this.imageWidth, this.imageHeight);
        int iter = 0;
        while (iter < imageArray.length) {
            imageArray[iter] = (imageArray[iter] & 0xFF0000) << 8;
            ++iter;
        }
        this.cache = Image.createImage(imageArray, this.imageWidth, this.imageHeight);
        this.imageArrayRef = new WeakReference<int[]>(imageArray);
    }

    public int charWidth(char ch) {
        int i = this.charsets.indexOf(ch);
        if (i < 0) {
            return 0;
        }
        return this.charWidth[i];
    }

    public int getHeight() {
        return this.imageHeight;
    }

    private boolean checkCacheCurrentColor(int newColor) {
        Integer currentColor = new Integer(this.color);
        Integer newColorKey = new Integer(newColor);
        if (this.colorCache.get(currentColor) == null) {
            this.colorCache.put(currentColor, new WeakReference<Image>(this.cache));
        }
        this.color = newColor;
        WeakReference newCache = (WeakReference)this.colorCache.get(newColorKey);
        if (newCache != null) {
            Image i = (Image)newCache.get();
            if (i != null) {
                this.cache = i;
                if (this.colorCache.size() > 20) {
                    this.colorCache.remove(this.colorCache.keys().nextElement());
                }
                return true;
            }
            this.colorCache.remove(newColorKey);
        }
        if (this.colorCache.size() > 20) {
            this.colorCache.remove(this.colorCache.keys().nextElement());
        }
        return false;
    }

    private void initColor(Graphics g) {
        int newColor = g.getColor();
        if (newColor != this.color && !this.checkCacheCurrentColor(newColor)) {
            this.color = newColor & 0xFFFFFF;
            int[] imageArray = this.getImageArray();
            int iter = 0;
            while (iter < imageArray.length) {
                imageArray[iter] = this.color | imageArray[iter] & 0xFF000000;
                ++iter;
            }
            this.cache = Image.createImage(imageArray, this.imageWidth, this.imageHeight);
        }
    }

    void drawChar(Graphics g, char character, int x, int y) {
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipWidth = g.getClipWidth();
        int clipHeight = g.getClipHeight();
        int i = this.charsets.indexOf(character);
        if (i > -1) {
            this.initColor(g);
            g.clipRect(x, y, this.charWidth[i], this.imageHeight);
            g.drawImage(this.cache, x - this.cutOffsets[i], y);
        }
        g.setClip(clipX, clipY, clipWidth, clipHeight);
    }

    public void addContrast(byte value) {
        int[] imageArray = this.getImageArray();
        int iter = 0;
        while (iter < imageArray.length) {
            int alpha = imageArray[iter] >> 24 & 0xFF;
            if (alpha != 0) {
                alpha = Math.min(alpha + value, 255);
                imageArray[iter] = alpha << 24 & 0xFF000000 | this.color;
            }
            ++iter;
        }
    }

    void drawChars(Graphics g, char[] data, int offset, int length, int x, int y) {
        if (Display.getInstance().isBidiAlgorithm()) {
            int i = offset;
            while (i < length) {
                if (Display.getInstance().isRTL(data[i])) {
                    String s = Display.getInstance().convertBidiLogicalToVisual(new String(data, offset, length));
                    data = s.toCharArray();
                    offset = 0;
                    length = s.length();
                    break;
                }
                ++i;
            }
        }
        this.initColor(g);
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipWidth = g.getClipWidth();
        int clipHeight = g.getClipHeight();
        if (clipY <= y + this.getHeight() && clipY + clipHeight >= y) {
            int i = 0;
            while (i < length) {
                char c = data[offset + i];
                int position = this.charsets.indexOf(c);
                if (position >= 0) {
                    g.clipRect(x, y, this.charWidth[position], this.imageHeight);
                    if (g.getClipWidth() > 0 && g.getClipHeight() > 0) {
                        g.drawImage(this.cache, x - this.cutOffsets[position], y);
                    }
                    x += this.charWidth[position];
                    g.setClip(clipX, clipY, clipWidth, clipHeight);
                }
                ++i;
            }
        }
    }

    public String getCharset() {
        return this.charsets;
    }

    public int charsWidth(char[] ch, int offset, int length) {
        int retVal = 0;
        int i = 0;
        while (i < length) {
            retVal += this.charWidth(ch[i + offset]);
            ++i;
        }
        return retVal;
    }

    public int substringWidth(String str, int offset, int len) {
        return this.charsWidth(str.toCharArray(), offset, len);
    }

    public int stringWidth(String str) {
        if (str == null || str.length() == 0) {
            return 0;
        }
        return this.substringWidth(str, 0, str.length());
    }

    public int getFace() {
        return 0;
    }

    public int getSize() {
        return 0;
    }

    public int getStyle() {
        return 0;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o.getClass() == this.getClass()) {
            CustomFont f = (CustomFont)o;
            if (this.charsets.equals(f.charsets)) {
                int iter = 0;
                while (iter < this.cutOffsets.length) {
                    if (this.cutOffsets[iter] != f.cutOffsets[iter]) {
                        return false;
                    }
                    ++iter;
                }
                return true;
            }
        }
        return false;
    }
}

