/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Button;
import com.sun.lwuit.Command;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Dialog;
import com.sun.lwuit.Display;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.List;
import com.sun.lwuit.MenuBar;
import com.sun.lwuit.Painter;
import com.sun.lwuit.RunnableWrapper;
import com.sun.lwuit.animations.Animation;
import com.sun.lwuit.animations.Transition;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.geom.Rectangle;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.layouts.FlowLayout;
import com.sun.lwuit.layouts.Layout;
import com.sun.lwuit.list.ListCellRenderer;
import com.sun.lwuit.plaf.LookAndFeel;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.plaf.UIManager;
import com.sun.lwuit.util.EventDispatcher;
import java.util.Hashtable;
import java.util.Vector;

public class Form
extends Container {
    private Painter glassPane;
    private Container contentPane = new Container(new FlowLayout());
    Container titleArea = new Container(new BorderLayout());
    private Label title = new Label("", "Title");
    private MenuBar menuBar;
    private Component dragged;
    protected boolean focusScrolling;
    static boolean comboLock;
    private Vector internalAnimatableComponents;
    private Vector animatableComponents;
    private Component focused;
    private Vector mediaComponents;
    private Transition transitionInAnimator;
    private Transition transitionOutAnimator;
    private EventDispatcher commandListener;
    private EventDispatcher pointerPressedListeners;
    private EventDispatcher pointerReleasedListeners;
    private EventDispatcher pointerDraggedListeners;
    private Form previousForm;
    boolean tint;
    private int tintColor;
    private Vector focusDownSequence;
    private Vector focusRightSequence;
    private Hashtable keyListeners;
    private Hashtable gameKeyListeners;
    private boolean cyclicFocus = true;
    private int tactileTouchDuration;
    private EventDispatcher showListener;

    public Form() {
        super(new BorderLayout());
        this.setUIID("Form");
        this.setVisible(false);
        Style formStyle = this.getStyle();
        int w = Display.getInstance().getDisplayWidth() - (formStyle.getMargin(this.isRTL(), 1) + formStyle.getMargin(this.isRTL(), 3));
        int h = Display.getInstance().getDisplayHeight() - (formStyle.getMargin(false, 0) + formStyle.getMargin(false, 2));
        this.setWidth(w);
        this.setHeight(h);
        this.setPreferredSize(new Dimension(w, h));
        this.title.setEndsWith3Points(false);
        this.titleArea.addComponent("Center", (Component)this.title);
        this.titleArea.setUIID("TitleArea");
        this.addComponentToForm("North", this.titleArea);
        this.addComponentToForm("Center", this.contentPane);
        this.contentPane.setUIID("ContentPane");
        this.contentPane.setScrollableY(true);
        LookAndFeel laf = UIManager.getInstance().getLookAndFeel();
        this.initLaf(laf);
        try {
            this.menuBar = (MenuBar)laf.getMenuBarClass().newInstance();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.menuBar = new MenuBar();
        }
        this.menuBar.initMenuBar(this);
        this.tintColor = laf.getDefaultFormTintColor();
        formStyle.setBgTransparency(255);
    }

    public Container getTitleArea() {
        return this.titleArea;
    }

    public void addShowListener(ActionListener l) {
        if (this.showListener == null) {
            this.showListener = new EventDispatcher();
        }
        this.showListener.addListener(l);
    }

    public void removeShowListener(ActionListener l) {
        if (this.showListener == null) {
            return;
        }
        this.showListener.removeListener(l);
    }

    protected void hideNotify() {
    }

    protected void showNotify() {
    }

    protected void sizeChanged(int w, int h) {
    }

    void sizeChangedInternal(int w, int h) {
        this.sizeChanged(w, h);
        Style formStyle = this.getStyle();
        this.setSize(new Dimension(w -= formStyle.getMargin(this.isRTL(), 1) + formStyle.getMargin(this.isRTL(), 3), h -= formStyle.getMargin(false, 0) + formStyle.getMargin(false, 2)));
        this.setShouldCalcPreferredSize(true);
        this.doLayout();
        this.repaint();
    }

    public void setGlassPane(Painter glassPane) {
        this.glassPane = glassPane;
        this.repaint();
    }

    void paintGlassImpl(Graphics g) {
        if (this.glassPane != null) {
            int tx = g.getTranslateX();
            int ty = g.getTranslateY();
            g.translate(-tx, -ty);
            this.glassPane.paint(g, this.getBounds());
            g.translate(tx, ty);
        }
        this.paintGlass(g);
    }

    public Painter getGlassPane() {
        return this.glassPane;
    }

    public void setTitleStyle(Style s) {
        this.title.setUnSelectedStyle(s);
    }

    public Label getTitleComponent() {
        return this.title;
    }

    public void setTitleComponent(Label title) {
        this.titleArea.replace(this.title, title);
        this.title = title;
    }

    public void setTitleComponent(Label title, Transition t) {
        this.titleArea.replace(this.title, title, t);
        this.title = title;
    }

    public void addKeyListener(int keyCode, ActionListener listener) {
        if (this.keyListeners == null) {
            this.keyListeners = new Hashtable();
        }
        this.addKeyListener(keyCode, listener, this.keyListeners);
    }

    public void removeKeyListener(int keyCode, ActionListener listener) {
        if (this.keyListeners == null) {
            return;
        }
        this.removeKeyListener(keyCode, listener, this.keyListeners);
    }

    public void removeGameKeyListener(int keyCode, ActionListener listener) {
        if (this.gameKeyListeners == null) {
            return;
        }
        this.removeKeyListener(keyCode, listener, this.gameKeyListeners);
    }

    private void addKeyListener(int keyCode, ActionListener listener, Hashtable keyListeners) {
        Integer code;
        Vector<ActionListener> vec;
        if (keyListeners == null) {
            keyListeners = new Hashtable();
        }
        if ((vec = (Vector<ActionListener>)keyListeners.get(code = new Integer(keyCode))) == null) {
            vec = new Vector<ActionListener>();
            vec.addElement(listener);
            keyListeners.put(code, vec);
            return;
        }
        if (!vec.contains(listener)) {
            vec.addElement(listener);
        }
    }

    private void removeKeyListener(int keyCode, ActionListener listener, Hashtable keyListeners) {
        if (keyListeners == null) {
            return;
        }
        Integer code = new Integer(keyCode);
        Vector vec = (Vector)keyListeners.get(code);
        if (vec == null) {
            return;
        }
        vec.removeElement(listener);
        if (vec.size() == 0) {
            keyListeners.remove(code);
        }
    }

    public void addGameKeyListener(int keyCode, ActionListener listener) {
        if (this.gameKeyListeners == null) {
            this.gameKeyListeners = new Hashtable();
        }
        this.addKeyListener(keyCode, listener, this.gameKeyListeners);
    }

    public int getSoftButtonCount() {
        return this.menuBar.getSoftButtons().length;
    }

    public Button getSoftButton(int offset) {
        return this.menuBar.getSoftButtons()[offset];
    }

    public Style getMenuStyle() {
        return this.menuBar.getMenuStyle();
    }

    public Style getTitleStyle() {
        return this.title.getStyle();
    }

    public Form getPreviousForm() {
        return this.previousForm;
    }

    void initLaf(LookAndFeel laf) {
        this.transitionOutAnimator = laf.getDefaultFormTransitionOut();
        this.transitionInAnimator = laf.getDefaultFormTransitionIn();
    }

    void clearFocusVectors() {
        this.focusDownSequence = null;
        this.focusRightSequence = null;
    }

    void setDraggedComponent(Component dragged) {
        this.dragged = dragged;
    }

    synchronized void initFocusRight() {
        if (this.focusRightSequence == null) {
            this.focusRightSequence = new Vector();
            this.findAllFocusable(this.contentPane, this.focusRightSequence, true);
        }
    }

    synchronized void initFocusDown() {
        if (this.focusDownSequence == null) {
            this.focusDownSequence = new Vector();
            this.findAllFocusable(this.contentPane, this.focusDownSequence, false);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void addSortedComponentRight(Vector components, Component c) {
        componentCount = components.size();
        componentX = c.getAbsoluteX();
        bestSpot = 0;
        rtl = this.isRTL();
        scrollableParent = this.findScrollableAncestor(c);
        iter = 0;
        while (iter < componentCount) {
            block9: {
                block8: {
                    current = (Component)components.elementAt(iter);
                    currentScrollParent = this.findScrollableAncestor(current);
                    if (currentScrollParent != scrollableParent) break block8;
                    if (!this.isInSameRow(current, c)) ** GOTO lbl-1000
                    currentX = current.getAbsoluteX();
                    if (!(!rtl && currentX > componentX || rtl && currentX < componentX)) {
                        bestSpot = iter + 1;
                    }
                    break block9;
                }
                tempScrollableParent = scrollableParent;
                if (scrollableParent == null) {
                    tempScrollableParent = c;
                }
                tempCurrentScrollParent = currentScrollParent;
                if (currentScrollParent == null) {
                    tempCurrentScrollParent = current;
                }
                if (!(!rtl && tempCurrentScrollParent.getAbsoluteX() > tempScrollableParent.getAbsoluteX() || rtl && tempCurrentScrollParent.getAbsoluteX() < tempScrollableParent.getAbsoluteX())) {
                    ** if (!this.isInSameRow((Component)tempCurrentScrollParent, (Component)tempScrollableParent)) goto lbl-1000
lbl-1000:
                    // 1 sources

                    {
                        bestSpot = iter + 1;
                        ** GOTO lbl30
                    }
                }
                break block9;
lbl-1000:
                // 2 sources

                {
                    if (current.getAbsoluteY() < c.getAbsoluteY()) {
                        bestSpot = iter + 1;
                    }
                }
            }
            ++iter;
        }
        components.insertElementAt(c, bestSpot);
    }

    private Component findScrollableAncestor(Component c) {
        if ((c = c.getParent()) == null || c.isScrollable()) {
            return c;
        }
        return this.findScrollableAncestor(c);
    }

    /*
     * Unable to fully structure code
     */
    private void addSortedComponentDown(Vector components, Component c) {
        componentCount = components.size();
        componentY = c.getAbsoluteY();
        bestSpot = 0;
        rtl = this.isRTL();
        scrollableParent = this.findScrollableAncestor(c);
        iter = 0;
        while (iter < componentCount) {
            block9: {
                block8: {
                    current = (Component)components.elementAt(iter);
                    currentScrollParent = this.findScrollableAncestor(current);
                    if (currentScrollParent != scrollableParent) break block8;
                    if (!this.isInSameColumn(current, c)) ** GOTO lbl-1000
                    currentY = current.getAbsoluteY();
                    if (currentY <= componentY) {
                        bestSpot = iter + 1;
                    }
                    break block9;
                }
                tempScrollableParent = scrollableParent;
                if (scrollableParent == null) {
                    tempScrollableParent = c;
                }
                tempCurrentScrollParent = currentScrollParent;
                if (currentScrollParent == null) {
                    tempCurrentScrollParent = current;
                }
                if (tempCurrentScrollParent.getAbsoluteY() <= tempScrollableParent.getAbsoluteY()) {
                    ** if (!this.isInSameColumn((Component)tempCurrentScrollParent, (Component)tempScrollableParent)) goto lbl-1000
lbl-1000:
                    // 1 sources

                    {
                        bestSpot = iter + 1;
                        ** GOTO lbl30
                    }
                }
                break block9;
lbl-1000:
                // 2 sources

                {
                    if (!rtl && current.getAbsoluteX() < c.getAbsoluteX() || rtl && current.getAbsoluteX() > c.getAbsoluteX()) {
                        bestSpot = iter + 1;
                    }
                }
            }
            ++iter;
        }
        components.insertElementAt(c, bestSpot);
    }

    private boolean isInSameColumn(Component source, Component dest) {
        return Rectangle.intersects(source.getAbsoluteX(), source.getAbsoluteY(), source.getWidth(), Integer.MAX_VALUE, dest.getAbsoluteX(), dest.getAbsoluteY(), dest.getWidth(), dest.getHeight());
    }

    private boolean isInSameRow(Component source, Component dest) {
        return Rectangle.intersects(source.getAbsoluteX(), source.getAbsoluteY(), Integer.MAX_VALUE, source.getHeight(), dest.getAbsoluteX(), dest.getAbsoluteY(), dest.getWidth(), dest.getHeight());
    }

    private void addSortedComponent(Vector components, Component c, boolean toTheRight) {
        if (toTheRight) {
            this.addSortedComponentRight(components, c);
        } else {
            this.addSortedComponentDown(components, c);
        }
    }

    public void setDefaultCommand(Command defaultCommand) {
        this.menuBar.setDefaultCommand(defaultCommand);
    }

    public Command getDefaultCommand() {
        return this.menuBar.getDefaultCommand();
    }

    public void setClearCommand(Command clearCommand) {
        this.menuBar.setClearCommand(clearCommand);
    }

    public Command getClearCommand() {
        return this.menuBar.getClearCommand();
    }

    public void setBackCommand(Command backCommand) {
        this.menuBar.setBackCommand(backCommand);
    }

    public Command getBackCommand() {
        return this.menuBar.getBackCommand();
    }

    private void findAllFocusable(Container c, Vector v, boolean toTheRight) {
        int size = c.getComponentCount();
        int iter = 0;
        while (iter < size) {
            Component current = c.getComponentAt(iter);
            if (current instanceof Container && !((Container)current).isBlockFocus()) {
                this.findAllFocusable((Container)current, v, toTheRight);
            }
            if (current.isFocusable()) {
                this.addSortedComponent(v, current, toTheRight);
            }
            ++iter;
        }
    }

    public Form(String title) {
        this();
        this.title.setText(title);
    }

    public Container getContentPane() {
        return this.contentPane;
    }

    public void removeAll() {
        this.contentPane.removeAll();
    }

    public void setBgImage(Image bgImage) {
        this.getStyle().setBgImage(bgImage);
    }

    public void setLayout(Layout layout) {
        this.contentPane.setLayout(layout);
    }

    public void setTitle(String title) {
        this.title.setText(title);
        if (this.isInitialized() && this.title.isTickerEnabled()) {
            if (this.title.shouldTickerStart()) {
                this.title.startTicker(UIManager.getInstance().getLookAndFeel().getTickerSpeed(), true);
            } else if (this.title.isTickerRunning()) {
                this.title.stopTicker();
            }
        }
    }

    public String getTitle() {
        return this.title.getText();
    }

    public void addComponent(Component cmp) {
        this.contentPane.addComponent(cmp);
    }

    public void addComponent(Object constraints, Component cmp) {
        this.contentPane.addComponent(constraints, cmp);
    }

    public void addComponent(int index, Object constraints, Component cmp) {
        this.contentPane.addComponent(index, constraints, cmp);
    }

    public void addComponent(int index, Component cmp) {
        this.contentPane.addComponent(index, cmp);
    }

    public void replace(Component current, Component next, Transition t) {
        this.contentPane.replace(current, next, t);
    }

    public void replaceAndWait(Component current, Component next, Transition t) {
        this.contentPane.replaceAndWait(current, next, t);
    }

    public void removeComponent(Component cmp) {
        this.contentPane.removeComponent(cmp);
    }

    void addComponentToForm(Object constraints, Component cmp) {
        super.addComponent(constraints, cmp);
    }

    void removeComponentFromForm(Component cmp) {
        super.removeComponent(cmp);
    }

    void registerMediaComponent(Component mediaCmp) {
        if (this.mediaComponents == null) {
            this.mediaComponents = new Vector();
        }
        if (!this.mediaComponents.contains(mediaCmp)) {
            this.mediaComponents.addElement(mediaCmp);
        }
    }

    public final boolean hasMedia() {
        return this.mediaComponents != null && this.mediaComponents.size() > 0;
    }

    void deregisterMediaComponent(Component mediaCmp) {
        this.mediaComponents.removeElement(mediaCmp);
    }

    public void registerAnimated(Animation cmp) {
        if (this.animatableComponents == null) {
            this.animatableComponents = new Vector();
        }
        if (!this.animatableComponents.contains(cmp)) {
            this.animatableComponents.addElement(cmp);
        }
        Display.getInstance().notifyDisplay();
    }

    void registerAnimatedInternal(Animation cmp) {
        if (this.internalAnimatableComponents == null) {
            this.internalAnimatableComponents = new Vector();
        }
        if (!this.internalAnimatableComponents.contains(cmp)) {
            this.internalAnimatableComponents.addElement(cmp);
        }
        Display.getInstance().notifyDisplay();
    }

    void deregisterAnimatedInternal(Animation cmp) {
        if (this.internalAnimatableComponents != null) {
            this.internalAnimatableComponents.removeElement(cmp);
        }
    }

    public void deregisterAnimated(Animation cmp) {
        if (this.animatableComponents != null) {
            this.animatableComponents.removeElement(cmp);
        }
    }

    int getFocusPosition(Component c) {
        this.initFocusDown();
        return this.focusDownSequence.indexOf(c);
    }

    int getFocusCount() {
        this.initFocusDown();
        return this.focusDownSequence.size();
    }

    void repaintAnimations() {
        if (this.animatableComponents != null) {
            this.loopAnimations(this.animatableComponents, null);
        }
        if (this.internalAnimatableComponents != null) {
            this.loopAnimations(this.internalAnimatableComponents, this.animatableComponents);
        }
    }

    private void loopAnimations(Vector v, Vector notIn) {
        int iter = 0;
        while (iter < v.size()) {
            Animation c = (Animation)v.elementAt(iter);
            if (c != null && (notIn == null || !notIn.contains(c)) && c.animate()) {
                if (c instanceof Component) {
                    Rectangle rect = ((Component)c).getDirtyRegion();
                    if (rect != null) {
                        Dimension d = rect.getSize();
                        if (d != null) {
                            ((Component)c).repaint(rect.getX(), rect.getY(), d.getWidth(), d.getHeight());
                        }
                    } else {
                        ((Component)c).repaint();
                    }
                } else {
                    Display.getInstance().repaint(c);
                }
            }
            ++iter;
        }
    }

    boolean hasAnimations() {
        return this.animatableComponents != null && this.animatableComponents.size() > 0 || this.internalAnimatableComponents != null && this.internalAnimatableComponents.size() > 0;
    }

    public void refreshTheme() {
        if (this.menuBar != null) {
            this.menuBar.refreshTheme();
        }
        if (this.titleArea != null) {
            this.titleArea.refreshTheme();
        }
        super.refreshTheme();
    }

    public void paintBackground(Graphics g) {
        super.paintBackground(g);
    }

    public Transition getTransitionInAnimator() {
        return this.transitionInAnimator;
    }

    public void setTransitionInAnimator(Transition transitionInAnimator) {
        this.transitionInAnimator = transitionInAnimator;
    }

    public Transition getTransitionOutAnimator() {
        return this.transitionOutAnimator;
    }

    public void setTransitionOutAnimator(Transition transitionOutAnimator) {
        this.transitionOutAnimator = transitionOutAnimator;
    }

    public void setCommandListener(ActionListener commandListener) {
        if (commandListener == null) {
            this.commandListener = null;
            return;
        }
        this.addCommandListener(commandListener);
    }

    public void addCommandListener(ActionListener l) {
        if (this.commandListener == null) {
            this.commandListener = new EventDispatcher();
        }
        this.commandListener.addListener(l);
    }

    public void removeCommandListener(ActionListener l) {
        this.commandListener.removeListener(l);
    }

    protected void actionCommand(Command cmd) {
    }

    public void dispatchCommand(Command cmd, ActionEvent ev) {
        cmd.actionPerformed(ev);
        if (!ev.isConsumed()) {
            this.actionCommandImpl(cmd, ev);
        }
    }

    void actionCommandImpl(Command cmd) {
        this.actionCommandImpl(cmd, new ActionEvent(cmd));
    }

    void actionCommandImpl(Command cmd, ActionEvent ev) {
        if (cmd == null) {
            return;
        }
        if (comboLock) {
            if (cmd == this.menuBar.getCancelMenuItem()) {
                this.actionCommand(cmd);
                return;
            }
            Component c = this.getFocused();
            if (c != null) {
                c.fireClicked();
            }
            return;
        }
        if (cmd != this.menuBar.getSelectCommand()) {
            if (this.commandListener != null) {
                this.commandListener.fireActionEvent(ev);
                if (ev.isConsumed()) {
                    return;
                }
            }
            this.actionCommand(cmd);
        } else {
            Component c = this.getFocused();
            if (c != null) {
                c.fireClicked();
            }
        }
    }

    void initFocused() {
        if (this.focused == null) {
            this.setFocused(this.contentPane.findFirstFocusable());
            this.layoutContainer();
            this.initFocusDown();
            if (this.focusDownSequence == null) {
                this.initFocusDown();
                if (this.focusDownSequence.size() > 0) {
                    this.setFocused((Component)this.focusDownSequence.elementAt(0));
                }
            } else if (this.focusDownSequence.size() > 0) {
                this.setFocused((Component)this.focusDownSequence.elementAt(0));
            }
        }
    }

    public void show() {
        this.show(false);
        this.repaint();
    }

    public void showBack() {
        this.show(true);
    }

    private void show(boolean reverse) {
        if (this.transitionOutAnimator == null && this.transitionInAnimator == null) {
            this.initLaf(UIManager.getInstance().getLookAndFeel());
        }
        this.initFocused();
        this.onShow();
        this.tint = false;
        Display.getInstance().setCurrent(this, reverse);
    }

    void initComponentImpl() {
        super.initComponentImpl();
        LookAndFeel lf = UIManager.getInstance().getLookAndFeel();
        this.tactileTouchDuration = lf.getTactileTouchDuration();
        this.focusScrolling = lf.isFocusScrolling();
        if (this.title.getText() != null && this.title.shouldTickerStart()) {
            this.title.startTicker(lf.getTickerSpeed(), true);
        }
        if (Display.getInstance().isNativeCommands()) {
            Display.getInstance().getImplementation().setNativeCommands(this.menuBar.getCommands());
        }
    }

    public void setSmoothScrolling(boolean smoothScrolling) {
        if (this.contentPane != null) {
            this.contentPane.setSmoothScrolling(smoothScrolling);
        }
    }

    public boolean isSmoothScrolling() {
        return this.contentPane.isSmoothScrolling();
    }

    public int getScrollAnimationSpeed() {
        return this.contentPane.getScrollAnimationSpeed();
    }

    public void setScrollAnimationSpeed(int animationSpeed) {
        this.contentPane.setScrollAnimationSpeed(animationSpeed);
    }

    protected void onShow() {
    }

    protected void onShowCompleted() {
    }

    void onShowCompletedImpl() {
        this.onShowCompleted();
        if (this.showListener != null) {
            this.showListener.fireActionEvent(new ActionEvent(this));
        }
    }

    void showModal(int top, int bottom, int left, int right, boolean includeTitle, boolean modal, boolean reverse) {
        Display.getInstance().flushEdt();
        if (this.previousForm == null) {
            Dialog previousDialog;
            this.previousForm = Display.getInstance().getCurrent();
            if (this.previousForm == null) {
                this.previousForm = new Form();
                this.previousForm.show();
            } else if (this.previousForm instanceof Dialog && (previousDialog = (Dialog)this.previousForm).isDisposed()) {
                this.previousForm = Display.getInstance().getCurrentUpcoming();
            }
            this.previousForm.tint = true;
        }
        Painter p = this.getStyle().getBgPainter();
        if (top > 0 || bottom > 0 || left > 0 || right > 0) {
            Style titleStyle = this.title.getStyle();
            Style contentStyle = this.contentPane.getUnselectedStyle();
            if (includeTitle) {
                titleStyle.setMargin(0, top, false);
                titleStyle.setMargin(2, 0, false);
                titleStyle.setMargin(1, left, false);
                titleStyle.setMargin(3, right, false);
                contentStyle.setMargin(0, 0, false);
                contentStyle.setMargin(2, bottom, false);
                contentStyle.setMargin(1, left, false);
                contentStyle.setMargin(3, right, false);
            } else {
                titleStyle.setMargin(0, 0, false);
                titleStyle.setMargin(2, 0, false);
                titleStyle.setMargin(1, 0, false);
                titleStyle.setMargin(3, 0, false);
                contentStyle.setMargin(0, top, false);
                contentStyle.setMargin(2, bottom, false);
                contentStyle.setMargin(1, left, false);
                contentStyle.setMargin(3, right, false);
            }
            if (p instanceof Component.BGPainter && ((Component.BGPainter)p).getPreviousForm() != null) {
                ((Component.BGPainter)p).setPreviousForm(this.previousForm);
            } else {
                Component.BGPainter b = new Component.BGPainter(this, this, p);
                this.getStyle().setBgPainter(b);
                b.setPreviousForm(this.previousForm);
            }
            this.revalidate();
        }
        this.initFocused();
        if (this.getTransitionOutAnimator() == null && this.getTransitionInAnimator() == null) {
            this.initLaf(UIManager.getInstance().getLookAndFeel());
        }
        this.initComponentImpl();
        Display.getInstance().setCurrent(this, reverse);
        this.onShow();
        if (modal) {
            Display.getInstance().invokeAndBlock(new RunnableWrapper(this, p, reverse));
            Display.getInstance().setShowVirtualKeyboard(false);
        }
    }

    void showModal(boolean reverse) {
        this.showDialog(true, reverse);
    }

    void showDialog(boolean modal, boolean reverse) {
        int h = Display.getInstance().getDisplayHeight() - this.menuBar.getPreferredH() - this.title.getPreferredH();
        int w = Display.getInstance().getDisplayWidth();
        int topSpace = h / 100 * 20;
        int bottomSpace = h / 100 * 10;
        int sideSpace = w / 100 * 20;
        this.showModal(topSpace, bottomSpace, sideSpace, sideSpace, true, modal, reverse);
    }

    void dispose() {
        this.disposeImpl();
    }

    boolean isDisposed() {
        return false;
    }

    void disposeImpl() {
        if (this.previousForm != null) {
            this.previousForm.tint = false;
            if (this.previousForm instanceof Dialog) {
                if (!((Dialog)this.previousForm).isDisposed()) {
                    Display.getInstance().setCurrent(this.previousForm, false);
                }
            } else {
                Display.getInstance().setCurrent(this.previousForm, false);
            }
            this.previousForm = null;
        }
    }

    boolean isMenu() {
        return false;
    }

    void repaint(Component cmp) {
        if (this.isVisible()) {
            Display.getInstance().repaint(cmp);
        }
    }

    public final Form getComponentForm() {
        return this;
    }

    void hideMenu() {
        this.menuBar.unInstallMenuBar();
    }

    void restoreMenu() {
        this.menuBar.installMenuBar();
    }

    public void setFocused(Component focused) {
        if (this.focused == focused && focused != null) {
            this.focused.repaint();
            return;
        }
        Component oldFocus = this.focused;
        this.focused = focused;
        boolean triggerRevalidate = false;
        if (oldFocus != null && !(triggerRevalidate = this.changeFocusState(oldFocus, false)) && oldFocus.getParent() != null) {
            oldFocus.repaint();
        }
        if (focused != null && this.focused == focused) {
            boolean bl = triggerRevalidate = this.changeFocusState(focused, true) || triggerRevalidate;
            if (!triggerRevalidate) {
                focused.repaint();
            }
        }
        if (triggerRevalidate) {
            this.revalidate();
        }
    }

    private boolean changeFocusState(Component cmp, boolean gained) {
        Dimension d;
        boolean trigger = false;
        Style selected = cmp.getSelectedStyle();
        Style unselected = cmp.getUnselectedStyle();
        if (!selected.getFont().equals(unselected.getFont()) || selected.getPadding(false, 0) != unselected.getPadding(false, 0) || selected.getPadding(false, 2) != unselected.getPadding(false, 2) || selected.getPadding(this.isRTL(), 3) != unselected.getPadding(this.isRTL(), 3) || selected.getPadding(this.isRTL(), 1) != unselected.getPadding(this.isRTL(), 1) || selected.getMargin(false, 0) != unselected.getMargin(false, 0) || selected.getMargin(false, 2) != unselected.getMargin(false, 2) || selected.getMargin(this.isRTL(), 3) != unselected.getMargin(this.isRTL(), 3) || selected.getMargin(this.isRTL(), 1) != unselected.getMargin(this.isRTL(), 1)) {
            trigger = true;
        }
        int prefW = 0;
        int prefH = 0;
        if (trigger) {
            d = cmp.getPreferredSize();
            prefW = d.getWidth();
            prefH = d.getHeight();
        }
        if (gained) {
            cmp.setFocus(true);
            cmp.fireFocusGained();
            this.fireFocusGained(cmp);
        } else {
            cmp.setFocus(false);
            cmp.fireFocusLost();
            this.fireFocusLost(cmp);
        }
        if (trigger) {
            cmp.setShouldCalcPreferredSize(true);
            d = cmp.getPreferredSize();
            if (prefW != d.getWidth() || prefH != d.getHeight()) {
                cmp.setShouldCalcPreferredSize(false);
                trigger = false;
            }
        }
        return trigger;
    }

    public Component getFocused() {
        return this.focused;
    }

    protected void longKeyPress(int keyCode) {
        if (this.focused != null && this.focused.getComponentForm() == this) {
            this.focused.longKeyPress(keyCode);
        }
    }

    protected void longPointerPress(int x, int y) {
        if (this.focused != null && this.focused.contains(x, y) && this.focused.getComponentForm() == this) {
            this.focused.longPointerPress(x, y);
        }
    }

    public void keyPressed(int keyCode) {
        int game = Display.getInstance().getGameAction(keyCode);
        if (this.menuBar.handlesKeycode(keyCode)) {
            this.menuBar.keyPressed(keyCode);
            return;
        }
        if (this.focused != null) {
            if (this.focused.isEnabled()) {
                this.focused.keyPressed(keyCode);
            }
            if (this.focused == null) {
                this.initFocused();
                return;
            }
            if (this.focused.handlesInput()) {
                return;
            }
            if (this.focused.getComponentForm() == this) {
                if (this.focused != null && this.focused.handlesInput()) {
                    return;
                }
                this.updateFocus(Display.getInstance().getGameAction(keyCode));
            } else {
                this.initFocused();
            }
        } else {
            this.initFocused();
            if (this.focused == null) {
                this.contentPane.moveScrollTowards(Display.getInstance().getGameAction(keyCode), null);
                return;
            }
        }
    }

    public Layout getLayout() {
        return this.contentPane.getLayout();
    }

    public void keyReleased(int keyCode) {
        Command defaultCmd;
        int game = Display.getInstance().getGameAction(keyCode);
        if (this.menuBar.handlesKeycode(keyCode)) {
            this.menuBar.keyReleased(keyCode);
            return;
        }
        if (this.focused != null && this.focused.getComponentForm() == this && this.focused.isEnabled()) {
            this.focused.keyReleased(keyCode);
        }
        if (game == 8 && (defaultCmd = this.getDefaultCommand()) != null) {
            defaultCmd.actionPerformed(new ActionEvent(defaultCmd, keyCode));
            this.actionCommandImpl(defaultCmd);
        }
        this.fireKeyEvent(this.keyListeners, keyCode);
        this.fireKeyEvent(this.gameKeyListeners, game);
    }

    private void fireKeyEvent(Hashtable keyListeners, int keyCode) {
        Vector listeners;
        if (keyListeners != null && (listeners = (Vector)keyListeners.get(new Integer(keyCode))) != null) {
            ActionEvent evt = new ActionEvent(this, keyCode);
            int iter = 0;
            while (iter < listeners.size()) {
                ((ActionListener)listeners.elementAt(iter)).actionPerformed(evt);
                if (evt.isConsumed()) {
                    return;
                }
                ++iter;
            }
        }
    }

    public void keyRepeated(int keyCode) {
        if (this.focused != null) {
            if (this.focused.isEnabled()) {
                this.focused.keyRepeated(keyCode);
            }
            int game = Display.getInstance().getGameAction(keyCode);
            if (!(this.focused.handlesInput() || game != 6 && game != 1 && game != 2 && game != 5)) {
                this.keyPressed(keyCode);
                this.keyReleased(keyCode);
            }
        } else {
            this.keyPressed(keyCode);
            this.keyReleased(keyCode);
        }
    }

    private void tactileTouchVibe(int x, int y, Component cmp) {
        if (this.tactileTouchDuration > 0 && cmp.isTactileTouch(x, y)) {
            Display.getInstance().vibrate(this.tactileTouchDuration);
        }
    }

    public void pointerPressed(int x, int y) {
        if (this.pointerPressedListeners != null) {
            this.pointerPressedListeners.fireActionEvent(new ActionEvent(this, x, y));
        }
        if (this.menuBar.contains(x, y)) {
            Component cmp = this.menuBar.getComponentAt(x, y);
            if (cmp != null && cmp.isEnabled()) {
                cmp.pointerPressed(x, y);
                this.tactileTouchVibe(x, y, cmp);
            }
            return;
        }
        if (y >= this.contentPane.getY()) {
            Component cmp = this.contentPane.getComponentAt(x, y);
            if (cmp != null) {
                if (cmp.hasLead) {
                    cmp.getLeadComponent().pointerPressed(x, y);
                } else if (cmp.isEnabled() && cmp.isFocusable()) {
                    this.setFocused(cmp);
                    cmp.pointerPressed(x, y);
                    this.tactileTouchVibe(x, y, cmp);
                }
            }
        } else {
            Component cmp = this.titleArea.getComponentAt(x, y);
            if (cmp != null && cmp.isEnabled() && cmp.isFocusable()) {
                cmp.pointerPressed(x, y);
                this.tactileTouchVibe(x, y, cmp);
            }
        }
    }

    public void addPointerPressedListener(ActionListener l) {
        if (this.pointerPressedListeners == null) {
            this.pointerPressedListeners = new EventDispatcher();
        }
        this.pointerPressedListeners.addListener(l);
    }

    public void removePointerPressedListener(ActionListener l) {
        if (this.pointerPressedListeners != null) {
            this.pointerPressedListeners.removeListener(l);
        }
    }

    public void addPointerReleasedListener(ActionListener l) {
        if (this.pointerReleasedListeners == null) {
            this.pointerReleasedListeners = new EventDispatcher();
        }
        this.pointerReleasedListeners.addListener(l);
    }

    public void removePointerReleasedListener(ActionListener l) {
        if (this.pointerReleasedListeners != null) {
            this.pointerReleasedListeners.removeListener(l);
        }
    }

    public void addPointerDraggedListener(ActionListener l) {
        if (this.pointerDraggedListeners == null) {
            this.pointerDraggedListeners = new EventDispatcher();
        }
        this.pointerDraggedListeners.addListener(l);
    }

    public void removePointerDraggedListener(ActionListener l) {
        if (this.pointerDraggedListeners != null) {
            this.pointerDraggedListeners.removeListener(l);
        }
    }

    public void pointerDragged(int x, int y) {
        if (this.pointerDraggedListeners != null) {
            this.pointerDraggedListeners.fireActionEvent(new ActionEvent(this, x, y));
        }
        if (this.dragged != null) {
            this.dragged.pointerDragged(x, y);
            return;
        }
        Component cmp = this.contentPane.getComponentAt(x, y);
        if (cmp != null) {
            if (cmp.isFocusable() && cmp.isEnabled()) {
                this.setFocused(cmp);
            }
            cmp.pointerDragged(x, y);
            cmp.repaint();
        }
    }

    public void pointerHoverReleased(int[] x, int[] y) {
        if (this.dragged != null) {
            this.dragged.pointerHoverReleased(x, y);
            this.dragged = null;
            return;
        }
        Component cmp = this.contentPane.getComponentAt(x[0], y[0]);
        if (cmp != null) {
            if (cmp.isFocusable() && cmp.isEnabled()) {
                this.setFocused(cmp);
            }
            cmp.pointerHoverReleased(x, y);
            cmp.repaint();
        }
    }

    public void pointerHoverPressed(int[] x, int[] y) {
        Component cmp = this.contentPane.getComponentAt(x[0], y[0]);
        if (cmp != null) {
            if (cmp.isFocusable() && cmp.isEnabled()) {
                this.setFocused(cmp);
            }
            cmp.pointerHoverPressed(x, y);
            cmp.repaint();
        }
    }

    public void pointerHover(int[] x, int[] y) {
        if (this.dragged != null) {
            this.dragged.pointerHover(x, y);
            return;
        }
        Component cmp = this.contentPane.getComponentAt(x[0], y[0]);
        if (cmp != null) {
            if (cmp.isFocusable() && cmp.isEnabled()) {
                this.setFocused(cmp);
            }
            cmp.pointerHover(x, y);
            cmp.repaint();
        }
    }

    public boolean isSingleFocusMode() {
        this.initFocusDown();
        return this.focusDownSequence.size() == 1;
    }

    public void pointerReleased(int x, int y) {
        if (this.pointerReleasedListeners != null) {
            this.pointerReleasedListeners.fireActionEvent(new ActionEvent(this, x, y));
        }
        if (this.dragged == null) {
            if (this.menuBar.contains(x, y)) {
                Component cmp = this.menuBar.getComponentAt(x, y);
                if (cmp != null && cmp.isEnabled()) {
                    cmp.pointerReleased(x, y);
                }
                return;
            }
            if (y >= this.contentPane.getY()) {
                Component cmp = this.contentPane.getComponentAt(x, y);
                if (cmp != null && cmp.isEnabled()) {
                    if (cmp.hasLead) {
                        cmp.getLeadComponent().pointerReleased(x, y);
                    } else if (cmp.isEnabled()) {
                        if (cmp.isFocusable()) {
                            this.setFocused(cmp);
                        }
                        cmp.pointerReleased(x, y);
                    }
                }
            } else {
                Component cmp = this.titleArea.getComponentAt(x, y);
                if (cmp != null && cmp.isEnabled()) {
                    cmp.pointerReleased(x, y);
                }
            }
        } else {
            this.dragged.pointerReleased(x, y);
            this.dragged = null;
        }
    }

    public void setScrollableY(boolean scrollableY) {
        this.getContentPane().setScrollableY(scrollableY);
    }

    public void setScrollableX(boolean scrollableX) {
        this.getContentPane().setScrollableX(scrollableX);
    }

    public int getComponentIndex(Component cmp) {
        return this.getContentPane().getComponentIndex(cmp);
    }

    public void addCommand(Command cmd, int offset) {
        this.menuBar.addCommand(cmd, offset);
    }

    public int getCommandCount() {
        return this.menuBar.getCommandCount();
    }

    public Command getCommand(int index) {
        return this.menuBar.getCommand(index);
    }

    public void addCommand(Command cmd) {
        this.addCommand(cmd, 0);
    }

    public void removeCommand(Command cmd) {
        this.menuBar.removeCommand(cmd);
    }

    public void setCyclicFocus(boolean cyclicFocus) {
        this.cyclicFocus = cyclicFocus;
    }

    public boolean isCyclicFocus() {
        return this.cyclicFocus;
    }

    private void updateFocus(int gameAction) {
        Component focused = this.getFocused();
        switch (gameAction) {
            case 6: {
                Component down = focused.getNextFocusDown();
                if (down != null && down.getComponentForm() == this) {
                    focused = down;
                    break;
                }
                this.initFocusDown();
                int i = this.focusDownSequence.indexOf(focused) + 1;
                if (this.focusDownSequence.size() <= 0) break;
                if (i == this.focusDownSequence.size()) {
                    i = this.cyclicFocus ? 0 : this.focusDownSequence.size() - 1;
                }
                focused = (Component)this.focusDownSequence.elementAt(i);
                break;
            }
            case 1: {
                Component up = focused.getNextFocusUp();
                if (up != null && up.getComponentForm() == this) {
                    focused = up;
                    break;
                }
                this.initFocusDown();
                if (this.focusDownSequence.size() <= 0) break;
                int i = this.focusDownSequence.indexOf(focused) - 1;
                if (i < 0) {
                    i = this.cyclicFocus ? this.focusDownSequence.size() - 1 : 0;
                }
                focused = (Component)this.focusDownSequence.elementAt(i);
                break;
            }
            case 5: {
                Component right = focused.getNextFocusRight();
                if (right != null && right.getComponentForm() == this) {
                    focused = right;
                    break;
                }
                this.initFocusRight();
                if (this.focusRightSequence.size() <= 0) break;
                int i = this.focusRightSequence.indexOf(focused) + 1;
                if (i == this.focusRightSequence.size()) {
                    i = this.cyclicFocus ? 0 : this.focusRightSequence.size() - 1;
                }
                focused = (Component)this.focusRightSequence.elementAt(i);
                break;
            }
            case 2: {
                Component left = focused.getNextFocusLeft();
                if (left != null && left.getComponentForm() == this) {
                    focused = left;
                    break;
                }
                this.initFocusRight();
                if (this.focusRightSequence.size() <= 0) break;
                int i = this.focusRightSequence.indexOf(focused) - 1;
                if (i < 0) {
                    i = this.cyclicFocus ? this.focusRightSequence.size() - 1 : 0;
                }
                focused = (Component)this.focusRightSequence.elementAt(i);
                break;
            }
            default: {
                return;
            }
        }
        if (this.isFocusScrolling()) {
            this.setFocused(focused);
            if (focused != null) {
                this.scrollComponentToVisible(focused);
            }
        } else if (this.moveScrollTowards(gameAction, focused)) {
            this.setFocused(focused);
            this.scrollComponentToVisible(focused);
        }
    }

    boolean moveScrollTowards(int direction, Component c) {
        Component current = this.getFocused();
        if (current != null) {
            Container parent = current instanceof Container ? (Container)current : current.getParent();
            while (parent != null) {
                if (parent.isScrollable()) {
                    return parent.moveScrollTowards(direction, c);
                }
                parent = parent.getParent();
            }
        }
        return true;
    }

    public void scrollComponentToVisible(Component c) {
        this.initFocused();
        Container parent = c.getParent();
        while (parent != null) {
            if (parent.isScrollable()) {
                parent.scrollComponentToVisible(c);
                return;
            }
            parent = parent.getParent();
        }
    }

    public void setMenuCellRenderer(ListCellRenderer menuCellRenderer) {
        this.menuBar.setMenuCellRenderer(menuCellRenderer);
    }

    public void removeAllCommands() {
        this.menuBar.removeAllCommands();
    }

    void requestFocus(Component cmp) {
        if (cmp.isFocusable() && this.contains(cmp)) {
            this.scrollComponentToVisible(cmp);
            this.setFocused(cmp);
        }
    }

    public void setRTL(boolean r) {
        super.setRTL(r);
        this.contentPane.setRTL(r);
    }

    public void paint(Graphics g) {
        this.paintBackground(g);
        super.paint(g);
        if (this.tint) {
            g.setColor(this.tintColor);
            g.fillRect(0, 0, this.getWidth(), this.getHeight(), (byte)(this.tintColor >> 24 & 0xFF));
        }
    }

    public void setScrollable(boolean scrollable) {
        this.contentPane.setScrollable(scrollable);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.mediaComponents != null) {
            int size = this.mediaComponents.size();
            int i = 0;
            while (i < size) {
                Component mediaCmp = (Component)this.mediaComponents.elementAt(i);
                mediaCmp.setVisible(visible);
                ++i;
            }
        }
    }

    public int getTintColor() {
        return this.tintColor;
    }

    public void setTintColor(int tintColor) {
        this.tintColor = tintColor;
    }

    public void setMenuTransitions(Transition transitionIn, Transition transitionOut) {
        this.menuBar.setTransitions(transitionIn, transitionOut);
    }

    protected String paramString() {
        return String.valueOf(super.paramString()) + ", title = " + this.title + ", visible = " + this.isVisible();
    }

    protected Command showMenuDialog(Dialog menu) {
        return this.menuBar.showMenuDialog(menu);
    }

    protected Component createCommandComponent(Vector commands) {
        return this.menuBar.createCommandComponent(commands);
    }

    protected List createCommandList(Vector commands) {
        return this.menuBar.createCommandList(commands);
    }

    protected boolean isReverseSoftButtons() {
        return this.menuBar.isReverseSoftButtons();
    }

    public MenuBar getMenuBar() {
        return this.menuBar;
    }

    public void setMenuBar(MenuBar menuBar) {
        this.menuBar = menuBar;
    }

    public boolean isFocusScrolling() {
        return this.focusScrolling;
    }

    public void setFocusScrolling(boolean focusScrolling) {
        this.focusScrolling = focusScrolling;
    }
}

