/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Button;
import com.sun.lwuit.Command;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Dialog;
import com.sun.lwuit.Display;
import com.sun.lwuit.Form;
import com.sun.lwuit.List;
import com.sun.lwuit.animations.CommonTransitions;
import com.sun.lwuit.animations.Transition;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.layouts.FlowLayout;
import com.sun.lwuit.layouts.GridLayout;
import com.sun.lwuit.list.ListCellRenderer;
import com.sun.lwuit.plaf.Border;
import com.sun.lwuit.plaf.LookAndFeel;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.plaf.UIManager;
import java.util.Vector;

public class MenuBar
extends Container
implements ActionListener {
    private Command selectCommand;
    private Command defaultCommand;
    private Command backCommand;
    private Command clearCommand;
    static int leftSK;
    static int rightSK;
    static int rightSK2;
    static int backSK;
    static int clearSK;
    static int backspaceSK;
    private Command menuCommand;
    private Vector commands = new Vector();
    private Button[] soft;
    private Command[] softCommand;
    private Button left;
    private Button right;
    private Button main;
    private ListCellRenderer menuCellRenderer;
    private Transition transitionIn;
    private Transition transitionOut;
    private Component commandList;
    private Style menuStyle;
    private Command selectMenuItem;
    private Command cancelMenuItem;
    private Form parent;
    private int softkeyCount;
    private boolean thirdSoftButton;

    static {
        if (Display.getInstance() == null || Display.getInstance().getImplementation() == null) {
            leftSK = -6;
            rightSK = -7;
            rightSK2 = -7;
            backSK = -11;
            clearSK = -8;
            backspaceSK = -8;
        }
    }

    protected void initMenuBar(Form parent) {
        this.parent = parent;
        this.selectMenuItem = this.createMenuSelectCommand();
        this.cancelMenuItem = this.createMenuCancelCommand();
        LookAndFeel lf = UIManager.getInstance().getLookAndFeel();
        this.menuStyle = UIManager.getInstance().getComponentStyle("Menu");
        this.menuStyle.setBgTransparency(255);
        this.setUIID("SoftButton");
        this.menuCommand = new Command(UIManager.getInstance().localize("menu", "Menu"), lf.getMenuIcons()[2]);
        if (lf.getDefaultMenuTransitionIn() != null || lf.getDefaultMenuTransitionOut() != null) {
            this.transitionIn = lf.getDefaultMenuTransitionIn();
            this.transitionOut = lf.getDefaultMenuTransitionOut();
        } else {
            this.transitionIn = CommonTransitions.createSlide(1, true, 300, true);
            this.transitionOut = CommonTransitions.createSlide(1, false, 300, true);
        }
        this.menuCellRenderer = lf.getMenuRenderer();
        this.softkeyCount = Display.getInstance().getImplementation().getSoftkeyCount();
        this.thirdSoftButton = Display.getInstance().isThirdSoftButton();
        int commandBehavior = this.getCommandBehavior();
        if (this.softkeyCount > 1 && commandBehavior < 4) {
            Button b;
            if (this.thirdSoftButton) {
                this.setLayout(new GridLayout(1, 3));
                this.soft = new Button[]{this.createSoftButton("SoftButtonCenter"), this.createSoftButton("SoftButtonLeft"), this.createSoftButton("SoftButtonRight")};
                this.main = this.soft[0];
                this.left = this.soft[1];
                this.right = this.soft[2];
                if (parent.isRTL()) {
                    this.right.setUIID("SoftButtonLeft");
                    this.left.setUIID("SoftButtonRight");
                    this.addComponent(this.right);
                    this.addComponent(this.main);
                    this.addComponent(this.left);
                } else {
                    this.addComponent(this.left);
                    this.addComponent(this.main);
                    this.addComponent(this.right);
                }
                if (this.isReverseSoftButtons()) {
                    b = this.soft[1];
                    this.soft[1] = this.soft[2];
                    this.soft[2] = b;
                }
            } else {
                this.setLayout(new GridLayout(1, 2));
                this.soft = new Button[]{this.createSoftButton("SoftButtonLeft"), this.createSoftButton("SoftButtonRight")};
                this.main = this.soft[0];
                this.left = this.soft[0];
                this.right = this.soft[1];
                if (parent.isRTL()) {
                    this.right.setUIID("SoftButtonLeft");
                    this.left.setUIID("SoftButtonRight");
                    this.addComponent(this.right);
                    this.addComponent(this.left);
                } else {
                    this.addComponent(this.left);
                    this.addComponent(this.right);
                }
                if (this.isReverseSoftButtons()) {
                    b = this.soft[0];
                    this.soft[0] = this.soft[1];
                    this.soft[1] = b;
                }
            }
            int iter = 0;
            while (iter < this.soft.length) {
                this.soft[iter].setEndsWith3Points(false);
                ++iter;
            }
        } else if (this.thirdSoftButton) {
            this.setLayout(new GridLayout(1, 3));
            this.soft = new Button[]{this.createSoftButton("SoftButtonCenter"), this.createSoftButton("SoftButtonLeft"), this.createSoftButton("SoftButtonRight")};
            this.main = this.soft[0];
            this.left = this.soft[1];
            this.right = this.soft[2];
            this.addComponent(this.left);
            this.addComponent(this.main);
            this.addComponent(this.right);
            if (this.isReverseSoftButtons()) {
                Button b = this.soft[1];
                this.soft[1] = this.soft[2];
                this.soft[2] = b;
            }
        } else {
            this.soft = new Button[]{this.createSoftButton("SoftButtonCenter")};
        }
        this.softCommand = new Command[this.soft.length];
    }

    private int getCommandBehavior() {
        int i = Display.getInstance().getCommandBehavior();
        if (i == 1) {
            if (Display.getInstance().isTouchScreenDevice()) {
                return 3;
            }
            return 2;
        }
        return i;
    }

    public void setDefaultCommand(Command defaultCommand) {
        this.defaultCommand = defaultCommand;
    }

    public Command getDefaultCommand() {
        if (this.selectCommand != null) {
            return this.selectCommand;
        }
        return this.defaultCommand;
    }

    public void setClearCommand(Command clearCommand) {
        this.clearCommand = clearCommand;
    }

    public Command getClearCommand() {
        return this.clearCommand;
    }

    public void setBackCommand(Command backCommand) {
        this.backCommand = backCommand;
        int commandBehavior = this.getCommandBehavior();
        if (commandBehavior == 5 && !(this.parent instanceof Dialog)) {
            Container t = this.parent.getTitleArea();
            if (t.getLayout() instanceof BorderLayout) {
                if (backCommand == null) {
                    return;
                }
                FlowLayout f = new FlowLayout();
                f.setValign(4);
                t.setLayout(f);
            }
            Button b = null;
            int iter = 0;
            while (iter < t.getComponentCount()) {
                Component c = t.getComponentAt(iter);
                if (c instanceof Button) {
                    b = (Button)c;
                    break;
                }
                ++iter;
            }
            if (backCommand == null) {
                if (b != null) {
                    t.removeComponent(b);
                    t.setLayout(new BorderLayout());
                    Component title = t.getComponentAt(0);
                    t.removeComponent(title);
                    t.addComponent("Center", title);
                }
            } else {
                if (b == null) {
                    b = new Button(backCommand);
                    b.setUIID("BackCommand");
                    t.addComponent(0, (Component)b);
                } else {
                    b.setCommand(backCommand);
                }
                this.removeCommand(backCommand);
            }
        }
    }

    public Command getBackCommand() {
        return this.backCommand;
    }

    public Command getSelectCommand() {
        return this.selectCommand;
    }

    public void setSelectCommand(Command selectCommand) {
        this.selectCommand = selectCommand;
    }

    private void updateCommands() {
        int commandBehavior = this.getCommandBehavior();
        if (commandBehavior == 6) {
            Display.getInstance().getImplementation().setNativeCommands(this.commands);
            return;
        }
        if (commandBehavior >= 4) {
            return;
        }
        if (this.soft.length > 1) {
            this.soft[0].setText("");
            this.soft[1].setText("");
            this.soft[0].setIcon(null);
            this.soft[1].setIcon(null);
            int commandSize = this.getCommandCount();
            if (this.soft.length > 2) {
                this.soft[2].setText("");
                if (commandSize > 2) {
                    this.softCommand[2] = commandSize > 3 ? this.menuCommand : this.getCommand(this.getCommandCount() - 3);
                    this.soft[2].setText(this.softCommand[2].getCommandName());
                    this.soft[2].setIcon(this.softCommand[2].getIcon());
                } else {
                    this.softCommand[2] = null;
                }
            }
            if (commandSize > 0) {
                this.softCommand[0] = this.getCommand(this.getCommandCount() - 1);
                this.soft[0].setText(this.softCommand[0].getCommandName());
                this.soft[0].setIcon(this.softCommand[0].getIcon());
                if (commandSize > 1) {
                    this.softCommand[1] = this.soft.length == 2 && commandSize > 2 ? this.menuCommand : this.getCommand(this.getCommandCount() - 2);
                    this.soft[1].setText(this.softCommand[1].getCommandName());
                    this.soft[1].setIcon(this.softCommand[1].getIcon());
                } else {
                    this.softCommand[1] = null;
                }
            } else {
                this.softCommand[0] = null;
                this.softCommand[1] = null;
            }
            if (commandSize == 1 && this.parent.isVisible()) {
                this.parent.revalidate();
            }
            this.repaint();
        }
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.isConsumed()) {
            return;
        }
        Object src = evt.getSource();
        if (this.commandList == null) {
            Button source = (Button)src;
            int iter = 0;
            while (iter < this.soft.length) {
                if (source == this.soft[iter]) {
                    if (this.softCommand[iter] == this.menuCommand) {
                        this.showMenu();
                        return;
                    }
                    if (this.softCommand[iter] != null) {
                        ActionEvent e = new ActionEvent(this.softCommand[iter]);
                        this.softCommand[iter].actionPerformed(e);
                        if (!e.isConsumed()) {
                            this.parent.actionCommandImpl(this.softCommand[iter]);
                        }
                    }
                    return;
                }
                ++iter;
            }
        } else {
            if (src instanceof Button) {
                int iter = 0;
                while (iter < this.soft.length) {
                    if (src == this.soft[iter]) {
                        Container parent = this.commandList.getParent();
                        while (parent != null) {
                            if (parent instanceof Dialog) {
                                ((Dialog)parent).actionCommand(this.softCommand[iter]);
                                return;
                            }
                            parent = parent.getParent();
                        }
                    }
                    ++iter;
                }
            }
            Command c = this.getComponentSelectedCommand(this.commandList);
            Container p = this.commandList.getParent();
            while (p != null) {
                if (p instanceof Dialog) {
                    ((Dialog)p).actionCommand(c);
                    return;
                }
                p = p.getParent();
            }
        }
    }

    protected Button createSoftButton(String uiid) {
        Button b = new Button();
        b.setUIID(uiid);
        Style[] styles = new Style[]{b.getStyle(), b.getDisabledStyle(), b.getPressedStyle(), b.getSelectedStyle(), b.getUnselectedStyle()};
        int i = 0;
        while (i < styles.length) {
            Style style = styles[i];
            style.setFgColor(0xFFFFFF);
            style.setBgTransparency(255);
            style.setBorder(null);
            ++i;
        }
        b.addActionListener(this);
        b.setFocusPainted(false);
        b.setFocusable(false);
        b.setTactileTouch(true);
        this.updateSoftButtonStyle(b);
        return b;
    }

    private void updateSoftButtonStyle(Button b) {
        if (this.softkeyCount < 2) {
            b.getStyle().setMargin(0, 0, 0, 0);
            b.getStyle().setPadding(0, 0, 0, 0);
        }
    }

    public void setUnselectedStyle(Style style) {
        style.setMargin(0, 0, true);
        style.setMargin(2, 0, true);
        super.setUnselectedStyle(style);
        if (this.soft != null) {
            int iter = 0;
            while (iter < this.soft.length) {
                this.updateSoftButtonStyle(this.soft[iter]);
                ++iter;
            }
        }
    }

    protected Dimension calcPreferredSize() {
        if (this.soft.length > 1) {
            Dimension d = super.calcPreferredSize();
            if (!(this.soft[0].getText() != null && !this.soft[0].getText().equals("") || this.soft[1].getText() != null && !this.soft[1].getText().equals("") || this.soft[0].getIcon() != null || this.soft[1].getIcon() != null || this.soft.length >= 3 && (this.soft[2].getText() != null && !this.soft[2].getText().equals("") || this.soft[2].getIcon() != null))) {
                d.setHeight(0);
            }
            return d;
        }
        return super.calcPreferredSize();
    }

    public void setTransitions(Transition transitionIn, Transition transitionOut) {
        this.transitionIn = transitionIn;
        this.transitionOut = transitionOut;
    }

    public void showMenu() {
        Form upcoming;
        Command result;
        Dialog d = new Dialog("Menu", "");
        d.setDisposeWhenPointerOutOfBounds(true);
        d.setMenu(true);
        d.setTransitionInAnimator(this.transitionIn);
        d.setTransitionOutAnimator(this.transitionOut);
        d.setLayout(new BorderLayout());
        d.setScrollable(false);
        d.getMenuBar().commandList = this.parent.createCommandComponent(this.commands);
        if (this.menuCellRenderer != null && d.getMenuBar().commandList instanceof List) {
            ((List)d.getMenuBar().commandList).setListCellRenderer(this.menuCellRenderer);
        }
        d.getContentPane().getStyle().setMargin(0, 0, 0, 0);
        Container listContainer = new Container(new BorderLayout());
        listContainer.addComponent("South", d.getMenuBar().commandList);
        d.addComponent("Center", (Component)listContainer);
        if (this.thirdSoftButton) {
            d.addCommand(this.selectMenuItem);
            d.addCommand(this.cancelMenuItem);
        } else {
            d.addCommand(this.cancelMenuItem);
            if (this.soft.length > 1) {
                d.addCommand(this.selectMenuItem);
            }
        }
        d.setClearCommand(this.cancelMenuItem);
        d.setBackCommand(this.cancelMenuItem);
        if (d.getMenuBar().commandList instanceof List) {
            ((List)d.getMenuBar().commandList).addActionListener(d.getMenuBar());
        }
        if ((result = this.parent.showMenuDialog(d)) != this.cancelMenuItem) {
            Command c = null;
            if (result == this.selectMenuItem) {
                c = this.getComponentSelectedCommand(d.getMenuBar().commandList);
                if (c != null) {
                    ActionEvent e = new ActionEvent(c);
                    c.actionPerformed(e);
                }
            } else {
                c = result;
                if (!UIManager.getInstance().getLookAndFeel().isTouchMenus() && (c = result) != null) {
                    ActionEvent e = new ActionEvent(c);
                    c.actionPerformed(e);
                }
            }
            if (c != null) {
                this.parent.actionCommandImpl(c);
            }
        }
        if (d.getMenuBar().commandList instanceof List) {
            ((List)d.getMenuBar().commandList).removeActionListener(d.getMenuBar());
        }
        if ((upcoming = Display.getInstance().getCurrentUpcoming()) == this.parent) {
            d.disposeImpl();
        } else {
            this.parent.tint = upcoming instanceof Dialog;
        }
    }

    Button[] getSoftButtons() {
        return this.soft;
    }

    public void addCommand(Command cmd) {
        int behavior;
        if (this.commands.contains(cmd)) {
            return;
        }
        if (this.soft.length > 2 && cmd == this.parent.getDefaultCommand()) {
            this.commands.addElement(cmd);
        } else {
            this.commands.insertElementAt(cmd, 0);
        }
        if (!(this.parent instanceof Dialog || (behavior = this.getCommandBehavior()) != 4 && behavior != 5)) {
            if (behavior == 5 && cmd == this.parent.getBackCommand()) {
                return;
            }
            if (this.parent.getBackCommand() != cmd) {
                this.setLayout(new GridLayout(1, this.getCommandCount()));
                this.addComponent(this.createTouchCommandButton(cmd));
            } else {
                this.commands.removeElement(cmd);
            }
            return;
        }
        this.updateCommands();
    }

    public Command getCommand(int index) {
        return (Command)this.commands.elementAt(index);
    }

    public int getCommandCount() {
        return this.commands.size();
    }

    protected void addCommand(Command cmd, int index) {
        int behavior;
        if (this.getCommandCount() == 0 && this.parent != null) {
            this.installMenuBar();
        }
        if (this.commands.contains(cmd)) {
            return;
        }
        this.commands.insertElementAt(cmd, index);
        if (!(this.parent instanceof Dialog || (behavior = this.getCommandBehavior()) != 4 && behavior != 5)) {
            if (behavior == 5 && cmd == this.parent.getBackCommand()) {
                return;
            }
            if (this.parent.getBackCommand() != cmd) {
                this.setLayout(new GridLayout(1, this.getCommandCount()));
                this.addComponent(index, (Component)this.createTouchCommandButton(cmd));
            } else {
                this.commands.removeElement(cmd);
            }
            return;
        }
        this.updateCommands();
    }

    protected void installMenuBar() {
        if (this.getParent() == null && this.softkeyCount > 1) {
            this.parent.addComponentToForm("South", this);
        }
    }

    protected void unInstallMenuBar() {
        this.parent.removeComponentFromForm(this);
    }

    protected void removeAllCommands() {
        this.commands.removeAllElements();
        int behavior = this.getCommandBehavior();
        if (behavior == 4 || behavior == 5) {
            this.removeAll();
            return;
        }
        this.updateCommands();
    }

    protected void removeCommand(Command cmd) {
        int behavior = this.getCommandBehavior();
        if (behavior == 4 || behavior == 5) {
            int i = this.commands.indexOf(cmd);
            if (i > -1) {
                this.commands.removeElementAt(i);
                this.removeComponent(this.getComponentAt(i));
                if (this.getCommandCount() > 0) {
                    this.setLayout(new GridLayout(1, this.getCommandCount()));
                }
            }
            return;
        }
        this.commands.removeElement(cmd);
        this.updateCommands();
    }

    void addSelectCommand(String selectText) {
        if (this.thirdSoftButton) {
            if (this.selectCommand == null) {
                this.selectCommand = this.createSelectCommand();
            }
            this.selectCommand.setCommandName(selectText);
            this.addCommand(this.selectCommand);
        }
    }

    void removeSelectCommand() {
        if (this.thirdSoftButton) {
            this.removeCommand(this.selectCommand);
        }
    }

    protected Command createSelectCommand() {
        return new Command(UIManager.getInstance().localize("select", "Select"));
    }

    protected Command createMenuSelectCommand() {
        LookAndFeel lf = UIManager.getInstance().getLookAndFeel();
        return new Command(UIManager.getInstance().localize("select", "Select"), lf.getMenuIcons()[0]);
    }

    protected Command createMenuCancelCommand() {
        LookAndFeel lf = UIManager.getInstance().getLookAndFeel();
        return new Command(UIManager.getInstance().localize("cancel", "Cancel"), lf.getMenuIcons()[1]);
    }

    public void setMenuCellRenderer(ListCellRenderer menuCellRenderer) {
        this.menuCellRenderer = menuCellRenderer;
    }

    public Style getMenuStyle() {
        return this.menuStyle;
    }

    public boolean handlesKeycode(int keyCode) {
        int game = Display.getInstance().getGameAction(keyCode);
        return keyCode == leftSK || keyCode == rightSK || keyCode == rightSK2 || keyCode == backSK || keyCode == clearSK && this.clearCommand != null || keyCode == backspaceSK && this.clearCommand != null || this.thirdSoftButton && game == 8;
    }

    public void keyPressed(int keyCode) {
        int commandBehavior = this.getCommandBehavior();
        if (commandBehavior >= 4) {
            return;
        }
        if (this.getCommandCount() > 0) {
            if (keyCode == leftSK) {
                if (this.left != null) {
                    this.left.pressed();
                }
            } else if (keyCode == rightSK || keyCode == rightSK2) {
                if (this.right != null) {
                    this.right.pressed();
                }
            } else if (Display.getInstance().getGameAction(keyCode) == 8) {
                this.main.pressed();
            }
        }
    }

    public void keyReleased(int keyCode) {
        int commandBehavior = this.getCommandBehavior();
        if (commandBehavior >= 4 && keyCode != backSK && keyCode != clearSK && keyCode != backspaceSK) {
            return;
        }
        if (this.getCommandCount() > 0) {
            if (this.softkeyCount < 2 && keyCode == leftSK) {
                if (this.commandList != null) {
                    Container parent = this.commandList.getParent();
                    while (parent != null) {
                        if (parent instanceof Dialog && ((Dialog)parent).isMenu()) {
                            return;
                        }
                        parent = parent.getParent();
                    }
                }
                this.showMenu();
                return;
            }
            if (keyCode == leftSK) {
                if (this.left != null) {
                    this.left.released();
                }
                return;
            }
            if (keyCode == rightSK || keyCode == rightSK2) {
                if (this.right != null) {
                    this.right.released();
                }
                return;
            }
            if (Display.getInstance().getGameAction(keyCode) == 8) {
                this.main.released();
                return;
            }
        }
        Command c = null;
        if (keyCode == backSK) {
            c = this.parent.getBackCommand();
        } else if (keyCode == clearSK || keyCode == backspaceSK) {
            c = this.getClearCommand();
        }
        if (c != null) {
            ActionEvent ev = new ActionEvent(c, keyCode);
            c.actionPerformed(ev);
            if (!ev.isConsumed()) {
                this.parent.actionCommandImpl(c);
            }
        }
    }

    public void refreshTheme() {
        super.refreshTheme();
        if (this.menuStyle.isModified()) {
            this.menuStyle.merge(UIManager.getInstance().getComponentStyle("Menu"));
        } else {
            this.menuStyle = UIManager.getInstance().getComponentStyle("Menu");
        }
        if (this.menuCellRenderer != null) {
            List tmp = new List();
            tmp.setListCellRenderer(this.menuCellRenderer);
            tmp.refreshTheme();
        }
        int iter = 0;
        while (iter < this.soft.length) {
            this.updateSoftButtonStyle(this.soft[iter]);
            ++iter;
        }
        this.revalidate();
    }

    protected Command showMenuDialog(Dialog menu) {
        float menuWidthPercent = 1.0f - Float.parseFloat(UIManager.getInstance().getThemeConstant("menuWidthPercent", "75")) / 100.0f;
        float menuHeightPercent = 1.0f - Float.parseFloat(UIManager.getInstance().getThemeConstant("menuHeightPercent", "50")) / 100.0f;
        int marginLeft = (int)((float)this.parent.getWidth() * menuWidthPercent);
        int marginRight = 0;
        if (this.isReverseSoftButtons()) {
            marginRight = marginLeft;
            marginLeft = 0;
        }
        int height = (int)((float)this.parent.getHeight() * menuHeightPercent);
        if (UIManager.getInstance().getLookAndFeel().isTouchMenus()) {
            return menu.showPacked("South", true);
        }
        return menu.show(height, 0, marginLeft, marginRight, true);
    }

    protected boolean isReverseSoftButtons() {
        LookAndFeel lf = UIManager.getInstance().getLookAndFeel();
        if (this.isRTL()) {
            return !lf.isReverseSoftButtons();
        }
        return lf.isReverseSoftButtons();
    }

    protected int calculateTouchCommandGridColumns(Container grid) {
        int count = grid.getComponentCount();
        int maxWidth = 0;
        int iter = 0;
        while (iter < count) {
            Component c = grid.getComponentAt(iter);
            Style s = c.getUnselectedStyle();
            maxWidth = Math.max(maxWidth, c.getPreferredW() + s.getMargin(false, 1) + s.getMargin(false, 3));
            ++iter;
        }
        return 3;
    }

    protected Button createTouchCommandButton(Command c) {
        Button b = new Button(c);
        if (b.getIcon() == null) {
            b.setIcon(UIManager.getInstance().getThemeImageConstant("defaultCommandImage"));
        }
        b.setTactileTouch(true);
        b.setTextPosition(2);
        b.setUIID("TouchCommand");
        Style[] styles = new Style[]{b.getStyle(), b.getSelectedStyle(), b.getPressedStyle()};
        return b;
    }

    protected Component createCommandComponent(Vector commands) {
        if (UIManager.getInstance().getLookAndFeel().isTouchMenus()) {
            Container menu = new Container();
            menu.setScrollableY(true);
            int iter = 0;
            while (iter < commands.size()) {
                Command c = (Command)commands.elementAt(iter);
                menu.addComponent(this.createTouchCommandButton(c));
                ++iter;
            }
            if (!UIManager.getInstance().isThemeConstant("touchCommandFlowBool", false)) {
                int cols = this.calculateTouchCommandGridColumns(menu);
                menu.setLayout(new GridLayout(Math.max(1, this.getCommandCount() / cols + (this.getCommandCount() % cols != 0 ? 1 : 0)), cols));
            } else {
                ((FlowLayout)menu.getLayout()).setFillRows(true);
            }
            return menu;
        }
        return this.parent.createCommandList(commands);
    }

    protected Vector getCommands() {
        return this.commands;
    }

    protected List createCommandList(Vector commands) {
        List l = new List(commands);
        l.setUIID("CommandList");
        Component c = (Component)((Object)l.getRenderer());
        c.setUIID("Command");
        c = l.getRenderer().getListFocusComponent(l);
        c.setUIID("CommandFocus");
        l.getSelectedStyle().setBgTransparency(255);
        c.getUnselectedStyle().setBorder(Border.createCompoundBorder(null, Border.createLineBorder(2, 0x333333), null, null));
        c.getSelectedStyle().setBorder(Border.createCompoundBorder(null, Border.createLineBorder(2, 0x333333), null, null));
        l.setFixedSelection(1);
        return l;
    }

    Command getComponentSelectedCommand(Component cmp) {
        if (cmp instanceof List) {
            List l = (List)cmp;
            return (Command)l.getSelectedItem();
        }
        if ((cmp = cmp.getComponentForm().getFocused()) instanceof Button) {
            return ((Button)cmp).getCommand();
        }
        return null;
    }

    protected Command getSelectMenuItem() {
        return this.selectMenuItem;
    }

    protected Command getCancelMenuItem() {
        return this.cancelMenuItem;
    }
}

