/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Dialog;
import com.sun.lwuit.Display;
import com.sun.lwuit.Form;
import com.sun.lwuit.Painter;
import java.util.Vector;

class RunnableWrapper
implements Runnable {
    private static final Object THREADPOOL_LOCK = new Object();
    private static Vector threadPool = new Vector();
    private static int threadCount = 0;
    private static int maxThreadCount = 5;
    private static int availableThreads = 0;
    private boolean done = false;
    private Runnable internal;
    private int type;
    private RuntimeException err;
    private Form parentForm;
    private Painter paint;
    private boolean reverse;

    public RunnableWrapper(Form parentForm, Painter paint, boolean reverse) {
        this.parentForm = parentForm;
        this.paint = paint;
        this.reverse = reverse;
    }

    public RunnableWrapper(Runnable internal, int type) {
        this.internal = internal;
        this.type = type;
    }

    public RuntimeException getErr() {
        return this.err;
    }

    public void setDone(boolean done) {
        this.done = done;
    }

    public boolean isDone() {
        return this.done;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.parentForm != null) {
            if (this.paint == null) {
                Display.getInstance().setCurrent(this.parentForm, this.reverse);
                return;
            }
            Dialog dlg = (Dialog)this.parentForm;
            while (!dlg.isDisposed()) {
                try {
                    Object object = Display.lock;
                    synchronized (object) {
                        Display.lock.wait(40L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.parentForm.getStyle().setBgPainter(this.paint);
        } else {
            switch (this.type) {
                case 0: {
                    this.internal.run();
                    this.done = true;
                    Object dlg = Display.lock;
                    synchronized (dlg) {
                        Display.lock.notify();
                        break;
                    }
                }
                case 1: {
                    try {
                        this.internal.run();
                    }
                    catch (RuntimeException ex) {
                        this.err = ex;
                    }
                    break;
                }
                case 2: {
                    while (!this.done) {
                        Object ex = Display.lock;
                        synchronized (ex) {
                            try {
                                Display.lock.wait(10L);
                            }
                            catch (InterruptedException ex2) {
                                ex2.printStackTrace();
                            }
                        }
                    }
                    break;
                }
                case 3: {
                    Display.getInstance().mainEDTLoop();
                    break;
                }
                case 4: {
                    while (true) {
                        Runnable r = null;
                        Object object = THREADPOOL_LOCK;
                        synchronized (object) {
                            if (threadPool.size() > 0) {
                                r = (Runnable)threadPool.elementAt(0);
                                threadPool.removeElementAt(0);
                            } else {
                                try {
                                    ++availableThreads;
                                    THREADPOOL_LOCK.wait();
                                    --availableThreads;
                                }
                                catch (InterruptedException ex) {
                                    ex.printStackTrace();
                                }
                            }
                        }
                        if (r == null) continue;
                        r.run();
                    }
                }
            }
        }
        this.done = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void pushToThreadPool(Runnable r) {
        if (availableThreads == 0 && threadCount < maxThreadCount) {
            Thread poolThread = new Thread((Runnable)new RunnableWrapper(null, 4), "invokeAndBlock" + ++threadCount);
            poolThread.start();
        }
        Object object = THREADPOOL_LOCK;
        synchronized (object) {
            threadPool.addElement(r);
            THREADPOOL_LOCK.notify();
        }
    }
}

