/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Display;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.animations.Animation;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.m2g.ScalableGraphics;
import javax.microedition.m2g.ScalableImage;
import org.w3c.dom.Document;
import org.w3c.dom.svg.SVGPoint;
import org.w3c.dom.svg.SVGSVGElement;

public class SVGImage
extends Image
implements Animation {
    private javax.microedition.m2g.SVGImage im;
    private static final String SVG_NAMESPACE = "http://www.w3.org/2000/svg";
    private boolean animated;
    private long startTime = -1L;
    private int id = 0;
    private static int idCounter = 0;
    private static final boolean IS_SUPPORTED;
    static /* synthetic */ Class class$0;

    static {
        boolean supported = false;
        try {
            Class.forName("javax.microedition.m2g.SVGImage");
            supported = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        IS_SUPPORTED = supported;
    }

    SVGImage(javax.microedition.m2g.SVGImage im, boolean animated) {
        super(null);
        this.im = im;
        this.animated = animated;
    }

    public static Image createSVGImage(InputStream stream, boolean animated) throws IOException {
        SVGImage instance = new SVGImage((javax.microedition.m2g.SVGImage)javax.microedition.m2g.SVGImage.createImage((InputStream)stream, null), animated);
        return instance;
    }

    public static Image createSVGImage(String url, boolean animated) throws IOException {
        Display display = Display.getInstance();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.sun.lwuit.SVGImage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return SVGImage.createSVGImage(display.getResourceAsStream(clazz, url), animated);
    }

    public int getWidth() {
        return this.im.getViewportWidth();
    }

    public int getHeight() {
        return this.im.getViewportHeight();
    }

    protected void drawImage(Graphics g, Object nativeGraphics, int x, int y) {
        ScalableGraphics svgGraphics = ScalableGraphics.createInstance();
        javax.microedition.lcdui.Graphics gr = (javax.microedition.lcdui.Graphics)nativeGraphics;
        gr.setClip(g.getTranslateX() + g.getClipX(), g.getTranslateY() + g.getClipY(), g.getClipWidth(), g.getClipHeight());
        svgGraphics.bindTarget((Object)gr);
        svgGraphics.render(x + g.getTranslateX(), y + g.getTranslateY(), (ScalableImage)this.im);
        svgGraphics.releaseTarget();
    }

    public Image scaled(int width, int height) {
        this.im.setViewportWidth(width);
        this.im.setViewportHeight(height);
        return this;
    }

    public Image rotate(int degrees) {
        SVGSVGElement e = this.getSVGElement();
        SVGPoint p = e.getCurrentTranslate();
        p.setX((float)(-this.getWidth() / 2));
        p.setY((float)(-this.getHeight() / 2));
        e.setCurrentRotate((float)degrees);
        p.setX(0.0f);
        p.setY(0.0f);
        return this;
    }

    public Document getDocument() {
        return this.im.getDocument();
    }

    private SVGSVGElement getSVGElement() {
        SVGSVGElement retVal = null;
        Document dom = this.im.getDocument();
        retVal = (SVGSVGElement)dom.getElementById(String.valueOf(this.getClass().getName()) + this.id);
        if (retVal == null) {
            retVal = (SVGSVGElement)dom.createElementNS(SVG_NAMESPACE, "svg");
            this.id = idCounter++;
            retVal.setId(String.valueOf(this.getClass().getName()) + this.id);
        }
        return retVal;
    }

    public boolean animate() {
        long currentTime = System.currentTimeMillis();
        if (this.startTime == -1L) {
            this.startTime = currentTime;
        }
        this.im.incrementTime((float)(currentTime - this.startTime) / 1000.0f);
        this.startTime = currentTime;
        return this.animated;
    }

    public void paint(Graphics g) {
    }

    public boolean isAnimation() {
        return true;
    }

    public static boolean isSupported() {
        return IS_SUPPORTED;
    }
}

