/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.IndexedImage;
import com.sun.lwuit.animations.Animation;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.geom.Rectangle;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;

public class StaticAnimation
extends IndexedImage
implements Animation {
    private Frame[] frames;
    private int currentFrame;
    private long animationStartTime;
    private int totalAnimationTime;
    private boolean loop;

    StaticAnimation(int width, int height, int[] palette, byte[] data) {
        super(width, height, palette, data);
    }

    public int getFrameCount() {
        return this.frames.length + 1;
    }

    public int getFrameTime(int frame) {
        if (frame == 0) {
            return 0;
        }
        return this.frames[frame - 1].time;
    }

    public int getTotalAnimationTime() {
        return this.totalAnimationTime;
    }

    public int[] getFrameRGB(int frame) {
        if (frame == 0) {
            return this.getRGBCached();
        }
        Frame f = this.frames[frame - 1];
        int height = this.getHeight();
        int width = this.getWidth();
        int[] array = new int[width * height];
        byte[] imageDataByte = f.getKeyFrame();
        int[] palette = this.getPalette();
        int line = 0;
        while (line < height) {
            byte[] lineArray = f.getModifiedRow(line);
            if (lineArray != null) {
                int position = 0;
                while (position < width) {
                    int i = lineArray[position] & 0xFF;
                    array[position + width * line] = palette[i];
                    ++position;
                }
            } else {
                int currentPos = line * width;
                int position = 0;
                while (position < width) {
                    int i = imageDataByte[position + currentPos] & 0xFF;
                    array[position + width * line] = palette[i];
                    ++position;
                }
            }
            ++line;
        }
        return array;
    }

    public static StaticAnimation createAnimation(DataInputStream data) throws IOException {
        byte pSize = data.readByte();
        int[] palette = new int[pSize & 0xFF];
        int iter = 0;
        while (iter < palette.length) {
            palette[iter] = data.readInt();
            ++iter;
        }
        short width = data.readShort();
        short height = data.readShort();
        int numberOfFrames = data.readByte() & 0xFF;
        int totalAnimationTime = Math.max(1, data.readInt());
        boolean loop = data.readBoolean();
        byte[] array = new byte[width * height];
        data.readFully(array);
        StaticAnimation animation = new StaticAnimation(width, height, palette, array);
        animation.frames = new Frame[numberOfFrames - 1];
        animation.totalAnimationTime = totalAnimationTime;
        animation.loop = loop;
        int currentTime = 0;
        byte[] lastKeyframe = array;
        Vector<Integer> rowNumbers = new Vector<Integer>();
        Vector<byte[]> rowValues = new Vector<byte[]>();
        int iter2 = 1;
        while (iter2 < numberOfFrames) {
            currentTime += data.readInt();
            if (data.readBoolean()) {
                array = new byte[width * height];
                data.readFully(array);
                animation.frames[iter2 - 1] = new Frame(currentTime, array);
                lastKeyframe = array;
                rowValues.removeAllElements();
                rowNumbers.removeAllElements();
            } else {
                boolean drawPrevious = data.readBoolean();
                short nextRow = data.readShort();
                while (nextRow != -1) {
                    byte[] rowData = new byte[width];
                    data.readFully(rowData);
                    Integer rowInteger = new Integer(nextRow);
                    int index = rowNumbers.indexOf(rowInteger);
                    if (index > -1) {
                        rowNumbers.removeElementAt(index);
                        rowValues.removeElementAt(index);
                    }
                    rowNumbers.addElement(rowInteger);
                    rowValues.addElement(rowData);
                    nextRow = data.readShort();
                }
                animation.frames[iter2 - 1] = new Frame(currentTime, lastKeyframe, rowNumbers, rowValues, drawPrevious);
            }
            ++iter2;
        }
        return animation;
    }

    public boolean animate() {
        if (this.animationStartTime == 0L) {
            this.animationStartTime = System.currentTimeMillis();
            return false;
        }
        long currentTime = System.currentTimeMillis();
        int position = (int)(currentTime - this.animationStartTime);
        if (this.loop) {
            position %= this.totalAnimationTime;
        } else if (position > this.totalAnimationTime) {
            return false;
        }
        if (this.currentFrame == this.frames.length) {
            if (position >= this.totalAnimationTime || position < this.frames[this.frames.length - 1].getTime()) {
                this.currentFrame = 0;
                return true;
            }
        } else if (position >= this.frames[this.currentFrame].getTime()) {
            ++this.currentFrame;
            if (this.currentFrame > this.frames.length + 1) {
                this.currentFrame = 0;
            }
            return true;
        }
        return false;
    }

    public void restart() {
        this.animationStartTime = System.currentTimeMillis();
    }

    public void paint(Graphics g) {
        this.drawImage(g, g.getGraphics(), 0, 0);
    }

    public boolean isLoop() {
        return this.loop;
    }

    public void setLoop(boolean loop) {
        this.loop = loop;
    }

    protected void drawImage(Graphics g, Object nativeGraphics, int x, int y) {
        if (this.currentFrame == 0) {
            super.drawImage(g, nativeGraphics, x, y);
            return;
        }
        int width = this.getWidth();
        if (IndexedImage.lineCache == null || IndexedImage.lineCache.length < width) {
            IndexedImage.lineCache = new int[width];
        }
        int clipY = g.getClipY();
        int clipBottomY = g.getClipHeight() + clipY;
        int firstLine = 0;
        int lastLine = this.getHeight();
        if (clipY > y) {
            firstLine = clipY - y;
        }
        if (clipBottomY < y + this.getHeight()) {
            lastLine = clipBottomY - y;
        }
        Frame f = this.frames[this.currentFrame - 1];
        byte[] imageDataByte = f.getKeyFrame();
        int[] palette = this.getPalette();
        int line = firstLine;
        while (line < lastLine) {
            byte[] lineArray = f.getModifiedRow(line);
            if (lineArray != null) {
                int position = 0;
                while (position < width) {
                    int i = lineArray[position] & 0xFF;
                    IndexedImage.lineCache[position] = palette[i];
                    ++position;
                }
            } else {
                int currentPos = line * width;
                int position = 0;
                while (position < width) {
                    int i = imageDataByte[position + currentPos] & 0xFF;
                    IndexedImage.lineCache[position] = palette[i];
                    ++position;
                }
            }
            g.drawRGB(IndexedImage.lineCache, 0, x, y + line, width, 1, true);
            ++line;
        }
    }

    public void scale(int width, int height) {
        StaticAnimation s = (StaticAnimation)this.scaled(width, height);
        super.scale(width, height);
        this.frames = s.frames;
    }

    public Image scaled(int width, int height) {
        int srcWidth = this.getWidth();
        int srcHeight = this.getHeight();
        if (srcWidth == width && srcHeight == height) {
            return this;
        }
        byte[] lastKeyFrame = this.getImageDataByte();
        StaticAnimation result = new StaticAnimation(width, height, this.getPalette(), this.scaleArray(lastKeyFrame, width, height));
        result.loop = this.loop;
        result.totalAnimationTime = this.totalAnimationTime;
        result.animationStartTime = this.animationStartTime;
        result.currentFrame = this.currentFrame;
        result.frames = new Frame[this.frames.length];
        byte[] lastKeyFrameAfterScale = result.getImageDataByte();
        int yRatio = (srcHeight << 16) / height;
        int xRatio = (srcWidth << 16) / width;
        int iter = 0;
        while (iter < this.frames.length) {
            byte[] currentKeyFrame = this.frames[iter].getKeyFrame();
            if (currentKeyFrame != lastKeyFrame) {
                lastKeyFrame = currentKeyFrame;
                currentKeyFrame = this.scaleArray(currentKeyFrame, width, height);
                lastKeyFrameAfterScale = currentKeyFrame;
            }
            result.frames[iter] = new Frame(this.frames[iter].getTime(), lastKeyFrameAfterScale, this.frames[iter], xRatio, yRatio, width, height);
            ++iter;
        }
        return result;
    }

    public boolean isAnimation() {
        return true;
    }

    boolean isKeyframe(int offset) {
        if (offset == 0) {
            return true;
        }
        if (offset == 1) {
            return this.frames[offset - 1].getKeyFrame() != this.imageDataByte;
        }
        return this.frames[offset - 1].getKeyFrame() != this.frames[offset - 2].getKeyFrame();
    }

    byte[] getKeyframe(int offset) {
        return this.frames[offset - 1].getKeyFrame();
    }

    boolean isDrawPrevious(int offset) {
        return this.frames[offset - 1].isDrawPrevious();
    }

    byte[][] getModifiedRows(int offset) {
        return this.frames[offset - 1].modifiedRows;
    }

    int[] getModifiedRowOffsets(int offset) {
        return this.frames[offset - 1].modifiedRowOffsets;
    }

    Rectangle getDirtyRegion() {
        int frame = this.currentFrame;
        if (frame == 0) {
            return null;
        }
        if (frame == this.frames.length) {
            frame = 0;
        }
        Rectangle rect = new Rectangle(0, this.frames[frame].smallestChangedRow, new Dimension(this.getWidth(), this.frames[frame].highestChangedRow - this.frames[frame].smallestChangedRow));
        return rect;
    }

    static class Frame {
        private int time;
        private byte[] keyFrame;
        byte[][] modifiedRows;
        int[] modifiedRowOffsets;
        private boolean drawPrevious;
        int smallestChangedRow;
        int highestChangedRow;

        public Frame(int time, byte[] keyFrame, Vector rowNumbers, Vector rowValues, boolean drawPrevious) {
            this.time = time;
            this.keyFrame = keyFrame;
            this.drawPrevious = drawPrevious;
            this.initArrays(rowNumbers, rowValues);
        }

        private void initArrays(Vector rowNumbers, Vector rowValues) {
            this.modifiedRowOffsets = new int[rowNumbers.size()];
            this.modifiedRows = new byte[this.modifiedRowOffsets.length][];
            int iter = 0;
            while (iter < this.modifiedRowOffsets.length) {
                this.modifiedRowOffsets[iter] = (Integer)rowNumbers.elementAt(iter);
                this.modifiedRows[iter] = (byte[])rowValues.elementAt(iter);
                ++iter;
            }
            this.smallestChangedRow = this.modifiedRowOffsets[0];
            this.highestChangedRow = this.modifiedRowOffsets[0];
            int i = 1;
            while (i < this.modifiedRowOffsets.length) {
                this.smallestChangedRow = Math.min(this.smallestChangedRow, this.modifiedRowOffsets[i]);
                this.highestChangedRow = Math.max(this.highestChangedRow, this.modifiedRowOffsets[i]);
                ++i;
            }
        }

        public Frame(int time, byte[] keyFrame) {
            this.time = time;
            this.keyFrame = keyFrame;
            this.modifiedRowOffsets = new int[0];
        }

        public Frame(int time, byte[] keyFrame, Frame original, int xRatio, int yRatio, int width, int height) {
            this.time = time;
            this.keyFrame = keyFrame;
            if (original.modifiedRowOffsets.length == 0) {
                this.modifiedRowOffsets = original.modifiedRowOffsets;
                return;
            }
            Vector<Integer> newRows = new Vector<Integer>();
            Vector<byte[]> newValues = new Vector<byte[]>();
            int xPos = xRatio / 2;
            int yPos = yRatio / 2;
            int y = 0;
            while (y < height) {
                int srcY = yPos >> 16;
                int rowAtY = -1;
                int iter = 0;
                while (iter < original.modifiedRowOffsets.length) {
                    if (original.modifiedRowOffsets[iter] == srcY) {
                        rowAtY = iter;
                        break;
                    }
                    ++iter;
                }
                if (rowAtY != -1) {
                    byte[] newRow = new byte[width];
                    int x = 0;
                    while (x < width) {
                        int srcX = xPos >> 16;
                        newRow[x] = original.modifiedRows[rowAtY][srcX];
                        xPos += xRatio;
                        ++x;
                    }
                    newRows.addElement(new Integer(y));
                    newValues.addElement(newRow);
                }
                yPos += yRatio;
                xPos = xRatio / 2;
                ++y;
            }
            this.initArrays(newRows, newValues);
        }

        public boolean isDrawPrevious() {
            return this.drawPrevious;
        }

        public int getTime() {
            return this.time;
        }

        private byte[] getModifiedRow(int row) {
            int iter = 0;
            while (iter < this.modifiedRowOffsets.length) {
                if (this.modifiedRowOffsets[iter] == row) {
                    return this.modifiedRows[iter];
                }
                ++iter;
            }
            return null;
        }

        private byte[] getKeyFrame() {
            return this.keyFrame;
        }

        private void setKeyFrame(byte[] keyFrame) {
            this.keyFrame = keyFrame;
        }
    }
}

