/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Button;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Form;
import com.sun.lwuit.Image;
import com.sun.lwuit.animations.Motion;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.events.FocusListener;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.layouts.FlowLayout;
import com.sun.lwuit.layouts.Layout;
import com.sun.lwuit.plaf.UIManager;
import com.sun.lwuit.util.EventDispatcher;

public class Tabs
extends Container {
    private Container contentPane = new Container(new TabsLayout());
    private int tabPlacement = -1;
    private Container tabsContainer;
    private Button selectedTab;
    private boolean swipeActivated = true;
    private ActionListener press;
    private ActionListener drag;
    private ActionListener release;
    private Motion slideToDestMotion;
    private int initialX = -1;
    private int lastX = -1;
    private boolean dragStarted = false;
    private int activeComponent = 0;
    private EventDispatcher focusListeners;
    private TabFocusListener focusListener = new TabFocusListener();
    private boolean tabsFillRows;
    static /* synthetic */ Class class$0;

    public Tabs() {
        this(0);
    }

    public Tabs(int tabPlacement) {
        super(new BorderLayout());
        this.contentPane.setUIID("TabbedPane");
        super.addComponent("Center", (Component)this.contentPane);
        this.tabsContainer = new Container();
        this.tabsContainer.setUIID("TabsContainer");
        this.tabsContainer.setIsScrollVisible(false);
        this.tabsContainer.getStyle().setMargin(0, 0, 0, 0);
        this.tabsFillRows = UIManager.getInstance().isThemeConstant("tabsFillRowsBool", false);
        ((FlowLayout)this.tabsContainer.getLayout()).setFillRows(this.tabsFillRows);
        this.setTabPlacement(tabPlacement);
        this.press = new SwipeListener(0);
        this.drag = new SwipeListener(1);
        this.release = new SwipeListener(2);
        this.setUIID("Tabs");
    }

    void initComponentImpl() {
        super.initComponentImpl();
        this.getComponentForm().registerAnimatedInternal(this);
    }

    protected void deinitialize() {
        Form form = this.getComponentForm();
        if (form != null) {
            form.removePointerPressedListener(this.press);
            form.removePointerReleasedListener(this.release);
            form.removePointerDraggedListener(this.drag);
        }
        super.deinitialize();
    }

    protected void initComponent() {
        super.initComponent();
        Form form = this.getComponentForm();
        if (form != null && this.swipeActivated) {
            form.addPointerPressedListener(this.press);
            form.addPointerReleasedListener(this.release);
            form.addPointerDraggedListener(this.drag);
        }
    }

    public boolean animate() {
        boolean b = super.animate();
        if (this.slideToDestMotion != null && this.swipeActivated) {
            int motionX = this.slideToDestMotion.getValue();
            int size = this.contentPane.getComponentCount();
            int i = 0;
            while (i < size) {
                int xOffset = i * this.contentPane.getWidth();
                xOffset -= this.activeComponent * this.contentPane.getWidth();
                Component component = this.contentPane.getComponentAt(i);
                component.setX(xOffset += motionX);
                ++i;
            }
            if (this.slideToDestMotion.isFinished()) {
                this.slideToDestMotion = null;
                this.deregisterAnimatedInternal();
                this.setSelectedIndex(this.activeComponent);
            }
            return true;
        }
        return b;
    }

    void deregisterAnimatedInternal() {
        Form f;
        if ((this.slideToDestMotion == null || this.slideToDestMotion.isFinished()) && (f = this.getComponentForm()) != null) {
            f.deregisterAnimatedInternal(this);
        }
    }

    public void setTabPlacement(int tabPlacement) {
        if (tabPlacement != 0 && tabPlacement != 1 && tabPlacement != 2 && tabPlacement != 3) {
            throw new IllegalArgumentException("illegal tab placement: must be TOP, BOTTOM, LEFT, or RIGHT");
        }
        if (this.tabPlacement == tabPlacement) {
            return;
        }
        this.tabPlacement = tabPlacement;
        this.removeComponent(this.tabsContainer);
        if (tabPlacement == 0 || tabPlacement == 2) {
            if (this.tabsFillRows) {
                FlowLayout f = new FlowLayout();
                f.setFillRows(true);
                this.tabsContainer.setLayout(f);
            } else {
                this.tabsContainer.setLayout(new BoxLayout(1));
            }
            this.tabsContainer.setScrollableX(true);
            this.tabsContainer.setScrollableY(false);
            if (tabPlacement == 0) {
                super.addComponent("North", (Component)this.tabsContainer);
            } else if (tabPlacement == 2) {
                super.addComponent("South", (Component)this.tabsContainer);
            }
        } else {
            this.tabsContainer.setLayout(new BoxLayout(2));
            this.tabsContainer.setScrollableX(false);
            this.tabsContainer.setScrollableY(true);
            if (tabPlacement == 1) {
                super.addComponent("West", (Component)this.tabsContainer);
            } else {
                super.addComponent("East", (Component)this.tabsContainer);
            }
        }
        this.initTabsFocus();
        this.tabsContainer.setShouldCalcPreferredSize(true);
        this.contentPane.setShouldCalcPreferredSize(true);
        this.revalidate();
    }

    public void addTab(String title, Image icon, Component component) {
        this.insertTab(title, icon, component, this.tabsContainer.getComponentCount());
    }

    public void addTab(String title, Component component) {
        this.insertTab(title, null, component, this.tabsContainer.getComponentCount());
    }

    public void addTab(Button tab, Component component) {
        this.insertTab(tab, component, this.tabsContainer.getComponentCount());
    }

    public void insertTab(String title, Image icon, Component component, int index) {
        Button b = new Button(title != null ? title : "", icon);
        this.insertTab(b, component, index);
    }

    public void insertTab(Button tab, Component component, int index) {
        this.checkIndex(index);
        if (component == null) {
            return;
        }
        final Button b = tab;
        b.setUIID("Tab");
        b.addFocusListener(this.focusListener);
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (Tabs.this.selectedTab != null) {
                    Component previousContent;
                    Tabs.this.selectedTab.setUIID("Tab");
                    Tabs.this.selectedTab.setShouldCalcPreferredSize(true);
                    Tabs.this.selectedTab.repaint();
                    int previousSelectedIndex = Tabs.this.tabsContainer.getComponentIndex(Tabs.this.selectedTab);
                    if (previousSelectedIndex != -1 && (previousContent = Tabs.this.contentPane.getComponentAt(previousSelectedIndex)) instanceof Container) {
                        ((Container)previousContent).setBlockFocus(true);
                    }
                }
                Tabs.this.activeComponent = Tabs.this.tabsContainer.getComponentIndex(b);
                Component content = Tabs.this.contentPane.getComponentAt(Tabs.this.activeComponent);
                if (content instanceof Container) {
                    ((Container)content).setBlockFocus(false);
                }
                Tabs.this.initTabsFocus();
                Tabs.this.selectedTab = b;
                Tabs.this.selectedTab.setUIID("TabSelected");
                Tabs.this.selectedTab.setShouldCalcPreferredSize(true);
                Tabs.this.tabsContainer.revalidate();
                Tabs.this.tabsContainer.scrollComponentToVisible(Tabs.this.selectedTab);
                Tabs.this.contentPane.revalidate();
            }
        });
        if (component instanceof Container) {
            ((Container)component).setBlockFocus(true);
        }
        this.tabsContainer.addComponent(index, (Component)b);
        this.contentPane.addComponent(index, component);
        if (this.tabsContainer.getComponentCount() == 1) {
            this.selectedTab = (Button)this.tabsContainer.getComponentAt(0);
            this.selectedTab.setUIID("TabSelected");
            if (component instanceof Container) {
                ((Container)component).setBlockFocus(false);
            }
            this.initTabsFocus();
        }
    }

    public void setTabTitle(String title, Image icon, int index) {
        this.checkIndex(index);
        Button b = (Button)this.tabsContainer.getComponentAt(index);
        b.setText(title);
        b.setIcon(icon);
    }

    public String getTabTitle(int index) {
        this.checkIndex(index);
        return ((Button)this.tabsContainer.getComponentAt(index)).getText();
    }

    public void removeTabAt(int index) {
        this.checkIndex(index);
        Component key = this.tabsContainer.getComponentAt(index);
        this.tabsContainer.removeComponent(key);
        Component content = this.contentPane.getComponentAt(index);
        this.contentPane.removeComponent(content);
    }

    public Component getTabComponentAt(int index) {
        this.checkIndex(index);
        return this.contentPane.getComponentAt(index);
    }

    private void checkIndex(int index) {
        if (index < 0 || index > this.tabsContainer.getComponentCount()) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
    }

    public int indexOfComponent(Component component) {
        return this.contentPane.getComponentIndex(component);
    }

    public int getTabCount() {
        return this.tabsContainer.getComponentCount();
    }

    public int getSelectedIndex() {
        if (this.tabsContainer != null) {
            return this.activeComponent;
        }
        return -1;
    }

    public void addTabsFocusListener(FocusListener listener) {
        if (this.focusListeners == null) {
            this.focusListeners = new EventDispatcher();
        }
        this.focusListeners.addListener(listener);
    }

    public void removeTabsFocusListener(FocusListener listener) {
        if (this.focusListeners != null) {
            this.focusListeners.removeListener(listener);
        }
    }

    public String toString() {
        String className = this.getClass().getName();
        className = className.substring(className.lastIndexOf(46) + 1);
        return String.valueOf(className) + "[x=" + this.getX() + " y=" + this.getY() + " width=" + this.getWidth() + " height=" + this.getHeight() + ", tab placement = " + this.tabPlacement + ", tab count = " + this.getTabCount() + ", selected index = " + this.getSelectedIndex() + "]";
    }

    public int getTabPlacement() {
        return this.tabPlacement;
    }

    public Container getContentPane() {
        return this.contentPane;
    }

    public Container getTabsContainer() {
        return this.tabsContainer;
    }

    public void setSelectedIndex(int index) {
        if (index < 0 || index >= this.tabsContainer.getComponentCount()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Tab count: " + this.tabsContainer.getComponentCount());
        }
        Button b = (Button)this.tabsContainer.getComponentAt(index);
        b.fireClicked();
    }

    public void hideTabs() {
        this.removeComponent(this.tabsContainer);
        this.revalidate();
    }

    public void showTabs() {
        int tp = this.tabPlacement;
        this.tabPlacement = -1;
        this.setTabPlacement(tp);
        this.revalidate();
    }

    public boolean isSwipeActivated() {
        return this.swipeActivated;
    }

    public void setSwipeActivated(boolean swipeActivated) {
        this.swipeActivated = swipeActivated;
    }

    private void initTabsFocus() {
        int i = 0;
        while (i < this.tabsContainer.getComponentCount()) {
            this.initTabFocus(this.tabsContainer.getComponentAt(i), this.contentPane.getComponentAt(this.activeComponent));
            ++i;
        }
    }

    private void initTabFocus(Component tab, Component content) {
        Component focus = null;
        if (content.isFocusable()) {
            focus = content;
        }
        if (content instanceof Container) {
            focus = ((Container)content).findFirstFocusable();
        }
        tab.setNextFocusDown(null);
        tab.setNextFocusUp(null);
        tab.setNextFocusLeft(null);
        tab.setNextFocusRight(null);
        if (focus != null) {
            focus.setNextFocusDown(null);
            focus.setNextFocusUp(null);
            focus.setNextFocusLeft(null);
            focus.setNextFocusRight(null);
            switch (this.tabPlacement) {
                case 0: {
                    tab.setNextFocusDown(focus);
                    focus.setNextFocusUp(this.tabsContainer.getComponentAt(this.activeComponent));
                    break;
                }
                case 2: {
                    tab.setNextFocusUp(focus);
                    break;
                }
                case 1: {
                    tab.setNextFocusRight(focus);
                    focus.setNextFocusLeft(this.tabsContainer.getComponentAt(this.activeComponent));
                    break;
                }
                case 3: {
                    tab.setNextFocusLeft(focus);
                    focus.setNextFocusRight(this.tabsContainer.getComponentAt(this.activeComponent));
                }
            }
        }
    }

    public String[] getPropertyNames() {
        return new String[]{"titles"};
    }

    public Class[] getPropertyTypes() {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Ljava.lang.String;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        return classArray;
    }

    public Object getPropertyValue(String name) {
        if (name.equals("titles")) {
            String[] t = new String[this.getTabCount()];
            int iter = 0;
            while (iter < t.length) {
                t[iter] = this.getTabTitle(iter);
                ++iter;
            }
            return t;
        }
        return null;
    }

    public String setPropertyValue(String name, Object value) {
        if (name.equals("titles")) {
            String[] t = (String[])value;
            int iter = 0;
            while (iter < t.length) {
                this.setTabTitle(t[iter], null, iter);
                ++iter;
            }
            return null;
        }
        return super.setPropertyValue(name, value);
    }

    class SwipeListener
    implements ActionListener {
        private static final int PRESS = 0;
        private static final int DRAG = 1;
        private static final int RELEASE = 2;
        private final int type;

        SwipeListener(int type) {
            this.type = type;
        }

        public void actionPerformed(ActionEvent evt) {
            if (Tabs.this.getComponentCount() == 0 || !Tabs.this.swipeActivated || Tabs.this.animate()) {
                return;
            }
            int x = evt.getX();
            int y = evt.getY();
            switch (this.type) {
                case 0: {
                    if (Tabs.this.contentPane.contains(x, y)) {
                        Tabs.this.lastX = x;
                        Tabs.this.initialX = x;
                    } else {
                        Tabs.this.lastX = -1;
                        Tabs.this.initialX = -1;
                    }
                    Tabs.this.dragStarted = false;
                    break;
                }
                case 1: {
                    int diffX;
                    if (!Tabs.this.dragStarted) {
                        Tabs.this.dragStarted = Math.abs(x - Tabs.this.initialX) > Tabs.this.contentPane.getWidth() / 8;
                    }
                    if (Tabs.this.initialX == -1 || !Tabs.this.contentPane.contains(x, y) || (diffX = x - Tabs.this.lastX) == 0 || !Tabs.this.dragStarted) break;
                    Tabs tabs = Tabs.this;
                    tabs.lastX = tabs.lastX + diffX;
                    int size = Tabs.this.contentPane.getComponentCount();
                    int i = 0;
                    while (i < size) {
                        Component component = Tabs.this.contentPane.getComponentAt(i);
                        component.setX(component.getX() + diffX);
                        ++i;
                    }
                    Tabs.this.repaint();
                    break;
                }
                case 2: {
                    int diff;
                    if (Tabs.this.initialX != -1 && (diff = x - Tabs.this.initialX) != 0 && Tabs.this.dragStarted) {
                        if (Math.abs(diff) > Tabs.this.contentPane.getWidth() / 2) {
                            if (diff > 0) {
                                Tabs tabs = Tabs.this;
                                tabs.activeComponent = tabs.activeComponent - 1;
                                if (Tabs.this.activeComponent < 0) {
                                    Tabs.this.activeComponent = 0;
                                    Tabs.this.activeComponent = 0;
                                }
                            } else {
                                Tabs tabs = Tabs.this;
                                tabs.activeComponent = tabs.activeComponent + 1;
                                if (Tabs.this.activeComponent >= Tabs.this.contentPane.getComponentCount()) {
                                    Tabs.this.activeComponent = Tabs.this.contentPane.getComponentCount() - 1;
                                }
                            }
                        }
                        int start = Tabs.this.contentPane.getComponentAt(Tabs.this.activeComponent).getX();
                        int end = 0;
                        Tabs.this.slideToDestMotion = Motion.createSplineMotion(start, end, 250);
                        Tabs.this.slideToDestMotion.start();
                        Form form = Tabs.this.getComponentForm();
                        if (form != null) {
                            form.registerAnimatedInternal(Tabs.this);
                        }
                    }
                    Tabs.this.lastX = -1;
                    Tabs.this.initialX = -1;
                    Tabs.this.dragStarted = false;
                }
            }
        }
    }

    class TabFocusListener
    implements FocusListener {
        TabFocusListener() {
        }

        public void focusGained(Component cmp) {
            if (Tabs.this.focusListeners != null) {
                Tabs.this.focusListeners.fireFocus(cmp);
            }
        }

        public void focusLost(Component cmp) {
            if (Tabs.this.focusListeners != null) {
                Tabs.this.focusListeners.fireFocus(cmp);
            }
        }
    }

    class TabsLayout
    extends Layout {
        TabsLayout() {
        }

        public void layoutContainer(Container parent) {
            int size = parent.getComponentCount();
            int i = 0;
            while (i < size) {
                int xOffset = i * parent.getWidth();
                Component component = parent.getComponentAt(i);
                component.setX(component.getStyle().getMargin(1) + (xOffset -= Tabs.this.activeComponent * parent.getWidth()));
                component.setY(component.getStyle().getMargin(0));
                component.setWidth(parent.getWidth() - component.getStyle().getMargin(1) - component.getStyle().getMargin(3));
                component.setHeight(parent.getHeight() - component.getStyle().getMargin(0) - component.getStyle().getMargin(2));
                ++i;
            }
        }

        public Dimension getPreferredSize(Container parent) {
            Dimension dim = new Dimension(0, 0);
            dim.setWidth(parent.getWidth() + parent.getStyle().getPadding(false, 1) + parent.getStyle().getPadding(false, 3));
            dim.setHeight(parent.getHeight() + parent.getStyle().getPadding(false, 0) + parent.getStyle().getPadding(false, 2));
            int compCount = Tabs.this.contentPane.getComponentCount();
            int iter = 0;
            while (iter < compCount) {
                Dimension d = Tabs.this.contentPane.getComponentAt(iter).getPreferredSizeWithMargin();
                dim.setWidth(Math.max(d.getWidth(), dim.getWidth()));
                dim.setHeight(Math.max(d.getHeight(), dim.getHeight()));
                ++iter;
            }
            return dim;
        }
    }
}

