/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.layouts;

import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.Layout;

public class CoordinateLayout
extends Layout {
    private int width;
    private int height;

    public CoordinateLayout(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public CoordinateLayout(Dimension d) {
        this(d.getWidth(), d.getHeight());
    }

    public void layoutContainer(Container parent) {
        int numOfcomponents = parent.getComponentCount();
        int parentW = parent.getWidth();
        int parentH = parent.getHeight();
        int i = 0;
        while (i < numOfcomponents) {
            Component cmp = parent.getComponentAt(i);
            int x = cmp.getX() * parentW / Math.max(1, this.width);
            int y = cmp.getY() * parentH / Math.max(1, this.height);
            cmp.setX(x);
            cmp.setY(y);
            cmp.setWidth(cmp.getPreferredW());
            cmp.setHeight(cmp.getPreferredH());
            ++i;
        }
        this.width = parentW;
        this.height = parentH;
    }

    public Dimension getPreferredSize(Container parent) {
        Dimension retVal = new Dimension();
        int numOfcomponents = parent.getComponentCount();
        int i = 0;
        while (i < numOfcomponents) {
            Component cmp = parent.getComponentAt(i);
            retVal.setWidth(Math.max(retVal.getWidth(), cmp.getX() + cmp.getPreferredW()));
            retVal.setHeight(Math.max(retVal.getHeight(), cmp.getY() + cmp.getPreferredH()));
            ++i;
        }
        return retVal;
    }

    public boolean isOverlapSupported() {
        return true;
    }
}

