/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.list;

import com.sun.lwuit.CheckBox;
import com.sun.lwuit.Command;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Form;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.List;
import com.sun.lwuit.RadioButton;
import com.sun.lwuit.TextArea;
import com.sun.lwuit.animations.Animation;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.list.ListCellRenderer;
import com.sun.lwuit.plaf.UIManager;
import java.util.Hashtable;
import java.util.Vector;

public class GenericListCellRenderer
implements ListCellRenderer {
    private Label focusComponent = new Label();
    private Component selected;
    private Component unselected;
    private Component[] selectedEntries;
    private Component[] unselectedEntries;
    private Component selectedEven;
    private Component unselectedEven;
    private Component[] selectedEntriesEven;
    private Component[] unselectedEntriesEven;
    private Monitor mon = new Monitor();
    private List parentList;
    private boolean selectionListener = true;

    public GenericListCellRenderer(Component selected, Component unselected) {
        if (selected == unselected) {
            throw new IllegalArgumentException("Must use distinct instances for renderer!");
        }
        this.selected = selected;
        this.unselected = unselected;
        this.focusComponent.setUIID("ListRendererFocus");
        this.focusComponent.setFocus(true);
        this.selectedEntries = this.initRenderer(selected);
        this.unselectedEntries = this.initRenderer(unselected);
    }

    private Component[] initRenderer(Component r) {
        r.setCellRenderer(true);
        if (r instanceof Container) {
            Vector selectedVector = new Vector();
            this.findComponentsOfInterest(r, selectedVector);
            return this.vectorToComponentArray(selectedVector);
        }
        return new Component[]{this.selected};
    }

    public GenericListCellRenderer(Component odd, Component oddUnselected, Component even, Component evenUnselected) {
        this(odd, oddUnselected);
        this.selectedEntriesEven = this.initRenderer(even);
        this.unselectedEntriesEven = this.initRenderer(evenUnselected);
    }

    private Component[] vectorToComponentArray(Vector v) {
        Component[] result = new Component[v.size()];
        int iter = 0;
        while (iter < result.length) {
            result[iter] = (Component)v.elementAt(iter);
            ++iter;
        }
        return result;
    }

    private void findComponentsOfInterest(Component cmp, Vector dest) {
        if (cmp instanceof Container) {
            Container c = (Container)cmp;
            int count = c.getComponentCount();
            int iter = 0;
            while (iter < count) {
                this.findComponentsOfInterest(c.getComponentAt(iter), dest);
                ++iter;
            }
            return;
        }
        if ((cmp instanceof Label || cmp instanceof TextArea) && cmp.getName() != null) {
            dest.addElement(cmp);
            return;
        }
    }

    public Component getListCellRendererComponent(List list, Object value, int index, boolean isSelected) {
        if (isSelected) {
            Component cmp = this.selected;
            Component[] entries = this.selectedEntries;
            if (this.selectedEven != null && index % 2 == 0) {
                cmp = this.selectedEven;
                entries = this.selectedEntriesEven;
            }
            if (value instanceof Hashtable) {
                Hashtable h = (Hashtable)value;
                int iter = 0;
                while (iter < entries.length) {
                    this.setComponentValueWithTickering(entries[iter], h.get(entries[iter].getName()), list);
                    ++iter;
                }
            } else {
                this.setComponentValueWithTickering(entries[0], value, list);
            }
            return cmp;
        }
        Component cmp = this.unselected;
        Component[] entries = this.unselectedEntries;
        if (this.unselectedEven != null && index % 2 == 0) {
            cmp = this.unselectedEven;
            entries = this.unselectedEntriesEven;
        }
        if (value instanceof Hashtable) {
            Hashtable h = (Hashtable)value;
            int iter = 0;
            while (iter < entries.length) {
                this.setComponentValue(entries[iter], h.get(entries[iter].getName()));
                ++iter;
            }
        } else {
            this.setComponentValue(entries[0], value);
        }
        return cmp;
    }

    private boolean isSelectedValue(Object v) {
        return v != null && "true".equalsIgnoreCase(v.toString());
    }

    private void setComponentValueWithTickering(Component cmp, Object value, List l) {
        this.setComponentValue(cmp, value);
        if (cmp instanceof Label) {
            Label label = (Label)cmp;
            if (label.shouldTickerStart()) {
                if (!label.isTickerRunning()) {
                    this.parentList = l;
                    if (this.selectionListener) {
                        this.parentList.addActionListener(this.mon);
                    }
                    this.parentList.getComponentForm().registerAnimated(this.mon);
                    label.startTicker(UIManager.getInstance().getLookAndFeel().getTickerSpeed(), true);
                }
            } else if (label.isTickerRunning()) {
                label.stopTicker();
            }
        }
    }

    protected void setComponentValue(Component cmp, Object value) {
        if (cmp instanceof Label) {
            if (value instanceof Image) {
                ((Label)cmp).setIcon((Image)value);
                ((Label)cmp).setText("");
                return;
            }
            ((Label)cmp).setIcon(null);
            if (cmp instanceof CheckBox) {
                ((CheckBox)cmp).setSelected(this.isSelectedValue(value));
                return;
            }
            if (cmp instanceof RadioButton) {
                ((RadioButton)cmp).setSelected(this.isSelectedValue(value));
                return;
            }
            if (value == null) {
                ((Label)cmp).setText("");
            } else {
                ((Label)cmp).setText(value.toString());
            }
            return;
        }
        if (cmp instanceof TextArea) {
            if (value == null) {
                ((TextArea)cmp).setText("");
            } else {
                ((TextArea)cmp).setText(value.toString());
            }
        }
    }

    public Component getListFocusComponent(List list) {
        return this.focusComponent;
    }

    public boolean isSelectionListener() {
        return this.selectionListener;
    }

    public void setSelectionListener(boolean selectionListener) {
        if (this.parentList != null) {
            this.parentList.addActionListener(this.mon);
        }
        this.selectionListener = selectionListener;
    }

    public Component getSelected() {
        return this.selected;
    }

    public Component getUnselected() {
        return this.unselected;
    }

    public Component getSelectedEven() {
        return this.selectedEven;
    }

    public Component getUnselectedEven() {
        return this.unselectedEven;
    }

    class Monitor
    implements ActionListener,
    Animation {
        Monitor() {
        }

        public boolean animate() {
            if (GenericListCellRenderer.this.parentList != null) {
                boolean repaint = false;
                Form f = GenericListCellRenderer.this.parentList.getComponentForm();
                if (f != null) {
                    int iter = 0;
                    while (iter < GenericListCellRenderer.this.selectedEntries.length) {
                        Label l;
                        if (GenericListCellRenderer.this.selectedEntries[iter] instanceof Label && (l = (Label)GenericListCellRenderer.this.selectedEntries[iter]).isTickerRunning() && l.animate()) {
                            repaint = true;
                        }
                        ++iter;
                    }
                }
                if (repaint) {
                    GenericListCellRenderer.this.parentList.repaint();
                }
            }
            return false;
        }

        public void paint(Graphics g) {
        }

        public void actionPerformed(ActionEvent evt) {
            Object selection = GenericListCellRenderer.this.parentList.getSelectedItem();
            if (selection instanceof Hashtable) {
                Hashtable h = (Hashtable)selection;
                Command cmd = (Command)h.get("$navigation");
                if (cmd != null) {
                    GenericListCellRenderer.this.parentList.getComponentForm().dispatchCommand(cmd, new ActionEvent(GenericListCellRenderer.this.parentList));
                    return;
                }
                int iter = 0;
                while (iter < GenericListCellRenderer.this.selectedEntries.length) {
                    if (GenericListCellRenderer.this.selectedEntries[iter] instanceof CheckBox || GenericListCellRenderer.this.selectedEntries[iter] instanceof RadioButton) {
                        boolean sel = !GenericListCellRenderer.this.isSelectedValue(h.get(GenericListCellRenderer.this.selectedEntries[iter].getName()));
                        h.put(GenericListCellRenderer.this.selectedEntries[iter].getName(), "" + sel);
                        return;
                    }
                    ++iter;
                }
            }
        }
    }
}

