/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.painter;

import com.sun.lwuit.Component;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.Painter;
import com.sun.lwuit.geom.Rectangle;
import com.sun.lwuit.plaf.Style;

public class BackgroundPainter
implements Painter {
    private Component parent;

    public BackgroundPainter(Component parent) {
        this.parent = parent;
    }

    public void paint(Graphics g, Rectangle rect) {
        Style s = this.parent.getStyle();
        int x = rect.getX();
        int y = rect.getY();
        int width = rect.getSize().getWidth();
        int height = rect.getSize().getHeight();
        if (width <= 0 || height <= 0) {
            return;
        }
        Image bgImage = s.getBgImage();
        if (bgImage == null) {
            g.setColor(s.getBgColor());
            g.fillRect(x, y, width, height, s.getBgTransparency());
        } else {
            if (s.getBackgroundType() == 1) {
                if (bgImage.getWidth() != width || bgImage.getHeight() != height) {
                    bgImage = bgImage.scaled(width, height);
                    s.setBgImage(bgImage, true);
                }
            } else {
                int iW = bgImage.getWidth();
                int iH = bgImage.getHeight();
                int xPos = 0;
                while (xPos < width) {
                    int yPos = 0;
                    while (yPos < height) {
                        g.drawImage(s.getBgImage(), x + xPos, y + yPos);
                        yPos += iH;
                    }
                    xPos += iW;
                }
                return;
            }
            g.drawImage(s.getBgImage(), x, y);
        }
    }
}

