/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.plaf;

import com.sun.lwuit.Font;
import com.sun.lwuit.Image;
import com.sun.lwuit.Painter;
import com.sun.lwuit.events.StyleListener;
import com.sun.lwuit.plaf.Border;
import com.sun.lwuit.plaf.UIManager;
import com.sun.lwuit.util.EventDispatcher;
import java.lang.ref.WeakReference;

public class Style {
    public static final String BG_COLOR = "bgColor";
    public static final String FG_COLOR = "fgColor";
    public static final String BG_IMAGE = "bgImage";
    public static final String BACKGROUND_TYPE = "bgType";
    public static final String BACKGROUND_ALIGNMENT = "bgAlign";
    public static final String BACKGROUND_GRADIENT = "bgGradient";
    public static final String FONT = "font";
    public static final String TRANSPARENCY = "transparency";
    public static final String MARGIN = "margin";
    public static final String BORDER = "border";
    public static final String PADDING = "padding";
    public static final String PAINTER = "painter";
    public static final String ALIGNMENT = "align";
    public static final String TEXT_DECORATION = "textDecoration";
    public static final byte BACKGROUND_IMAGE_SCALED = 1;
    public static final byte BACKGROUND_IMAGE_TILE_BOTH = 2;
    public static final byte BACKGROUND_IMAGE_TILE_VERTICAL = 3;
    public static final byte BACKGROUND_IMAGE_TILE_HORIZONTAL = 4;
    public static final byte BACKGROUND_IMAGE_ALIGNED = 5;
    public static final byte BACKGROUND_IMAGE_ALIGNED_TOP = 20;
    public static final byte BACKGROUND_IMAGE_ALIGNED_BOTTOM = 21;
    public static final byte BACKGROUND_IMAGE_ALIGNED_LEFT = 22;
    public static final byte BACKGROUND_IMAGE_ALIGNED_RIGHT = 23;
    public static final byte BACKGROUND_IMAGE_ALIGNED_CENTER = 24;
    public static final byte BACKGROUND_GRADIENT_LINEAR_VERTICAL = 6;
    public static final byte BACKGROUND_GRADIENT_LINEAR_HORIZONTAL = 7;
    public static final byte BACKGROUND_GRADIENT_RADIAL = 8;
    public static final byte BACKGROUND_IMAGE_ALIGN_TOP = -95;
    public static final byte BACKGROUND_IMAGE_ALIGN_BOTTOM = -94;
    public static final byte BACKGROUND_IMAGE_ALIGN_LEFT = -93;
    public static final byte BACKGROUND_IMAGE_ALIGN_RIGHT = -92;
    public static final byte BACKGROUND_IMAGE_ALIGN_CENTER = -91;
    public static final byte TEXT_DECORATION_UNDERLINE = 1;
    public static final byte TEXT_DECORATION_STRIKETHRU = 2;
    private int fgColor = 0;
    private int bgColor = 0xFFFFFF;
    private Font font = Font.getDefaultFont();
    private Image bgImage;
    private int[] padding = new int[4];
    private int[] margin = new int[4];
    private byte transparency = (byte)-1;
    private Painter bgPainter;
    private byte backgroundType = 1;
    private byte backgroundAlignment = (byte)-95;
    private Object[] backgroundGradient;
    private Border border = null;
    private int align = 1;
    private int textDecoration;
    private int modifiedFlag;
    private static final int FG_COLOR_MODIFIED = 1;
    private static final int BG_COLOR_MODIFIED = 2;
    private static final int FONT_MODIFIED = 16;
    private static final int BG_IMAGE_MODIFIED = 32;
    private static final int TRANSPARENCY_MODIFIED = 128;
    private static final int PADDING_MODIFIED = 256;
    private static final int MARGIN_MODIFIED = 512;
    private static final int BORDER_MODIFIED = 1024;
    private static final int BACKGROUND_TYPE_MODIFIED = 2048;
    private static final int BACKGROUND_ALIGNMENT_MODIFIED = 4096;
    private static final int BACKGROUND_GRADIENT_MODIFIED = 8192;
    private static final int ALIGNMENT_MODIFIED = 16384;
    private static final int TEXT_DECORATION_MODIFIED = 64;
    private EventDispatcher listeners;
    WeakReference roundRectCache;

    public Style() {
        this.setPadding(3, 3, 3, 3);
        this.setMargin(2, 2, 2, 2);
        this.modifiedFlag = 0;
    }

    public Style(Style style) {
        this(style.getFgColor(), style.getBgColor(), 0, 0, style.getFont(), style.getBgTransparency(), style.getBgImage(), true);
        this.setPadding(style.padding[0], style.padding[2], style.padding[1], style.padding[3]);
        this.setMargin(style.margin[0], style.margin[2], style.margin[1], style.margin[3]);
        this.setBorder(style.getBorder());
        this.modifiedFlag = 0;
        this.align = style.align;
        this.backgroundType = style.backgroundType;
        this.backgroundAlignment = style.backgroundAlignment;
        this.textDecoration = style.textDecoration;
        if (style.backgroundGradient != null) {
            this.backgroundGradient = new Object[style.backgroundGradient.length];
            System.arraycopy(style.backgroundGradient, 0, this.backgroundGradient, 0, this.backgroundGradient.length);
        }
    }

    private Style(int fgColor, int bgColor, int fgSelectionColor, int bgSelectionColor, Font f, byte transparency) {
        this(fgColor, bgColor, fgSelectionColor, bgSelectionColor, f, transparency, null, false);
    }

    public Style(int fgColor, int bgColor, Font f, byte transparency) {
        this(fgColor, bgColor, f, transparency, null, 1);
    }

    private Style(int fgColor, int bgColor, int fgSelectionColor, int bgSelectionColor, Font f, byte transparency, Image im, boolean scaledImage) {
        this();
        this.fgColor = fgColor;
        this.bgColor = bgColor;
        this.font = f;
        this.transparency = transparency;
        this.bgImage = im;
    }

    public Style(int fgColor, int bgColor, Font f, byte transparency, Image im, byte backgroundType) {
        this();
        this.fgColor = fgColor;
        this.bgColor = bgColor;
        this.font = f;
        this.transparency = transparency;
        this.backgroundType = backgroundType;
        this.bgImage = im;
    }

    public void merge(Style style) {
        int tmp = this.modifiedFlag;
        if ((this.modifiedFlag & 1) == 0) {
            this.setFgColor(style.getFgColor());
        }
        if ((this.modifiedFlag & 2) == 0) {
            this.setBgColor(style.getBgColor());
        }
        if ((this.modifiedFlag & 0x20) == 0) {
            this.setBgImage(style.getBgImage());
        }
        if ((this.modifiedFlag & 0x800) == 0) {
            this.setBackgroundType(style.getBackgroundType());
        }
        if ((this.modifiedFlag & 0x1000) == 0) {
            this.setBackgroundAlignment(style.getBackgroundAlignment());
        }
        if ((this.modifiedFlag & 0x2000) == 0) {
            this.setBackgroundGradientStartColor(style.getBackgroundGradientStartColor());
            this.setBackgroundGradientEndColor(style.getBackgroundGradientEndColor());
            this.setBackgroundGradientRelativeX(style.getBackgroundGradientRelativeX());
            this.setBackgroundGradientRelativeY(style.getBackgroundGradientRelativeY());
            this.setBackgroundGradientRelativeSize(style.getBackgroundGradientRelativeSize());
        }
        if ((this.modifiedFlag & 0x10) == 0) {
            this.setFont(style.getFont());
        }
        if ((this.modifiedFlag & 0x80) == 0) {
            this.setBgTransparency(style.getBgTransparency());
        }
        if ((this.modifiedFlag & 0x100) == 0) {
            this.setPadding(style.padding[0], style.padding[2], style.padding[1], style.padding[3]);
        }
        if ((this.modifiedFlag & 0x200) == 0) {
            this.setMargin(style.margin[0], style.margin[2], style.margin[1], style.margin[3]);
        }
        if ((this.modifiedFlag & 0x400) == 0) {
            this.setBorder(style.getBorder());
        }
        if ((this.modifiedFlag & 0x40) == 0) {
            this.setTextDecoration(style.getTextDecoration());
        }
        if ((this.modifiedFlag & 0x4000) == 0) {
            this.setAlignment(style.getAlignment());
        }
        this.bgPainter = style.bgPainter;
        this.modifiedFlag = tmp;
    }

    public boolean isModified() {
        return this.modifiedFlag != 0;
    }

    public int getBgColor() {
        return this.bgColor;
    }

    public Image getBgImage() {
        return this.bgImage;
    }

    public byte getBackgroundType() {
        return this.backgroundType;
    }

    public byte getBackgroundAlignment() {
        return this.backgroundAlignment;
    }

    public int getBackgroundGradientStartColor() {
        if (this.backgroundGradient != null && this.backgroundGradient.length > 1) {
            return (Integer)this.backgroundGradient[0];
        }
        return 0xFFFFFF;
    }

    public int getBackgroundGradientEndColor() {
        if (this.backgroundGradient != null && this.backgroundGradient.length > 1) {
            return (Integer)this.backgroundGradient[1];
        }
        return 0;
    }

    public float getBackgroundGradientRelativeX() {
        if (this.backgroundGradient != null && this.backgroundGradient.length > 2) {
            return ((Float)this.backgroundGradient[2]).floatValue();
        }
        return 0.5f;
    }

    public float getBackgroundGradientRelativeY() {
        if (this.backgroundGradient != null && this.backgroundGradient.length > 3) {
            return ((Float)this.backgroundGradient[3]).floatValue();
        }
        return 0.5f;
    }

    public float getBackgroundGradientRelativeSize() {
        if (this.backgroundGradient != null && this.backgroundGradient.length > 4) {
            return ((Float)this.backgroundGradient[4]).floatValue();
        }
        return 1.0f;
    }

    public int getFgColor() {
        return this.fgColor;
    }

    public Font getFont() {
        return this.font;
    }

    public void setBgColor(int bgColor) {
        this.setBgColor(bgColor, false);
    }

    public void setAlignment(int align) {
        this.setAlignment(align, false);
    }

    public void setAlignment(int align, boolean override) {
        if (this.align != align) {
            this.align = align;
            if (!override) {
                this.modifiedFlag |= 0x4000;
            }
            this.firePropertyChanged(ALIGNMENT);
        }
    }

    public int getAlignment() {
        return this.align;
    }

    public void setBgImage(Image bgImage) {
        this.setBgImage(bgImage, false);
    }

    public void setBackgroundType(byte backgroundType) {
        this.setBackgroundType(backgroundType, false);
    }

    public void setBackgroundAlignment(byte backgroundAlignment) {
        this.setBackgroundAlignment(backgroundAlignment, false);
    }

    public void setBackgroundGradientStartColor(int backgroundGradientStartColor) {
        this.setBackgroundGradientStartColor(backgroundGradientStartColor, false);
    }

    public void setBackgroundGradientEndColor(int backgroundGradientEndColor) {
        this.setBackgroundGradientEndColor(backgroundGradientEndColor, false);
    }

    public void setBackgroundGradientRelativeX(float backgroundGradientRelativeX) {
        this.setBackgroundGradientRelativeX(backgroundGradientRelativeX, false);
    }

    public void setBackgroundGradientRelativeY(float backgroundGradientRelativeY) {
        this.setBackgroundGradientRelativeY(backgroundGradientRelativeY, false);
    }

    public void setBackgroundGradientRelativeSize(float backgroundGradientRelativeSize) {
        this.setBackgroundGradientRelativeSize(backgroundGradientRelativeSize, false);
    }

    public void setFgColor(int fgColor) {
        this.setFgColor(fgColor, false);
    }

    public void setFont(Font font) {
        this.setFont(font, false);
    }

    public void setUnderline(boolean underline) {
        if (underline != this.isUnderline()) {
            this.textDecoration = underline ? (this.textDecoration |= 1) : --this.textDecoration;
        }
    }

    public boolean isUnderline() {
        return (this.textDecoration & 1) != 0;
    }

    public void setStrikeThru(boolean strikethru) {
        if (strikethru != this.isStrikeThru()) {
            this.textDecoration = strikethru ? (this.textDecoration |= 2) : (this.textDecoration -= 2);
        }
    }

    public boolean isStrikeThru() {
        return (this.textDecoration & 2) != 0;
    }

    public int getTextDecoration() {
        return this.textDecoration;
    }

    public void setTextDecoration(int textDecoration) {
        this.setTextDecoration(textDecoration, false);
    }

    public void setTextDecoration(int textDecoration, boolean override) {
        this.textDecoration = textDecoration;
        if (this.textDecoration != textDecoration) {
            this.textDecoration = textDecoration;
            if (!override) {
                this.modifiedFlag |= 0x40;
            }
            this.firePropertyChanged(TEXT_DECORATION);
        }
    }

    public byte getBgTransparency() {
        if (this.bgImage != null && (this.bgImage.isAnimation() || this.bgImage.isOpaque())) {
            return -1;
        }
        return this.transparency;
    }

    public void setBgTransparency(byte transparency) {
        this.setBgTransparency(transparency & 0xFF, false);
    }

    public void setBgTransparency(int transparency) {
        this.setBgTransparency(transparency, false);
    }

    public void setPadding(int top, int bottom, int left, int right) {
        if (top < 0 || left < 0 || right < 0 || bottom < 0) {
            throw new IllegalArgumentException("padding cannot be negative");
        }
        if (this.padding[0] != top || this.padding[2] != bottom || this.padding[1] != left || this.padding[3] != right) {
            this.padding[0] = top;
            this.padding[2] = bottom;
            this.padding[1] = left;
            this.padding[3] = right;
            this.modifiedFlag |= 0x100;
            this.firePropertyChanged(PADDING);
        }
    }

    public void setPadding(int orientation, int gap) {
        this.setPadding(orientation, gap, false);
    }

    public void setMargin(int top, int bottom, int left, int right) {
        if (top < 0 || left < 0 || right < 0 || bottom < 0) {
            throw new IllegalArgumentException("margin cannot be negative");
        }
        if (this.margin[0] != top || this.margin[2] != bottom || this.margin[1] != left || this.margin[3] != right) {
            this.margin[0] = top;
            this.margin[2] = bottom;
            this.margin[1] = left;
            this.margin[3] = right;
            this.modifiedFlag |= 0x200;
            this.firePropertyChanged(MARGIN);
        }
    }

    public void setMargin(int orientation, int gap) {
        this.setMargin(orientation, gap, false);
    }

    public int getPadding(boolean rtl, int orientation) {
        if (orientation < 0 || orientation > 3) {
            throw new IllegalArgumentException("wrong orientation " + orientation);
        }
        if (rtl) {
            switch (orientation) {
                case 1: {
                    orientation = 3;
                    break;
                }
                case 3: {
                    orientation = 1;
                }
            }
        }
        return this.padding[orientation];
    }

    public int getPadding(int orientation) {
        return this.getPadding(UIManager.getInstance().getLookAndFeel().isRTL(), orientation);
    }

    public int getMargin(int orientation) {
        return this.getMargin(UIManager.getInstance().getLookAndFeel().isRTL(), orientation);
    }

    public int getMargin(boolean rtl, int orientation) {
        if (orientation < 0 || orientation > 3) {
            throw new IllegalArgumentException("wrong orientation " + orientation);
        }
        if (rtl) {
            switch (orientation) {
                case 1: {
                    orientation = 3;
                    break;
                }
                case 3: {
                    orientation = 1;
                }
            }
        }
        return this.margin[orientation];
    }

    public void setBgColor(int bgColor, boolean override) {
        if (this.bgColor != bgColor) {
            this.bgColor = bgColor;
            if (!override) {
                this.modifiedFlag |= 2;
            }
            this.firePropertyChanged(BG_COLOR);
        }
    }

    public void setBgImage(Image bgImage, boolean override) {
        if (this.bgImage != bgImage) {
            this.bgImage = bgImage;
            if (!override) {
                this.modifiedFlag |= 0x20;
            }
            this.firePropertyChanged(BG_IMAGE);
        }
    }

    public void setBackgroundType(byte backgroundType, boolean override) {
        if (this.backgroundType != backgroundType) {
            this.backgroundType = backgroundType;
            if (!override) {
                this.modifiedFlag |= 0x800;
            }
            this.firePropertyChanged(BACKGROUND_TYPE);
        }
    }

    public void setBackgroundAlignment(byte backgroundAlignment, boolean override) {
        if (this.backgroundAlignment != backgroundAlignment) {
            this.backgroundAlignment = backgroundAlignment;
            if (!override) {
                this.modifiedFlag |= 0x1000;
            }
            this.firePropertyChanged(BACKGROUND_ALIGNMENT);
        }
    }

    Object[] getBackgroundGradient() {
        if (this.backgroundGradient == null) {
            Float c = new Float(0.5f);
            this.backgroundGradient = new Object[]{new Integer(0xFFFFFF), new Integer(0), c, c, new Float(1.0f)};
        }
        return this.backgroundGradient;
    }

    void setBackgroundGradient(Object[] backgroundGradient) {
        this.backgroundGradient = backgroundGradient;
    }

    public void setBackgroundGradientStartColor(int backgroundGradientStartColor, boolean override) {
        if ((Integer)this.getBackgroundGradient()[0] != backgroundGradientStartColor) {
            this.getBackgroundGradient()[0] = new Integer(backgroundGradientStartColor);
            if (!override) {
                this.modifiedFlag |= 0x2000;
            }
            this.firePropertyChanged(BACKGROUND_GRADIENT);
        }
    }

    public void setBackgroundGradientEndColor(int backgroundGradientEndColor, boolean override) {
        if ((Integer)this.getBackgroundGradient()[1] != backgroundGradientEndColor) {
            this.getBackgroundGradient()[1] = new Integer(backgroundGradientEndColor);
            if (!override) {
                this.modifiedFlag |= 0x2000;
            }
            this.firePropertyChanged(BACKGROUND_GRADIENT);
        }
    }

    public void setBackgroundGradientRelativeX(float backgroundGradientRelativeX, boolean override) {
        if (((Float)this.getBackgroundGradient()[2]).floatValue() != backgroundGradientRelativeX) {
            this.getBackgroundGradient()[2] = new Float(backgroundGradientRelativeX);
            if (!override) {
                this.modifiedFlag |= 0x2000;
            }
            this.firePropertyChanged(BACKGROUND_GRADIENT);
        }
    }

    public void setBackgroundGradientRelativeY(float backgroundGradientRelativeY, boolean override) {
        if (((Float)this.getBackgroundGradient()[3]).floatValue() != backgroundGradientRelativeY) {
            this.getBackgroundGradient()[3] = new Float(backgroundGradientRelativeY);
            if (!override) {
                this.modifiedFlag |= 0x2000;
            }
            this.firePropertyChanged(BACKGROUND_GRADIENT);
        }
    }

    public void setBackgroundGradientRelativeSize(float backgroundGradientRelativeSize, boolean override) {
        if (((Float)this.getBackgroundGradient()[4]).floatValue() != backgroundGradientRelativeSize) {
            this.getBackgroundGradient()[4] = new Float(backgroundGradientRelativeSize);
            if (!override) {
                this.modifiedFlag |= 0x2000;
            }
            this.firePropertyChanged(BACKGROUND_GRADIENT);
        }
    }

    public void setFgColor(int fgColor, boolean override) {
        if (this.fgColor != fgColor) {
            this.fgColor = fgColor;
            if (!override) {
                this.modifiedFlag |= 1;
            }
            this.firePropertyChanged(FG_COLOR);
        }
    }

    public void setFont(Font font, boolean override) {
        if (this.font == null && font != null || this.font != null && !this.font.equals(font)) {
            this.font = font;
            if (!override) {
                this.modifiedFlag |= 0x10;
            }
            this.firePropertyChanged(FONT);
        }
    }

    public void setBgTransparency(int transparency, boolean override) {
        if (transparency < 0 || transparency > 255) {
            throw new IllegalArgumentException("valid values are between 0-255");
        }
        if (this.transparency != (byte)transparency) {
            this.transparency = (byte)transparency;
            if (!override) {
                this.modifiedFlag |= 0x80;
            }
            this.firePropertyChanged(TRANSPARENCY);
        }
    }

    public void setPadding(int orientation, int gap, boolean override) {
        if (orientation < 0 || orientation > 3) {
            throw new IllegalArgumentException("wrong orientation " + orientation);
        }
        if (gap < 0) {
            throw new IllegalArgumentException("padding cannot be negative");
        }
        if (this.padding[orientation] != gap) {
            this.padding[orientation] = gap;
            if (!override) {
                this.modifiedFlag |= 0x100;
            }
            this.firePropertyChanged(PADDING);
        }
    }

    public void setMargin(int orientation, int gap, boolean override) {
        if (orientation < 0 || orientation > 3) {
            throw new IllegalArgumentException("wrong orientation " + orientation);
        }
        if (gap < 0) {
            throw new IllegalArgumentException("margin cannot be negative");
        }
        if (this.margin[orientation] != gap) {
            this.margin[orientation] = gap;
            if (!override) {
                this.modifiedFlag |= 0x200;
            }
            this.firePropertyChanged(MARGIN);
        }
    }

    private void firePropertyChanged(String propertName) {
        this.roundRectCache = null;
        if (this.listeners == null) {
            return;
        }
        this.listeners.fireStyleChangeEvent(propertName, this);
    }

    public void addStyleListener(StyleListener l) {
        if (this.listeners == null) {
            this.listeners = new EventDispatcher();
        }
        this.listeners.addListener(l);
    }

    public void removeStyleListener(StyleListener l) {
        if (this.listeners != null) {
            this.listeners.removeListener(l);
        }
    }

    void resetModifiedFlag() {
        this.modifiedFlag = 0;
    }

    public void setBorder(Border border) {
        this.setBorder(border, false);
    }

    public void setBorder(Border border, boolean override) {
        if (this.border == null && border != null || this.border != null && !this.border.equals(border)) {
            this.border = border;
            if (!override) {
                this.modifiedFlag |= 0x400;
            }
            this.firePropertyChanged(BORDER);
        }
    }

    public Border getBorder() {
        return this.border;
    }

    public Painter getBgPainter() {
        return this.bgPainter;
    }

    public void setBgPainter(Painter bgPainter) {
        this.bgPainter = bgPainter;
        this.firePropertyChanged(PAINTER);
    }
}

