/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.table;

import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.Layout;
import com.sun.lwuit.plaf.Style;
import java.util.Vector;

public class TableLayout
extends Layout {
    private int currentRow;
    private int currentColumn;
    private static int minimumSizePerColumn = 10;
    private Constraint[][] tablePositions;
    private int[] columnSizes;
    private int[] columnPositions;
    private int[] rowPositions;
    private boolean[] modifableColumnSize;
    private static final Constraint H_SPAN_CONSTRAINT = new Constraint();
    private static final Constraint V_SPAN_CONSTRAINT = new Constraint();
    private static final Constraint VH_SPAN_CONSTRAINT = new Constraint();
    private static int defaultColumnWidth = -1;
    private static int defaultRowHeight = -1;
    private boolean horizontalSpanningExists;
    private boolean verticalSpanningExists;

    public TableLayout(int rows, int columns) {
        this.tablePositions = new Constraint[rows][columns];
    }

    public int getRows() {
        return this.tablePositions.length;
    }

    public int getColumns() {
        return this.tablePositions[0].length;
    }

    public Component getComponentAt(int row, int column) {
        return this.tablePositions[row][column].parent;
    }

    public void layoutContainer(Container parent) {
        this.verticalSpanningExists = false;
        this.horizontalSpanningExists = false;
        Style s = parent.getStyle();
        int top = s.getPadding(false, 0);
        int left = s.getPadding(parent.isRTL(), 1);
        int bottom = s.getPadding(false, 2);
        int right = s.getPadding(parent.isRTL(), 3);
        boolean rtl = parent.isRTL();
        this.columnSizes = new int[this.tablePositions[0].length];
        if (this.modifableColumnSize == null) {
            this.modifableColumnSize = new boolean[this.tablePositions[0].length];
        }
        this.columnPositions = new int[this.tablePositions[0].length];
        int[] rowSizes = new int[this.tablePositions.length];
        this.rowPositions = new int[this.tablePositions.length];
        int pWidth = parent.getLayoutWidth() - parent.getSideGap() - left - right;
        int pHeight = parent.getLayoutHeight() - parent.getBottomGap() - top - bottom;
        int currentX = left;
        int iter = 0;
        while (iter < this.columnSizes.length) {
            this.columnSizes[iter] = this.getColumnWidthPixels(iter, pWidth, pWidth);
            ++iter;
        }
        if (!parent.isScrollableX()) {
            int totalWidth = 0;
            int totalModifyablePixels = 0;
            int iter2 = 0;
            while (iter2 < this.modifableColumnSize.length) {
                if (this.modifableColumnSize[iter2]) {
                    totalModifyablePixels += this.columnSizes[iter2];
                }
                totalWidth += this.columnSizes[iter2];
                ++iter2;
            }
            if (pWidth < totalWidth) {
                int totalPixelsToRemove = totalWidth - pWidth;
                int totalPixelsNecessary = totalModifyablePixels - totalPixelsToRemove;
                int iter3 = 0;
                while (iter3 < this.modifableColumnSize.length) {
                    if (this.modifableColumnSize[iter3]) {
                        this.columnSizes[iter3] = (int)((float)this.columnSizes[iter3] / (float)totalModifyablePixels * (float)totalPixelsNecessary);
                    }
                    ++iter3;
                }
            }
        }
        iter = 0;
        while (iter < this.columnSizes.length) {
            if (rtl) {
                this.columnPositions[iter] = pWidth - (currentX += this.columnSizes[iter]);
            } else {
                this.columnPositions[iter] = currentX;
                currentX += this.columnSizes[iter];
            }
            ++iter;
        }
        int currentY = top;
        int iter4 = 0;
        while (iter4 < rowSizes.length) {
            rowSizes[iter4] = parent.isScrollableY() ? this.getRowHeightPixels(iter4, pHeight, -1) : this.getRowHeightPixels(iter4, pHeight, pHeight - currentY);
            this.rowPositions[iter4] = currentY;
            currentY += rowSizes[iter4];
            ++iter4;
        }
        int r = 0;
        while (r < rowSizes.length) {
            int c = 0;
            while (c < this.columnSizes.length) {
                Constraint con = this.tablePositions[r][c];
                if (con != null && con != H_SPAN_CONSTRAINT && con != V_SPAN_CONSTRAINT && con != VH_SPAN_CONSTRAINT) {
                    int conH;
                    int conW;
                    Style componentStyle = con.parent.getStyle();
                    int leftMargin = componentStyle.getMargin(parent.isRTL(), 1);
                    int topMargin = componentStyle.getMargin(false, 0);
                    int conX = left + leftMargin + this.columnPositions[c];
                    int conY = top + topMargin + this.rowPositions[r];
                    if (con.spanHorizontal > 1) {
                        this.horizontalSpanningExists = true;
                        int w = this.columnSizes[c];
                        int sh = 1;
                        while (sh < con.spanHorizontal) {
                            w += this.columnSizes[Math.min(c + sh, this.columnSizes.length - 1)];
                            ++sh;
                        }
                        if (rtl) {
                            conX = left + leftMargin + this.columnPositions[c + con.spanHorizontal - 1];
                        }
                        conW = w - leftMargin - componentStyle.getMargin(parent.isRTL(), 3);
                    } else {
                        conW = this.columnSizes[c] - leftMargin - componentStyle.getMargin(parent.isRTL(), 3);
                    }
                    if (con.spanVertical > 1) {
                        this.verticalSpanningExists = true;
                        int h = rowSizes[r];
                        int sv = 1;
                        while (sv < con.spanVertical) {
                            h += rowSizes[Math.min(r + sv, rowSizes.length - 1)];
                            ++sv;
                        }
                        conH = h - topMargin - componentStyle.getMargin(false, 2);
                    } else {
                        conH = rowSizes[r] - topMargin - componentStyle.getMargin(false, 2);
                    }
                    this.placeComponent(rtl, con, conX, conY, conW, conH);
                }
                ++c;
            }
            ++r;
        }
    }

    public int getRowPosition(int row) {
        if (this.rowPositions != null && this.rowPositions.length > row) {
            return this.rowPositions[row];
        }
        return -1;
    }

    public int getColumnPosition(int col) {
        if (this.columnPositions != null && this.columnPositions.length > col) {
            return this.columnPositions[col];
        }
        return -1;
    }

    private void placeComponent(boolean rtl, Constraint con, int x, int y, int width, int height) {
        int d;
        con.parent.setX(x);
        con.parent.setY(y);
        con.parent.setWidth(width);
        con.parent.setHeight(height);
        Dimension pref = con.parent.getPreferredSize();
        int pWidth = pref.getWidth();
        int pHeight = pref.getHeight();
        if (pWidth < width) {
            d = width - pWidth;
            int a = con.align;
            if (rtl) {
                switch (a) {
                    case 1: {
                        a = 3;
                        break;
                    }
                    case 3: {
                        a = 1;
                    }
                }
            }
            switch (a) {
                case 1: {
                    con.parent.setX(x);
                    con.parent.setWidth(width - d);
                    break;
                }
                case 3: {
                    con.parent.setX(x + d);
                    con.parent.setWidth(width - d);
                    break;
                }
                case 4: {
                    con.parent.setX(x + d / 2);
                    con.parent.setWidth(width - d);
                }
            }
        }
        if (pHeight < height) {
            d = height - pHeight;
            switch (con.valign) {
                case 0: {
                    con.parent.setY(y);
                    con.parent.setHeight(height - d);
                    break;
                }
                case 2: {
                    con.parent.setY(y + d);
                    con.parent.setHeight(height - d);
                    break;
                }
                case 4: {
                    con.parent.setY(y + d / 2);
                    con.parent.setHeight(height - d);
                }
            }
        }
    }

    private int getColumnWidthPixels(int column, int percentageOf, int available) {
        int current = 0;
        if (this.modifableColumnSize == null) {
            this.modifableColumnSize = new boolean[this.tablePositions[0].length];
        }
        int iter = 0;
        while (iter < this.tablePositions.length) {
            Constraint c = this.tablePositions[iter][column];
            if (c != null && c != H_SPAN_CONSTRAINT && c != V_SPAN_CONSTRAINT && c != VH_SPAN_CONSTRAINT && c.spanHorizontal <= 1) {
                if (c.width > 0 && available > -1) {
                    current = Math.max(current, c.width * percentageOf / 100);
                    this.modifableColumnSize[column] = false;
                } else {
                    Style s = c.parent.getStyle();
                    current = Math.max(current, c.parent.getPreferredW() + s.getMargin(false, 1) + s.getMargin(false, 3));
                    this.modifableColumnSize[column] = true;
                }
                if (available > -1) {
                    current = Math.min(available, current);
                }
            }
            ++iter;
        }
        return current;
    }

    private int getRowHeightPixels(int row, int percentageOf, int available) {
        int current = 0;
        int iter = 0;
        while (iter < this.tablePositions[row].length) {
            Constraint c = this.tablePositions[row][iter];
            if (c != null && c != H_SPAN_CONSTRAINT && c != V_SPAN_CONSTRAINT && c != VH_SPAN_CONSTRAINT && c.spanVertical <= 1) {
                if (c.height > 0) {
                    current = Math.max(current, c.height * percentageOf / 100);
                } else {
                    Style s = c.parent.getStyle();
                    current = Math.max(current, c.parent.getPreferredH() + s.getMargin(false, 2) + s.getMargin(false, 0));
                }
                if (available > -1) {
                    current = Math.min(available, current);
                }
            }
            ++iter;
        }
        return current;
    }

    public Dimension getPreferredSize(Container parent) {
        Style s = parent.getStyle();
        int w = s.getPadding(false, 1) + s.getPadding(false, 3);
        int h = s.getPadding(false, 0) + s.getPadding(false, 2);
        int iter = 0;
        while (iter < this.tablePositions[0].length) {
            w += this.getColumnWidthPixels(iter, Integer.MAX_VALUE, -1);
            ++iter;
        }
        iter = 0;
        while (iter < this.tablePositions.length) {
            h += this.getRowHeightPixels(iter, Integer.MAX_VALUE, -1);
            ++iter;
        }
        return new Dimension(w, h);
    }

    public int getNextRow() {
        return this.currentRow;
    }

    public int getNextColumn() {
        return this.currentColumn;
    }

    private void shiftCell(int row, int column) {
        Constraint currentConstraint = this.tablePositions[row][column];
        int iter = column + 1;
        while (iter < this.tablePositions[row].length) {
            if (this.tablePositions[row][iter] == null) {
                this.tablePositions[row][iter] = currentConstraint;
                return;
            }
            Constraint tmp = this.tablePositions[row][iter];
            this.tablePositions[row][iter] = currentConstraint;
            currentConstraint = tmp;
            ++iter;
        }
        int rowIter = row + 1;
        while (rowIter < this.getRows()) {
            int colIter = 0;
            while (colIter < this.getColumns()) {
                if (this.tablePositions[rowIter][colIter] == null) {
                    this.tablePositions[rowIter][colIter] = currentConstraint;
                    return;
                }
                Constraint tmp = this.tablePositions[rowIter][colIter];
                this.tablePositions[rowIter][colIter] = currentConstraint;
                currentConstraint = tmp;
                ++colIter;
            }
            ++rowIter;
        }
        this.addRow();
    }

    private void addRow() {
        Constraint[][] newArr = new Constraint[this.tablePositions.length + 1][this.tablePositions[0].length];
        int iter = 0;
        while (iter < this.tablePositions.length) {
            newArr[iter] = this.tablePositions[iter];
            ++iter;
        }
        this.tablePositions = newArr;
    }

    public void addLayoutComponent(Object value, Component comp, Container c) {
        Constraint con = (Constraint)value;
        if (con == null) {
            con = this.createConstraint();
        } else if (con.parent != null) {
            throw new IllegalArgumentException("Constraint already associated with component!");
        }
        con.actualRow = con.row;
        con.actualColumn = con.column;
        if (con.actualRow < 0) {
            con.actualRow = this.currentRow;
        }
        if (con.actualColumn < 0) {
            con.actualColumn = this.currentColumn;
        }
        con.parent = comp;
        if (con.actualRow >= this.tablePositions.length) {
            this.addRow();
        }
        if (this.tablePositions[con.actualRow][con.actualColumn] != null) {
            if (this.tablePositions[con.actualRow][con.actualColumn].row != -1 || this.tablePositions[con.actualRow][con.actualColumn].column != -1) {
                throw new IllegalArgumentException("Row: " + con.row + " and column: " + con.column + " already occupied");
            }
            this.shiftCell(con.actualRow, con.actualColumn);
            this.tablePositions[con.actualRow][con.actualColumn] = con;
        }
        this.tablePositions[con.actualRow][con.actualColumn] = con;
        if (con.spanHorizontal > 1 || con.spanVertical > 1) {
            int sh = 0;
            while (sh < con.spanHorizontal) {
                int sv = 0;
                while (sv < con.spanVertical) {
                    if ((sh > 0 || sv > 0) && this.tablePositions.length > con.actualRow + sv && this.tablePositions[con.actualRow + sv].length > con.actualColumn + sh && this.tablePositions[con.actualRow + sv][con.actualColumn + sh] == null) {
                        this.tablePositions[con.actualRow + sv][con.actualColumn + sh] = con.spanHorizontal > 1 ? (con.spanVertical > 1 ? VH_SPAN_CONSTRAINT : V_SPAN_CONSTRAINT) : H_SPAN_CONSTRAINT;
                    }
                    ++sv;
                }
                ++sh;
            }
        }
        this.updateRowColumn();
    }

    /*
     * Unable to fully structure code
     */
    private void updateRowColumn() {
        if (this.currentRow < this.tablePositions.length) ** GOTO lbl9
        return;
lbl-1000:
        // 1 sources

        {
            ++this.currentColumn;
            if (this.currentColumn < this.tablePositions[0].length) continue;
            this.currentColumn = 0;
            ++this.currentRow;
            if (this.currentRow < this.tablePositions.length) continue;
            return;
lbl9:
            // 3 sources

            ** while (this.tablePositions[this.currentRow][this.currentColumn] != null)
        }
lbl10:
        // 1 sources

    }

    public int getCellHorizontalSpan(int row, int column) {
        return this.tablePositions[row][column].spanHorizontal;
    }

    public int getCellVerticalSpan(int row, int column) {
        return this.tablePositions[row][column].spanVertical;
    }

    public boolean isCellSpannedThroughVertically(int row, int column) {
        return this.tablePositions[row][column] == V_SPAN_CONSTRAINT || this.tablePositions[row][column] == VH_SPAN_CONSTRAINT;
    }

    public boolean isCellSpannedThroughHorizontally(int row, int column) {
        return this.tablePositions[row][column] == H_SPAN_CONSTRAINT || this.tablePositions[row][column] == VH_SPAN_CONSTRAINT;
    }

    public boolean hasVerticalSpanning() {
        return this.verticalSpanningExists;
    }

    public boolean hasHorizontalSpanning() {
        return this.horizontalSpanningExists;
    }

    public void removeLayoutComponent(Component comp) {
        Vector<Constraint> comps = new Vector<Constraint>();
        int r = 0;
        while (r < this.tablePositions.length) {
            int c = 0;
            while (c < this.tablePositions[r].length) {
                if (this.tablePositions[r][c] != null) {
                    if (this.tablePositions[r][c].parent != comp) {
                        comps.addElement(this.tablePositions[r][c]);
                    } else {
                        this.tablePositions[r][c].parent = null;
                    }
                }
                this.tablePositions[r][c] = null;
                ++c;
            }
            ++r;
        }
        this.currentRow = 0;
        this.currentColumn = 0;
        int count = comps.size();
        int iter = 0;
        while (iter < count) {
            Constraint con = (Constraint)comps.elementAt(iter);
            if (con != H_SPAN_CONSTRAINT && con != V_SPAN_CONSTRAINT && con != VH_SPAN_CONSTRAINT) {
                Component c = con.parent;
                con.parent = null;
                this.addLayoutComponent(con, c, c.getParent());
            }
            ++iter;
        }
    }

    public Object getComponentConstraint(Component comp) {
        int r = 0;
        while (r < this.tablePositions.length) {
            int c = 0;
            while (c < this.tablePositions[r].length) {
                if (this.tablePositions[r][c] != null && this.tablePositions[r][c].parent == comp) {
                    return this.tablePositions[r][c];
                }
                ++c;
            }
            ++r;
        }
        return null;
    }

    public Constraint createConstraint() {
        return new Constraint();
    }

    public Constraint createConstraint(int row, int column) {
        Constraint c = this.createConstraint();
        c.row = row;
        c.column = column;
        return c;
    }

    public static void setMinimumSizePerColumn(int minimumSize) {
        minimumSizePerColumn = minimumSize;
    }

    public static int getMinimumSizePerColumn() {
        return minimumSizePerColumn;
    }

    public static void setDefaultColumnWidth(int w) {
        defaultColumnWidth = w;
    }

    public static int getDefaultColumnWidth() {
        return defaultColumnWidth;
    }

    public static void setDefaultRowHeight(int h) {
        defaultRowHeight = h;
    }

    public static int getDefaultRowHeight() {
        return defaultRowHeight;
    }

    public String toString() {
        return "TableLayout";
    }

    public boolean equals(Object o) {
        return super.equals(o) && ((TableLayout)o).getRows() == this.getRows() && ((TableLayout)o).getColumns() == this.getColumns();
    }

    static /* synthetic */ int access$0() {
        return defaultColumnWidth;
    }

    static /* synthetic */ int access$1() {
        return defaultRowHeight;
    }

    public static class Constraint {
        private Component parent;
        private int row = -1;
        private int column = -1;
        private int width = TableLayout.access$0();
        private int height = TableLayout.access$1();
        private int spanHorizontal = 1;
        private int spanVertical = 1;
        private int align = -1;
        private int valign = -1;
        int actualRow = -1;
        int actualColumn = -1;

        public void setVerticalSpan(int span) {
            if (span < 1) {
                throw new IllegalArgumentException("Illegal span");
            }
            this.spanVertical = span;
        }

        public void setHorizontalSpan(int span) {
            if (span < 1) {
                throw new IllegalArgumentException("Illegal span");
            }
            this.spanHorizontal = span;
        }

        public void setWidthPercentage(int width) {
            this.width = width;
        }

        public void setHeightPercentage(int height) {
            this.height = height;
        }

        public void setHorizontalAlign(int align) {
            this.align = align;
        }

        public void setVerticalAlign(int valign) {
            this.valign = valign;
        }

        public int getRow() {
            return this.row;
        }

        public int getColumn() {
            return this.column;
        }

        public int getWidthPercentage() {
            return this.width;
        }

        public int getHeightPercentage() {
            return this.height;
        }

        public int getHorizontalSpan() {
            return this.spanHorizontal;
        }

        public int getVerticalSpan() {
            return this.spanVertical;
        }

        public int getHorizontalAlign() {
            return this.align;
        }

        public int getVerticalAlign() {
            return this.valign;
        }
    }
}

