/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.tree;

import com.sun.lwuit.Button;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Display;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.animations.CommonTransitions;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.tree.TreeModel;
import com.sun.lwuit.util.EventDispatcher;
import java.util.Vector;

public class Tree
extends Container {
    private static final String KEY_OBJECT = "TREE_OBJECT";
    private static final String KEY_PARENT = "TREE_PARENT";
    private static final String KEY_EXPANDED = "TREE_NODE_EXPANDED";
    private static final String KEY_DEPTH = "TREE_DEPTH";
    private EventDispatcher leafListener = new EventDispatcher();
    private ActionListener expansionListener = new Handler();
    private TreeModel model;
    private static Image folder;
    private static Image openFolder;
    private static Image nodeImage;
    private int depthIndent = 15;
    static /* synthetic */ Class class$0;

    public Tree() {
        this(new StringArrayTreeModel(new String[][]{{"Colors", "Letters", "Numbers"}, {"Red", "Green", "Blue"}, {"A", "B", "C"}, {"1", "2", "3"}}));
    }

    public String[] getPropertyNames() {
        return new String[]{"data"};
    }

    public Class[] getPropertyTypes() {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[[Ljava.lang.String;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        return classArray;
    }

    public Object getPropertyValue(String name) {
        if (name.equals("data")) {
            return ((StringArrayTreeModel)this.model).arr;
        }
        return null;
    }

    public String setPropertyValue(String name, Object value) {
        if (name.equals("data")) {
            this.setModel(new StringArrayTreeModel((String[][])value));
            return null;
        }
        return super.setPropertyValue(name, value);
    }

    public Tree(TreeModel model) {
        this.model = model;
        this.setLayout(new BoxLayout(2));
        this.buildBranch(null, 0, this);
        this.setScrollableY(true);
        this.setUIID("Tree");
    }

    public TreeModel getModel() {
        return this.model;
    }

    public void setModel(TreeModel model) {
        this.model = model;
        this.removeAll();
        this.buildBranch(null, 0, this);
    }

    public static void setFolderIcon(Image folderIcon) {
        folder = folderIcon;
    }

    public static void setFolderOpenIcon(Image folderIcon) {
        openFolder = folderIcon;
    }

    public static void setNodeIcon(Image nodeIcon) {
        nodeImage = nodeIcon;
    }

    private void expandNode(Component c) {
        c.putClientProperty(KEY_EXPANDED, "true");
        ((Button)c).setIcon(openFolder);
        int depth = (Integer)c.getClientProperty(KEY_DEPTH);
        Container parent = c.getParent();
        Object o = c.getClientProperty(KEY_OBJECT);
        Container dest = new Container(new BoxLayout(2));
        Label dummy = new Label();
        parent.addComponent("Center", (Component)dummy);
        this.buildBranch(o, depth, dest);
        parent.replace(dummy, dest, CommonTransitions.createSlide(1, true, 0));
    }

    private void collapseNode(Component c) {
        c.putClientProperty(KEY_EXPANDED, null);
        ((Button)c).setIcon(folder);
        Container p = c.getParent();
        int iter = 0;
        while (iter < p.getComponentCount()) {
            if (p.getComponentAt(iter) != c) {
                Label dummy = new Label();
                p.replaceAndWait(p.getComponentAt(iter), dummy, CommonTransitions.createSlide(1, false, 0));
                p.removeComponent(dummy);
            }
            ++iter;
        }
    }

    public Object getSelectedItem() {
        Component c = this.getComponentForm().getFocused();
        if (c != null) {
            return c.getClientProperty(KEY_OBJECT);
        }
        return null;
    }

    private void buildBranch(Object parent, int depth, Container destination) {
        Vector children = this.model.getChildren(parent);
        int size = children.size();
        Integer depthVal = new Integer(depth + 1);
        int iter = 0;
        while (iter < size) {
            Object current = children.elementAt(iter);
            Button nodeComponent = this.createNodeComponent(current, depth);
            if (this.model.isLeaf(current)) {
                destination.addComponent(nodeComponent);
                nodeComponent.addActionListener(new Handler(current));
            } else {
                Container componentArea = new Container(new BorderLayout());
                componentArea.addComponent("North", (Component)nodeComponent);
                destination.addComponent(componentArea);
                nodeComponent.addActionListener(this.expansionListener);
            }
            nodeComponent.putClientProperty(KEY_OBJECT, current);
            nodeComponent.putClientProperty(KEY_PARENT, parent);
            nodeComponent.putClientProperty(KEY_DEPTH, depthVal);
            ++iter;
        }
    }

    protected Button createNodeComponent(Object node, int depth) {
        Button cmp = new Button(this.childToDisplayLabel(node));
        cmp.setUIID("TreeNode");
        if (this.model.isLeaf(node)) {
            cmp.setIcon(nodeImage);
        } else {
            cmp.setIcon(folder);
        }
        this.updateNodeComponentStyle(cmp.getSelectedStyle(), depth);
        this.updateNodeComponentStyle(cmp.getUnselectedStyle(), depth);
        this.updateNodeComponentStyle(cmp.getPressedStyle(), depth);
        return cmp;
    }

    private void updateNodeComponentStyle(Style s, int depth) {
        s.setMargin(1, depth * this.depthIndent);
    }

    protected String childToDisplayLabel(Object child) {
        return child.toString();
    }

    public void addLeafListener(ActionListener l) {
        this.leafListener.addListener(l);
    }

    public void removeLeafListener(ActionListener l) {
        this.leafListener.removeListener(l);
    }

    protected Dimension calcPreferredSize() {
        Dimension d = super.calcPreferredSize();
        int count = this.getComponentCount();
        int iter = 0;
        while (iter < count) {
            if (this.getComponentAt(iter) instanceof Container) {
                return d;
            }
            ++iter;
        }
        int size = this.model.getChildren(null).size();
        if (size < 6) {
            return new Dimension(Math.max(d.getWidth(), Display.getInstance().getDisplayWidth() / 4 * 3), d.getHeight() / size * 6);
        }
        return d;
    }

    private class Handler
    implements ActionListener {
        private Object current;

        public Handler() {
        }

        public Handler(Object current) {
            this.current = current;
        }

        public void actionPerformed(ActionEvent evt) {
            if (this.current != null) {
                Tree.this.leafListener.fireActionEvent(new ActionEvent(this.current));
                return;
            }
            Component c = (Component)evt.getSource();
            Object e = c.getClientProperty(Tree.KEY_EXPANDED);
            if (e != null && e.equals("true")) {
                Tree.this.collapseNode(c);
            } else {
                Tree.this.expandNode(c);
            }
        }
    }

    static class StringArrayTreeModel
    implements TreeModel {
        String[][] arr;

        StringArrayTreeModel(String[][] arr) {
            this.arr = arr;
        }

        public Vector getChildren(Object parent) {
            if (parent == null) {
                Vector<String> v = new Vector<String>();
                int iter = 0;
                while (iter < this.arr[0].length) {
                    v.addElement(this.arr[0][iter]);
                    ++iter;
                }
                return v;
            }
            Vector<String> v = new Vector<String>();
            int iter = 0;
            while (iter < this.arr[0].length) {
                if (parent == this.arr[0][iter] && this.arr.length > iter + 1 && this.arr[iter + 1] != null) {
                    int i = 0;
                    while (i < this.arr[iter + 1].length) {
                        v.addElement(this.arr[iter + 1][i]);
                        ++i;
                    }
                }
                ++iter;
            }
            return v;
        }

        public boolean isLeaf(Object node) {
            return !node.equals("Root");
        }
    }
}

