/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.panels.request.views.html;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.support.panels.AbstractHttpXmlRequestDesktopPanel;
import com.eviware.soapui.impl.wsdl.monitor.JProxyServletWsdlMonitorMessageExchange;
import com.eviware.soapui.impl.wsdl.support.MessageExchangeModelItem;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.BrowserComponent;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.editor.inspectors.attachments.ContentTypeHandler;
import com.eviware.soapui.support.editor.views.AbstractXmlEditorView;
import com.eviware.soapui.support.editor.xml.XmlEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpHtmlMessageExchangeResponseView
extends AbstractXmlEditorView<AbstractHttpXmlRequestDesktopPanel.HttpResponseDocument>
implements PropertyChangeListener {
    private final MessageExchangeModelItem messageExchangeModelItem;
    private JPanel contentPanel;
    private JPanel panel;
    private JLabel statusLabel;
    private BrowserComponent browser;

    public HttpHtmlMessageExchangeResponseView(XmlEditor editor, MessageExchangeModelItem messageExchangeModelItem) {
        super("HTML", editor, "HTML Response");
        this.messageExchangeModelItem = messageExchangeModelItem;
        messageExchangeModelItem.addPropertyChangeListener(this);
    }

    @Override
    public JComponent getComponent() {
        if (this.panel == null) {
            this.panel = new JPanel(new BorderLayout());
            this.panel.add(this.buildToolbar(), "North");
            this.panel.add(this.buildContent(), "Center");
            this.panel.add(this.buildStatus(), "South");
        }
        return this.panel;
    }

    @Override
    public void release() {
        super.release();
        if (this.browser != null) {
            this.browser.release();
        }
        this.messageExchangeModelItem.removePropertyChangeListener(this);
    }

    private Component buildStatus() {
        this.statusLabel = new JLabel();
        this.statusLabel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        return this.statusLabel;
    }

    private Component buildContent() {
        this.contentPanel = new JPanel(new BorderLayout());
        if (SoapUI.isJXBrowserDisabled()) {
            this.contentPanel.add(new JLabel("Browser Component is disabled"));
        } else {
            this.browser = new BrowserComponent(false, false);
            Component component = this.browser.getComponent();
            component.setMinimumSize(new Dimension(100, 100));
            this.contentPanel.add(new JScrollPane(component));
            this.setEditorContent(this.messageExchangeModelItem);
        }
        return this.contentPanel;
    }

    protected void setEditorContent(JProxyServletWsdlMonitorMessageExchange jproxyServletWsdlMonitorMessageExchange) {
        if (jproxyServletWsdlMonitorMessageExchange != null) {
            String contentType = jproxyServletWsdlMonitorMessageExchange.getResponseContentType();
            if (contentType.contains("html") || contentType.contains("text")) {
                try {
                    String content = jproxyServletWsdlMonitorMessageExchange.getResponseContent();
                    this.browser.setContent(content, jproxyServletWsdlMonitorMessageExchange.getEndpoint());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (this.isSupportedContentType(contentType)) {
                try {
                    String ext = ContentTypeHandler.getExtensionForContentType(contentType);
                    File temp = File.createTempFile("response", "." + ext);
                    FileOutputStream fileOutputStream = new FileOutputStream(temp);
                    this.writeHttpBody(jproxyServletWsdlMonitorMessageExchange.getRawResponseData(), fileOutputStream);
                    fileOutputStream.close();
                    this.browser.navigate(temp.toURI().toURL().toString(), null);
                    temp.deleteOnExit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                this.browser.setContent("unsupported content-type [" + contentType + "]");
            }
        } else {
            this.browser.setContent("-missing content-");
        }
    }

    private boolean isSupportedContentType(String contentType) {
        return contentType.toLowerCase().contains("image");
    }

    protected void setEditorContent(MessageExchangeModelItem messageExchangeModelItem2) {
        if (messageExchangeModelItem2 != null && messageExchangeModelItem2.getMessageExchange() != null) {
            String contentType = messageExchangeModelItem2.getMessageExchange().getResponseHeaders().get("Content-Type", "");
            if (contentType.contains("html") || contentType.contains("text")) {
                try {
                    String content = messageExchangeModelItem2.getMessageExchange().getResponseContent();
                    this.browser.setContent(content);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (!contentType.contains("xml")) {
                try {
                    String ext = ContentTypeHandler.getExtensionForContentType(contentType);
                    File temp = File.createTempFile("response", "." + ext);
                    FileOutputStream fileOutputStream = new FileOutputStream(temp);
                    this.writeHttpBody(messageExchangeModelItem2.getMessageExchange().getRawResponseData(), fileOutputStream);
                    fileOutputStream.close();
                    this.browser.navigate(temp.toURI().toURL().toString(), null);
                    temp.deleteOnExit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            this.browser.setContent("<missing content>");
        }
    }

    private void writeHttpBody(byte[] rawResponse, FileOutputStream out) throws IOException {
        byte[] divider = "\r\n\r\n".getBytes();
        for (int index = 0; index < rawResponse.length - divider.length; ++index) {
            int i;
            for (i = 0; i < divider.length && rawResponse[index + i] == divider[i]; ++i) {
            }
            if (i != divider.length) continue;
            out.write(rawResponse, index + divider.length, rawResponse.length - (index + divider.length));
            return;
        }
        out.write(rawResponse);
    }

    private Component buildToolbar() {
        JXToolBar toolbar = UISupport.createToolbar();
        return toolbar;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("messageExchange") && this.browser != null && evt.getNewValue() != null) {
            this.setEditorContent((JProxyServletWsdlMonitorMessageExchange)evt.getNewValue());
        }
    }

    @Override
    public void setXml(String xml) {
    }

    @Override
    public boolean saveDocument(boolean validate) {
        return false;
    }

    @Override
    public void setEditable(boolean enabled) {
    }
}

