/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.support.http;

import com.eviware.soapui.impl.rest.panels.resource.RestParamsTable;
import com.eviware.soapui.impl.rest.panels.resource.RestParamsTableModel;
import com.eviware.soapui.impl.rest.support.RestParamProperty;
import com.eviware.soapui.impl.rest.support.RestParamsPropertyHolder;
import com.eviware.soapui.impl.support.AbstractHttpRequest;
import com.eviware.soapui.impl.support.http.HttpRequestInterface;
import com.eviware.soapui.impl.support.panels.AbstractHttpXmlRequestDesktopPanel;
import com.eviware.soapui.support.DocumentListenerAdapter;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.editor.views.AbstractXmlEditorView;
import com.eviware.soapui.support.propertyexpansion.PropertyExpansionPopupListener;
import com.eviware.soapui.support.xml.SyntaxEditorUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpRequestContentView
extends AbstractXmlEditorView<AbstractHttpXmlRequestDesktopPanel.HttpRequestDocument>
implements PropertyChangeListener {
    private final HttpRequestInterface<?> httpRequest;
    private JPanel contentPanel;
    private RSyntaxTextArea contentEditor;
    private boolean updatingRequest;
    private JComponent panel;
    private JComboBox mediaTypeCombo;
    private JSplitPane split;
    private RestParamsTable paramsTable;
    private JCheckBox postQueryCheckBox;

    public HttpRequestContentView(AbstractHttpXmlRequestDesktopPanel.HttpRequestMessageEditor httpRequestMessageEditor, HttpRequestInterface<?> httpRequest) {
        super("Request", httpRequestMessageEditor, "HTTP Content");
        this.httpRequest = httpRequest;
        httpRequest.addPropertyChangeListener(this);
    }

    @Override
    public JComponent getComponent() {
        if (this.panel == null) {
            this.buildComponent();
        }
        return this.panel;
    }

    protected void buildComponent() {
        JPanel p = new JPanel(new BorderLayout());
        p.add(this.buildToolbar(), "North");
        p.add(this.buildContent(), "Center");
        this.paramsTable = this.buildParamsTable();
        this.split = UISupport.createVerticalSplit(this.paramsTable, p);
        this.panel = new JPanel(new BorderLayout());
        this.panel.add(this.split);
        this.fixRequestPanel();
    }

    protected RestParamsTable buildParamsTable() {
        this.paramsTable = new RestParamsTable(this.httpRequest.getParams(), false){

            protected RestParamsTableModel createTableModel(RestParamsPropertyHolder params) {
                return new RestParamsTableModel(params){

                    public String getColumnName(int column) {
                        return column == 0 ? "Name" : "Value";
                    }

                    public int getColumnCount() {
                        return 2;
                    }

                    public Object getValueAt(int rowIndex, int columnIndex) {
                        RestParamProperty prop = this.params.getPropertyAt(rowIndex);
                        return columnIndex == 0 ? prop.getName() : prop.getValue();
                    }

                    public void setValueAt(Object value, int rowIndex, int columnIndex) {
                        RestParamProperty prop = this.params.getPropertyAt(rowIndex);
                        if (columnIndex == 0) {
                            prop.setName(value.toString());
                        } else {
                            prop.setValue(value.toString());
                        }
                    }
                };
            }
        };
        return this.paramsTable;
    }

    @Override
    public void release() {
        super.release();
        this.httpRequest.removePropertyChangeListener(this);
        this.paramsTable.release();
    }

    public HttpRequestInterface<?> getRestRequest() {
        return this.httpRequest;
    }

    protected Component buildContent() {
        this.contentPanel = new JPanel(new BorderLayout());
        this.contentEditor = SyntaxEditorUtil.createDefaultXmlSyntaxTextArea();
        this.contentEditor.setText(this.httpRequest.getRequestContent());
        this.contentEditor.getDocument().addDocumentListener(new DocumentListenerAdapter(){

            public void update(Document document) {
                if (!HttpRequestContentView.this.updatingRequest) {
                    HttpRequestContentView.this.updatingRequest = true;
                    HttpRequestContentView.this.httpRequest.setRequestContent(this.getText(document));
                    HttpRequestContentView.this.updatingRequest = false;
                }
            }
        });
        this.contentPanel.add(new JScrollPane((Component)this.contentEditor));
        PropertyExpansionPopupListener.enable(this.contentEditor, this.httpRequest);
        return this.contentPanel;
    }

    private void enableBodyComponents() {
        this.httpRequest.setPostQueryString(this.httpRequest.hasRequestBody() && this.httpRequest.isPostQueryString());
        this.postQueryCheckBox.setSelected(this.httpRequest.isPostQueryString());
        this.mediaTypeCombo.setEnabled(this.httpRequest.hasRequestBody() && !this.httpRequest.isPostQueryString());
        this.contentEditor.setEnabled(this.httpRequest.hasRequestBody() && !this.httpRequest.isPostQueryString());
        this.contentEditor.setEditable(this.httpRequest.hasRequestBody() && !this.httpRequest.isPostQueryString());
        this.postQueryCheckBox.setEnabled(this.httpRequest.hasRequestBody());
    }

    protected Component buildToolbar() {
        JXToolBar toolbar = UISupport.createToolbar();
        this.addMediaTypeCombo(toolbar);
        toolbar.addSeparator();
        this.addPostQueryCheckBox(toolbar);
        toolbar.setMinimumSize(new Dimension(50, 20));
        return toolbar;
    }

    protected void addPostQueryCheckBox(JXToolBar toolbar) {
        this.postQueryCheckBox = new JCheckBox("Post QueryString", this.httpRequest.isPostQueryString());
        this.postQueryCheckBox.setToolTipText("Controls if Query-parameters should be put in message body");
        this.postQueryCheckBox.setOpaque(false);
        this.postQueryCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                HttpRequestContentView.this.httpRequest.setPostQueryString(HttpRequestContentView.this.postQueryCheckBox.isSelected());
                HttpRequestContentView.this.enableBodyComponents();
            }
        });
        this.postQueryCheckBox.setPreferredSize(new Dimension(130, 20));
        toolbar.addFixed(this.postQueryCheckBox);
    }

    protected void addMediaTypeCombo(JXToolBar toolbar) {
        this.mediaTypeCombo = new JComboBox<Object>(this.getRequestMediaTypes());
        this.mediaTypeCombo.setPreferredSize(new Dimension(120, 20));
        this.mediaTypeCombo.setEnabled(this.httpRequest.hasRequestBody());
        this.mediaTypeCombo.setEditable(true);
        if (this.httpRequest.getMediaType() != null) {
            this.mediaTypeCombo.setSelectedItem(this.httpRequest.getMediaType());
        }
        this.mediaTypeCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                HttpRequestContentView.this.httpRequest.setMediaType(String.valueOf(HttpRequestContentView.this.mediaTypeCombo.getSelectedItem()));
            }
        });
        toolbar.addLabeledFixed("Media Type", this.mediaTypeCombo);
    }

    protected Object[] getRequestMediaTypes() {
        return new String[]{"application/xml", "text/xml", "multipart/form-data"};
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("request") && !this.updatingRequest) {
            this.updatingRequest = true;
            this.contentEditor.setText((String)evt.getNewValue());
            this.updatingRequest = false;
        } else if (evt.getPropertyName().equals("method")) {
            this.fixRequestPanel();
        } else if (evt.getPropertyName().equals("mediaType")) {
            this.mediaTypeCombo.setSelectedItem(evt.getNewValue());
        } else if (evt.getPropertyName().equals(AbstractHttpRequest.ATTACHMENTS_PROPERTY)) {
            this.mediaTypeCombo.setModel(new DefaultComboBoxModel<Object>(this.getRequestMediaTypes()));
            this.mediaTypeCombo.setSelectedItem(this.httpRequest.getMediaType());
        }
        super.propertyChange(evt);
    }

    private void fixRequestPanel() {
        if (this.httpRequest.hasRequestBody()) {
            this.panel.remove(this.paramsTable);
            this.split.setLeftComponent(this.paramsTable);
            this.panel.add(this.split);
            this.enableBodyComponents();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (HttpRequestContentView.this.panel.getHeight() == 0) {
                        SwingUtilities.invokeLater(this);
                    } else {
                        HttpRequestContentView.this.split.setDividerLocation(0.5);
                    }
                }
            });
        } else {
            this.panel.remove(this.split);
            this.panel.add(this.paramsTable);
        }
    }

    @Override
    public void setXml(String xml) {
    }

    @Override
    public boolean saveDocument(boolean validate) {
        return false;
    }

    @Override
    public void setEditable(boolean enabled) {
        this.contentEditor.setEnabled(enabled ? this.httpRequest.hasRequestBody() : false);
        this.contentEditor.setEditable(enabled ? this.httpRequest.hasRequestBody() : false);
        this.mediaTypeCombo.setEnabled(enabled && !this.httpRequest.isPostQueryString());
        this.postQueryCheckBox.setEnabled(enabled);
    }

    public RestParamsTable getParamsTable() {
        return this.paramsTable;
    }
}

