/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wadl.inference.schema.content;

import com.eviware.soapui.impl.wadl.inference.ConflictHandler;
import com.eviware.soapui.impl.wadl.inference.schema.Content;
import com.eviware.soapui.impl.wadl.inference.schema.Context;
import com.eviware.soapui.impl.wadl.inference.schema.Particle;
import com.eviware.soapui.impl.wadl.inference.schema.Schema;
import com.eviware.soapui.inferredSchema.ParticleConfig;
import com.eviware.soapui.inferredSchema.SequenceContentConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceContent
implements Content {
    private final Schema schema;
    private Map<QName, Particle> particles;
    private HashMap<QName, List<QName>> comesBefore;
    private boolean completed;

    public SequenceContent(Schema schema, boolean completed) {
        this.schema = schema;
        this.completed = completed;
        this.particles = new LinkedHashMap<QName, Particle>();
        this.comesBefore = new HashMap();
    }

    public SequenceContent(SequenceContentConfig xml, Schema schema) {
        this.schema = schema;
        this.completed = xml.getCompleted();
        this.particles = new LinkedHashMap<QName, Particle>();
        for (ParticleConfig particleXml : xml.getParticleList()) {
            Particle p = Particle.Factory.parse(particleXml, schema);
            this.particles.put(p.getName(), p);
        }
        this.comesBefore = new HashMap();
        for (SequenceContentConfig.ComesBefore item : xml.getComesBeforeList()) {
            ArrayList<QName> others = new ArrayList<QName>();
            for (QName item2 : item.getOtherList()) {
                others.add(item2);
            }
            this.comesBefore.put(item.getQname(), others);
        }
    }

    @Override
    public SequenceContentConfig save() {
        SequenceContentConfig xml = SequenceContentConfig.Factory.newInstance();
        xml.setCompleted(this.completed);
        ArrayList<ParticleConfig> particleList = new ArrayList<ParticleConfig>();
        for (Particle particle : this.particles.values()) {
            particleList.add(particle.save());
        }
        xml.setParticleArray(particleList.toArray(new ParticleConfig[0]));
        for (Map.Entry entry : this.comesBefore.entrySet()) {
            SequenceContentConfig.ComesBefore comesBeforeEntry = xml.addNewComesBefore();
            comesBeforeEntry.setQname((QName)entry.getKey());
            for (QName item : (List)entry.getValue()) {
                comesBeforeEntry.addOther(item);
            }
        }
        return xml;
    }

    @Override
    public Content validate(Context context) throws XmlException {
        XmlCursor cursor = context.getCursor();
        ArrayList<QName> orderSet = new ArrayList<QName>();
        ArrayList<QName> orderList = new ArrayList<QName>();
        if (!cursor.isEnd()) {
            QName qname;
            cursor.push();
            while ((qname = cursor.getName()) != null) {
                if (orderSet.contains(qname)) {
                    if (!((QName)orderSet.get(orderSet.size() - 1)).equals(qname)) {
                        cursor.pop();
                        throw new XmlException("Same element occurs multiple times in sequence!");
                    }
                } else {
                    orderSet.add(qname);
                }
                orderList.add(qname);
                if (cursor.toNextSibling()) continue;
            }
            cursor.pop();
        }
        if (this.validateOrder(context, orderSet) && this.validateOccurances(context, orderList)) {
            for (QName item : orderList) {
                cursor.push();
                this.particles.get(item).validate(context);
                cursor.pop();
                cursor.toNextSibling();
            }
        } else {
            throw new XmlException("Sequence validation");
        }
        this.completed = true;
        return this;
    }

    @Override
    public String toString(String attrs) {
        if (this.particles.size() == 0) {
            return attrs;
        }
        this.fixOrder();
        String type = this.isChoice() ? ":choice" : (this.isAll() ? ":all" : ":sequence");
        StringBuilder s = new StringBuilder("<" + this.schema.getPrefixForNamespace("http://www.w3.org/2001/XMLSchema") + type + ">");
        for (Particle item : this.particles.values()) {
            s.append(item);
        }
        s.append("</" + this.schema.getPrefixForNamespace("http://www.w3.org/2001/XMLSchema") + type + ">" + attrs);
        return s.toString();
    }

    private void fixOrder() {
        ArrayList<QName> order = new ArrayList<QName>();
        for (QName item : this.particles.keySet()) {
            int i = order.size();
            while (!this.canAppend(order.subList(0, i), item)) {
                --i;
            }
            order.add(i, item);
        }
        LinkedHashMap<QName, Particle> fixedParticles = new LinkedHashMap<QName, Particle>();
        for (QName item : order) {
            fixedParticles.put(item, this.particles.get(item));
        }
        this.particles = fixedParticles;
    }

    private boolean verifyOrder() {
        ArrayList<QName> order = new ArrayList<QName>();
        order.addAll(this.particles.keySet());
        for (int i = 1; i < this.particles.size(); ++i) {
            if (this.canAppend(order.subList(0, i), (QName)order.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean canAppend(List<QName> before, QName item) {
        for (QName item2 : before) {
            List<QName> list = this.comesBefore.get(item);
            if (list == null || !list.contains(item2)) continue;
            return false;
        }
        return true;
    }

    private boolean validateOccurances(Context context, List<QName> sequence) throws XmlException {
        HashMap<QName, Integer> seen = new HashMap<QName, Integer>();
        for (QName qName : this.particles.keySet()) {
            seen.put(qName, 0);
        }
        for (QName qName : sequence) {
            seen.put(qName, (Integer)seen.get(qName) + 1);
        }
        for (Map.Entry entry : seen.entrySet()) {
            Particle particle = this.particles.get(entry.getKey());
            if (Integer.parseInt(particle.getAttribute("minOccurs")) > (Integer)entry.getValue()) {
                if (context.getHandler().callback(ConflictHandler.Event.MODIFICATION, ConflictHandler.Type.ELEMENT, (QName)entry.getKey(), context.getPath(), "Element occurs less times than required.")) {
                    particle.setAttribute("minOccurs", ((Integer)entry.getValue()).toString());
                } else {
                    throw new XmlException("Element '" + ((QName)entry.getKey()).getLocalPart() + "' required at least minOccurs times!");
                }
            }
            if (particle.getAttribute("maxOccurs").equals("unbounded") || Integer.parseInt(particle.getAttribute("maxOccurs")) >= (Integer)entry.getValue()) continue;
            if (context.getHandler().callback(ConflictHandler.Event.MODIFICATION, ConflictHandler.Type.TYPE, new QName(this.schema.getNamespace(), context.getAttribute("typeName")), context.getPath(), "Element occurs more times than allowed.")) {
                particle.setAttribute("maxOccurs", ((Integer)entry.getValue()).toString());
                continue;
            }
            throw new XmlException("Element '" + ((QName)entry.getKey()).getLocalPart() + "' must not occur more than maxOccurs times!");
        }
        return true;
    }

    private boolean validateOrder(Context context, List<QName> sequence) {
        ArrayList<QName> seen = new ArrayList<QName>();
        HashMap comesBefore = (HashMap)this.comesBefore.clone();
        for (QName item : sequence) {
            if (!this.particles.containsKey(item)) {
                if (context.getHandler().callback(ConflictHandler.Event.CREATION, ConflictHandler.Type.ELEMENT, item, context.getPath() + "/" + item.getLocalPart(), "Element has undeclared child element.")) {
                    if (item.getNamespaceURI().equals(this.schema.getNamespace())) {
                        Particle element = Particle.Factory.newElementInstance(this.schema, item.getLocalPart());
                        if (this.completed) {
                            element.setAttribute("minOccurs", "0");
                        }
                        this.particles.put(item, element);
                    } else {
                        Particle ref;
                        Schema otherSchema = context.getSchemaSystem().getSchemaForNamespace(item.getNamespaceURI());
                        this.schema.putPrefixForNamespace(item.getPrefix(), item.getNamespaceURI());
                        if (otherSchema == null) {
                            otherSchema = context.getSchemaSystem().newSchema(item.getNamespaceURI());
                        }
                        if ((ref = otherSchema.getParticle(item.getLocalPart())) == null) {
                            ref = otherSchema.newElement(item.getLocalPart());
                        }
                        if (this.completed) {
                            ref.setAttribute("minOccurs", "0");
                        }
                        this.particles.put(item, Particle.Factory.newReferenceInstance(this.schema, ref));
                    }
                } else {
                    return false;
                }
            }
            if (comesBefore.containsKey(item)) {
                for (QName item2 : (List)comesBefore.get(item)) {
                    if (!seen.contains(item2)) continue;
                    return false;
                }
            } else {
                comesBefore.put(item, new ArrayList());
            }
            for (QName item2 : seen) {
                if (((List)comesBefore.get(item2)).contains(item)) continue;
                ((List)comesBefore.get(item2)).add(item);
            }
            seen.add(item);
        }
        this.comesBefore = comesBefore;
        return true;
    }

    private boolean isChoice() {
        for (Particle e : this.particles.values()) {
            if ("0".equals(e.getAttribute("minOccurs")) && "1".equals(e.getAttribute("maxOccurs")) && this.comesBefore.get(e.getName()).size() == 0) continue;
            return false;
        }
        return true;
    }

    private boolean isAll() {
        for (Particle e : this.particles.values()) {
            if (Integer.parseInt(e.getAttribute("maxOccurs")) <= 1) continue;
            return false;
        }
        return !this.verifyOrder();
    }
}

