/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.iface.tools.support;

import com.eviware.soapui.support.UISupport;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public abstract class ShowConfigFileAction
extends AbstractAction {
    private ContentDialog dialog;
    private final String title;
    private final String description;

    public ShowConfigFileAction(String title, String description) {
        super("Show Config");
        this.title = title;
        this.description = description;
    }

    public void actionPerformed(ActionEvent e) {
        if (this.dialog == null) {
            this.dialog = new ContentDialog(this.title, this.description);
        }
        this.dialog.showDialog();
    }

    protected abstract String getConfigFile();

    public class ContentDialog
    extends JDialog {
        private JTextArea contentArea;

        public ContentDialog(String title, String description) throws HeadlessException {
            super(UISupport.getMainFrame());
            this.setTitle(title);
            this.setModal(true);
            this.getContentPane().setLayout(new BorderLayout());
            JLabel label = new JLabel(description);
            label.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
            this.getContentPane().add((Component)label, "North");
            this.getContentPane().add(this.buildContent(), "Center");
            ButtonBarBuilder builder = ButtonBarBuilder.createLeftToRightBuilder();
            builder.addGlue();
            JButton closeButton = new JButton(new CloseAction());
            builder.addFixed((JComponent)closeButton);
            builder.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
            this.getContentPane().add((Component)builder.getPanel(), "South");
            this.pack();
            UISupport.initDialogActions(this, null, closeButton);
        }

        public void showDialog() {
            this.contentArea.setText(ShowConfigFileAction.this.getConfigFile());
            this.setVisible(true);
        }

        private Component buildContent() {
            this.contentArea = new JTextArea();
            this.contentArea.setEditable(false);
            this.contentArea.setBackground(Color.WHITE);
            JScrollPane scrollPane = new JScrollPane(this.contentArea);
            scrollPane.setPreferredSize(new Dimension(500, 300));
            return UISupport.wrapInEmptyPanel(scrollPane, BorderFactory.createEmptyBorder(10, 10, 10, 10));
        }

        private final class CloseAction
        extends AbstractAction {
            public CloseAction() {
                super("Close");
            }

            public void actionPerformed(ActionEvent e) {
                ContentDialog.this.setVisible(false);
            }
        }
    }
}

