/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.mockresponse;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.MockResponseStepConfig;
import com.eviware.soapui.config.TestStepConfig;
import com.eviware.soapui.impl.wsdl.actions.support.AbstractAddToTestCaseAction;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockResponse;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockService;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlMockResponseTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.registry.WsdlMockResponseStepFactory;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.ui.desktop.SoapUIDesktop;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;
import org.apache.xmlbeans.XmlObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddMockResponseToTestCaseAction
extends AbstractAddToTestCaseAction<WsdlMockResponse> {
    public static final String SOAPUI_ACTION_ID = "AddMockResponseToTestCaseAction";
    private XFormDialog dialog;

    public AddMockResponseToTestCaseAction() {
        super("Add to TestCase", "Adds this MockResponse to a TestCase");
    }

    @Override
    public void perform(WsdlMockResponse mockResponse, Object param) {
        WsdlMockService mockService = mockResponse.getMockOperation().getMockService();
        WsdlTestCase testCase = this.getTargetTestCase(mockService.getProject());
        if (testCase == null) {
            return;
        }
        this.addMockResponseToTestCase(mockResponse, testCase, -1);
    }

    public void addMockResponseToTestCase(WsdlMockResponse mockResponse, WsdlTestCase testCase, int index) {
        if (mockResponse.getMockOperation().getOperation() == null) {
            UISupport.showErrorMessage("Missing operation for this mock response");
            return;
        }
        WsdlMockService mockService = mockResponse.getMockOperation().getMockService();
        if (this.dialog == null) {
            this.dialog = ADialogBuilder.buildDialog(Form.class);
        }
        this.dialog.setValue("Name", mockResponse.getMockOperation().getName());
        this.dialog.setBooleanValue("Close MockResponse Window", true);
        this.dialog.setBooleanValue("Shows TestCase Editor", true);
        this.dialog.setIntValue("Port", mockService.getPort());
        this.dialog.setValue("Path", mockService.getPath());
        SoapUIDesktop desktop = SoapUI.getDesktop();
        this.dialog.getFormField("Close MockResponse Window").setEnabled(desktop != null && desktop.hasDesktopPanel(mockResponse));
        if (!this.dialog.show()) {
            return;
        }
        TestStepConfig config = WsdlMockResponseStepFactory.createConfig(mockResponse.getMockOperation().getOperation(), false);
        MockResponseStepConfig mockResponseStepConfig = (MockResponseStepConfig)config.getConfig();
        config.setName(this.dialog.getValue("Name"));
        mockResponseStepConfig.setPath(this.dialog.getValue("Path"));
        mockResponseStepConfig.setPort(this.dialog.getIntValue("Port", mockService.getPort()));
        mockResponse.beforeSave();
        mockResponseStepConfig.getResponse().set((XmlObject)mockResponse.getConfig());
        WsdlMockResponseTestStep testStep = (WsdlMockResponseTestStep)testCase.insertTestStep(config, -1);
        if (testStep == null) {
            return;
        }
        if (this.dialog.getBooleanValue("Add Schema Assertion")) {
            testStep.addAssertion("Schema Compliance");
        }
        UISupport.selectAndShow(testStep);
        if (this.dialog.getBooleanValue("Close MockResponse Window") && desktop != null) {
            desktop.closeDesktopPanel(mockResponse);
        }
        if (this.dialog.getBooleanValue("Shows TestCase Editor")) {
            UISupport.selectAndShow(testCase);
        }
    }

    @AForm(name="Add MockResponse to TestCase", description="Options for adding this MockResponse to a TestCase", helpUrl="http://www.soapui.org/userguide/functional/mockresponse.html", icon="/applications-system.png")
    private static interface Form {
        @AField(name="Name", description="Unique name of MockResponse Step")
        public static final String STEP_NAME = "Name";
        @AField(name="Path", description="Path to listen on")
        public static final String PATH = "Path";
        @AField(name="Port", description="Port to listen on", type=AField.AFieldType.INT)
        public static final String PORT = "Port";
        @AField(name="Add Schema Assertion", description="Adds SchemaCompliance Assertion for request", type=AField.AFieldType.BOOLEAN)
        public static final String ADD_SCHEMA_ASSERTION = "Add Schema Assertion";
        @AField(name="Close MockResponse Window", description="Closes the MockResponse editor if visible", type=AField.AFieldType.BOOLEAN)
        public static final String CLOSE_EDITOR = "Close MockResponse Window";
        @AField(name="Shows TestCase Editor", description="Shows the target steps TestCase editor", type=AField.AFieldType.BOOLEAN)
        public static final String SHOW_TESTCASE = "Shows TestCase Editor";
    }
}

