/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.mockservice;

import com.eviware.soapui.impl.support.AbstractInterface;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockOperation;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockResponse;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockService;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddNewMockOperationAction
extends AbstractSoapUIAction<WsdlMockService> {
    public static final String SOAPUI_ACTION_ID = "AddNewMockOperationAction";

    public AddNewMockOperationAction() {
        super("New MockOperation", "Creates a new MockOperation for this MockService");
    }

    @Override
    public void perform(WsdlMockService mockService, Object param) {
        ArrayList<OperationWrapper> operations = new ArrayList<OperationWrapper>();
        List<AbstractInterface<?>> interfaces = mockService.getProject().getInterfaces("wsdl");
        for (Interface interface_ : interfaces) {
            for (int i = 0; i < interface_.getOperationCount(); ++i) {
                if (mockService.hasMockOperation(interface_.getOperationAt(i))) continue;
                operations.add(new OperationWrapper((WsdlOperation)interface_.getOperationAt(i)));
            }
        }
        if (operations.isEmpty()) {
            UISupport.showErrorMessage("No unique operations to mock in project!");
            return;
        }
        Object result = UISupport.prompt("Select Operation to Mock", "New MockOperation", operations.toArray());
        if (result != null) {
            WsdlMockOperation wsdlMockOperation = mockService.addNewMockOperation(((OperationWrapper)result).getOperation());
            WsdlMockResponse mockResponse = wsdlMockOperation.addNewMockResponse("Response 1", true);
            UISupport.selectAndShow(mockResponse);
        }
    }

    public class OperationWrapper {
        private final WsdlOperation operation;

        public OperationWrapper(WsdlOperation operation) {
            this.operation = operation;
        }

        public WsdlOperation getOperation() {
            return this.operation;
        }

        public String toString() {
            return this.operation.getInterface().getName() + " - " + this.operation.getName();
        }
    }
}

