/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.project;

import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockService;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddNewMockServiceAction
extends AbstractSoapUIAction<WsdlProject> {
    public static final String SOAPUI_ACTION_ID = "AddNewMockServiceAction";

    public AddNewMockServiceAction() {
        super("New MockService", "Creates a new MockService in this project");
    }

    @Override
    public void perform(WsdlProject target, Object param) {
        this.createMockService(target);
    }

    public WsdlMockService createMockService(WsdlProject project) {
        String name = UISupport.prompt("Specify name of MockService", "New MockService", "MockService " + (project.getMockServiceCount() + 1));
        if (name == null) {
            return null;
        }
        while (project.getMockServiceByName(name.trim()) != null) {
            name = UISupport.prompt("Specify unique name of MockService", "Rename MockService", name);
        }
        WsdlMockService mockService = project.addNewMockService(name);
        UISupport.select(mockService);
        return mockService;
    }
}

