/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.project;

import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloseProjectAction
extends AbstractSoapUIAction<WsdlProject> {
    public static final String SOAPUI_ACTION_ID = "CloseProjectAction";

    public CloseProjectAction() {
        super("Close Project", "Closes this project");
    }

    @Override
    public void perform(WsdlProject project, Object param) {
        if (project.isRemote()) {
            if (UISupport.confirm("Close remote project? (changes will be lost)", this.getName())) {
                // empty if block
            }
            project.getWorkspace().closeProject(project);
        } else {
            Boolean retval = UISupport.confirmOrCancel("Save project [" + project.getName() + "] before closing?", "Close Project");
            if (retval == null) {
                return;
            }
            try {
                if (retval.booleanValue()) {
                    project.save();
                }
                project.getWorkspace().closeProject(project);
            }
            catch (IOException e) {
                UISupport.showErrorMessage(e);
            }
        }
    }
}

