/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.testcase;

import com.eviware.soapui.impl.wsdl.actions.project.StartLoadUI;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.integration.loadui.IntegrationUtils;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormField;
import com.eviware.x.form.XFormFieldListener;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;
import java.io.IOException;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunTestCaseWithLoadUIAction
extends AbstractSoapUIAction<WsdlTestCase> {
    private static final String EMPTY_OPTION = "-";
    private XFormDialog dialog;
    public static final String SOAPUI_ACTION_ID = "RunTestCaseWithLoadUIAction";

    public RunTestCaseWithLoadUIAction() {
        super("Run with loadUI", "Run this TestCase with loadUI");
    }

    @Override
    public void perform(WsdlTestCase testCase, Object param) {
        if (IntegrationUtils.forceSaveProject(testCase.getTestSuite().getProject())) {
            if (!StartLoadUI.testCajoConnection()) {
                if (UISupport.confirm("For this action you have to launch loadUI. Launch it now?", "Launch loadUI")) {
                    StartLoadUI.launchLoadUI();
                }
                return;
            }
            String soapUITestCase = testCase.getName();
            String soapUITestSuite = testCase.getTestSuite().getName();
            String soapUIProjectPath = testCase.getTestSuite().getProject().getPath();
            String generatorType = EMPTY_OPTION;
            String analisysType = EMPTY_OPTION;
            if (this.dialog == null) {
                this.dialog = ADialogBuilder.buildDialog(Form.class);
            }
            this.dialog.getFormField("Target Project").addFormFieldListener(new XFormFieldListener(){

                public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                    RunTestCaseWithLoadUIAction.this.dialog.setOptions("Target TestCase", IntegrationUtils.getAvailableTestCases(newValue));
                    if (RunTestCaseWithLoadUIAction.this.dialog.getValue("Target TestCase").equals("<Project Level>")) {
                        RunTestCaseWithLoadUIAction.this.dialog.setOptions("Target SoapUI Runner", IntegrationUtils.getAvailableRunners(newValue, "<Project Level>"));
                    }
                }
            });
            this.dialog.getFormField("Target TestCase").addFormFieldListener(new XFormFieldListener(){

                public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                    if (newValue.equals("<Create New>")) {
                        RunTestCaseWithLoadUIAction.this.dialog.setOptions("Target SoapUI Runner", new String[]{"<Create New>"});
                    } else {
                        RunTestCaseWithLoadUIAction.this.dialog.setOptions("Target SoapUI Runner", IntegrationUtils.getAvailableRunners(RunTestCaseWithLoadUIAction.this.dialog.getValue("Target Project"), newValue));
                    }
                }
            });
            this.dialog.setOptions("Target Project", IntegrationUtils.getAvailableProjects());
            if (!StringUtils.isNullOrEmpty(IntegrationUtils.getOpenedProjectName())) {
                this.dialog.setValue("Target Project", IntegrationUtils.getOpenedProjectName());
            } else {
                this.dialog.setValue("Target Project", "<Create New>");
            }
            this.dialog.setOptions("Target TestCase", IntegrationUtils.getAvailableTestCases(this.dialog.getValue("Target Project")));
            if (!this.dialog.getValue("Target Project").equals(IntegrationUtils.getOpenedProjectName())) {
                this.dialog.setValue("Target TestCase", "<Project Level>");
            }
            this.dialog.setOptions("Target SoapUI Runner", IntegrationUtils.getAvailableRunners(this.dialog.getValue("Target Project"), this.dialog.getValue("Target TestCase")));
            this.dialog.setValue("Target SoapUI Runner", "<Create New>");
            this.dialog.setOptions("Default Generator", new String[]{EMPTY_OPTION, "Fixed Rate", "Variance", "Random", "Ramp", "Virtual Users", "Fixed Load"});
            this.dialog.setValue("Default Generator", EMPTY_OPTION);
            this.dialog.setOptions("Default Statistics", new String[]{EMPTY_OPTION, "Statistics"});
            this.dialog.setValue("Default Statistics", EMPTY_OPTION);
            if (this.dialog.show()) {
                String targetProjectString = this.dialog.getValue("Target Project");
                String targetTestCaseName = !this.dialog.getValue("Target TestCase").equals("<Project Level>") ? this.dialog.getValue("Target TestCase") : null;
                String targetSoapUIRunnerName = this.dialog.getValue("Target SoapUI Runner");
                generatorType = this.dialog.getValue("Default Generator");
                analisysType = this.dialog.getValue("Default Statistics");
                if (this.dialog.getReturnValue() == 1) {
                    String openedProjectName = IntegrationUtils.getOpenedProjectName();
                    if (!StringUtils.isNullOrEmpty(openedProjectName) && !targetProjectString.equals(openedProjectName) && IntegrationUtils.checkOpenedLoadUIProjectForClose()) {
                        return;
                    }
                    HashMap<String, String> createdRunnerSettings = null;
                    try {
                        createdRunnerSettings = IntegrationUtils.createSoapUIRunner(soapUIProjectPath, soapUITestSuite, soapUITestCase, targetProjectString, targetTestCaseName, targetSoapUIRunnerName, generatorType, analisysType);
                    }
                    catch (IOException e) {
                        UISupport.showInfoMessage("Error while opening selected loadUI project");
                        return;
                    }
                }
            }
        }
    }

    @AForm(description="Specify Items in loadUI for Running TestCase", name="Run With loadUI", helpUrl="http://www.soapui.org/userguide/functional/testcases.html#Clone_TestCase", icon="/runWithLoadui.png")
    protected static interface Form {
        @AField(name="Target Project", description="The target Project in loadUI", type=AField.AFieldType.ENUMERATION)
        public static final String PROJECT = "Target Project";
        @AField(name="Target TestCase", description="The name of the target TestCase in loadUI", type=AField.AFieldType.ENUMERATION)
        public static final String TESTCASE = "Target TestCase";
        @AField(name="Target SoapUI Runner", description="The target SoapUI Runner in loadUI", type=AField.AFieldType.ENUMERATION)
        public static final String SOAPUIRUNNER = "Target SoapUI Runner";
        @AField(name="Default Generator", description="Choose generator type in loadUI", type=AField.AFieldType.ENUMERATION)
        public static final String GENERATOR = "Default Generator";
        @AField(name="Default Statistics", description="Choose Statistics in loadUI", type=AField.AFieldType.ENUMERATION)
        public static final String STATISTICS = "Default Statistics";
    }
}

