/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.testsuite;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.HttpRequestConfig;
import com.eviware.soapui.config.TestStepConfig;
import com.eviware.soapui.impl.rest.panels.request.views.html.HttpHtmlResponseView;
import com.eviware.soapui.impl.support.HttpUtils;
import com.eviware.soapui.impl.wsdl.WsdlSubmit;
import com.eviware.soapui.impl.wsdl.WsdlTestSuite;
import com.eviware.soapui.impl.wsdl.panels.teststeps.HttpTestRequestDesktopPanel;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestRunContext;
import com.eviware.soapui.impl.wsdl.teststeps.HttpTestRequest;
import com.eviware.soapui.impl.wsdl.teststeps.HttpTestRequestStep;
import com.eviware.soapui.model.iface.Submit;
import com.eviware.soapui.support.MessageSupport;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;
import com.sun.java.xml.ns.j2Ee.HttpMethodType;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateWebTestCaseAction
extends AbstractSoapUIAction<WsdlTestSuite> {
    public static final String SOAPUI_ACTION_ID = "CreateWebTestCaseAction";
    private WsdlTestSuite testSuite;
    public static final MessageSupport messages = MessageSupport.getMessages(CreateWebTestCaseAction.class);
    private XFormDialog dialog;
    HttpTestRequestDesktopPanel desktopPanel;
    private static final Logger logger = Logger.getLogger(CreateWebTestCaseAction.class);

    public CreateWebTestCaseAction() {
        super("New Web TestCase", "Creates a new Web TestCase in this TestSuite");
    }

    @Override
    public void perform(WsdlTestSuite target, Object param) {
        this.testSuite = target;
        if (this.dialog == null) {
            this.dialog = ADialogBuilder.buildDialog(Form.class);
        }
        this.dialog.setValue("Web TestCase Name", "Web TestCase");
        this.dialog.setValue("Web Address", "");
        this.dialog.setValue("Start Recording immediately", Boolean.toString(true));
        if (this.dialog.show()) {
            String targetTestCaseName = this.dialog.getValue("Web TestCase Name");
            while (StringUtils.isNullOrEmpty(this.dialog.getValue("Web Address"))) {
                UISupport.showErrorMessage("You must specify the web address to start at");
                this.dialog.show();
            }
            String testStepName = this.dialog.getValue("Web Address");
            String url = HttpUtils.ensureEndpointStartsWithProtocol(testStepName);
            WsdlTestCase targetTestCase = null;
            targetTestCase = this.testSuite.getTestCaseByName(targetTestCaseName);
            if (targetTestCase == null) {
                while (this.testSuite.getTestCaseByName(targetTestCaseName) != null) {
                    targetTestCaseName = UISupport.prompt("TestCase name must be unique, please specify new name for TestCase\n[" + targetTestCaseName + "] in TestSuite [" + this.testSuite.getName() + "->" + this.testSuite.getName() + "]", "Change TestCase name", targetTestCaseName);
                    if (targetTestCaseName != null) continue;
                    return;
                }
                targetTestCase = this.testSuite.addNewTestCase(targetTestCaseName);
            }
            while (testStepName == null || targetTestCase.getTestStepByName(testStepName) != null) {
                testStepName = UISupport.prompt("TestStep name must be unique, please specify new name for step\n[" + testStepName + "] in TestCase [" + this.testSuite.getName() + "->" + this.testSuite.getName() + "->" + targetTestCaseName + "]", "Change TestStep name", testStepName);
                if (testStepName != null) continue;
                return;
            }
            this.createWebTest(targetTestCase, HttpUtils.ensureEndpointStartsWithProtocol(url), testStepName, this.dialog.getBooleanValue("Start Recording immediately"));
        }
    }

    public void createWebTest(WsdlTestCase targetTestCase, String endpoint, String name, boolean startRecording) {
        targetTestCase.setKeepSession(true);
        HttpRequestConfig httpRequest = HttpRequestConfig.Factory.newInstance();
        httpRequest.setMethod(HttpMethodType.GET.toString());
        httpRequest.setEndpoint(endpoint);
        TestStepConfig testStepConfig = TestStepConfig.Factory.newInstance();
        testStepConfig.setType("httprequest");
        testStepConfig.setConfig(httpRequest);
        testStepConfig.setName(name);
        HttpTestRequestStep testStep = (HttpTestRequestStep)targetTestCase.addTestStep(testStepConfig);
        this.desktopPanel = (HttpTestRequestDesktopPanel)UISupport.selectAndShow(testStep);
        HttpTestRequest testRequest = null;
        try {
            testRequest = testStep.getTestRequest();
            Submit submitRequest = testRequest.submit(new WsdlTestRunContext(testStep), true);
            if (startRecording) {
                ((WsdlSubmit)submitRequest).waitUntilFinished();
                HttpHtmlResponseView htmlResponseView = (HttpHtmlResponseView)this.desktopPanel.getResponseEditor().getViews().get(2);
                htmlResponseView.setRecordHttpTrafic(true);
            }
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
        this.desktopPanel.focusResponseInTabbedView(true);
    }

    @AForm(description="Specify Web TestCase Options", name="Add Web TestCase", helpUrl="http://www.soapui.org/userguide/functional/testsuites.html", icon="/applications-system.png")
    public static interface Form {
        @AField(name="Web Address", description="The web address to start at", type=AField.AFieldType.STRING)
        public static final String URL = "Web Address";
        @AField(name="Web TestCase Name", description="The Web TestCase name", type=AField.AFieldType.STRING)
        public static final String TESTCASENAME = "Web TestCase Name";
        @AField(description="", type=AField.AFieldType.BOOLEAN, enabled=true)
        public static final String STARTRECORDING = "Start Recording immediately";
    }
}

