/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.mock;

import com.eviware.soapui.impl.wsdl.mock.WsdlMockOperation;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockRequest;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockResponse;
import com.eviware.soapui.impl.wsdl.panels.mockoperation.WsdlMockResultMessageExchange;
import com.eviware.soapui.impl.wsdl.teststeps.actions.ShowMessageExchangeAction;
import com.eviware.soapui.model.mock.MockResult;
import com.eviware.soapui.support.DateUtil;
import com.eviware.soapui.support.action.swing.ActionList;
import com.eviware.soapui.support.action.swing.DefaultActionList;
import com.eviware.soapui.support.types.StringToStringsMap;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import org.mortbay.jetty.HttpFields;
import org.mortbay.jetty.Response;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlMockResult
implements MockResult {
    private WsdlMockResponse mockResponse;
    private String responseContent;
    private long timeTaken;
    private long timestamp;
    private DefaultActionList actions;
    private StringToStringsMap responseHeaders = new StringToStringsMap();
    private WsdlMockRequest mockRequest;
    private byte[] rawResponseData;
    private WsdlMockOperation mockOperation;
    private String responseContentType;
    private int responseStatus = 200;

    public WsdlMockResult(WsdlMockRequest request) throws Exception {
        this.timestamp = System.currentTimeMillis();
        this.mockRequest = request;
    }

    @Override
    public WsdlMockRequest getMockRequest() {
        return this.mockRequest;
    }

    @Override
    public ActionList getActions() {
        if (this.actions == null) {
            this.actions = new DefaultActionList("MockResult");
            this.actions.setDefaultAction(new ShowMessageExchangeAction(new WsdlMockResultMessageExchange(this, this.mockResponse), "MockResult"));
        }
        return this.actions;
    }

    @Override
    public WsdlMockResponse getMockResponse() {
        return this.mockResponse;
    }

    @Override
    public String getResponseContent() {
        return this.responseContent;
    }

    @Override
    public long getTimeTaken() {
        return this.timeTaken;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setTimeTaken(long timeTaken) {
        this.timeTaken = timeTaken;
    }

    @Override
    public StringToStringsMap getResponseHeaders() {
        return this.responseHeaders;
    }

    public void setMockResponse(WsdlMockResponse mockResponse) {
        this.mockResponse = mockResponse;
        this.mockRequest.getRequestContext().setMockResponse(mockResponse);
    }

    public void setReponseContent(String responseContent) {
        this.responseContent = responseContent;
    }

    public void setResponseContent(String responseContent) {
        this.responseContent = responseContent;
    }

    @Override
    public void finish() {
        if (this.mockRequest.getHttpResponse() instanceof Response) {
            HttpFields httpFields = ((Response)this.mockRequest.getHttpResponse()).getHttpFields();
            Enumeration e = httpFields.getFieldNames();
            while (e.hasMoreElements()) {
                String nextElement = (String)e.nextElement();
                this.responseHeaders.add(nextElement, httpFields.getStringField(nextElement));
            }
        }
    }

    public void addHeader(String name, String value) {
        if (this.mockRequest.getHttpResponse() != null) {
            this.mockRequest.getHttpResponse().addHeader(name, value);
        }
        this.responseHeaders.add(name, value);
    }

    public boolean isCommitted() {
        return this.mockRequest.getHttpResponse().isCommitted();
    }

    public void setContentType(String contentType) {
        this.mockRequest.getHttpResponse().setContentType(contentType);
        this.responseContentType = contentType;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.mockRequest.getHttpResponse().getOutputStream();
    }

    public void initResponse() {
        this.mockRequest.getHttpResponse().setStatus(200);
        this.responseStatus = 200;
    }

    public boolean isDiscarded() {
        return false;
    }

    public Vector<?> getRequestWssResult() {
        return this.mockRequest.getWssResult();
    }

    public byte[] getRawResponseData() {
        return this.rawResponseData;
    }

    public void setRawResponseData(byte[] rawResponseData) {
        this.rawResponseData = rawResponseData;
    }

    public void writeRawResponseData(byte[] bs) throws IOException {
        this.getOutputStream().write(bs);
        this.setRawResponseData(bs);
    }

    public void setMockOperation(WsdlMockOperation mockOperation) {
        this.mockOperation = mockOperation;
    }

    @Override
    public WsdlMockOperation getMockOperation() {
        if (this.mockOperation != null) {
            return this.mockOperation;
        }
        return this.mockResponse == null ? null : this.mockResponse.getMockOperation();
    }

    public String getResponseContentType() {
        return this.responseContentType;
    }

    public int getResponseStatus() {
        return this.responseStatus;
    }

    public void setResponseStatus(int responseStatus) {
        this.responseStatus = responseStatus;
    }

    public void setResponseContentType(String responseContentType) {
        this.responseContentType = responseContentType;
    }

    public String toString() {
        StringBuilder msg = new StringBuilder(DateUtil.formatExtraFull(new Date(this.getTimestamp())));
        WsdlMockResponse mockResponse = this.getMockResponse();
        if (mockResponse == null) {
            msg.append(": [dispatch error; missing response]");
        } else {
            try {
                msg.append(": [" + mockResponse.getMockOperation().getName());
            }
            catch (Throwable e) {
                msg.append(": [removed operation?]");
            }
            msg.append("] " + this.getTimeTaken() + "ms");
        }
        return msg.toString();
    }
}

