/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.loadtest;

import com.eviware.soapui.impl.wsdl.loadtest.LoadTestAssertion;
import com.eviware.soapui.impl.wsdl.loadtest.data.actions.ExportLoadTestLogAction;
import com.eviware.soapui.impl.wsdl.loadtest.log.LoadTestLog;
import com.eviware.soapui.impl.wsdl.loadtest.log.LoadTestLogEntry;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.support.DateUtil;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.swing.ActionList;
import com.eviware.soapui.support.action.swing.ActionSupport;
import com.eviware.soapui.support.components.JXToolBar;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.Filter;
import org.jdesktop.swingx.decorator.FilterPipeline;
import org.jdesktop.swingx.decorator.PatternFilter;
import org.jdesktop.swingx.decorator.SortOrder;

public class JLoadTestLogTable
extends JPanel {
    private final LoadTestLog loadTestLog;
    private JXTable logTable;
    private PatternFilter stepFilter;
    private PatternFilter typeFilter;
    private JComboBox typesFilterComboBox;
    private JComboBox stepsFilterComboBox;
    private JButton clearErrorsButton;
    private JLabel rowCountLabel;
    private JPopupMenu popup;
    private LoadTestLogTableModel logTableModel;
    private JButton exportButton;
    private LogTableModelListener logTableModelListener;

    public JLoadTestLogTable(LoadTestLog log) {
        super(new BorderLayout());
        this.loadTestLog = log;
        this.logTableModel = new LoadTestLogTableModel();
        this.logTable = new JXTable((TableModel)this.logTableModel);
        this.logTable.setHorizontalScrollEnabled(true);
        this.logTable.setColumnControlVisible(true);
        this.logTable.addMouseListener((MouseListener)new LoadTestLogTableMouseListener());
        TableColumnModel columnModel = this.logTable.getColumnModel();
        columnModel.getColumn(0).setMaxWidth(5);
        columnModel.getColumn(0).setCellRenderer(new IconTableCellRenderer());
        columnModel.getColumn(1).setPreferredWidth(120);
        columnModel.getColumn(1).setCellRenderer(new TimestampTableCellRenderer());
        columnModel.getColumn(2).setPreferredWidth(110);
        columnModel.getColumn(3).setPreferredWidth(110);
        columnModel.getColumn(4).setPreferredWidth(250);
        this.typeFilter = new PatternFilter(".*", 0, 2);
        this.typeFilter.setAcceptNull(true);
        this.stepFilter = new PatternFilter(".*", 0, 3);
        this.stepFilter.setAcceptNull(true);
        Filter[] filters = new Filter[]{this.typeFilter, this.stepFilter};
        FilterPipeline pipeline = new FilterPipeline(filters);
        this.logTable.setFilters(pipeline);
        JScrollPane scrollPane = new JScrollPane((Component)this.logTable);
        this.add((Component)scrollPane, "Center");
        this.add((Component)this.buildToolbar(), "North");
        this.add((Component)this.buildStatus(), "South");
        this.logTableModelListener = new LogTableModelListener();
        this.logTable.getModel().addTableModelListener(this.logTableModelListener);
        this.logTable.setSortOrder(1, SortOrder.ASCENDING);
    }

    public void addNotify() {
        super.addNotify();
        if (this.logTableModelListener != null) {
            this.logTableModel.addTableModelListener(this.logTableModelListener);
        }
        this.loadTestLog.addListDataListener(this.logTableModel);
    }

    public void removeNotify() {
        super.removeNotify();
        this.logTableModel.removeTableModelListener(this.logTableModelListener);
        this.loadTestLog.removeListDataListener(this.logTableModel);
    }

    private JComponent buildStatus() {
        ButtonBarBuilder builder = new ButtonBarBuilder();
        this.rowCountLabel = new JLabel("0 entries");
        builder.addFixed((JComponent)this.rowCountLabel);
        builder.addGlue();
        builder.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        return builder.getPanel();
    }

    protected void updateRowCountLabel() {
        int c = this.logTableModel.getRowCount();
        this.rowCountLabel.setText(c == 1 ? "1 entry" : c + " entries");
    }

    private JComponent buildToolbar() {
        JXToolBar toolbar = UISupport.createToolbar();
        this.clearErrorsButton = UISupport.createToolbarButton(new ClearErrorsAction());
        this.exportButton = UISupport.createToolbarButton(new ExportLoadTestLogAction(this.loadTestLog, this.logTable));
        toolbar.add(this.clearErrorsButton);
        toolbar.add(this.exportButton);
        toolbar.addGlue();
        ArrayList<String> steps = new ArrayList<String>();
        steps.add("- All -");
        steps.add("Message");
        for (LoadTestAssertion assertion : this.loadTestLog.getLoadTest().getAssertionList()) {
            steps.add(assertion.getName());
        }
        toolbar.add(new JLabel("Show Types:"));
        toolbar.addSeparator();
        this.typesFilterComboBox = new JComboBox<Object>(steps.toArray());
        this.typesFilterComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                int ix = JLoadTestLogTable.this.typesFilterComboBox.getSelectedIndex();
                if (ix == -1) {
                    return;
                }
                JLoadTestLogTable.this.typeFilter.setAcceptNull(ix == 0);
                if (ix == 0) {
                    JLoadTestLogTable.this.typeFilter.setPattern(".*", 0);
                } else {
                    JLoadTestLogTable.this.typeFilter.setPattern(JLoadTestLogTable.this.typesFilterComboBox.getSelectedItem().toString(), 0);
                }
                JLoadTestLogTable.this.updateRowCountLabel();
            }
        });
        toolbar.add(this.typesFilterComboBox);
        toolbar.addSeparator();
        ArrayList<String> types = new ArrayList<String>();
        types.add("- All -");
        for (TestStep testStep : this.loadTestLog.getLoadTest().getTestCase().getTestStepList()) {
            types.add(testStep.getName());
        }
        toolbar.addFixed(new JLabel("Show Steps:"));
        toolbar.addSeparator();
        this.stepsFilterComboBox = new JComboBox<Object>(types.toArray());
        this.stepsFilterComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                int ix = JLoadTestLogTable.this.stepsFilterComboBox.getSelectedIndex();
                if (ix == -1) {
                    return;
                }
                JLoadTestLogTable.this.stepFilter.setAcceptNull(ix == 0);
                if (ix == 0) {
                    JLoadTestLogTable.this.stepFilter.setPattern(".*", 0);
                } else {
                    JLoadTestLogTable.this.stepFilter.setPattern(JLoadTestLogTable.this.stepsFilterComboBox.getSelectedItem().toString(), 0);
                }
                JLoadTestLogTable.this.updateRowCountLabel();
            }
        });
        toolbar.addFixed(this.stepsFilterComboBox);
        return toolbar;
    }

    public void showPopup(MouseEvent e) {
        int row;
        int selectedRow = this.logTable.rowAtPoint(e.getPoint());
        if (selectedRow == -1) {
            return;
        }
        if (this.logTable.getSelectedRow() != selectedRow) {
            this.logTable.getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
        }
        if ((row = this.logTable.convertRowIndexToModel(selectedRow)) < 0) {
            return;
        }
        LoadTestLogEntry entry = (LoadTestLogEntry)this.loadTestLog.getElementAt(row);
        ActionList actions = entry.getActions();
        if (actions == null || actions.getActionCount() == 0) {
            return;
        }
        JPopupMenu popup = ActionSupport.buildPopup(actions);
        popup.setInvoker((Component)this.logTable);
        popup.setLocation((int)(this.logTable.getLocationOnScreen().getX() + e.getPoint().getX()), (int)(this.logTable.getLocationOnScreen().getY() + e.getPoint().getY()));
        popup.setVisible(true);
    }

    private final class LoadTestLogTableMouseListener
    extends MouseAdapter {
        private LoadTestLogTableMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() > 1) {
                int selectedRow = JLoadTestLogTable.this.logTable.getSelectedRow();
                if (selectedRow < 0) {
                    return;
                }
                int row = JLoadTestLogTable.this.logTable.convertRowIndexToModel(selectedRow);
                if (row < 0) {
                    return;
                }
                LoadTestLogEntry entry = (LoadTestLogEntry)JLoadTestLogTable.this.loadTestLog.getElementAt(row);
                ActionList actions = entry.getActions();
                if (actions != null) {
                    actions.performDefaultAction(new ActionEvent(JLoadTestLogTable.this.logTable, 0, null));
                }
            }
        }

        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                JLoadTestLogTable.this.showPopup(e);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                JLoadTestLogTable.this.showPopup(e);
            }
        }
    }

    public class ClearErrorsAction
    extends AbstractAction {
        public ClearErrorsAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/clear_errors.gif"));
            this.putValue("ShortDescription", "Removes all errors from the LoadTest log");
        }

        public void actionPerformed(ActionEvent e) {
            JLoadTestLogTable.this.loadTestLog.clearErrors();
        }
    }

    private static final class TimestampTableCellRenderer
    extends DefaultTableCellRenderer {
        private TimestampTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value != null) {
                this.setText(DateUtil.formatExtraFull(new Date((Long)value)));
            }
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            return this;
        }
    }

    private static final class IconTableCellRenderer
    extends DefaultTableCellRenderer {
        private IconTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value != null) {
                this.setIcon((Icon)value);
            }
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LoadTestLogTableModel
    extends AbstractTableModel
    implements ListDataListener {
        @Override
        public int getRowCount() {
            return JLoadTestLogTable.this.loadTestLog.getSize();
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ImageIcon.class;
                }
                case 1: {
                    return Date.class;
                }
            }
            return String.class;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return " ";
                }
                case 1: {
                    return "time";
                }
                case 2: {
                    return "type";
                }
                case 3: {
                    return "step";
                }
                case 4: {
                    return "message";
                }
            }
            return null;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex == -1) {
                return null;
            }
            LoadTestLogEntry entry = (LoadTestLogEntry)JLoadTestLogTable.this.loadTestLog.getElementAt(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return entry.getIcon();
                }
                case 1: {
                    return entry.getTimeStamp();
                }
                case 2: {
                    return entry.getType();
                }
                case 3: {
                    return entry.getTargetStepName();
                }
                case 4: {
                    return entry.getMessage();
                }
            }
            return null;
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            this.fireTableRowsInserted(e.getIndex0(), e.getIndex1());
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            this.fireTableRowsDeleted(e.getIndex0(), e.getIndex1());
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            this.fireTableDataChanged();
        }
    }

    private final class LogTableModelListener
    implements TableModelListener {
        private LogTableModelListener() {
        }

        public void tableChanged(TableModelEvent e) {
            JLoadTestLogTable.this.updateRowCountLabel();
        }
    }
}

