/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.support;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.model.support.TestRunListenerAdapter;
import com.eviware.soapui.model.testsuite.LoadTestRunner;
import com.eviware.soapui.model.testsuite.TestCaseRunContext;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestRunner;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestStepResult;
import com.eviware.soapui.monitor.support.TestMonitorListenerAdapter;
import com.eviware.soapui.security.SecurityTestRunner;
import java.awt.Color;
import javax.swing.JProgressBar;

public class ProgressBarTestCaseAdapter {
    private final JProgressBar progressBar;
    private final WsdlTestCase testCase;
    private InternalTestRunListener internalTestRunListener;
    private InternalTestMonitorListener internalTestMonitorListener;

    public ProgressBarTestCaseAdapter(JProgressBar progressBar, WsdlTestCase testCase) {
        this.progressBar = progressBar;
        this.testCase = testCase;
        this.setLoadTestingState();
        this.setSecurityTestingState();
        this.internalTestRunListener = new InternalTestRunListener();
        testCase.addTestRunListener(this.internalTestRunListener);
        this.internalTestMonitorListener = new InternalTestMonitorListener();
        SoapUI.getTestMonitor().addTestMonitorListener(this.internalTestMonitorListener);
    }

    public void release() {
        this.testCase.removeTestRunListener(this.internalTestRunListener);
        SoapUI.getTestMonitor().removeTestMonitorListener(this.internalTestMonitorListener);
    }

    private void setLoadTestingState() {
        if (SoapUI.getTestMonitor().hasRunningLoadTest(this.testCase)) {
            this.progressBar.setIndeterminate(true);
            this.progressBar.setString("load testing");
        } else {
            this.progressBar.setIndeterminate(false);
            this.progressBar.setString("");
        }
    }

    private void setSecurityTestingState() {
        if (SoapUI.getTestMonitor().hasRunningSecurityTest(this.testCase)) {
            this.progressBar.setIndeterminate(true);
            this.progressBar.setString("security testing");
        } else {
            this.progressBar.setIndeterminate(false);
            this.progressBar.setString("");
        }
    }

    public class InternalTestRunListener
    extends TestRunListenerAdapter {
        public void beforeRun(TestCaseRunner testRunner, TestCaseRunContext runContext) {
            if (ProgressBarTestCaseAdapter.this.progressBar.isIndeterminate()) {
                return;
            }
            ProgressBarTestCaseAdapter.this.progressBar.getModel().setMaximum(testRunner.getTestCase().getTestStepCount());
            ProgressBarTestCaseAdapter.this.progressBar.setForeground(Color.GREEN.darker());
            ProgressBarTestCaseAdapter.this.progressBar.setValue(0);
            ProgressBarTestCaseAdapter.this.progressBar.setString("");
        }

        public void beforeStep(TestCaseRunner testRunner, TestCaseRunContext runContext, TestStep testStep) {
            if (ProgressBarTestCaseAdapter.this.progressBar.isIndeterminate()) {
                return;
            }
            if (testStep != null) {
                ProgressBarTestCaseAdapter.this.progressBar.setString(testStep.getName());
                ProgressBarTestCaseAdapter.this.progressBar.setValue(runContext.getCurrentStepIndex());
            }
        }

        public void afterStep(TestCaseRunner testRunner, TestCaseRunContext runContext, TestStepResult result) {
            if (ProgressBarTestCaseAdapter.this.progressBar.isIndeterminate()) {
                return;
            }
            if (result.getStatus() == TestStepResult.TestStepStatus.FAILED) {
                ProgressBarTestCaseAdapter.this.progressBar.setForeground(Color.RED);
            } else if (!ProgressBarTestCaseAdapter.this.testCase.getFailTestCaseOnErrors()) {
                ProgressBarTestCaseAdapter.this.progressBar.setForeground(Color.GREEN.darker());
            }
            ProgressBarTestCaseAdapter.this.progressBar.setValue(runContext.getCurrentStepIndex() + 1);
        }

        public void afterRun(TestCaseRunner testRunner, TestCaseRunContext runContext) {
            if (testRunner.getStatus() == TestRunner.Status.FAILED) {
                ProgressBarTestCaseAdapter.this.progressBar.setForeground(Color.RED);
            } else if (testRunner.getStatus() == TestRunner.Status.FINISHED) {
                ProgressBarTestCaseAdapter.this.progressBar.setForeground(Color.GREEN.darker());
            }
            if (ProgressBarTestCaseAdapter.this.progressBar.isIndeterminate()) {
                return;
            }
            if (testRunner.getStatus() == TestRunner.Status.FINISHED) {
                ProgressBarTestCaseAdapter.this.progressBar.setValue(testRunner.getTestCase().getTestStepCount());
            }
            ProgressBarTestCaseAdapter.this.progressBar.setString(testRunner.getStatus().toString());
        }
    }

    private class InternalTestMonitorListener
    extends TestMonitorListenerAdapter {
        private InternalTestMonitorListener() {
        }

        public void loadTestStarted(LoadTestRunner loadTestRunner) {
            ProgressBarTestCaseAdapter.this.setLoadTestingState();
        }

        public void loadTestFinished(LoadTestRunner loadTestRunner) {
            ProgressBarTestCaseAdapter.this.setLoadTestingState();
        }

        public void securityTestStarted(SecurityTestRunner securityTestRunner) {
            ProgressBarTestCaseAdapter.this.setSecurityTestingState();
        }

        public void securityTestFinished(SecurityTestRunner securityTestRunner) {
            ProgressBarTestCaseAdapter.this.setSecurityTestingState();
        }
    }
}

