/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.support;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.WsdlTestSuite;
import com.eviware.soapui.model.testsuite.LoadTestRunner;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestRunner;
import com.eviware.soapui.model.testsuite.TestSuiteRunContext;
import com.eviware.soapui.model.testsuite.TestSuiteRunListener;
import com.eviware.soapui.model.testsuite.TestSuiteRunner;
import com.eviware.soapui.monitor.support.TestMonitorListenerAdapter;
import com.eviware.soapui.security.SecurityTestRunner;
import java.awt.Color;
import javax.swing.JProgressBar;

public class ProgressBarTestSuiteAdapter {
    private final JProgressBar progressBar;
    private final WsdlTestSuite testSuite;
    private InternalTestSuiteRunListener internalTestRunListener;
    private InternalTestMonitorListener internalTestMonitorListener;

    public ProgressBarTestSuiteAdapter(JProgressBar progressBar, WsdlTestSuite testSuite) {
        this.progressBar = progressBar;
        this.testSuite = testSuite;
        this.setLoadTestingState();
        this.setSecurityTestingState();
        this.internalTestRunListener = new InternalTestSuiteRunListener();
        testSuite.addTestSuiteRunListener(this.internalTestRunListener);
        this.internalTestMonitorListener = new InternalTestMonitorListener();
        SoapUI.getTestMonitor().addTestMonitorListener(this.internalTestMonitorListener);
    }

    public void release() {
        this.testSuite.removeTestSuiteRunListener(this.internalTestRunListener);
        SoapUI.getTestMonitor().removeTestMonitorListener(this.internalTestMonitorListener);
    }

    private void setLoadTestingState() {
        if (SoapUI.getTestMonitor().hasRunningLoadTest(this.testSuite)) {
            this.progressBar.setIndeterminate(true);
            this.progressBar.setString("load testing");
        } else {
            this.progressBar.setIndeterminate(false);
            this.progressBar.setString("");
        }
    }

    private void setSecurityTestingState() {
        if (SoapUI.getTestMonitor().hasRunningSecurityTest(this.testSuite)) {
            this.progressBar.setIndeterminate(true);
            this.progressBar.setString("security testing");
        } else {
            this.progressBar.setIndeterminate(false);
            this.progressBar.setString("");
        }
    }

    public class InternalTestSuiteRunListener
    implements TestSuiteRunListener {
        public void beforeRun(TestSuiteRunner testRunner, TestSuiteRunContext runContext) {
            if (ProgressBarTestSuiteAdapter.this.progressBar.isIndeterminate()) {
                return;
            }
            ProgressBarTestSuiteAdapter.this.progressBar.getModel().setMaximum(testRunner.getTestSuite().getTestCaseCount());
            ProgressBarTestSuiteAdapter.this.progressBar.setForeground(Color.GREEN.darker());
        }

        public void beforeTestCase(TestSuiteRunner testRunner, TestSuiteRunContext runContext, TestCase testCase) {
            if (ProgressBarTestSuiteAdapter.this.progressBar.isIndeterminate()) {
                return;
            }
            ProgressBarTestSuiteAdapter.this.progressBar.setString(testCase.getName());
            ProgressBarTestSuiteAdapter.this.progressBar.setValue(testRunner.getResults().size());
        }

        public void afterTestCase(TestSuiteRunner testRunner, TestSuiteRunContext runContext, TestCaseRunner result) {
            if (ProgressBarTestSuiteAdapter.this.progressBar.isIndeterminate()) {
                return;
            }
            if (result.getStatus() == TestRunner.Status.FAILED) {
                ProgressBarTestSuiteAdapter.this.progressBar.setForeground(Color.RED);
            } else if (!ProgressBarTestSuiteAdapter.this.testSuite.isFailOnErrors()) {
                ProgressBarTestSuiteAdapter.this.progressBar.setForeground(Color.GREEN.darker());
            }
            ProgressBarTestSuiteAdapter.this.progressBar.setValue(testRunner.getResults().size() + 1);
        }

        public void afterRun(TestSuiteRunner testRunner, TestSuiteRunContext runContext) {
            if (testRunner.getStatus() == TestRunner.Status.FAILED) {
                ProgressBarTestSuiteAdapter.this.progressBar.setForeground(Color.RED);
            } else if (testRunner.getStatus() == TestRunner.Status.FINISHED) {
                ProgressBarTestSuiteAdapter.this.progressBar.setForeground(Color.GREEN.darker());
            }
            if (ProgressBarTestSuiteAdapter.this.progressBar.isIndeterminate()) {
                return;
            }
            if (testRunner.getStatus() == TestRunner.Status.FINISHED) {
                ProgressBarTestSuiteAdapter.this.progressBar.setValue(testRunner.getTestSuite().getTestCaseCount());
            }
            ProgressBarTestSuiteAdapter.this.progressBar.setString(testRunner.getStatus().toString());
        }
    }

    private class InternalTestMonitorListener
    extends TestMonitorListenerAdapter {
        private InternalTestMonitorListener() {
        }

        public void loadTestStarted(LoadTestRunner loadTestRunner) {
            ProgressBarTestSuiteAdapter.this.setLoadTestingState();
        }

        public void loadTestFinished(LoadTestRunner loadTestRunner) {
            ProgressBarTestSuiteAdapter.this.setLoadTestingState();
        }

        public void securityTestStarted(SecurityTestRunner securityTestRunner) {
            ProgressBarTestSuiteAdapter.this.setSecurityTestingState();
        }

        public void securityTestFinished(SecurityTestRunner securityTestRunner) {
            ProgressBarTestSuiteAdapter.this.setSecurityTestingState();
        }
    }
}

