/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.teststeps;

import com.eviware.soapui.impl.support.actions.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.panels.support.TestRunComponentEnabler;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.PropertyHolderTable;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlPropertiesTestStep;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.TestPropertyHolder;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.support.DocumentListenerAdapter;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.ui.support.ModelItemDesktopPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.text.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesStepDesktopPanel
extends ModelItemDesktopPanel<WsdlPropertiesTestStep>
implements PropertyChangeListener {
    private final WsdlPropertiesTestStep testStep;
    private JTextField sourceField;
    private JTextField targetField;
    private PropertyHolderTable propertiesTable;
    private TestRunComponentEnabler componentEnabler;
    protected boolean updatingSource;
    protected boolean updatingTarget;

    public PropertiesStepDesktopPanel(WsdlPropertiesTestStep testStep) {
        super(testStep);
        this.testStep = testStep;
        this.componentEnabler = new TestRunComponentEnabler(testStep.getTestCase());
        this.buildUI();
        testStep.addPropertyChangeListener(this);
    }

    private void buildUI() {
        this.propertiesTable = this.createPropertyHolderTable();
        this.add((Component)this.propertiesTable, "Center");
        JXToolBar toolbar = this.propertiesTable.getToolbar();
        toolbar.addRelatedGap();
        JButton reloadButton = UISupport.createToolbarButton(new ReloadPropertiesFromSourceAction());
        toolbar.add(reloadButton);
        toolbar.addSeparator();
        toolbar.add(new JLabel("Load from:"));
        this.sourceField = new JTextField(this.testStep.getSource(), 20){

            public String getToolTipText(MouseEvent event) {
                return PropertiesStepDesktopPanel.this.testStep.getSource(true);
            }
        };
        this.sourceField.setToolTipText("The filename/url or referring system-property to load properties from");
        this.sourceField.getDocument().addDocumentListener(new DocumentListenerAdapter(){

            public void update(Document document) {
                if (PropertiesStepDesktopPanel.this.updatingSource) {
                    return;
                }
                PropertiesStepDesktopPanel.this.updatingSource = true;
                PropertiesStepDesktopPanel.this.testStep.setSource(PropertiesStepDesktopPanel.this.sourceField.getText());
                PropertiesStepDesktopPanel.this.updatingSource = false;
            }
        });
        toolbar.addRelatedGap();
        toolbar.addFixed(this.sourceField);
        JButton setSourceButton = UISupport.createToolbarButton(new SetPropertiesSourceAction());
        toolbar.addRelatedGap();
        toolbar.add(setSourceButton);
        toolbar.addSeparator();
        toolbar.add(new JLabel("Save to:"));
        this.targetField = new JTextField(this.testStep.getTarget(), 20){

            public String getToolTipText(MouseEvent event) {
                return PropertiesStepDesktopPanel.this.testStep.getTarget(true);
            }
        };
        this.targetField.setToolTipText("The filename/url or referring system-property to save properties to");
        this.targetField.getDocument().addDocumentListener(new DocumentListenerAdapter(){

            public void update(Document document) {
                if (PropertiesStepDesktopPanel.this.updatingTarget) {
                    return;
                }
                PropertiesStepDesktopPanel.this.updatingTarget = true;
                PropertiesStepDesktopPanel.this.testStep.setTarget(PropertiesStepDesktopPanel.this.targetField.getText());
                PropertiesStepDesktopPanel.this.updatingTarget = false;
            }
        });
        toolbar.addRelatedGap();
        toolbar.addFixed(this.targetField);
        JButton setTargetButton = UISupport.createToolbarButton(new SetPropertiesTargetAction());
        toolbar.addRelatedGap();
        toolbar.add(setTargetButton);
        toolbar.add(Box.createHorizontalGlue());
        toolbar.addSeparator();
        toolbar.add(UISupport.createToolbarButton(new ShowOnlineHelpAction("http://www.soapui.org/userguide/functional/propertiesstep.html#Properties_Editor")));
        this.componentEnabler.add(this.sourceField);
        this.componentEnabler.add(this.targetField);
        this.componentEnabler.add(setTargetButton);
        this.componentEnabler.add(setSourceButton);
        this.componentEnabler.add(this.propertiesTable);
        this.setPreferredSize(new Dimension(600, 400));
    }

    protected PropertyHolderTable createPropertyHolderTable() {
        return new PropertyHolderTable((TestPropertyHolder)this.getModelItem());
    }

    @Override
    public boolean onClose(boolean canCancel) {
        this.componentEnabler.release();
        this.propertiesTable.release();
        return this.release();
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public boolean dependsOn(ModelItem modelItem) {
        return modelItem == this.testStep || modelItem == this.testStep.getTestCase() || modelItem == this.testStep.getTestCase().getTestSuite() || modelItem == this.testStep.getTestCase().getTestSuite().getProject();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!this.updatingSource && evt.getPropertyName().equals(WsdlPropertiesTestStep.SOURCE_PROPERTY)) {
            this.sourceField.setText(evt.getNewValue().toString());
        } else if (!this.updatingTarget && evt.getPropertyName().equals(WsdlPropertiesTestStep.TARGET_PROPERTY)) {
            this.targetField.setText(evt.getNewValue().toString());
        }
        super.propertyChange(evt);
    }

    @Override
    protected boolean release() {
        this.testStep.removePropertyChangeListener(this);
        return super.release();
    }

    private class SetPropertiesTargetAction
    extends AbstractAction {
        public SetPropertiesTargetAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/set_properties_target.gif"));
            this.putValue("ShortDescription", "Selects the properties target file");
        }

        public void actionPerformed(ActionEvent e) {
            String root = ModelSupport.getResourceRoot(PropertiesStepDesktopPanel.this.testStep);
            File file = UISupport.getFileDialogs().saveAs(this, "Set properties target", "properties", "Properties Files (*.properties)", new File(root));
            if (file != null) {
                PropertiesStepDesktopPanel.this.updatingTarget = true;
                PropertiesStepDesktopPanel.this.testStep.setTarget(file.getAbsolutePath());
                PropertiesStepDesktopPanel.this.targetField.setText(PropertiesStepDesktopPanel.this.testStep.getTarget());
                PropertiesStepDesktopPanel.this.updatingTarget = false;
                try {
                    int cnt = PropertiesStepDesktopPanel.this.testStep.saveProperties();
                    UISupport.showInfoMessage("Saved " + cnt + " properties to [" + PropertiesStepDesktopPanel.this.testStep.getTarget() + "]");
                }
                catch (IOException e1) {
                    UISupport.showErrorMessage("Failed to save properties to [" + PropertiesStepDesktopPanel.this.testStep.getTarget() + "]; " + e1);
                }
            }
        }
    }

    private class ReloadPropertiesFromSourceAction
    extends AbstractAction {
        public ReloadPropertiesFromSourceAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/reload_properties.gif"));
            this.putValue("ShortDescription", "Reloads the current properties from the selected file");
        }

        public void actionPerformed(ActionEvent e) {
            if (StringUtils.isNullOrEmpty(PropertiesStepDesktopPanel.this.testStep.getSource())) {
                UISupport.showErrorMessage("Missing source-file to load from");
                return;
            }
            try {
                boolean createMissing = UISupport.confirm("Create missing properties?", "Reload Properties");
                int cnt = PropertiesStepDesktopPanel.this.testStep.loadProperties(createMissing);
                UISupport.showInfoMessage("Loaded " + cnt + " properties from [" + PropertiesStepDesktopPanel.this.testStep.getSource() + "]");
            }
            catch (Exception e1) {
                UISupport.showErrorMessage("Failed to load properties from [" + PropertiesStepDesktopPanel.this.testStep.getSource() + "]; " + e1);
            }
        }
    }

    private class SetPropertiesSourceAction
    extends AbstractAction {
        public SetPropertiesSourceAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/set_properties_source.gif"));
            this.putValue("ShortDescription", "Selects the properties source file");
        }

        public void actionPerformed(ActionEvent e) {
            String root = ModelSupport.getResourceRoot(PropertiesStepDesktopPanel.this.testStep);
            File file = UISupport.getFileDialogs().open(this, "Set properties source", "properties", "Properties Files (*.properties)", root);
            if (file != null) {
                PropertiesStepDesktopPanel.this.updatingSource = true;
                PropertiesStepDesktopPanel.this.testStep.setSource(file.getAbsolutePath());
                PropertiesStepDesktopPanel.this.sourceField.setText(PropertiesStepDesktopPanel.this.testStep.getSource());
                PropertiesStepDesktopPanel.this.updatingSource = false;
                try {
                    boolean createMissing = UISupport.confirm("Create missing properties?", "Set Properties Source");
                    int cnt = PropertiesStepDesktopPanel.this.testStep.loadProperties(createMissing);
                    UISupport.showInfoMessage("Loaded " + cnt + " properties from [" + PropertiesStepDesktopPanel.this.testStep.getSource() + "]");
                }
                catch (IOException e1) {
                    UISupport.showErrorMessage("Failed to load properties from [" + PropertiesStepDesktopPanel.this.testStep.getSource() + "]; " + e1);
                }
            }
        }
    }
}

