/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.teststeps;

import com.eviware.soapui.impl.EmptyPanelBuilder;
import com.eviware.soapui.impl.wsdl.panels.teststeps.RestTestRequestDesktopPanel;
import com.eviware.soapui.impl.wsdl.teststeps.RestTestRequest;
import com.eviware.soapui.impl.wsdl.teststeps.RestTestRequestStep;
import com.eviware.soapui.support.components.JPropertiesTable;
import com.eviware.soapui.support.types.StringList;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestTestRequestPanelBuilder
extends EmptyPanelBuilder<RestTestRequestStep> {
    public RestTestRequestDesktopPanel buildDesktopPanel(RestTestRequestStep testStep) {
        return new RestTestRequestDesktopPanel(testStep);
    }

    @Override
    public boolean hasDesktopPanel() {
        return true;
    }

    public JPanel buildOverviewPanel(RestTestRequestStep testStep) {
        RestTestRequest request = testStep.getTestRequest();
        JPropertiesTable<RestTestRequest> table = new JPropertiesTable<RestTestRequest>("REST TestRequest Properties");
        table.addProperty("Name", "name", true);
        table.addProperty("Description", "description", true);
        table.addProperty("Encoding", "encoding", new String[]{null, "UTF-8", "iso-8859-1"});
        if (request.getOperation() == null) {
            table.addProperty("Path", "path", true);
        } else {
            table.addProperty("Endpoint", "endpoint", request.getInterface() == null ? new String[]{} : request.getInterface().getEndpoints());
            table.addProperty("Service", "serviceName");
            table.addProperty("Resource", "path");
            table.addProperty("Method", "restMethodName");
        }
        table.addProperty("Timeout", "timeout", true);
        table.addProperty("Bind Address", "bindAddress", true);
        table.addProperty("Follow Redirects", "followRedirects", JPropertiesTable.BOOLEAN_OPTIONS);
        StringList keystores = new StringList(request.getTestStep().getTestCase().getTestSuite().getProject().getWssContainer().getCryptoNames());
        keystores.add("");
        table.addProperty("SSL Keystore", "sslKeystore", keystores.toStringArray());
        table.addProperty("Strip whitespaces", "stripWhitespaces", JPropertiesTable.BOOLEAN_OPTIONS);
        table.addProperty("Remove Empty Content", "removeEmptyContent", JPropertiesTable.BOOLEAN_OPTIONS);
        table.addProperty("Entitize Properties", "entitizeProperties", JPropertiesTable.BOOLEAN_OPTIONS);
        table.addProperty("Multi-Value Delimiter", "multiValueDelimiter", true);
        table.addProperty("Pretty Print", "prettyPrint", JPropertiesTable.BOOLEAN_OPTIONS);
        table.addProperty("Dump File", "dumpFile", true).setDescription("Dumps response message to specified file");
        table.addProperty("Max Size", "maxSize", true).setDescription("The maximum number of bytes to receive");
        table.addProperty("Discard Response", "discardResponse", JPropertiesTable.BOOLEAN_OPTIONS);
        table.setPropertyObject(request);
        return table;
    }

    @Override
    public boolean hasOverviewPanel() {
        return true;
    }
}

