/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.teststeps.amf;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.AMFRequestTestStepConfig;
import com.eviware.soapui.impl.support.actions.ShowOnlineHelpAction;
import com.eviware.soapui.impl.support.components.ModelItemXmlEditor;
import com.eviware.soapui.impl.support.components.RequestMessageXmlEditor;
import com.eviware.soapui.impl.support.components.ResponseMessageXmlEditor;
import com.eviware.soapui.impl.support.panels.AbstractHttpRequestDesktopPanel;
import com.eviware.soapui.impl.wsdl.panels.support.TestRunComponentEnabler;
import com.eviware.soapui.impl.wsdl.panels.teststeps.AssertionsPanel;
import com.eviware.soapui.impl.wsdl.panels.teststeps.amf.AMFRequest;
import com.eviware.soapui.impl.wsdl.panels.teststeps.amf.AMFResponse;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.DefaultPropertyTableHolderModel;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.GroovyEditor;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.GroovyEditorModel;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.PropertyHolderTable;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestRunContext;
import com.eviware.soapui.impl.wsdl.teststeps.AMFRequestTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStepWithProperties;
import com.eviware.soapui.impl.wsdl.teststeps.actions.AddAssertionAction;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.TestPropertyHolder;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.model.iface.Submit;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.iface.SubmitListener;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.model.testsuite.Assertable;
import com.eviware.soapui.model.testsuite.AssertionsListener;
import com.eviware.soapui.model.testsuite.LoadTestRunner;
import com.eviware.soapui.model.testsuite.TestAssertion;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.monitor.support.TestMonitorListenerAdapter;
import com.eviware.soapui.security.SecurityTestRunner;
import com.eviware.soapui.settings.UISettings;
import com.eviware.soapui.support.DocumentListenerAdapter;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.actions.ChangeSplitPaneOrientationAction;
import com.eviware.soapui.support.components.JComponentInspector;
import com.eviware.soapui.support.components.JEditorStatusBarWithProgress;
import com.eviware.soapui.support.components.JInspectorPanel;
import com.eviware.soapui.support.components.JInspectorPanelFactory;
import com.eviware.soapui.support.components.JUndoableTextField;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.components.SimpleForm;
import com.eviware.soapui.support.editor.support.AbstractEditorView;
import com.eviware.soapui.support.editor.xml.support.AbstractXmlDocument;
import com.eviware.soapui.support.propertyexpansion.PropertyExpansionPopupListener;
import com.eviware.soapui.support.scripting.SoapUIScriptEngine;
import com.eviware.soapui.support.scripting.SoapUIScriptEngineRegistry;
import com.eviware.soapui.support.swing.SoapUISplitPaneUI;
import com.eviware.soapui.ui.support.ModelItemDesktopPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AMFRequestTestStepDesktopPanel
extends ModelItemDesktopPanel<AMFRequestTestStep>
implements SubmitListener {
    private static final String ENDPOINT = "Endpoint";
    private static final String AMF_CALL = "AMF Call";
    private static final Logger log = Logger.getLogger(AbstractHttpRequestDesktopPanel.class);
    private JPanel configPanel;
    private JButton addAssertionButton;
    private JInspectorPanel inspectorPanel;
    private AMFRequestTestStep amfRequestTestStep;
    protected AMFRequestTestStepConfig amfRequestTestStepConfig;
    private JComponentInspector<?> assertionInspector;
    private AssertionsPanel assertionsPanel;
    private InternalAssertionsListener assertionsListener = new InternalAssertionsListener();
    private InternalTestMonitorListener testMonitorListener = new InternalTestMonitorListener();
    private JComponent requestEditor;
    private ModelItemXmlEditor<?, ?> responseEditor;
    private Submit submit;
    private JButton submitButton;
    private JToggleButton tabsButton;
    private JTabbedPane requestTabs;
    private JPanel requestTabPanel;
    private boolean responseHasFocus;
    private JSplitPane requestSplitPane;
    private JEditorStatusBarWithProgress statusBar;
    private JButton cancelButton;
    private JButton splitButton;
    private JComponent propertiesTableComponent;
    private SoapUIScriptEngine scriptEngine;
    private RunAction runAction = new RunAction();
    private GroovyEditor groovyEditor;
    private JTextField amfCallField;
    public boolean updating;
    SimpleForm configForm;
    private JTextField endpointField;
    private TestRunComponentEnabler componentEnabler;
    protected PropertyHolderTable propertyHolderTable;

    public AMFRequestTestStepDesktopPanel(AMFRequestTestStep modelItem) {
        super(modelItem);
        this.amfRequestTestStep = modelItem;
        this.componentEnabler = new TestRunComponentEnabler(this.amfRequestTestStep.getTestCase());
        this.initConfig();
        this.initContent();
        SoapUI.getTestMonitor().addTestMonitorListener(this.testMonitorListener);
        this.setEnabled(!SoapUI.getTestMonitor().hasRunningTest(this.amfRequestTestStep.getTestCase()));
        this.amfRequestTestStep.addAssertionsListener(this.assertionsListener);
        this.scriptEngine = SoapUIScriptEngineRegistry.create(modelItem);
        this.scriptEngine.setScript(this.amfRequestTestStep.getScript());
    }

    protected void initConfig() {
        this.amfRequestTestStepConfig = this.amfRequestTestStep.getAMFRequestTestStepConfig();
    }

    private JComponent buildContent() {
        JComponent content;
        this.requestSplitPane = UISupport.createHorizontalSplit();
        this.requestSplitPane.setResizeWeight(0.5);
        this.requestSplitPane.setBorder(null);
        this.submitButton = AMFRequestTestStepDesktopPanel.createActionButton(new SubmitAction(), true);
        this.submitButton.setEnabled(this.enableSubmit());
        this.cancelButton = AMFRequestTestStepDesktopPanel.createActionButton(new CancelAction(), false);
        this.tabsButton = new JToggleButton(new ChangeToTabsAction());
        this.tabsButton.setPreferredSize(UISupport.TOOLBAR_BUTTON_DIMENSION);
        this.splitButton = AMFRequestTestStepDesktopPanel.createActionButton(new ChangeSplitPaneOrientationAction(this.requestSplitPane), true);
        this.addAssertionButton = UISupport.createToolbarButton(new AddAssertionAction(this.amfRequestTestStep));
        this.addAssertionButton.setEnabled(true);
        this.requestTabs = new JTabbedPane();
        this.requestTabs.setTabPlacement(2);
        this.requestTabs.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        int ix = AMFRequestTestStepDesktopPanel.this.requestTabs.getSelectedIndex();
                        if (ix == 0) {
                            AMFRequestTestStepDesktopPanel.this.requestEditor.requestFocus();
                        } else if (ix == 1 && AMFRequestTestStepDesktopPanel.this.responseEditor != null) {
                            AMFRequestTestStepDesktopPanel.this.responseEditor.requestFocus();
                        }
                    }
                });
            }
        });
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (AMFRequestTestStepDesktopPanel.this.requestTabs.getSelectedIndex() == 1 || AMFRequestTestStepDesktopPanel.this.responseHasFocus) {
                    AMFRequestTestStepDesktopPanel.this.responseEditor.requestFocusInWindow();
                } else {
                    AMFRequestTestStepDesktopPanel.this.requestEditor.requestFocusInWindow();
                }
            }
        });
        this.requestTabPanel = UISupport.createTabPanel(this.requestTabs, true);
        this.requestEditor = this.buildRequestConfigPanel();
        this.responseEditor = this.buildResponseEditor();
        if (this.amfRequestTestStep.getSettings().getBoolean(UISettings.START_WITH_REQUEST_TABS)) {
            this.requestTabs.addTab("Request", this.requestEditor);
            if (this.responseEditor != null) {
                this.requestTabs.addTab("Response", this.responseEditor);
            }
            this.tabsButton.setSelected(true);
            this.splitButton.setEnabled(false);
            content = this.requestTabPanel;
        } else {
            this.requestSplitPane.setTopComponent(this.requestEditor);
            this.requestSplitPane.setBottomComponent(this.responseEditor);
            this.requestSplitPane.setDividerLocation(0.5);
            content = this.requestSplitPane;
        }
        this.inspectorPanel = JInspectorPanelFactory.build(content);
        this.inspectorPanel.setDefaultDividerLocation(0.7f);
        this.add((Component)this.buildToolbar(), "North");
        this.add((Component)this.inspectorPanel.getComponent(), "Center");
        this.assertionsPanel = this.buildAssertionsPanel();
        this.assertionInspector = new JComponentInspector<AssertionsPanel>(this.assertionsPanel, "Assertions (" + ((AMFRequestTestStep)this.getModelItem()).getAssertionCount() + ")", "Assertions for this Test Request", true);
        this.inspectorPanel.addInspector(this.assertionInspector);
        this.updateStatusIcon();
        return this.inspectorPanel.getComponent();
    }

    protected JComponent buildRequestConfigPanel() {
        ModelItemXmlEditor<?, ?> reqEditor = this.buildRequestEditor();
        this.configPanel = UISupport.addTitledBorder(new JPanel(new BorderLayout()), "Script");
        this.configPanel.add((Component)this.buildToolbarButtonAndText(), "North");
        this.groovyEditor = (GroovyEditor)UISupport.getEditorFactory().buildGroovyEditor(new ScriptStepGroovyEditorModel());
        this.configPanel.add((Component)this.groovyEditor, "Center");
        this.propertiesTableComponent = this.buildProperties();
        final JSplitPane split = UISupport.createVerticalSplit(this.propertiesTableComponent, this.configPanel);
        split.setDividerLocation(120);
        reqEditor.addEditorView(new AbstractEditorView<AMFRequestDocument>("AMF", reqEditor, "amf"){

            @Override
            public JComponent buildUI() {
                return split;
            }
        });
        reqEditor.selectView(1);
        return reqEditor;
    }

    private JComponent buildToolbarButtonAndText() {
        JXToolBar toolBar = UISupport.createToolbar();
        JButton runButton = UISupport.createToolbarButton(this.runAction);
        toolBar.add(runButton);
        toolBar.add(Box.createHorizontalGlue());
        JLabel label = new JLabel("<html>Script is invoked with <code>log</code>, <code>context</code> , <code>parameters</code> and <code>amfHeaders</code> variables</html>");
        label.setToolTipText(label.getText());
        label.setMinimumSize(label.getPreferredSize());
        label.setMaximumSize(label.getPreferredSize());
        toolBar.add(label);
        toolBar.addRelatedGap();
        toolBar.add(UISupport.createToolbarButton(new ShowOnlineHelpAction("http://www.soapui.org/userguide/functional/groovystep.html#The_Groovy_Script_Editor")));
        this.componentEnabler.add(runButton);
        return toolBar;
    }

    protected JComponent buildToolbar() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.buildToolbar1(), "North");
        panel.add((Component)this.buildToolbar2(), "South");
        return panel;
    }

    protected void initContent() {
        this.amfRequestTestStep.getAMFRequest().addSubmitListener(this);
        this.add((Component)this.buildContent(), "Center");
        this.add((Component)this.buildToolbar(), "North");
        this.add((Component)this.buildStatusLabel(), "South");
        this.setPreferredSize(new Dimension(600, 500));
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (AMFRequestTestStepDesktopPanel.this.requestTabs.getSelectedIndex() == 1 || AMFRequestTestStepDesktopPanel.this.responseHasFocus) {
                    AMFRequestTestStepDesktopPanel.this.responseEditor.requestFocusInWindow();
                } else {
                    AMFRequestTestStepDesktopPanel.this.requestEditor.requestFocusInWindow();
                }
            }
        });
    }

    protected JComponent buildStatusLabel() {
        this.statusBar = new JEditorStatusBarWithProgress();
        this.statusBar.setBorder(BorderFactory.createEmptyBorder(1, 0, 0, 0));
        return this.statusBar;
    }

    protected JComponent buildProperties() {
        this.propertyHolderTable = new PropertyHolderTable((TestPropertyHolder)this.getModelItem()){

            protected JTable buildPropertiesTable() {
                this.propertiesModel = new DefaultPropertyTableHolderModel(this.holder){

                    public String[] getPropertyNames() {
                        ArrayList<String> propertyNamesList = new ArrayList<String>();
                        for (String name : holder.getPropertyNames()) {
                            if (name.equals(WsdlTestStepWithProperties.RESPONSE_AS_XML)) continue;
                            propertyNamesList.add(name);
                        }
                        return propertyNamesList.toArray(new String[propertyNamesList.size()]);
                    }
                };
                this.propertiesTable = new PropertyHolderTable.PropertiesHolderJTable(this);
                this.propertiesTable.setSurrendersFocusOnKeystroke(true);
                this.propertiesTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
                this.propertiesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                    public void valueChanged(ListSelectionEvent e) {
                        int selectedRow = propertiesTable.getSelectedRow();
                        if (removePropertyAction != null) {
                            removePropertyAction.setEnabled(selectedRow != -1);
                        }
                        if (movePropertyUpAction != null) {
                            movePropertyUpAction.setEnabled(selectedRow > 0);
                        }
                        if (movePropertyDownAction != null) {
                            movePropertyDownAction.setEnabled(selectedRow >= 0 && selectedRow < propertiesTable.getRowCount() - 1);
                        }
                    }
                });
                this.propertiesTable.setDragEnabled(true);
                this.propertiesTable.setTransferHandler(new TransferHandler("testProperty"));
                if (this.getHolder().getModelItem() != null) {
                    DropTarget dropTarget = new DropTarget(this.propertiesTable, new PropertyHolderTable.PropertyHolderTablePropertyExpansionDropTarget(this));
                    dropTarget.setDefaultActions(3);
                }
                return this.propertiesTable;
            }
        };
        JUndoableTextField textField = new JUndoableTextField(true);
        PropertyExpansionPopupListener.enable(textField, this.getModelItem());
        this.propertyHolderTable.getPropertiesTable().setDefaultEditor(String.class, new DefaultCellEditor(textField));
        return this.propertyHolderTable;
    }

    protected JComponent buildToolbar1() {
        JXToolBar toolbar = UISupport.createToolbar();
        toolbar.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        toolbar.addFixed(this.submitButton);
        toolbar.add(this.cancelButton);
        toolbar.addFixed(this.addAssertionButton);
        toolbar.add(Box.createHorizontalGlue());
        toolbar.add(this.tabsButton);
        toolbar.add(this.splitButton);
        toolbar.addFixed(UISupport.createToolbarButton(new ShowOnlineHelpAction("http://www.soapui.org/userguide/functional/propertytransfers.html#The_PropertyTransfer_Editor")));
        return toolbar;
    }

    protected JComponent buildToolbar2() {
        JXToolBar toolbar = UISupport.createToolbar();
        toolbar.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        toolbar.addLabeledFixed(ENDPOINT, this.addEndpointField());
        toolbar.addSeparator();
        toolbar.addLabeledFixed(AMF_CALL, this.addAmfCallField());
        return toolbar;
    }

    public AMFRequestTestStep getAMFRequestTestStep() {
        return this.amfRequestTestStep;
    }

    protected AssertionsPanel buildAssertionsPanel() {
        return new AMFAssertionsPanel(this.amfRequestTestStep){};
    }

    private JTextField addAmfCallField() {
        this.amfCallField = new JTextField();
        this.amfCallField.setText(this.amfRequestTestStep.getAmfCall());
        this.amfCallField.setColumns(20);
        this.amfCallField.setToolTipText("object.methodName for amf method call");
        PropertyExpansionPopupListener.enable(this.amfCallField, (ModelItem)this.amfRequestTestStep);
        this.addAmfCallDocumentListener();
        return this.amfCallField;
    }

    private JTextField addEndpointField() {
        this.endpointField = new JTextField();
        this.endpointField.setText(this.amfRequestTestStep.getEndpoint());
        this.endpointField.setColumns(35);
        this.endpointField.setToolTipText("http to connect");
        PropertyExpansionPopupListener.enable(this.endpointField, (ModelItem)this.amfRequestTestStep);
        this.addEndpointCallDocumentListener();
        return this.endpointField;
    }

    protected void addAmfCallDocumentListener() {
        this.amfCallField.getDocument().addDocumentListener(new DocumentListenerAdapter(){

            public void update(Document document) {
                if (!AMFRequestTestStepDesktopPanel.this.updating) {
                    AMFRequestTestStepDesktopPanel.this.amfRequestTestStep.setAmfCall(AMFRequestTestStepDesktopPanel.this.amfCallField.getText());
                }
            }
        });
    }

    protected void addEndpointCallDocumentListener() {
        this.endpointField.getDocument().addDocumentListener(new DocumentListenerAdapter(){

            public void update(Document document) {
                if (!AMFRequestTestStepDesktopPanel.this.updating) {
                    AMFRequestTestStepDesktopPanel.this.amfRequestTestStep.setEndpoint(AMFRequestTestStepDesktopPanel.this.endpointField.getText());
                }
            }
        });
    }

    protected boolean enableSubmit() {
        return !StringUtils.isNullOrEmpty(this.amfRequestTestStep.getEndpoint()) && !StringUtils.isNullOrEmpty(this.amfRequestTestStep.getAmfCall());
    }

    protected ModelItemXmlEditor<?, ?> buildResponseEditor() {
        return new AMFResponseMessageEditor();
    }

    protected ModelItemXmlEditor<?, ?> buildRequestEditor() {
        return new AMFRequestMessageEditor();
    }

    @Override
    public boolean dependsOn(ModelItem modelItem) {
        return modelItem == this.getModelItem() || modelItem == ((AMFRequestTestStep)this.getModelItem()).getTestCase() || modelItem == ((AMFRequestTestStep)this.getModelItem()).getTestCase().getTestSuite() || modelItem == ((AMFRequestTestStep)this.getModelItem()).getTestCase().getTestSuite().getProject();
    }

    @Override
    public boolean onClose(boolean canCancel) {
        this.configPanel.removeAll();
        this.inspectorPanel.release();
        this.requestEditor.removeAll();
        ((ModelItemXmlEditor)this.requestEditor).release();
        this.responseEditor.release();
        this.responseEditor.removeAll();
        this.responseEditor = null;
        this.assertionsPanel.release();
        SoapUI.getTestMonitor().removeTestMonitorListener(this.testMonitorListener);
        this.amfRequestTestStep.removeAssertionsListener(this.assertionsListener);
        this.amfRequestTestStep.getAMFRequest().removeSubmitListener(this);
        this.componentEnabler.release();
        this.groovyEditor.release();
        this.amfRequestTestStep.release();
        this.propertyHolderTable.release();
        this.removeAll();
        return this.release();
    }

    protected void onSubmit() {
        if (this.submit != null && this.submit.getStatus() == Submit.Status.RUNNING) {
            if (UISupport.confirm("Cancel current request?", "Submit Request")) {
                this.submit.cancel();
            } else {
                return;
            }
        }
        try {
            this.submit = this.doSubmit();
        }
        catch (Request.SubmitException e1) {
            SoapUI.logError(e1);
        }
    }

    protected Submit doSubmit() throws Request.SubmitException {
        WsdlTestRunContext submitContext = new WsdlTestRunContext((TestStep)this.getModelItem());
        if (!this.amfRequestTestStep.initAmfRequest(submitContext)) {
            throw new Request.SubmitException("AMF request is not initialised properly !");
        }
        return this.amfRequestTestStep.getAMFRequest().submit(submitContext, true);
    }

    public void setContent(JComponent content) {
        this.inspectorPanel.setContentComponent(content);
    }

    public void removeContent(JComponent content) {
        this.inspectorPanel.setContentComponent(null);
    }

    protected void onCancel() {
        if (this.submit == null) {
            return;
        }
        this.cancelButton.setEnabled(false);
        this.submit.cancel();
        this.setEnabled(true);
        this.submit = null;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.responseEditor != null) {
            this.responseEditor.setEnabled(enabled);
        }
        this.submitButton.setEnabled(enabled);
        this.addAssertionButton.setEnabled(enabled);
        this.propertiesTableComponent.setEnabled(enabled);
        this.groovyEditor.setEnabled(enabled);
        this.endpointField.setEnabled(enabled);
        this.amfCallField.setEnabled(enabled);
        this.statusBar.setIndeterminate(!enabled);
    }

    @Override
    public void afterSubmit(Submit submit, SubmitContext context) {
        if (submit.getRequest() != this.amfRequestTestStep.getAMFRequest()) {
            return;
        }
        Submit.Status status = submit.getStatus();
        AMFResponse response = (AMFResponse)submit.getResponse();
        if (status == Submit.Status.FINISHED) {
            this.amfRequestTestStep.setResponse(response, context);
        }
        this.cancelButton.setEnabled(false);
        this.setEnabled(true);
        String message = null;
        String infoMessage = null;
        String requestName = this.amfRequestTestStep.getName();
        if (status == Submit.Status.CANCELED) {
            message = "CANCELED";
            infoMessage = "[" + requestName + "] - CANCELED";
        } else if (status == Submit.Status.ERROR || response == null) {
            message = "Error getting response; " + submit.getError();
            infoMessage = "Error getting response for [" + requestName + "]; " + submit.getError();
        } else {
            message = "response time: " + response.getTimeTaken() + "ms (" + response.getContentLength() + " bytes)";
            infoMessage = "Got response for [" + requestName + "] in " + response.getTimeTaken() + "ms (" + response.getContentLength() + " bytes)";
            if (!this.splitButton.isEnabled()) {
                this.requestTabs.setSelectedIndex(1);
            }
            this.responseEditor.requestFocus();
        }
        this.logMessages(message, infoMessage);
        if (((AMFRequestTestStep)this.getModelItem()).getSettings().getBoolean(UISettings.AUTO_VALIDATE_RESPONSE)) {
            this.responseEditor.getSourceEditor().validate();
        }
        this.submit = null;
        this.updateStatusIcon();
    }

    protected void logMessages(String message, String infoMessage) {
        log.info((Object)infoMessage);
        this.statusBar.setInfo(message);
    }

    @Override
    public boolean beforeSubmit(Submit submit, SubmitContext context) {
        if (submit.getRequest() != this.amfRequestTestStep.getAMFRequest()) {
            return true;
        }
        this.setEnabled(false);
        this.cancelButton.setEnabled(this.submit != null);
        return true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if (evt.getPropertyName().equals("script") && !this.updating) {
            this.updating = true;
            this.groovyEditor.getEditArea().setText((String)evt.getNewValue());
            this.updating = false;
        }
        if (evt.getPropertyName().equals(AMFRequestTestStep.STATUS_PROPERTY)) {
            this.updateStatusIcon();
        }
    }

    private void updateStatusIcon() {
        Assertable.AssertionStatus status = this.amfRequestTestStep.getAssertionStatus();
        switch (status) {
            case FAILED: {
                this.assertionInspector.setIcon(UISupport.createImageIcon("/failed_assertion.gif"));
                this.inspectorPanel.activate(this.assertionInspector);
                break;
            }
            case UNKNOWN: {
                this.assertionInspector.setIcon(UISupport.createImageIcon("/unknown_assertion.gif"));
                break;
            }
            case VALID: {
                this.assertionInspector.setIcon(UISupport.createImageIcon("/valid_assertion.gif"));
                this.inspectorPanel.deactivate();
            }
        }
    }

    private final class InternalAssertionsListener
    implements AssertionsListener {
        private InternalAssertionsListener() {
        }

        public void assertionAdded(TestAssertion assertion) {
            AMFRequestTestStepDesktopPanel.this.assertionInspector.setTitle("Assertions (" + ((AMFRequestTestStep)AMFRequestTestStepDesktopPanel.this.getModelItem()).getAssertionCount() + ")");
        }

        public void assertionRemoved(TestAssertion assertion) {
            AMFRequestTestStepDesktopPanel.this.assertionInspector.setTitle("Assertions (" + ((AMFRequestTestStep)AMFRequestTestStepDesktopPanel.this.getModelItem()).getAssertionCount() + ")");
        }

        public void assertionMoved(TestAssertion assertion, int ix, int offset) {
            AMFRequestTestStepDesktopPanel.this.assertionInspector.setTitle("Assertions (" + ((AMFRequestTestStep)AMFRequestTestStepDesktopPanel.this.getModelItem()).getAssertionCount() + ")");
        }
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/cancel_request.gif"));
            this.putValue("ShortDescription", "Aborts ongoing request");
            this.putValue("AcceleratorKey", UISupport.getKeyStroke("alt X"));
        }

        public void actionPerformed(ActionEvent e) {
            AMFRequestTestStepDesktopPanel.this.onCancel();
        }
    }

    private final class ChangeToTabsAction
    extends AbstractAction {
        public ChangeToTabsAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/toggle_tabs.gif"));
            this.putValue("ShortDescription", "Toggles to tab-based layout");
        }

        public void actionPerformed(ActionEvent e) {
            if (AMFRequestTestStepDesktopPanel.this.splitButton.isEnabled()) {
                AMFRequestTestStepDesktopPanel.this.splitButton.setEnabled(false);
                AMFRequestTestStepDesktopPanel.this.removeContent(AMFRequestTestStepDesktopPanel.this.requestSplitPane);
                AMFRequestTestStepDesktopPanel.this.setContent(AMFRequestTestStepDesktopPanel.this.requestTabPanel);
                AMFRequestTestStepDesktopPanel.this.requestTabs.addTab("Request", AMFRequestTestStepDesktopPanel.this.requestEditor);
                if (AMFRequestTestStepDesktopPanel.this.responseEditor != null) {
                    AMFRequestTestStepDesktopPanel.this.requestTabs.addTab("Response", AMFRequestTestStepDesktopPanel.this.responseEditor);
                }
                if (AMFRequestTestStepDesktopPanel.this.responseHasFocus) {
                    AMFRequestTestStepDesktopPanel.this.requestTabs.setSelectedIndex(1);
                    AMFRequestTestStepDesktopPanel.this.requestEditor.requestFocus();
                }
                AMFRequestTestStepDesktopPanel.this.requestTabs.repaint();
            } else {
                int selectedIndex = AMFRequestTestStepDesktopPanel.this.requestTabs.getSelectedIndex();
                AMFRequestTestStepDesktopPanel.this.splitButton.setEnabled(true);
                AMFRequestTestStepDesktopPanel.this.removeContent(AMFRequestTestStepDesktopPanel.this.requestTabPanel);
                AMFRequestTestStepDesktopPanel.this.setContent(AMFRequestTestStepDesktopPanel.this.requestSplitPane);
                AMFRequestTestStepDesktopPanel.this.requestSplitPane.setTopComponent(AMFRequestTestStepDesktopPanel.this.requestEditor);
                if (AMFRequestTestStepDesktopPanel.this.responseEditor != null) {
                    AMFRequestTestStepDesktopPanel.this.requestSplitPane.setBottomComponent(AMFRequestTestStepDesktopPanel.this.responseEditor);
                }
                AMFRequestTestStepDesktopPanel.this.requestSplitPane.setDividerLocation(0.5);
                if (selectedIndex == 0 || AMFRequestTestStepDesktopPanel.this.responseEditor == null) {
                    AMFRequestTestStepDesktopPanel.this.requestEditor.requestFocus();
                } else {
                    AMFRequestTestStepDesktopPanel.this.responseEditor.requestFocus();
                }
                AMFRequestTestStepDesktopPanel.this.requestSplitPane.repaint();
            }
            AMFRequestTestStepDesktopPanel.this.revalidate();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class ResultAreaFocusListener
    implements FocusListener {
        private final ModelItemXmlEditor<?, ?> responseEditor;

        public ResultAreaFocusListener(ModelItemXmlEditor<?, ?> editor) {
            this.responseEditor = editor;
        }

        @Override
        public void focusGained(FocusEvent e) {
            int maximumDividerLocation;
            AMFRequestTestStepDesktopPanel.this.responseHasFocus = true;
            if (!AMFRequestTestStepDesktopPanel.this.splitButton.isEnabled()) {
                AMFRequestTestStepDesktopPanel.this.requestTabs.setSelectedIndex(1);
                return;
            }
            if (((AMFRequestTestStep)AMFRequestTestStepDesktopPanel.this.getModelItem()).getSettings().getBoolean(UISettings.NO_RESIZE_REQUEST_EDITOR)) {
                return;
            }
            if (AMFRequestTestStepDesktopPanel.this.requestSplitPane.getUI() instanceof SoapUISplitPaneUI && ((SoapUISplitPaneUI)AMFRequestTestStepDesktopPanel.this.requestSplitPane.getUI()).hasBeenDragged() || AMFRequestTestStepDesktopPanel.this.amfRequestTestStep.getAMFRequest().getResponse() == null) {
                return;
            }
            int pos = AMFRequestTestStepDesktopPanel.this.requestSplitPane.getDividerLocation();
            if (pos + 600 < (maximumDividerLocation = AMFRequestTestStepDesktopPanel.this.requestSplitPane.getMaximumDividerLocation())) {
                return;
            }
            if (maximumDividerLocation > 700) {
                AMFRequestTestStepDesktopPanel.this.requestSplitPane.setDividerLocation(maximumDividerLocation - 600);
            } else {
                AMFRequestTestStepDesktopPanel.this.requestSplitPane.setDividerLocation(0.2);
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }

    protected final class InputAreaFocusListener
    implements FocusListener {
        public InputAreaFocusListener(JComponent editor) {
        }

        public void focusGained(FocusEvent e) {
            AMFRequestTestStepDesktopPanel.this.responseHasFocus = false;
            if (!AMFRequestTestStepDesktopPanel.this.splitButton.isEnabled()) {
                AMFRequestTestStepDesktopPanel.this.requestTabs.setSelectedIndex(0);
                return;
            }
            int pos = AMFRequestTestStepDesktopPanel.this.requestSplitPane.getDividerLocation();
            if (pos >= 600) {
                return;
            }
            if (AMFRequestTestStepDesktopPanel.this.requestSplitPane.getMaximumDividerLocation() > 700) {
                AMFRequestTestStepDesktopPanel.this.requestSplitPane.setDividerLocation(600);
            } else {
                AMFRequestTestStepDesktopPanel.this.requestSplitPane.setDividerLocation(0.8);
            }
        }

        public void focusLost(FocusEvent e) {
        }
    }

    public class SubmitAction
    extends AbstractAction {
        public SubmitAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/submit_request.gif"));
            this.putValue("ShortDescription", "Submit request to specified endpoint URL");
            this.putValue("AcceleratorKey", UISupport.getKeyStroke("alt ENTER"));
        }

        public void actionPerformed(ActionEvent e) {
            AMFRequestTestStepDesktopPanel.this.onSubmit();
        }
    }

    private class InternalTestMonitorListener
    extends TestMonitorListenerAdapter {
        private InternalTestMonitorListener() {
        }

        public void loadTestFinished(LoadTestRunner runner) {
            AMFRequestTestStepDesktopPanel.this.setEnabled(!SoapUI.getTestMonitor().hasRunningTest(((AMFRequestTestStep)AMFRequestTestStepDesktopPanel.this.getModelItem()).getTestCase()));
        }

        public void loadTestStarted(LoadTestRunner runner) {
            if (runner.getLoadTest().getTestCase() == ((AMFRequestTestStep)AMFRequestTestStepDesktopPanel.this.getModelItem()).getTestCase()) {
                AMFRequestTestStepDesktopPanel.this.setEnabled(false);
            }
        }

        public void securityTestFinished(SecurityTestRunner runner) {
            AMFRequestTestStepDesktopPanel.this.setEnabled(!SoapUI.getTestMonitor().hasRunningTest(((AMFRequestTestStep)AMFRequestTestStepDesktopPanel.this.getModelItem()).getTestCase()));
        }

        public void securityTestStarted(SecurityTestRunner runner) {
            if (runner.getSecurityTest().getTestCase() == ((AMFRequestTestStep)AMFRequestTestStepDesktopPanel.this.getModelItem()).getTestCase()) {
                AMFRequestTestStepDesktopPanel.this.setEnabled(false);
            }
        }

        public void testCaseFinished(TestCaseRunner runner) {
            AMFRequestTestStepDesktopPanel.this.setEnabled(!SoapUI.getTestMonitor().hasRunningTest(((AMFRequestTestStep)AMFRequestTestStepDesktopPanel.this.getModelItem()).getTestCase()));
        }

        public void testCaseStarted(TestCaseRunner runner) {
            if (runner.getTestCase() == ((AMFRequestTestStep)AMFRequestTestStepDesktopPanel.this.getModelItem()).getTestCase()) {
                AMFRequestTestStepDesktopPanel.this.setEnabled(false);
            }
        }
    }

    public class AMFRequestDocument
    extends AbstractXmlDocument
    implements PropertyChangeListener {
        public AMFRequestDocument() {
            AMFRequestTestStepDesktopPanel.this.amfRequestTestStep.addPropertyChangeListener("request", this);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            this.fireXmlChanged(evt.getOldValue() == null ? null : ((AMFRequest)evt.getOldValue()).requestAsXML(), this.getXml());
        }

        public String getXml() {
            AMFRequest request = AMFRequestTestStepDesktopPanel.this.amfRequestTestStep.getAMFRequest();
            return request == null ? null : request.requestAsXML();
        }

        public void setXml(String xml) {
        }

        public void release() {
            super.release();
            AMFRequestTestStepDesktopPanel.this.amfRequestTestStep.removePropertyChangeListener("request", this);
        }
    }

    public class AMFResponseDocument
    extends AbstractXmlDocument
    implements PropertyChangeListener {
        public AMFResponseDocument() {
            AMFRequestTestStepDesktopPanel.this.amfRequestTestStep.addPropertyChangeListener("response", this);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            this.fireXmlChanged(evt.getOldValue() == null ? null : ((AMFResponse)evt.getOldValue()).getContentAsString(), this.getXml());
        }

        public String getXml() {
            AMFResponse response = AMFRequestTestStepDesktopPanel.this.amfRequestTestStep.getAMFRequest().getResponse();
            return response == null ? null : response.getResponseContentXML();
        }

        public void setXml(String xml) {
            if (AMFRequestTestStepDesktopPanel.this.amfRequestTestStep.getAMFRequest().getResponse() != null) {
                AMFRequestTestStepDesktopPanel.this.amfRequestTestStep.getAMFRequest().getResponse().setResponseContentXML(xml);
            }
        }

        public void release() {
            super.release();
            AMFRequestTestStepDesktopPanel.this.amfRequestTestStep.removePropertyChangeListener("response", this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AMFRequestMessageEditor
    extends RequestMessageXmlEditor<AMFRequestTestStep, AMFRequestDocument> {
        public AMFRequestMessageEditor() {
            super(new AMFRequestDocument(), AMFRequestTestStepDesktopPanel.this.amfRequestTestStep);
        }

        @Override
        public void release() {
            ((AMFRequestDocument)this.getDocument()).release();
            super.release();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AMFResponseMessageEditor
    extends ResponseMessageXmlEditor<AMFRequestTestStep, AMFResponseDocument> {
        public AMFResponseMessageEditor() {
            super(new AMFResponseDocument(), AMFRequestTestStepDesktopPanel.this.amfRequestTestStep);
        }

        @Override
        public void release() {
            ((AMFResponseDocument)this.getDocument()).release();
            super.release();
        }
    }

    private class RunAction
    extends AbstractAction {
        public RunAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/run_groovy_script.gif"));
            this.putValue("ShortDescription", "Runs this script in a seperate thread using a mock testRunner and testContext");
        }

        public void actionPerformed(ActionEvent e) {
            SoapUI.getThreadPool().execute(new Runnable(){

                public void run() {
                    WsdlTestRunContext context = new WsdlTestRunContext((TestStep)AMFRequestTestStepDesktopPanel.this.getModelItem());
                    AMFRequestTestStepDesktopPanel.this.statusBar.setIndeterminate(true);
                    AMFRequestTestStepDesktopPanel.this.amfRequestTestStep.initAmfRequest(context);
                    if (context.getProperty("AMF_SCRIPT_ERROR") != null) {
                        UISupport.showInfoMessage(((Throwable)context.getProperty("AMF_SCRIPT_ERROR")).getMessage());
                    } else {
                        UISupport.showInfoMessage(this.scriptInfo(context));
                    }
                    AMFRequestTestStepDesktopPanel.this.statusBar.setIndeterminate(false);
                    AMFRequestTestStepDesktopPanel.this.amfRequestTestStep.getAMFRequest().clearArguments();
                }

                private String scriptInfo(SubmitContext context) {
                    HashMap parameters = (HashMap)context.getProperty("AMF_SCRIPT_PARAMETERS");
                    HashMap amfHeaders = (HashMap)context.getProperty("AMF_SCRIPT_HEADERS");
                    StringBuilder sb = new StringBuilder();
                    sb.append("parameters " + (parameters != null ? parameters.toString() : ""));
                    sb.append("\n");
                    sb.append("amfHeaders " + (amfHeaders != null ? amfHeaders.toString() : ""));
                    return sb.toString();
                }
            });
        }
    }

    private class ScriptStepGroovyEditorModel
    implements GroovyEditorModel {
        private ScriptStepGroovyEditorModel() {
        }

        public String[] getKeywords() {
            return new String[]{"log", "context", "property"};
        }

        public Action getRunAction() {
            return AMFRequestTestStepDesktopPanel.this.runAction;
        }

        public String getScript() {
            return AMFRequestTestStepDesktopPanel.this.amfRequestTestStep.getScript();
        }

        public void setScript(String text) {
            if (AMFRequestTestStepDesktopPanel.this.updating) {
                return;
            }
            AMFRequestTestStepDesktopPanel.this.updating = true;
            AMFRequestTestStepDesktopPanel.this.amfRequestTestStep.setScript(text);
            AMFRequestTestStepDesktopPanel.this.updating = false;
        }

        public Settings getSettings() {
            return SoapUI.getSettings();
        }

        public String getScriptName() {
            return null;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
        }

        public ModelItem getModelItem() {
            return AMFRequestTestStepDesktopPanel.this.amfRequestTestStep;
        }
    }

    protected class AMFAssertionsPanel
    extends AssertionsPanel {
        public AMFAssertionsPanel(Assertable assertable) {
            super(assertable);
        }
    }
}

