/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.filters;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.submit.filters.AbstractWssRequestFilter;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.xml.XmlUtils;
import java.io.IOException;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.message.WSSecTimestamp;
import org.apache.ws.security.message.WSSecUsernameToken;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class WssAuthenticationRequestFilter
extends AbstractWssRequestFilter {
    private static final String WSS_USERNAME_TOKEN = "WsSecurityAuthenticationRequestFilter@UsernameToken";
    private static final String WSS_TIMESTAMP_TOKEN = "WsSecurityAuthenticationRequestFilter@TimestampToken";

    public void filterWsdlRequest(SubmitContext context, WsdlRequest wsdlRequest) {
        String pwType = PropertyExpander.expandProperties(context, wsdlRequest.getWssPasswordType());
        String wsTimestamp = wsdlRequest.getWssTimeToLive();
        if ((StringUtils.isNullOrEmpty(pwType) || "None".equals(pwType)) && StringUtils.isNullOrEmpty(wsTimestamp)) {
            return;
        }
        try {
            String password = PropertyExpander.expandProperties(context, wsdlRequest.getPassword());
            String username = PropertyExpander.expandProperties(context, wsdlRequest.getUsername());
            WssAuthenticationRequestFilter.setWssHeaders(context, username, password, pwType, wsTimestamp);
        }
        catch (Throwable e) {
            SoapUI.logError(e);
        }
    }

    public static void setWssHeaders(SubmitContext context, String username, String password, String pwType, String wsTimestamp) throws SAXException, IOException, WSSecurityException {
        Element parentNode;
        Element elm;
        Document doc = WssAuthenticationRequestFilter.getWssDocument(context);
        if (StringUtils.hasContent(pwType) && !pwType.equals("None") && StringUtils.hasContent(username) && StringUtils.hasContent(password)) {
            elm = (Element)context.getProperty(WSS_USERNAME_TOKEN);
            if (elm != null) {
                parentNode = (Element)elm.getParentNode();
                parentNode.removeChild(elm);
            }
            context.setProperty(WSS_USERNAME_TOKEN, WssAuthenticationRequestFilter.setWssUsernameToken(username, password, pwType, doc));
        } else if (pwType != null && context.getProperty(WSS_USERNAME_TOKEN) != null) {
            elm = (Element)context.getProperty(WSS_USERNAME_TOKEN);
            context.removeProperty(WSS_USERNAME_TOKEN);
            parentNode = (Element)elm.getParentNode();
            parentNode.removeChild(elm);
            if (XmlUtils.getChildElements(parentNode).getLength() == 0) {
                parentNode.getParentNode().removeChild(parentNode);
            }
        }
        if (StringUtils.hasContent(wsTimestamp)) {
            elm = (Element)context.getProperty(WSS_TIMESTAMP_TOKEN);
            if (elm != null) {
                parentNode = (Element)elm.getParentNode();
                parentNode.removeChild(elm);
            }
            context.setProperty(WSS_TIMESTAMP_TOKEN, WssAuthenticationRequestFilter.setWsTimestampToken(wsTimestamp, doc));
        } else if (wsTimestamp != null && context.getProperty(WSS_TIMESTAMP_TOKEN) != null) {
            elm = (Element)context.getProperty(WSS_TIMESTAMP_TOKEN);
            context.removeProperty(WSS_TIMESTAMP_TOKEN);
            parentNode = (Element)elm.getParentNode();
            parentNode.removeChild(elm);
            if (XmlUtils.getChildElements(parentNode).getLength() == 0) {
                parentNode.getParentNode().removeChild(parentNode);
            }
        }
        WssAuthenticationRequestFilter.updateWssDocument(context, doc);
    }

    private static Element setWsTimestampToken(String ttl, Document doc) throws WSSecurityException {
        WSSecTimestamp addTimestamp = new WSSecTimestamp();
        addTimestamp.setTimeToLive(Integer.parseInt(ttl));
        WSSConfig wsc = WSSConfig.getNewInstance();
        wsc.setPrecisionInMilliSeconds(false);
        wsc.setTimeStampStrict(false);
        addTimestamp.setWsConfig(wsc);
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        addTimestamp.build(doc, secHeader);
        return addTimestamp.getElement();
    }

    private static Element setWssUsernameToken(String username, String password, String pwType, Document doc) throws WSSecurityException {
        WSSecUsernameToken wsa = new WSSecUsernameToken();
        if ("PasswordDigest".equals(pwType)) {
            wsa.setPasswordType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest");
        } else {
            wsa.setPasswordType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText");
        }
        wsa.setUserInfo(username, password);
        wsa.addNonce();
        wsa.addCreated();
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        wsa.build(doc, secHeader);
        return wsa.getUsernameTokenElement();
    }
}

