/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.filters;

import com.eviware.soapui.config.EndpointConfig;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.endpoint.DefaultEndpointStrategy;
import com.eviware.soapui.impl.wsdl.submit.RequestFilter;
import com.eviware.soapui.impl.wsdl.submit.filters.AbstractWssRequestFilter;
import com.eviware.soapui.impl.wsdl.support.wss.DefaultWssContainer;
import com.eviware.soapui.impl.wsdl.support.wss.IncomingWss;
import com.eviware.soapui.impl.wsdl.support.wss.OutgoingWss;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.xml.XmlUtils;
import org.w3c.dom.Document;

public class WssRequestFilter
extends AbstractWssRequestFilter
implements RequestFilter {
    public static final String INCOMING_WSS_PROPERTY = "WssRequestFilter#IncomingWss";

    public void filterWsdlRequest(SubmitContext context, WsdlRequest wsdlRequest) {
        DefaultWssContainer wssContainer = wsdlRequest.getOperation().getInterface().getProject().getWssContainer();
        if (wssContainer == null) {
            return;
        }
        OutgoingWss outgoingWss = wssContainer.getOutgoingWssByName(wsdlRequest.getOutgoingWss());
        DefaultEndpointStrategy des = (DefaultEndpointStrategy)wsdlRequest.getOperation().getInterface().getProject().getEndpointStrategy();
        DefaultEndpointStrategy.EndpointDefaults endpointDefaults = des.getEndpointDefaults(wsdlRequest.getEndpoint());
        if (StringUtils.hasContent(endpointDefaults.getOutgoingWss()) && (outgoingWss == null || endpointDefaults.getMode() != EndpointConfig.Mode.COMPLEMENT)) {
            outgoingWss = wssContainer.getOutgoingWssByName(endpointDefaults.getOutgoingWss());
        }
        if (outgoingWss != null) {
            try {
                Document wssDocument = WssRequestFilter.getWssDocument(context);
                if (!"true".equals(System.getProperty("soapui.savewss"))) {
                    context.setProperty("PreWssProcessedDocument", XmlUtils.serialize(wssDocument));
                }
                outgoingWss.processOutgoing(wssDocument, context);
                WssRequestFilter.updateWssDocument(context, wssDocument);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        IncomingWss incomingWss = wssContainer.getIncomingWssByName(wsdlRequest.getIncomingWss());
        if (StringUtils.hasContent(endpointDefaults.getIncomingWss()) && (incomingWss == null || endpointDefaults.getMode() != EndpointConfig.Mode.COMPLEMENT)) {
            incomingWss = wssContainer.getIncomingWssByName(endpointDefaults.getIncomingWss());
        }
        if (incomingWss != null) {
            context.setProperty(INCOMING_WSS_PROPERTY, incomingWss);
        }
    }
}

