/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.transports.http.support.attachments;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.OperationConfig;
import com.eviware.soapui.config.PartsConfig;
import com.eviware.soapui.impl.wsdl.AttachmentContainer;
import com.eviware.soapui.impl.wsdl.HttpAttachmentPart;
import com.eviware.soapui.impl.wsdl.WsdlAttachmentContainer;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.attachments.AttachmentDataSource;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.attachments.MultipartAttachmentDataSource;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.attachments.MultipartAttachmentFileDataSource;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.attachments.XOPPartDataSource;
import com.eviware.soapui.impl.wsdl.support.MessageXmlPart;
import com.eviware.soapui.impl.wsdl.support.PathUtils;
import com.eviware.soapui.impl.wsdl.support.soap.SoapVersion;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlContext;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlValidator;
import com.eviware.soapui.impl.wsdl.support.xsd.SchemaUtils;
import com.eviware.soapui.model.iface.Attachment;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.editor.inspectors.attachments.ContentTypeHandler;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.xml.XmlObjectTreeModel;
import com.eviware.soapui.support.xml.XmlUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.PreencodedMimeBodyPart;
import javax.wsdl.Input;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.xml.namespace.QName;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlBase64Binary;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlHexBinary;
import org.apache.xmlbeans.XmlObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttachmentUtils {
    private static final Logger log = Logger.getLogger(AttachmentUtils.class);
    private static final QName XMLMIME_CONTENTTYPE_200505 = new QName("http://www.w3.org/2005/05/xmlmime", "contentType");
    private static final QName XMLMIME_CONTENTTYPE_200411 = new QName("http://www.w3.org/2004/11/xmlmime", "contentType");
    private static final QName SWAREF_QNAME = new QName("http://ws-i.org/profiles/basic/1.1/xsd", "swaRef");
    public static final QName XOP_HREF_QNAME = new QName("href");
    private static final QName XOP_INCLUDE_QNAME = new QName("http://www.w3.org/2004/08/xop/include", "Include");
    public static final String ROOTPART_SOAPUI_ORG = "<rootpart@soapui.org>";
    public static final long MAX_SIZE_IN_MEMORY_ATTACHMENT = 512000L;
    public static final Session JAVAMAIL_SESSION = Session.getDefaultInstance((Properties)new Properties());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean prepareMessagePart(WsdlAttachmentContainer container, MimeMultipart mp, MessageXmlPart messagePart, StringToStringMap contentIds) throws Exception, MessagingException {
        boolean isXop = false;
        XmlObjectTreeModel treeModel = null;
        XmlCursor cursor = messagePart.newCursor();
        XmlObject rootXmlObject = cursor.getObject();
        try {
            while (!cursor.isEnddoc()) {
                if (cursor.isContainer()) {
                    String textContent;
                    if (messagePart.isAttachmentPart()) {
                        String href = cursor.getAttributeText(XOP_HREF_QNAME);
                        if (href == null || href.length() <= 0) break;
                        contentIds.put(messagePart.getPart().getName(), href);
                        break;
                    }
                    XmlObject xmlObj = cursor.getObject();
                    SchemaType schemaType = xmlObj.schemaType();
                    if (schemaType.isNoType()) {
                        XmlObjectTreeModel.XmlTreeNode tn;
                        if (treeModel == null) {
                            treeModel = new XmlObjectTreeModel(messagePart.getSchemaType().getTypeSystem(), rootXmlObject);
                        }
                        if ((tn = treeModel.getXmlTreeNode(xmlObj)) != null) {
                            schemaType = tn.getSchemaType();
                        }
                    }
                    if (AttachmentUtils.isSwaRefType(schemaType)) {
                        textContent = XmlUtils.getNodeValue(cursor.getDomNode());
                        if (StringUtils.hasContent(textContent) && textContent.startsWith("cid:")) {
                            textContent = textContent.substring(4);
                            try {
                                new URI(textContent);
                                contentIds.put(textContent, textContent);
                            }
                            catch (RuntimeException e) {
                                String contentId = textContent + "@soapui.org";
                                cursor.setTextValue("cid:" + contentId);
                                contentIds.put(textContent, contentId);
                            }
                        }
                    } else if (AttachmentUtils.isXopInclude(schemaType)) {
                        String contentId = cursor.getAttributeText(new QName("href"));
                        if (contentId != null && contentId.length() > 0) {
                            contentIds.put(contentId, contentId);
                            isXop = true;
                            Attachment[] attachments = container.getAttachmentsForPart(contentId);
                            if (attachments.length == 1) {
                                String contentType;
                                XmlCursor cur = cursor.newCursor();
                                if (cur.toParent() && (contentType = AttachmentUtils.getXmlMimeContentType(cur)) != null && contentType.length() > 0) {
                                    attachments[0].setContentType(contentType);
                                }
                                cur.dispose();
                            }
                        }
                    } else {
                        textContent = XmlUtils.getNodeValue(cursor.getDomNode());
                        if (StringUtils.hasContent(textContent)) {
                            String xmimeContentType;
                            Attachment attachment = null;
                            boolean isXopAttachment = false;
                            if (container.isInlineFilesEnabled() && textContent.startsWith("file:")) {
                                String filename = textContent.substring(5);
                                if (container.isMtomEnabled()) {
                                    PreencodedMimeBodyPart part = new PreencodedMimeBodyPart("binary");
                                    xmimeContentType = AttachmentUtils.getXmlMimeContentType(cursor);
                                    if (StringUtils.isNullOrEmpty(xmimeContentType)) {
                                        xmimeContentType = ContentTypeHandler.getContentTypeFromFilename(filename);
                                    }
                                    part.setDataHandler(new DataHandler((DataSource)new XOPPartDataSource(new File(filename), xmimeContentType, schemaType)));
                                    part.setContentID("<" + filename + ">");
                                    mp.addBodyPart((BodyPart)part);
                                    isXopAttachment = true;
                                } else if (new File(filename).exists()) {
                                    AttachmentUtils.inlineData(cursor, schemaType, new FileInputStream(filename));
                                } else {
                                    Attachment att = AttachmentUtils.getAttachmentForFilename(container, filename);
                                    if (att != null) {
                                        AttachmentUtils.inlineData(cursor, schemaType, att.getInputStream());
                                    }
                                }
                            } else {
                                Attachment[] attachmentsForPart = container.getAttachmentsForPart(textContent);
                                if (textContent.startsWith("cid:")) {
                                    attachmentsForPart = container.getAttachmentsForPart(textContent = textContent.substring(4));
                                    Attachment[] attachments = attachmentsForPart;
                                    if (attachments.length == 1) {
                                        attachment = attachments[0];
                                    } else if (attachments.length > 1) {
                                        attachment = AttachmentUtils.buildMulitpartAttachment(attachments);
                                    }
                                    isXopAttachment = container.isMtomEnabled();
                                    contentIds.put(textContent, textContent);
                                } else if (container.isMtomEnabled() && (SchemaUtils.isBinaryType(schemaType) || SchemaUtils.isAnyType(schemaType))) {
                                    if ("true".equals(System.getProperty("soapui.mtom.strict"))) {
                                        if (SchemaUtils.isAnyType(schemaType)) {
                                            textContent = null;
                                        } else {
                                            for (int c = 0; c < textContent.length(); ++c) {
                                                if (!Character.isWhitespace(textContent.charAt(c))) continue;
                                                textContent = null;
                                                break;
                                            }
                                        }
                                    }
                                    if (textContent != null) {
                                        PreencodedMimeBodyPart part = new PreencodedMimeBodyPart("binary");
                                        xmimeContentType = AttachmentUtils.getXmlMimeContentType(cursor);
                                        part.setDataHandler(new DataHandler((DataSource)new XOPPartDataSource(textContent, xmimeContentType, schemaType)));
                                        textContent = "http://www.soapui.org/" + System.nanoTime();
                                        part.setContentID("<" + textContent + ">");
                                        mp.addBodyPart((BodyPart)part);
                                        isXopAttachment = true;
                                    }
                                } else if (container.isInlineFilesEnabled() && attachmentsForPart != null && attachmentsForPart.length > 0) {
                                    attachment = attachmentsForPart[0];
                                }
                            }
                            if (isXopAttachment && container.isMtomEnabled()) {
                                AttachmentUtils.buildXopInclude(cursor, textContent);
                                isXop = true;
                            } else if (attachment != null) {
                                AttachmentUtils.inlineAttachment(cursor, schemaType, attachment);
                            }
                        }
                    }
                }
                cursor.toNextToken();
            }
            Object var17_23 = null;
        }
        catch (Throwable throwable) {
            Object var17_24 = null;
            cursor.dispose();
            throw throwable;
        }
        cursor.dispose();
        return isXop;
    }

    private static Attachment getAttachmentForFilename(WsdlAttachmentContainer container, String filename) {
        for (Attachment attachment : container.getAttachments()) {
            if (!filename.equals(attachment.getName())) continue;
            return attachment;
        }
        return null;
    }

    private static void inlineAttachment(XmlCursor cursor, SchemaType schemaType, Attachment attachment) throws Exception {
        AttachmentUtils.inlineData(cursor, schemaType, attachment.getInputStream());
    }

    private static void inlineData(XmlCursor cursor, SchemaType schemaType, InputStream in) throws IOException {
        String content = null;
        byte[] data = Tools.readAll(in, -1L).toByteArray();
        content = SchemaUtils.isInstanceOf(schemaType, XmlHexBinary.type) ? new String(Hex.encodeHex((byte[])data)) : (SchemaUtils.isInstanceOf(schemaType, XmlBase64Binary.type) ? new String(Base64.encodeBase64((byte[])data)) : new String(data));
        XmlCursor c = cursor.newCursor();
        c.setTextValue(content);
        c.dispose();
    }

    private static void buildXopInclude(XmlCursor cursor, String contentId) {
        XmlCursor c = cursor.newCursor();
        c.removeXmlContents();
        c.toFirstContentToken();
        c.beginElement(XOP_INCLUDE_QNAME);
        c.insertAttributeWithValue(XOP_HREF_QNAME, "cid:" + contentId);
        c.toNextSibling();
        c.removeXml();
        c.dispose();
    }

    private static Attachment buildMulitpartAttachment(Attachment[] attachments) {
        System.out.println("buildMulitpartAttachment(Attachment[] attachments) not implemented!");
        return null;
    }

    public static String buildRootPartContentType(String action, SoapVersion soapVersion) {
        String contentType = "application/xop+xml; charset=UTF-8; type=\"" + soapVersion.getContentType();
        if (soapVersion == SoapVersion.Soap12) {
            contentType = contentType + "; action=\\\"" + action + "\\\"";
        }
        return contentType + "\"";
    }

    public static String buildMTOMContentType(String header, String action, SoapVersion soapVersion) {
        int ix = header.indexOf("boundary");
        String contentType = "multipart/related; type=\"application/xop+xml\"; start=\"<rootpart@soapui.org>\"; start-info=\"" + soapVersion.getContentType();
        if (soapVersion == SoapVersion.Soap12 && action != null) {
            contentType = contentType + "\"; action=\"" + action;
        }
        return contentType + "\"; " + header.substring(ix);
    }

    public static boolean isSwaRefType(SchemaType schemaType) {
        return schemaType != null && schemaType.getName() != null && schemaType.getName().equals(SWAREF_QNAME);
    }

    public static String getXmlMimeContentType(XmlCursor cursor) {
        String attributeText = cursor.getAttributeText(XMLMIME_CONTENTTYPE_200411);
        if (attributeText == null) {
            attributeText = cursor.getAttributeText(XMLMIME_CONTENTTYPE_200505);
        }
        return attributeText;
    }

    public static Attachment.AttachmentEncoding getAttachmentEncoding(WsdlOperation operation, HttpAttachmentPart httpAttachmentPart, boolean isResponse) {
        if (httpAttachmentPart.getSchemaType() != null) {
            if (SchemaUtils.isInstanceOf(httpAttachmentPart.getSchemaType(), XmlBase64Binary.type)) {
                return Attachment.AttachmentEncoding.BASE64;
            }
            if (SchemaUtils.isInstanceOf(httpAttachmentPart.getSchemaType(), XmlHexBinary.type)) {
                return Attachment.AttachmentEncoding.HEX;
            }
        }
        return AttachmentUtils.getAttachmentEncoding(operation, httpAttachmentPart.getName(), isResponse);
    }

    public static Attachment.AttachmentEncoding getAttachmentEncoding(WsdlOperation operation, String partName, boolean isResponse) {
        QName typeName;
        if (operation == null || operation.getBindingOperation() == null || operation.getBindingOperation().getOperation() == null) {
            return Attachment.AttachmentEncoding.NONE;
        }
        Part part = null;
        if (isResponse) {
            Output output = operation.getBindingOperation().getOperation().getOutput();
            if (output == null || output.getMessage() == null) {
                return Attachment.AttachmentEncoding.NONE;
            }
            part = output.getMessage().getPart(partName);
        } else {
            Input input = operation.getBindingOperation().getOperation().getInput();
            if (input == null || input.getMessage() == null) {
                return Attachment.AttachmentEncoding.NONE;
            }
            part = input.getMessage().getPart(partName);
        }
        if (part != null && (typeName = part.getTypeName()).getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
            if (typeName.getLocalPart().equals("base64Binary")) {
                return Attachment.AttachmentEncoding.BASE64;
            }
            if (typeName.getLocalPart().equals("hexBinary")) {
                return Attachment.AttachmentEncoding.HEX;
            }
        }
        return Attachment.AttachmentEncoding.NONE;
    }

    public static boolean isXopInclude(SchemaType schemaType) {
        return XOP_INCLUDE_QNAME.equals(schemaType.getName());
    }

    public static List<HttpAttachmentPart> extractAttachmentParts(WsdlOperation operation, String messageContent, boolean addAnonymous, boolean isResponse, boolean forceMtom) {
        PartsConfig messageParts;
        ArrayList<HttpAttachmentPart> result = new ArrayList<HttpAttachmentPart>();
        PartsConfig partsConfig = messageParts = isResponse ? ((OperationConfig)operation.getConfig()).getResponseParts() : ((OperationConfig)operation.getConfig()).getRequestParts();
        if (messageParts != null) {
            for (PartsConfig.Part part : messageParts.getPartList()) {
                HttpAttachmentPart attachmentPart = new HttpAttachmentPart(part.getName(), part.getContentTypeList());
                attachmentPart.setType(Attachment.AttachmentType.MIME);
                result.add(attachmentPart);
            }
        }
        if (messageContent.length() > 0) {
            WsdlContext wsdlContext = operation.getInterface().getWsdlContext();
            WsdlValidator validator = new WsdlValidator(wsdlContext);
            try {
                XmlObject[] requestDocuments;
                for (XmlObject partDoc : requestDocuments = validator.getMessageParts(messageContent, operation.getName(), isResponse)) {
                    XmlCursor cursor = partDoc.newCursor();
                    while (!cursor.isEnddoc()) {
                        SchemaType schemaType;
                        if (cursor.isContainer() && (schemaType = cursor.getObject().schemaType()) != null) {
                            HttpAttachmentPart attachmentPart;
                            String contentId;
                            String attributeText = AttachmentUtils.getXmlMimeContentType(cursor);
                            if (SchemaUtils.isBinaryType(schemaType) || SchemaUtils.isAnyType(schemaType)) {
                                contentId = cursor.getTextValue();
                                if (contentId.startsWith("cid:")) {
                                    attachmentPart = new HttpAttachmentPart(contentId.substring(4), attributeText);
                                    attachmentPart.setType(attributeText == null && !forceMtom ? Attachment.AttachmentType.CONTENT : Attachment.AttachmentType.XOP);
                                    result.add(attachmentPart);
                                }
                            } else if (AttachmentUtils.isXopInclude(schemaType)) {
                                contentId = cursor.getAttributeText(new QName("href"));
                                if (contentId != null && contentId.length() > 0) {
                                    attachmentPart = new HttpAttachmentPart(contentId, attributeText);
                                    attachmentPart.setType(Attachment.AttachmentType.XOP);
                                    result.add(attachmentPart);
                                }
                            } else if (AttachmentUtils.isSwaRefType(schemaType) && (contentId = cursor.getTextValue()).startsWith("cid:")) {
                                attachmentPart = new HttpAttachmentPart(contentId.substring(4), attributeText);
                                attachmentPart.setType(Attachment.AttachmentType.SWAREF);
                                result.add(attachmentPart);
                            }
                        }
                        cursor.toNextToken();
                    }
                }
            }
            catch (Exception e) {
                if (e instanceof NullPointerException) {
                    SoapUI.logError(e);
                }
                log.warn((Object)e.getMessage());
            }
        }
        if (addAnonymous) {
            result.add(new HttpAttachmentPart());
        }
        return result;
    }

    public static void addMimeParts(AttachmentContainer container, List<Attachment> attachments, MimeMultipart mp, StringToStringMap contentIds) throws MessagingException {
        if (!container.isMultipartEnabled()) {
            for (int c = 0; c < attachments.size(); ++c) {
                Attachment att = attachments.get(c);
                if (att.getAttachmentType() == Attachment.AttachmentType.CONTENT) continue;
                AttachmentUtils.addSingleAttachment(mp, contentIds, att);
            }
        } else {
            Attachment att;
            HashMap attachmentsMap = new HashMap();
            for (int c = 0; c < attachments.size(); ++c) {
                att = attachments.get(c);
                if (att.getAttachmentType() == Attachment.AttachmentType.CONTENT) continue;
                String partName = att.getPart();
                if (!attachmentsMap.containsKey(partName)) {
                    attachmentsMap.put(partName, new ArrayList());
                }
                ((List)attachmentsMap.get(partName)).add(att);
            }
            Iterator i = attachmentsMap.keySet().iterator();
            while (i.hasNext()) {
                attachments = (List)attachmentsMap.get(i.next());
                if (attachments.size() == 1) {
                    att = (Attachment)attachments.get(0);
                    AttachmentUtils.addSingleAttachment(mp, contentIds, att);
                    continue;
                }
                if (attachments.size() <= 1) continue;
                AttachmentUtils.addMultipartAttachment(mp, contentIds, attachments);
            }
        }
    }

    public static void addMultipartAttachment(MimeMultipart mp, StringToStringMap contentIds, List<Attachment> attachments) throws MessagingException {
        MimeMultipart multipart = new MimeMultipart("mixed");
        long totalSize = 0L;
        for (int c = 0; c < attachments.size(); ++c) {
            Attachment att = attachments.get(c);
            String contentType = att.getContentType();
            totalSize += att.getSize();
            MimeBodyPart part = contentType.startsWith("text/") ? new MimeBodyPart() : new PreencodedMimeBodyPart("binary");
            part.setDataHandler(new DataHandler((DataSource)new AttachmentDataSource(att)));
            AttachmentUtils.initPartContentId(contentIds, part, att, false);
            multipart.addBodyPart((BodyPart)part);
        }
        PreencodedMimeBodyPart part = new PreencodedMimeBodyPart("binary");
        if (totalSize > 512000L) {
            part.setDataHandler(new DataHandler((DataSource)new MultipartAttachmentFileDataSource(multipart)));
        } else {
            part.setDataHandler(new DataHandler((DataSource)new MultipartAttachmentDataSource(multipart)));
        }
        Attachment attachment = attachments.get(0);
        AttachmentUtils.initPartContentId(contentIds, (MimeBodyPart)part, attachment, true);
        mp.addBodyPart((BodyPart)part);
    }

    public static void initPartContentId(StringToStringMap contentIds, MimeBodyPart part, Attachment attachment, boolean isMultipart) throws MessagingException {
        String partName = attachment.getPart();
        String contentID = attachment.getContentID();
        if (StringUtils.hasContent(contentID)) {
            int ix = (contentID = contentID.trim()).indexOf(32);
            if (ix != -1) {
                part.setContentID("<" + (isMultipart ? contentID.substring(ix + 1) : contentID.substring(0, ix)) + ">");
            } else {
                if (!contentID.startsWith("<")) {
                    contentID = "<" + contentID;
                }
                if (!contentID.endsWith(">")) {
                    contentID = contentID + ">";
                }
                part.setContentID(contentID);
            }
        } else if (partName != null && !partName.equals("<anonymous>")) {
            if (contentIds.containsKey(partName)) {
                part.setContentID("<" + (String)contentIds.get(partName) + ">");
            } else {
                part.setContentID("<" + partName + "=" + System.nanoTime() + "@soapui.org>");
            }
        }
        String name = attachment.getName();
        String file = attachment.getUrl();
        if (PathUtils.isFilePath(file)) {
            int ix = file.lastIndexOf(File.separatorChar);
            if (ix == -1) {
                ix = file.lastIndexOf(47);
            }
            if (ix > 0 && ix < file.length() - 1) {
                file = file.substring(ix + 1);
            }
            part.setDisposition("attachment; name=\"" + name + "\"; filename=\"" + file + "\"");
        } else {
            part.setDisposition("attachment; name=\"" + name + "\"");
        }
    }

    public static void addSingleAttachment(MimeMultipart mp, StringToStringMap contentIds, Attachment att) throws MessagingException {
        String contentType = att.getContentType();
        MimeBodyPart part = contentType.startsWith("text/") ? new MimeBodyPart() : new PreencodedMimeBodyPart("binary");
        part.setDataHandler(new DataHandler((DataSource)new AttachmentDataSource(att)));
        AttachmentUtils.initPartContentId(contentIds, part, att, false);
        mp.addBodyPart((BodyPart)part);
    }
}

