/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.transports.http.support.attachments;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.support.AbstractHttpOperation;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.attachments.AttachmentUtils;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.attachments.BodyPartAttachment;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.attachments.BodyPartDataSource;
import com.eviware.soapui.model.iface.Attachment;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.xml.XmlUtils;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class MultipartMessageSupport {
    private final List<BodyPartAttachment> attachments = new ArrayList<BodyPartAttachment>();
    private Attachment rootPart;
    private MimeMessage message;
    private String responseContent;
    private boolean prettyPrint;

    public MultipartMessageSupport(DataSource dataSource, String rootPartId, AbstractHttpOperation operation, boolean isRequest, boolean prettyPrint) throws MessagingException {
        this.prettyPrint = prettyPrint;
        MimeMultipart mp = new MimeMultipart(dataSource);
        this.message = new MimeMessage(AttachmentUtils.JAVAMAIL_SESSION);
        this.message.setContent((Multipart)mp);
        Attachment.AttachmentType attachmentType = Attachment.AttachmentType.MIME;
        for (int c = 0; c < mp.getCount(); ++c) {
            BodyPart bodyPart = mp.getBodyPart(c);
            String contentType = bodyPart.getContentType().toUpperCase();
            if (contentType.startsWith("APPLICATION/XOP+XML")) {
                attachmentType = Attachment.AttachmentType.XOP;
            }
            if (contentType.startsWith("MULTIPART/")) {
                MimeMultipart mp2 = new MimeMultipart((DataSource)new BodyPartDataSource(bodyPart));
                for (int i = 0; i < mp2.getCount(); ++i) {
                    this.attachments.add(new BodyPartAttachment(mp2.getBodyPart(i), operation, isRequest, attachmentType));
                }
                continue;
            }
            BodyPartAttachment attachment = new BodyPartAttachment(bodyPart, operation, isRequest, attachmentType);
            String[] contentIdHeaders = bodyPart.getHeader("Content-ID");
            if (contentIdHeaders != null && contentIdHeaders.length > 0 && contentIdHeaders[0].equals(rootPartId)) {
                this.rootPart = attachment;
                continue;
            }
            this.attachments.add(attachment);
        }
        if (operation != null && this.rootPart == null) {
            this.rootPart = this.attachments.remove(0);
        }
        if (this.rootPart != null) {
            ((BodyPartAttachment)this.rootPart).setAttachmentType(Attachment.AttachmentType.CONTENT);
        }
    }

    public void setOperation(WsdlOperation operation) {
        for (BodyPartAttachment attachment : this.attachments) {
            attachment.setOperation(operation);
        }
    }

    public Attachment[] getAttachments() {
        return this.attachments.toArray(new Attachment[this.attachments.size()]);
    }

    public Attachment getRootPart() {
        return this.rootPart;
    }

    public Attachment[] getAttachmentsForPart(String partName) {
        ArrayList<Attachment> results = new ArrayList<Attachment>();
        for (Attachment attachment : this.attachments) {
            if (!attachment.getPart().equals(partName)) continue;
            results.add(attachment);
        }
        return results.toArray(new Attachment[results.size()]);
    }

    public String getResponseContent() {
        if (this.rootPart == null) {
            return null;
        }
        if (this.responseContent == null) {
            try {
                InputStream in = this.rootPart.getInputStream();
                ByteArrayOutputStream out = Tools.readAll(in, 0L);
                byte[] data = out.toByteArray();
                int contentOffset = 0;
                String contentType = this.rootPart.getContentType();
                if (contentType != null && data.length > 0) {
                    int ix;
                    String charset = null;
                    if (contentType.indexOf("charset=") > 0) {
                        try {
                            ix = contentType.indexOf("charset=");
                            int ix2 = contentType.indexOf(";", ix);
                            charset = ix2 == -1 ? contentType.substring(ix + 8) : contentType.substring(ix + 8, ix2);
                        }
                        catch (Throwable e) {
                            SoapUI.logError(e);
                        }
                    }
                    if ((ix = contentType.indexOf(59)) > 0 && (contentType = contentType.substring(0, ix)).toLowerCase().endsWith("xml") && data.length > 3 && data[0] == -17 && data[1] == -69 && data[2] == -65) {
                        charset = "UTF-8";
                        contentOffset = 3;
                    }
                    String string = this.responseContent = (charset = StringUtils.unquote(charset)) == null ? new String(data) : new String(data, contentOffset, data.length - contentOffset, charset);
                }
                if (this.responseContent == null) {
                    this.responseContent = new String(data);
                }
                return this.responseContent;
            }
            catch (Exception e) {
                SoapUI.logError(e);
            }
        }
        return this.responseContent;
    }

    public String getContentAsString() {
        if (this.responseContent == null) {
            this.getResponseContent();
        }
        if (this.prettyPrint) {
            this.responseContent = XmlUtils.prettyPrintXml(this.responseContent);
            this.prettyPrint = false;
        }
        return this.responseContent;
    }

    public void setResponseContent(String responseContent) {
        this.responseContent = responseContent;
    }

    public Attachment getAttachmentWithContentId(String contentId) {
        for (Attachment attachment : this.attachments) {
            if (!contentId.equals(attachment.getContentID())) continue;
            return attachment;
        }
        return null;
    }
}

