/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.wss.entries;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.WSSEntryConfig;
import com.eviware.soapui.impl.wsdl.support.wss.OutgoingWss;
import com.eviware.soapui.impl.wsdl.support.wss.entries.WssEntryBase;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionContext;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.components.SimpleBindingForm;
import com.eviware.soapui.support.xml.XmlObjectConfigurationBuilder;
import com.eviware.soapui.support.xml.XmlObjectConfigurationReader;
import com.jgoodies.binding.PresentationModel;
import java.security.MessageDigest;
import javax.swing.JComponent;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.message.WSSecUsernameToken;
import org.apache.ws.security.util.Base64;
import org.w3c.dom.Document;

public class UsernameEntry
extends WssEntryBase {
    private static final String PASSWORD_DIGEST_EXT = "PasswordDigest Ext";
    private static final String PASSWORD_DIGEST = "PasswordDigest";
    private static final String PASSWORD_TEXT = "PasswordText";
    public static final String TYPE = "Username";
    private boolean addCreated;
    private boolean addNonce;
    private String passwordType;

    public void init(WSSEntryConfig config, OutgoingWss container) {
        super.init(config, container, TYPE);
    }

    public void process(WSSecHeader secHeader, Document doc, PropertyExpansionContext context) {
        String password;
        WSSecUsernameToken token = new WSSecUsernameToken();
        if (this.addCreated) {
            token.addCreated();
        }
        if (this.addNonce) {
            token.addNonce();
        }
        if (StringUtils.hasContent(this.passwordType)) {
            if (this.passwordType.equals(PASSWORD_TEXT)) {
                token.setPasswordType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText");
            } else if (this.passwordType.equals(PASSWORD_DIGEST) || this.passwordType.equals(PASSWORD_DIGEST_EXT)) {
                token.setPasswordType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest");
            }
        }
        if (PASSWORD_DIGEST_EXT.equals(password = context.expand(this.getPassword()))) {
            try {
                MessageDigest sha = MessageDigest.getInstance("SHA-1");
                sha.reset();
                sha.update(password.getBytes("UTF-8"));
                password = Base64.encode((byte[])sha.digest());
            }
            catch (Exception e) {
                SoapUI.logError(e);
            }
        }
        token.setUserInfo(context.expand(this.getUsername()), password);
        token.build(doc, secHeader);
    }

    protected JComponent buildUI() {
        SimpleBindingForm form = new SimpleBindingForm(new PresentationModel((Object)this));
        form.addSpace(5);
        form.appendTextField("username", TYPE, "The username for this token");
        form.appendPasswordField("password", "Password", "The password for this token");
        form.appendCheckBox("addNonce", "Add Nonce", "Adds a nonce");
        form.appendCheckBox("addCreated", "Add Created", "Adds a created");
        form.appendComboBox("passwordType", "Password Type", new String[]{PASSWORD_TEXT, PASSWORD_DIGEST, PASSWORD_DIGEST_EXT}, "The password type to generate");
        return form.getPanel();
    }

    protected void load(XmlObjectConfigurationReader reader) {
        this.addCreated = reader.readBoolean("addCreated", true);
        this.addNonce = reader.readBoolean("addNonce", true);
        this.passwordType = reader.readString("passwordType", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest");
    }

    protected void save(XmlObjectConfigurationBuilder builder) {
        builder.add("addCreated", this.addCreated);
        builder.add("addNonce", this.addNonce);
        builder.add("passwordType", this.passwordType);
    }

    public boolean isAddCreated() {
        return this.addCreated;
    }

    public void setAddCreated(boolean addCreated) {
        this.addCreated = addCreated;
        this.saveConfig();
    }

    public boolean isAddNonce() {
        return this.addNonce;
    }

    public void setAddNonce(boolean addNonce) {
        this.addNonce = addNonce;
        this.saveConfig();
    }

    public String getPasswordType() {
        return this.passwordType;
    }

    public void setPasswordType(String passwordType) {
        this.passwordType = passwordType;
        this.saveConfig();
    }
}

