/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.wss.entries;

import com.eviware.soapui.config.WSSEntryConfig;
import com.eviware.soapui.impl.wsdl.support.wss.OutgoingWss;
import com.eviware.soapui.impl.wsdl.support.wss.WssContainer;
import com.eviware.soapui.impl.wsdl.support.wss.WssCrypto;
import com.eviware.soapui.impl.wsdl.support.wss.WssEntry;
import com.eviware.soapui.impl.wsdl.support.wss.crypto.CryptoType;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansion;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionContainer;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionsResult;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.types.StringList;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.xml.XmlObjectConfigurationBuilder;
import com.eviware.soapui.support.xml.XmlObjectConfigurationReader;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Merlin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WssEntryBase
implements WssEntry,
PropertyExpansionContainer {
    private WSSEntryConfig config;
    private OutgoingWss outgoingWss;
    private JComponent configComponent;
    private String label;

    public void init(WSSEntryConfig config, OutgoingWss outgoingWss, String label) {
        this.config = config;
        this.outgoingWss = outgoingWss;
        this.label = label;
        if (config.getConfiguration() == null) {
            config.addNewConfiguration();
        }
        this.load(new XmlObjectConfigurationReader(config.getConfiguration()));
    }

    @Override
    public OutgoingWss getOutgoingWss() {
        return this.outgoingWss;
    }

    public String getPassword() {
        String password = this.config.getPassword();
        if (StringUtils.isNullOrEmpty(password)) {
            password = this.outgoingWss.getPassword();
        }
        return password;
    }

    public String getUsername() {
        String username = this.config.getUsername();
        if (StringUtils.isNullOrEmpty(username)) {
            username = this.outgoingWss.getUsername();
        }
        return username;
    }

    public void setPassword(String arg0) {
        this.config.setPassword(arg0);
    }

    public void setUsername(String arg0) {
        this.config.setUsername(arg0);
    }

    @Override
    public JComponent getConfigurationPanel() {
        if (this.configComponent == null) {
            this.configComponent = this.buildUI();
        }
        return this.configComponent;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    protected abstract JComponent buildUI();

    protected abstract void load(XmlObjectConfigurationReader var1);

    public void setConfig(WSSEntryConfig config) {
        this.config = config;
    }

    public void saveConfig() {
        XmlObjectConfigurationBuilder builder = new XmlObjectConfigurationBuilder();
        this.save(builder);
        this.config.getConfiguration().set(builder.finish());
    }

    protected abstract void save(XmlObjectConfigurationBuilder var1);

    public WssContainer getWssContainer() {
        return this.outgoingWss.getWssContainer();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
    }

    @Override
    public PropertyExpansion[] getPropertyExpansions() {
        PropertyExpansionsResult result = new PropertyExpansionsResult(this.getWssContainer().getModelItem(), this);
        this.addPropertyExpansions(result);
        return result.toArray();
    }

    protected void addPropertyExpansions(PropertyExpansionsResult result) {
        if (StringUtils.hasContent(this.config.getUsername())) {
            result.extractAndAddAll("username");
        }
        if (StringUtils.hasContent(this.config.getPassword())) {
            result.extractAndAddAll("password");
        }
    }

    @Override
    public void updateEntryConfig(WSSEntryConfig config) {
        this.config = config;
    }

    public String toString() {
        return this.getLabel();
    }

    protected List<StringToStringMap> readTableValues(XmlObjectConfigurationReader reader, String parameterName) {
        ArrayList<StringToStringMap> result = new ArrayList<StringToStringMap>();
        String[] tableValues = reader.readStrings(parameterName);
        if (tableValues != null && tableValues.length > 0) {
            for (String tableValue : tableValues) {
                result.add(StringToStringMap.fromXml(tableValue));
            }
        }
        return result;
    }

    protected void saveTableValues(XmlObjectConfigurationBuilder builder, List<StringToStringMap> tableValues, String string) {
        for (StringToStringMap tableValue : tableValues) {
            builder.add(string, tableValue.toXml());
        }
    }

    protected Vector<WSEncryptionPart> createWSParts(List<StringToStringMap> parts) {
        Vector<WSEncryptionPart> result = new Vector<WSEncryptionPart>();
        for (StringToStringMap map : parts) {
            String name;
            if (map.hasValue("id")) {
                result.add(new WSEncryptionPart((String)map.get("id"), (String)map.get("enc")));
                continue;
            }
            String ns = (String)map.get("namespace");
            if (ns == null) {
                ns = "";
            }
            if (!StringUtils.hasContent(name = (String)map.get("name"))) continue;
            result.add(new WSEncryptionPart(name, ns, (String)map.get("enc")));
        }
        return result;
    }

    @Override
    public void release() {
    }

    protected class KeyAliasComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private KeyStore keyStore;
        private Object alias;
        private StringList aliases = new StringList();

        public KeyAliasComboBoxModel(WssCrypto crypto) {
            this.update(crypto);
        }

        void update(WssCrypto crypto) {
            try {
                if (crypto == null || crypto.getCrypto() == null) {
                    this.keyStore = null;
                } else {
                    Merlin merlinCrypto = (Merlin)crypto.getCrypto();
                    if (crypto.getType() == CryptoType.KEYSTORE) {
                        this.keyStore = merlinCrypto.getKeyStore();
                    } else if (crypto.getType() == CryptoType.TRUSTSTORE) {
                        this.keyStore = merlinCrypto.getTrustStore();
                    }
                }
            }
            catch (WSSecurityException wssecurityException) {
                wssecurityException.printStackTrace();
            }
            if (this.keyStore != null) {
                if (!this.aliases.isEmpty()) {
                    int sz = this.aliases.size();
                    this.aliases.clear();
                    this.fireIntervalRemoved(this, 0, sz - 1);
                }
                try {
                    Enumeration<String> e = this.keyStore.aliases();
                    while (e.hasMoreElements()) {
                        this.aliases.add(e.nextElement().toString());
                    }
                    this.fireIntervalAdded(this, 0, this.aliases.size() - 1);
                }
                catch (KeyStoreException e) {
                    e.printStackTrace();
                }
            }
        }

        public Object getSelectedItem() {
            return this.alias;
        }

        public void setSelectedItem(Object anItem) {
            this.alias = anItem;
        }

        public Object getElementAt(int index) {
            return this.aliases.get(index);
        }

        public int getSize() {
            return this.aliases.size();
        }
    }

    protected class KeyIdentifierTypeRenderer
    extends DefaultListCellRenderer {
        protected KeyIdentifierTypeRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component result = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value.equals(0)) {
                this.setText("Issuer Name and Serial Number");
            } else if (value.equals(1)) {
                this.setText("Binary Security Token");
            } else if (value.equals(3)) {
                this.setText("X509 Certificate");
            } else if (value.equals(4)) {
                this.setText("Subject Key Identifier");
            } else if (value.equals(5)) {
                this.setText("Embedded KeyInfo");
            } else if (value.equals(6)) {
                this.setText("Embed SecurityToken Reference");
            } else if (value.equals(7)) {
                this.setText("UsernameToken Signature");
            } else if (value.equals(8)) {
                this.setText("Thumbprint SHA1 Identifier");
            } else if (value.equals(9)) {
                this.setText("Custom Reference");
            }
            return result;
        }
    }
}

