/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.testcase;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.LoadTestConfig;
import com.eviware.soapui.config.SecurityTestConfig;
import com.eviware.soapui.config.TestCaseConfig;
import com.eviware.soapui.config.TestStepConfig;
import com.eviware.soapui.config.WsrmVersionTypeConfig;
import com.eviware.soapui.impl.wsdl.AbstractTestPropertyHolderWsdlModelItem;
import com.eviware.soapui.impl.wsdl.WsdlTestSuite;
import com.eviware.soapui.impl.wsdl.loadtest.WsdlLoadTest;
import com.eviware.soapui.impl.wsdl.panels.teststeps.amf.AMFTestRunListener;
import com.eviware.soapui.impl.wsdl.support.wsrm.WsrmTestRunListener;
import com.eviware.soapui.impl.wsdl.support.wsrm.WsrmUtils;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCaseRunner;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.registry.HttpRequestStepFactory;
import com.eviware.soapui.impl.wsdl.teststeps.registry.WsdlTestStepFactory;
import com.eviware.soapui.impl.wsdl.teststeps.registry.WsdlTestStepRegistry;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.security.SecurityScan;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.model.testsuite.LoadTest;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.model.testsuite.TestCaseRunContext;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestRunListener;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.security.SecurityTest;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.swing.ActionList;
import com.eviware.soapui.support.action.swing.DefaultActionList;
import com.eviware.soapui.support.resolver.ResolveDialog;
import com.eviware.soapui.support.scripting.SoapUIScriptEngine;
import com.eviware.soapui.support.scripting.SoapUIScriptEngineRegistry;
import com.eviware.soapui.support.types.StringToObjectMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlTestCase
extends AbstractTestPropertyHolderWsdlModelItem<TestCaseConfig>
implements TestCase {
    private static final Logger logger = Logger.getLogger(WsdlTestCase.class);
    public static final String KEEP_SESSION_PROPERTY = WsdlTestCase.class.getName() + "@keepSession";
    public static final String FAIL_ON_ERROR_PROPERTY = WsdlTestCase.class.getName() + "@failOnError";
    public static final String FAIL_ON_ERRORS_PROPERTY = WsdlTestCase.class.getName() + "@failOnErrors";
    public static final String DISCARD_OK_RESULTS = WsdlTestCase.class.getName() + "@discardOkResults";
    public static final String SETUP_SCRIPT_PROPERTY = WsdlTestCase.class.getName() + "@setupScript";
    public static final String TEARDOWN_SCRIPT_PROPERTY = WsdlTestCase.class.getName() + "@tearDownScript";
    public static final String TIMEOUT_PROPERTY = WsdlTestCase.class.getName() + "@timeout";
    public static final String SEARCH_PROPERTIES_PROPERTY = WsdlTestCase.class.getName() + "@searchProperties";
    private final WsdlTestSuite testSuite;
    private final List<WsdlTestStep> testSteps = new ArrayList<WsdlTestStep>();
    private final List<WsdlLoadTest> loadTests = new ArrayList<WsdlLoadTest>();
    private final List<SecurityTest> securityTests = new ArrayList<SecurityTest>();
    private final Set<TestRunListener> testRunListeners = new HashSet<TestRunListener>();
    private DefaultActionList createActions;
    private final boolean forLoadTest;
    private SoapUIScriptEngine setupScriptEngine;
    private SoapUIScriptEngine tearDownScriptEngine;
    private StringToObjectMap runFromHereContext = new StringToObjectMap();

    public WsdlTestCase(WsdlTestSuite testSuite, TestCaseConfig config, boolean forLoadTest) {
        super(config, testSuite, "/testCase.gif");
        this.testSuite = testSuite;
        this.forLoadTest = forLoadTest;
        if (!((TestCaseConfig)this.getConfig()).isSetProperties()) {
            ((TestCaseConfig)this.getConfig()).addNewProperties();
        }
        this.setPropertiesConfig(((TestCaseConfig)this.getConfig()).getProperties());
        List<TestStepConfig> testStepConfigs = config.getTestStepList();
        ArrayList<TestStepConfig> removed = new ArrayList<TestStepConfig>();
        for (TestStepConfig tsc : testStepConfigs) {
            WsdlTestStep wsdlTestStep = this.createTestStepFromConfig(tsc);
            if (wsdlTestStep != null) {
                this.ensureUniqueName(wsdlTestStep);
                this.testSteps.add(wsdlTestStep);
                continue;
            }
            removed.add(tsc);
        }
        if (removed.size() > 0) {
            testStepConfigs.removeAll(removed);
        }
        if (!forLoadTest) {
            List<LoadTestConfig> loadTestConfigs = config.getLoadTestList();
            for (LoadTestConfig loadTestConfig : loadTestConfigs) {
                WsdlLoadTest loadTest = this.buildLoadTest(loadTestConfig);
                this.loadTests.add(loadTest);
            }
        }
        List<SecurityTestConfig> securityTestConfigs = config.getSecurityTestList();
        for (SecurityTestConfig securityTestConfig : securityTestConfigs) {
            SecurityTest securityTest = this.buildSecurityTest(securityTestConfig);
            this.securityTests.add(securityTest);
        }
        if (!config.isSetFailOnError()) {
            config.setFailOnError(true);
        }
        if (!config.isSetFailTestCaseOnErrors()) {
            config.setFailTestCaseOnErrors(true);
        }
        if (!config.isSetKeepSession()) {
            config.setKeepSession(false);
        }
        if (!config.isSetMaxResults()) {
            config.setMaxResults(0);
        }
        for (TestRunListener testRunListener : SoapUI.getListenerRegistry().getListeners(TestRunListener.class)) {
            this.addTestRunListener(testRunListener);
        }
        WsrmTestRunListener wsrmListener = new WsrmTestRunListener();
        this.addTestRunListener(wsrmListener);
        this.addTestRunListener(new AMFTestRunListener());
    }

    public boolean isForLoadTest() {
        return this.forLoadTest;
    }

    public WsdlLoadTest buildLoadTest(LoadTestConfig tsc) {
        return new WsdlLoadTest(this, tsc);
    }

    public boolean getKeepSession() {
        return ((TestCaseConfig)this.getConfig()).getKeepSession();
    }

    public void setKeepSession(boolean keepSession) {
        boolean old = this.getKeepSession();
        if (old != keepSession) {
            ((TestCaseConfig)this.getConfig()).setKeepSession(keepSession);
            this.notifyPropertyChanged(KEEP_SESSION_PROPERTY, old, keepSession);
        }
    }

    public void setSetupScript(String script) {
        String oldScript = this.getSetupScript();
        if (!((TestCaseConfig)this.getConfig()).isSetSetupScript()) {
            ((TestCaseConfig)this.getConfig()).addNewSetupScript();
        }
        ((TestCaseConfig)this.getConfig()).getSetupScript().setStringValue(script);
        if (this.setupScriptEngine != null) {
            this.setupScriptEngine.setScript(script);
        }
        this.notifyPropertyChanged(SETUP_SCRIPT_PROPERTY, oldScript, script);
    }

    public String getSetupScript() {
        return ((TestCaseConfig)this.getConfig()).isSetSetupScript() ? ((TestCaseConfig)this.getConfig()).getSetupScript().getStringValue() : null;
    }

    public void setTearDownScript(String script) {
        String oldScript = this.getTearDownScript();
        if (!((TestCaseConfig)this.getConfig()).isSetTearDownScript()) {
            ((TestCaseConfig)this.getConfig()).addNewTearDownScript();
        }
        ((TestCaseConfig)this.getConfig()).getTearDownScript().setStringValue(script);
        if (this.tearDownScriptEngine != null) {
            this.tearDownScriptEngine.setScript(script);
        }
        this.notifyPropertyChanged(TEARDOWN_SCRIPT_PROPERTY, oldScript, script);
    }

    public String getTearDownScript() {
        return ((TestCaseConfig)this.getConfig()).isSetTearDownScript() ? ((TestCaseConfig)this.getConfig()).getTearDownScript().getStringValue() : null;
    }

    public boolean getFailOnError() {
        return ((TestCaseConfig)this.getConfig()).getFailOnError();
    }

    public boolean getFailTestCaseOnErrors() {
        return ((TestCaseConfig)this.getConfig()).getFailTestCaseOnErrors();
    }

    public void setFailOnError(boolean failOnError) {
        boolean old = this.getFailOnError();
        if (old != failOnError) {
            ((TestCaseConfig)this.getConfig()).setFailOnError(failOnError);
            this.notifyPropertyChanged(FAIL_ON_ERROR_PROPERTY, old, failOnError);
        }
    }

    public void setFailTestCaseOnErrors(boolean failTestCaseOnErrors) {
        boolean old = this.getFailTestCaseOnErrors();
        if (old != failTestCaseOnErrors) {
            ((TestCaseConfig)this.getConfig()).setFailTestCaseOnErrors(failTestCaseOnErrors);
            this.notifyPropertyChanged(FAIL_ON_ERRORS_PROPERTY, old, failTestCaseOnErrors);
        }
    }

    public boolean getSearchProperties() {
        return ((TestCaseConfig)this.getConfig()).getSearchProperties();
    }

    public void setSearchProperties(boolean searchProperties) {
        boolean old = this.getSearchProperties();
        if (old != searchProperties) {
            ((TestCaseConfig)this.getConfig()).setSearchProperties(searchProperties);
            this.notifyPropertyChanged(SEARCH_PROPERTIES_PROPERTY, old, searchProperties);
        }
    }

    public boolean getDiscardOkResults() {
        return ((TestCaseConfig)this.getConfig()).getDiscardOkResults();
    }

    public void setDiscardOkResults(boolean discardOkResults) {
        boolean old = this.getDiscardOkResults();
        if (old != discardOkResults) {
            ((TestCaseConfig)this.getConfig()).setDiscardOkResults(discardOkResults);
            this.notifyPropertyChanged(DISCARD_OK_RESULTS, old, discardOkResults);
        }
    }

    public int getMaxResults() {
        return ((TestCaseConfig)this.getConfig()).getMaxResults();
    }

    public void setMaxResults(int maxResults) {
        int old = this.getMaxResults();
        if (old != maxResults) {
            ((TestCaseConfig)this.getConfig()).setMaxResults(maxResults);
            this.notifyPropertyChanged("maxResults", old, maxResults);
        }
    }

    private WsdlTestStep createTestStepFromConfig(TestStepConfig tsc) {
        WsdlTestStepFactory factory = WsdlTestStepRegistry.getInstance().getFactory(tsc.getType());
        if (factory != null) {
            WsdlTestStep testStep = factory.buildTestStep(this, tsc, this.forLoadTest);
            return testStep;
        }
        logger.error((Object)("Failed to create test step for [" + tsc.getName() + "]"));
        return null;
    }

    private boolean ensureUniqueName(WsdlTestStep testStep) {
        String name = testStep.getName();
        while (name == null || this.getTestStepByName(name.trim()) != null) {
            if (name == null) {
                name = testStep.getName();
            } else {
                int cnt = 0;
                while (this.getTestStepByName(name.trim()) != null) {
                    name = testStep.getName() + " " + ++cnt;
                }
                if (cnt == 0) break;
            }
            if ((name = UISupport.prompt("TestStep name must be unique, please specify new name for step\n[" + testStep.getName() + "] in TestCase [" + this.getTestSuite().getProject().getName() + "->" + this.getTestSuite().getName() + "->" + this.getName() + "]", "Change TestStep name", name)) != null) continue;
            return false;
        }
        if (!name.equals(testStep.getName())) {
            testStep.setName(name);
        }
        return true;
    }

    public WsdlLoadTest addNewLoadTest(String name) {
        WsdlLoadTest loadTest = this.buildLoadTest(((TestCaseConfig)this.getConfig()).addNewLoadTest());
        loadTest.setStartDelay(0);
        loadTest.setName(name);
        this.loadTests.add(loadTest);
        loadTest.addAssertion("Step Status", "- Any -", false);
        this.getTestSuite().fireLoadTestAdded(loadTest);
        return loadTest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLoadTest(WsdlLoadTest loadTest) {
        int ix = this.loadTests.indexOf(loadTest);
        this.loadTests.remove(ix);
        try {
            this.getTestSuite().fireLoadTestRemoved(loadTest);
        }
        finally {
            loadTest.release();
            ((TestCaseConfig)this.getConfig()).removeLoadTest(ix);
        }
    }

    @Override
    public WsdlTestSuite getTestSuite() {
        return this.testSuite;
    }

    public WsdlTestStep cloneStep(WsdlTestStep testStep, String name) {
        return testStep.clone(this, name);
    }

    @Override
    @Nonnull
    public WsdlTestStep getTestStepAt(int index) {
        return this.testSteps.get(index);
    }

    @Override
    public int getTestStepCount() {
        return this.testSteps.size();
    }

    @Override
    public WsdlLoadTest getLoadTestAt(int index) {
        return this.loadTests.get(index);
    }

    @Override
    public LoadTest getLoadTestByName(String loadTestName) {
        return (LoadTest)((Object)this.getWsdlModelItemByName(this.loadTests, loadTestName));
    }

    @Override
    public int getLoadTestCount() {
        return this.loadTests.size();
    }

    public WsdlTestStep addTestStep(TestStepConfig stepConfig) {
        return this.insertTestStep(stepConfig, -1, true);
    }

    public WsdlTestStep addTestStep(String type, String name) {
        TestStepConfig newStepConfig = WsdlTestStepRegistry.getInstance().getFactory(type).createNewTestStep(this, name);
        if (newStepConfig != null) {
            return this.addTestStep(newStepConfig);
        }
        return null;
    }

    public WsdlTestStep addTestStep(String type, String name, String endpoint, String method) {
        TestStepConfig newStepConfig = ((HttpRequestStepFactory)WsdlTestStepRegistry.getInstance().getFactory(type)).createNewTestStep(this, name, endpoint, method);
        if (newStepConfig != null) {
            return this.addTestStep(newStepConfig);
        }
        return null;
    }

    public WsdlTestStep insertTestStep(String type, String name, int index) {
        TestStepConfig newStepConfig = WsdlTestStepRegistry.getInstance().getFactory(type).createNewTestStep(this, name);
        if (newStepConfig != null) {
            return this.insertTestStep(newStepConfig, index, false);
        }
        return null;
    }

    public WsdlTestStep importTestStep(WsdlTestStep testStep, String name, int index, boolean createCopy) {
        testStep.beforeSave();
        TestStepConfig newStepConfig = (TestStepConfig)((TestStepConfig)testStep.getConfig()).copy();
        newStepConfig.setName(name);
        WsdlTestStep result = this.insertTestStep(newStepConfig, index, createCopy);
        if (result == null) {
            return null;
        }
        if (createCopy) {
            ModelSupport.unsetIds(result);
        }
        this.resolveTestCase();
        return result;
    }

    private void resolveTestCase() {
        ResolveDialog resolver = new ResolveDialog("Validate TestCase", "Checks TestCase for inconsistencies", null);
        resolver.setShowOkMessage(false);
        resolver.resolve(this);
    }

    public WsdlTestStep[] importTestSteps(WsdlTestStep[] testSteps, int index, boolean createCopies) {
        TestStepConfig[] newStepConfigs = new TestStepConfig[testSteps.length];
        for (int c = 0; c < testSteps.length; ++c) {
            testSteps[c].beforeSave();
            newStepConfigs[c] = (TestStepConfig)((TestStepConfig)testSteps[c].getConfig()).copy();
        }
        WsdlTestStep[] result = this.insertTestSteps(newStepConfigs, index, createCopies);
        this.resolveTestCase();
        return result;
    }

    public WsdlTestStep insertTestStep(TestStepConfig stepConfig, int ix) {
        return this.insertTestStep(stepConfig, ix, true);
    }

    public WsdlTestStep insertTestStep(TestStepConfig stepConfig, int ix, boolean clearIds) {
        TestStepConfig newStepConfig = ix == -1 ? ((TestCaseConfig)this.getConfig()).addNewTestStep() : ((TestCaseConfig)this.getConfig()).insertNewTestStep(ix);
        newStepConfig.set(stepConfig);
        WsdlTestStep testStep = this.createTestStepFromConfig(newStepConfig);
        if (!this.ensureUniqueName(testStep)) {
            testStep.release();
            ((TestCaseConfig)this.getConfig()).getTestStepList().remove(newStepConfig);
            return null;
        }
        if (clearIds) {
            ModelSupport.unsetIds(testStep);
        }
        if (ix == -1) {
            this.testSteps.add(testStep);
        } else {
            this.testSteps.add(ix, testStep);
        }
        testStep.afterLoad();
        if (this.getTestSuite() != null) {
            this.getTestSuite().fireTestStepAdded(testStep, ix == -1 ? this.testSteps.size() - 1 : ix);
        }
        this.notifyPropertyChanged("testSteps", null, testStep);
        return testStep;
    }

    public WsdlTestStep[] insertTestSteps(TestStepConfig[] stepConfig, int ix, boolean clearIds) {
        int c;
        WsdlTestStep[] result = new WsdlTestStep[stepConfig.length];
        for (c = 0; c < stepConfig.length; ++c) {
            TestStepConfig newStepConfig = ix == -1 ? ((TestCaseConfig)this.getConfig()).addNewTestStep() : ((TestCaseConfig)this.getConfig()).insertNewTestStep(ix + c);
            newStepConfig.set(stepConfig[c]);
            WsdlTestStep testStep = this.createTestStepFromConfig(newStepConfig);
            if (!this.ensureUniqueName(testStep)) {
                return null;
            }
            if (clearIds) {
                ModelSupport.unsetIds(testStep);
            }
            if (ix == -1) {
                this.testSteps.add(testStep);
            } else {
                this.testSteps.add(ix + c, testStep);
            }
            result[c] = testStep;
        }
        for (c = 0; c < result.length; ++c) {
            result[c].afterLoad();
            if (this.getTestSuite() != null) {
                this.getTestSuite().fireTestStepAdded(result[c], this.getIndexOfTestStep(result[c]));
            }
            this.notifyPropertyChanged("testSteps", null, result[c]);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTestStep(WsdlTestStep testStep) {
        int ix = this.testSteps.indexOf(testStep);
        if (ix == -1) {
            logger.error((Object)("TestStep [" + testStep.getName() + "] passed to removeTestStep in testCase [" + this.getName() + "] not found"));
            return;
        }
        this.testSteps.remove(ix);
        for (SecurityTest securityTest : this.getSecurityTestList()) {
            List<SecurityScan> testStepChecks = securityTest.getTestStepSecurityScans(testStep.getId());
            Iterator<SecurityScan> iterator = testStepChecks.iterator();
            while (iterator.hasNext()) {
                SecurityScan chk = iterator.next();
                securityTest.removeSecurityScanWhenRemoveTestStep(testStep, chk);
                iterator.remove();
            }
        }
        try {
            this.getTestSuite().fireTestStepRemoved(testStep, ix);
        }
        finally {
            this.notifyPropertyChanged("testSteps", testStep, null);
            testStep.release();
            for (int c = 0; c < ((TestCaseConfig)this.getConfig()).sizeOfTestStepArray(); ++c) {
                if (testStep.getConfig() != ((TestCaseConfig)this.getConfig()).getTestStepArray(c)) continue;
                ((TestCaseConfig)this.getConfig()).removeTestStep(c);
                break;
            }
        }
    }

    @Override
    public WsdlTestCaseRunner run(StringToObjectMap properties, boolean async) {
        WsdlTestCaseRunner runner = new WsdlTestCaseRunner(this, properties);
        runner.start(async);
        return runner;
    }

    @Override
    public void addTestRunListener(TestRunListener listener) {
        if (listener == null) {
            throw new RuntimeException("listener must not be null");
        }
        this.testRunListeners.add(listener);
    }

    @Override
    public void removeTestRunListener(TestRunListener listener) {
        this.testRunListeners.remove(listener);
    }

    public TestRunListener[] getTestRunListeners() {
        return this.testRunListeners.toArray(new TestRunListener[this.testRunListeners.size()]);
    }

    public Map<String, TestStep> getTestSteps() {
        HashMap<String, TestStep> result = new HashMap<String, TestStep>();
        for (TestStep testStep : this.testSteps) {
            result.put(testStep.getName(), testStep);
        }
        return result;
    }

    public Map<String, TestStep> getTestStepsOrdered() {
        TreeMap<String, TestStep> result = new TreeMap<String, TestStep>();
        for (TestStep testStep : this.testSteps) {
            result.put(testStep.getName(), testStep);
        }
        return result;
    }

    public Map<String, LoadTest> getLoadTests() {
        HashMap<String, LoadTest> result = new HashMap<String, LoadTest>();
        for (LoadTest loadTest : this.loadTests) {
            result.put(loadTest.getName(), loadTest);
        }
        return result;
    }

    @Override
    public int getIndexOfTestStep(TestStep step) {
        return this.testSteps.indexOf(step);
    }

    @Override
    public void moveTestStep(int ix, int offset) {
        int c;
        if (offset == 0) {
            return;
        }
        WsdlTestStep step = this.testSteps.get(ix);
        if (ix + offset >= this.testSteps.size()) {
            offset = this.testSteps.size() - ix - 1;
        }
        this.testSteps.remove(ix);
        this.testSteps.add(ix + offset, step);
        TestStepConfig[] configs = new TestStepConfig[this.testSteps.size()];
        TestCaseConfig conf = (TestCaseConfig)this.getConfig();
        for (c = 0; c < this.testSteps.size(); ++c) {
            if (offset > 0) {
                if (c < ix) {
                    configs[c] = (TestStepConfig)conf.getTestStepArray(c).copy();
                    continue;
                }
                if (c < ix + offset) {
                    configs[c] = (TestStepConfig)conf.getTestStepArray(c + 1).copy();
                    continue;
                }
                if (c == ix + offset) {
                    configs[c] = (TestStepConfig)conf.getTestStepArray(ix).copy();
                    continue;
                }
                configs[c] = (TestStepConfig)conf.getTestStepArray(c).copy();
                continue;
            }
            configs[c] = c < ix + offset ? (TestStepConfig)conf.getTestStepArray(c).copy() : (c == ix + offset ? (TestStepConfig)conf.getTestStepArray(ix).copy() : (c <= ix ? (TestStepConfig)conf.getTestStepArray(c - 1).copy() : (TestStepConfig)conf.getTestStepArray(c).copy()));
        }
        conf.setTestStepArray(configs);
        for (c = 0; c < configs.length; ++c) {
            this.testSteps.get(c).resetConfigOnMove(conf.getTestStepArray(c));
        }
        this.getTestSuite().fireTestStepMoved(step, ix, offset);
    }

    @Override
    public int getIndexOfLoadTest(LoadTest loadTest) {
        return this.loadTests.indexOf(loadTest);
    }

    @Override
    public int getTestStepIndexByName(String stepName) {
        for (int c = 0; c < this.testSteps.size(); ++c) {
            if (!this.testSteps.get(c).getName().equals(stepName)) continue;
            return c;
        }
        return -1;
    }

    @Override
    public <T extends TestStep> T findPreviousStepOfType(TestStep referenceStep, Class<T> stepClass) {
        int ix;
        int currentStepIndex = this.getIndexOfTestStep(referenceStep);
        for (ix = currentStepIndex - 1; ix >= 0 && !stepClass.isAssignableFrom(this.getTestStepAt(ix).getClass()); --ix) {
        }
        return (T)(ix < 0 ? null : this.getTestStepAt(ix));
    }

    @Override
    public <T extends TestStep> T findNextStepOfType(TestStep referenceStep, Class<T> stepClass) {
        int ix;
        int currentStepIndex = this.getIndexOfTestStep(referenceStep);
        for (ix = currentStepIndex + 1; ix < this.getTestStepCount() && !stepClass.isAssignableFrom(this.getTestStepAt(ix).getClass()); ++ix) {
        }
        return (T)(ix >= this.getTestStepCount() ? null : this.getTestStepAt(ix));
    }

    @Override
    public List<TestStep> getTestStepList() {
        ArrayList<TestStep> result = new ArrayList<TestStep>();
        for (TestStep testStep : this.testSteps) {
            result.add(testStep);
        }
        return result;
    }

    @Override
    public <T extends TestStep> List<T> getTestStepsOfType(Class<T> stepType) {
        ArrayList<TestStep> result = new ArrayList<TestStep>();
        for (TestStep testStep : this.testSteps) {
            if (!testStep.getClass().isAssignableFrom(stepType)) continue;
            result.add(testStep);
        }
        return result;
    }

    @Override
    public WsdlTestStep getTestStepByName(String stepName) {
        return (WsdlTestStep)this.getWsdlModelItemByName(this.testSteps, stepName);
    }

    public WsdlLoadTest cloneLoadTest(WsdlLoadTest loadTest, String name) {
        loadTest.beforeSave();
        LoadTestConfig loadTestConfig = ((TestCaseConfig)this.getConfig()).addNewLoadTest();
        loadTestConfig.set(((LoadTestConfig)loadTest.getConfig()).copy());
        WsdlLoadTest newLoadTest = this.buildLoadTest(loadTestConfig);
        newLoadTest.setName(name);
        ModelSupport.unsetIds(newLoadTest);
        newLoadTest.afterLoad();
        this.loadTests.add(newLoadTest);
        this.getTestSuite().fireLoadTestAdded(newLoadTest);
        return newLoadTest;
    }

    @Override
    public void release() {
        super.release();
        for (WsdlTestStep testStep : this.testSteps) {
            testStep.release();
        }
        for (WsdlLoadTest loadTest : this.loadTests) {
            loadTest.release();
        }
        for (SecurityTest securityTest : this.securityTests) {
            securityTest.release();
        }
        this.testRunListeners.clear();
        if (this.setupScriptEngine != null) {
            this.setupScriptEngine.release();
        }
        if (this.tearDownScriptEngine != null) {
            this.tearDownScriptEngine.release();
        }
    }

    public ActionList getCreateActions() {
        return this.createActions;
    }

    public void resetConfigOnMove(TestCaseConfig testCaseConfig) {
        this.setConfig(testCaseConfig);
        int mod = 0;
        List<TestStepConfig> configs = ((TestCaseConfig)this.getConfig()).getTestStepList();
        for (int c = 0; c < configs.size(); ++c) {
            if (WsdlTestStepRegistry.getInstance().hasFactory(configs.get(c))) {
                this.testSteps.get(c - mod).resetConfigOnMove(configs.get(c));
                continue;
            }
            ++mod;
        }
        List<LoadTestConfig> loadTestConfigs = ((TestCaseConfig)this.getConfig()).getLoadTestList();
        for (int c = 0; c < loadTestConfigs.size(); ++c) {
            this.loadTests.get(c).resetConfigOnMove(loadTestConfigs.get(c));
        }
        List<SecurityTestConfig> securityTestConfigs = ((TestCaseConfig)this.getConfig()).getSecurityTestList();
        for (int c = 0; c < securityTestConfigs.size(); ++c) {
            this.securityTests.get(c).resetConfigOnMove(securityTestConfigs.get(c));
        }
        this.setPropertiesConfig(testCaseConfig.getProperties());
    }

    @Override
    public List<LoadTest> getLoadTestList() {
        ArrayList<LoadTest> result = new ArrayList<LoadTest>();
        for (LoadTest loadTest : this.loadTests) {
            result.add(loadTest);
        }
        return result;
    }

    public Object runSetupScript(TestCaseRunContext runContext, TestCaseRunner runner) throws Exception {
        String script = this.getSetupScript();
        if (StringUtils.isNullOrEmpty(script)) {
            return null;
        }
        if (this.setupScriptEngine == null) {
            this.setupScriptEngine = SoapUIScriptEngineRegistry.create(this);
            this.setupScriptEngine.setScript(script);
        }
        this.setupScriptEngine.setVariable("testCase", this);
        this.setupScriptEngine.setVariable("context", runContext);
        this.setupScriptEngine.setVariable("testRunner", runner);
        this.setupScriptEngine.setVariable("log", SoapUI.ensureGroovyLog());
        return this.setupScriptEngine.run();
    }

    public Object runTearDownScript(TestCaseRunContext runContext, TestCaseRunner runner) throws Exception {
        String script = this.getTearDownScript();
        if (StringUtils.isNullOrEmpty(script)) {
            return null;
        }
        if (this.tearDownScriptEngine == null) {
            this.tearDownScriptEngine = SoapUIScriptEngineRegistry.create(this);
            this.tearDownScriptEngine.setScript(script);
        }
        this.tearDownScriptEngine.setVariable("context", runContext);
        this.tearDownScriptEngine.setVariable("testCase", this);
        this.tearDownScriptEngine.setVariable("testRunner", runner);
        this.tearDownScriptEngine.setVariable("log", SoapUI.ensureGroovyLog());
        return this.tearDownScriptEngine.run();
    }

    @Override
    public List<? extends ModelItem> getChildren() {
        ArrayList<ModelItem> result = new ArrayList<ModelItem>();
        result.addAll(this.getTestStepList());
        result.addAll(this.getLoadTestList());
        result.addAll(this.getSecurityTestList());
        return result;
    }

    @Override
    public void setName(String name) {
        String oldLabel = this.getLabel();
        super.setName(name);
        String label = this.getLabel();
        if (oldLabel != null && !oldLabel.equals(label)) {
            this.notifyPropertyChanged(LABEL_PROPERTY, oldLabel, label);
        }
    }

    @Override
    public String getLabel() {
        String name = this.getName();
        if (this.isDisabled()) {
            return name + " (disabled)";
        }
        return name;
    }

    @Override
    public boolean isDisabled() {
        return ((TestCaseConfig)this.getConfig()).getDisabled();
    }

    public void setDisabled(boolean disabled) {
        String oldLabel = this.getLabel();
        boolean oldDisabled = this.isDisabled();
        if (oldDisabled == disabled) {
            return;
        }
        if (disabled) {
            ((TestCaseConfig)this.getConfig()).setDisabled(disabled);
        } else if (((TestCaseConfig)this.getConfig()).isSetDisabled()) {
            ((TestCaseConfig)this.getConfig()).unsetDisabled();
        }
        this.notifyPropertyChanged(DISABLED_PROPERTY, oldDisabled, disabled);
        String label = this.getLabel();
        if (!oldLabel.equals(label)) {
            this.notifyPropertyChanged(LABEL_PROPERTY, oldLabel, label);
        }
    }

    public long getTimeout() {
        return ((TestCaseConfig)this.getConfig()).getTimeout();
    }

    public void setTimeout(long timeout) {
        long old = this.getTimeout();
        ((TestCaseConfig)this.getConfig()).setTimeout(timeout);
        this.notifyPropertyChanged(TIMEOUT_PROPERTY, old, timeout);
    }

    public void exportTestCase(File file) {
        try {
            ((TestCaseConfig)this.getConfig()).newCursor().save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void afterCopy(WsdlTestSuite oldTestSuite, WsdlTestCase oldTestCase) {
        for (WsdlTestStep testStep : this.testSteps) {
            testStep.afterCopy(oldTestSuite, oldTestCase);
        }
    }

    public void importSecurityTests(WsdlTestSuite oldTestSuite, WsdlTestCase oldTestCase) {
        for (SecurityTest secTest : oldTestCase.getSecurityTestList()) {
            SecurityTest newSecurityTest = this.addNewSecurityTest(secTest.getName());
            for (int i = 0; i < oldTestCase.getTestStepList().size(); ++i) {
                WsdlTestStep oldStep = oldTestCase.getTestStepAt(i);
                WsdlTestStep newStep = this.getTestStepAt(i);
                for (SecurityScan secCheck : secTest.getTestStepSecurityScans(oldStep.getId())) {
                    newSecurityTest.importSecurityScan(newStep, secCheck, true);
                }
            }
        }
    }

    public void setWsrmEnabled(boolean enabled) {
        ((TestCaseConfig)this.getConfig()).setWsrmEnabled(enabled);
    }

    public void setWsrmAckTo(String ackTo) {
        ((TestCaseConfig)this.getConfig()).setWsrmAckTo(ackTo);
    }

    public void setWsrmExpires(Long expires) {
        ((TestCaseConfig)this.getConfig()).setWsrmExpires(expires);
    }

    public void setWsrmVersion(String version) {
        ((TestCaseConfig)this.getConfig()).setWsrmVersion(WsrmVersionTypeConfig.Enum.forString(version));
    }

    public boolean getWsrmEnabled() {
        return ((TestCaseConfig)this.getConfig()).getWsrmEnabled();
    }

    public String getWsrmAckTo() {
        return ((TestCaseConfig)this.getConfig()).getWsrmAckTo();
    }

    public long getWsrmExpires() {
        return ((TestCaseConfig)this.getConfig()).getWsrmExpires();
    }

    public String getWsrmVersion() {
        if (((TestCaseConfig)this.getConfig()).getWsrmVersion() == null) {
            return WsrmVersionTypeConfig.X_1_0.toString();
        }
        return ((TestCaseConfig)this.getConfig()).getWsrmVersion().toString();
    }

    public String getWsrmVersionNamespace() {
        return WsrmUtils.getWsrmVersionNamespace(((TestCaseConfig)this.getConfig()).getWsrmVersion());
    }

    public void setAmfAuthorisation(boolean enabled) {
        ((TestCaseConfig)this.getConfig()).setAmfAuthorisation(enabled);
    }

    public boolean getAmfAuthorisation() {
        return ((TestCaseConfig)this.getConfig()).getAmfAuthorisation();
    }

    public void setAmfLogin(String login) {
        ((TestCaseConfig)this.getConfig()).setAmfLogin(login);
    }

    public String getAmfLogin() {
        if (((TestCaseConfig)this.getConfig()).getAmfLogin() == null) {
            return "";
        }
        return ((TestCaseConfig)this.getConfig()).getAmfLogin();
    }

    public void setAmfPassword(String password) {
        ((TestCaseConfig)this.getConfig()).setAmfPassword(password);
    }

    public String getAmfPassword() {
        if (((TestCaseConfig)this.getConfig()).getAmfPassword() == null) {
            return "";
        }
        return ((TestCaseConfig)this.getConfig()).getAmfPassword();
    }

    public void setAmfEndpoint(String endpoint) {
        ((TestCaseConfig)this.getConfig()).setAmfEndpoint(endpoint);
    }

    public String getAmfEndpoint() {
        if (((TestCaseConfig)this.getConfig()).getAmfEndpoint() == null) {
            return "";
        }
        return ((TestCaseConfig)this.getConfig()).getAmfEndpoint();
    }

    @Override
    public int getSecurityTestCount() {
        return this.securityTests.size();
    }

    @Override
    public int getIndexOfSecurityTest(SecurityTest securityTest) {
        return this.securityTests.indexOf(securityTest);
    }

    @Override
    public SecurityTest getSecurityTestAt(int index) {
        return this.securityTests.get(index);
    }

    @Override
    public SecurityTest getSecurityTestByName(String securityTestName) {
        return (SecurityTest)this.getWsdlModelItemByName(this.securityTests, securityTestName);
    }

    @Override
    public List<SecurityTest> getSecurityTestList() {
        return this.securityTests;
    }

    public Map<String, SecurityTest> getSecurityTests() {
        HashMap<String, SecurityTest> result = new HashMap<String, SecurityTest>();
        for (SecurityTest securityTest : this.securityTests) {
            result.put(securityTest.getName(), securityTest);
        }
        return result;
    }

    public SecurityTest addNewSecurityTest(String name) {
        SecurityTest securityTest = this.buildSecurityTest(((TestCaseConfig)this.getConfig()).addNewSecurityTest());
        securityTest.setName(name);
        securityTest.setFailOnError(true);
        securityTest.setSkipDataSourceLoops(false);
        this.securityTests.add(securityTest);
        this.getTestSuite().fireSecurityTestAdded(securityTest);
        return securityTest;
    }

    protected SecurityTest buildSecurityTest(SecurityTestConfig addNewSecurityTest) {
        return new SecurityTest(this, addNewSecurityTest);
    }

    public SecurityTest cloneSecurityTest(SecurityTest securityTest, String name) {
        SecurityTestConfig securityTestConfig = ((TestCaseConfig)this.getConfig()).addNewSecurityTest();
        securityTestConfig.set(((SecurityTestConfig)securityTest.getConfig()).copy());
        SecurityTest newSecurityTest = this.buildSecurityTest(securityTestConfig);
        newSecurityTest.setName(name);
        ModelSupport.unsetIds(newSecurityTest);
        newSecurityTest.afterLoad();
        this.securityTests.add(newSecurityTest);
        this.getTestSuite().fireSecurityTestAdded(newSecurityTest);
        return newSecurityTest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSecurityTest(SecurityTest securityTest) {
        int ix = this.securityTests.indexOf(securityTest);
        this.securityTests.remove(ix);
        try {
            this.getTestSuite().fireSecurityTestRemoved(securityTest);
        }
        finally {
            securityTest.release();
            ((TestCaseConfig)this.getConfig()).removeSecurityTest(ix);
        }
    }

    public StringToObjectMap getRunFromHereContext() {
        return this.runFromHereContext;
    }

    public void setRunFromHereContext(StringToObjectMap runFromHereContext) {
        if (!this.isForLoadTest()) {
            this.runFromHereContext = new StringToObjectMap(runFromHereContext);
        }
    }
}

