/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.TestStepConfig;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStepResult;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStepWithProperties;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansion;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionContainer;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionUtils;
import com.eviware.soapui.model.support.DefaultTestStepProperty;
import com.eviware.soapui.model.testsuite.TestCaseRunContext;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestStepResult;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.xml.XmlObjectConfigurationBuilder;
import com.eviware.soapui.support.xml.XmlObjectConfigurationReader;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public class WsdlDelayTestStep
extends WsdlTestStepWithProperties
implements PropertyExpansionContainer {
    private static final String DEFAULT_DELAY = "1000";
    private static final int DELAY_CHUNK = 100;
    private int delay = 0;
    private String delayString = "1000";
    private int timeWaited = 0;
    private boolean canceled;
    private boolean running;

    public WsdlDelayTestStep(WsdlTestCase testCase, TestStepConfig config, boolean forLoadTest) {
        super(testCase, config, false, forLoadTest);
        if (!forLoadTest) {
            this.setIcon(UISupport.createImageIcon("/wait.gif"));
        }
        if (config.getConfig() == null) {
            if (!forLoadTest) {
                this.saveDelay(config);
            }
        } else {
            this.readConfig(config);
        }
        this.addProperty(new DefaultTestStepProperty("delay", true, new DefaultTestStepProperty.PropertyHandlerAdapter(){

            public String getValue(DefaultTestStepProperty property) {
                return WsdlDelayTestStep.this.getDelayString();
            }

            public void setValue(DefaultTestStepProperty property, String value) {
                WsdlDelayTestStep.this.setDelayString(value);
            }
        }, this));
    }

    private void readConfig(TestStepConfig config) {
        XmlObjectConfigurationReader reader = new XmlObjectConfigurationReader(config.getConfig());
        this.delayString = reader.readString("delay", DEFAULT_DELAY);
    }

    public String getLabel() {
        String str;
        String string = str = this.running ? super.getName() + " [" + (this.delay - this.timeWaited) + "ms]" : super.getName() + " [" + this.delayString + "]";
        if (this.isDisabled()) {
            str = str + " (disabled)";
        }
        return str;
    }

    public String getDefaultSourcePropertyName() {
        return "delay";
    }

    public String getDefaultTargetPropertyName() {
        return "delay";
    }

    public PropertyExpansion[] getPropertyExpansions() {
        ArrayList<? extends PropertyExpansion> result = new ArrayList<PropertyExpansion>();
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(this, this, "delayString"));
        return result.toArray(new PropertyExpansion[result.size()]);
    }

    private void saveDelay(TestStepConfig config) {
        XmlObjectConfigurationBuilder builder = new XmlObjectConfigurationBuilder();
        builder.add("delay", this.delayString);
        config.setConfig(builder.finish());
    }

    public void resetConfigOnMove(TestStepConfig config) {
        super.resetConfigOnMove(config);
        this.readConfig(config);
    }

    public void setDelayString(String delayString) {
        if (this.delayString.equals(delayString)) {
            return;
        }
        String oldLabel = this.getLabel();
        this.delayString = delayString;
        this.saveDelay((TestStepConfig)this.getConfig());
        this.notifyPropertyChanged(WsdlTestStep.LABEL_PROPERTY, oldLabel, this.getLabel());
        this.firePropertyValueChanged("delay", oldLabel, this.getLabel());
    }

    public String getDelayString() {
        return this.delayString;
    }

    public int getDelay() {
        try {
            return Integer.parseInt(PropertyExpander.expandProperties(this, this.delayString));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public void setDelay(int delay) {
        String oldLabel = this.getLabel();
        this.delayString = String.valueOf(delay);
        this.saveDelay((TestStepConfig)this.getConfig());
        this.notifyPropertyChanged(WsdlTestStep.LABEL_PROPERTY, oldLabel, this.getLabel());
        this.firePropertyValueChanged("delay", oldLabel, this.getLabel());
    }

    public TestStepResult run(TestCaseRunner testRunner, TestCaseRunContext context) {
        WsdlTestStepResult result = new WsdlTestStepResult(this);
        result.startTimer();
        String oldLabel = this.getLabel();
        try {
            this.canceled = false;
            this.running = true;
            try {
                this.delay = Integer.parseInt(PropertyExpander.expandProperties(context, this.delayString));
            }
            catch (NumberFormatException e) {
                this.delay = Integer.parseInt(DEFAULT_DELAY);
            }
            long stopTime = System.currentTimeMillis() + (long)this.delay;
            int lastUpdate = 0;
            while (!this.canceled && this.timeWaited < this.delay) {
                if (this.timeWaited - lastUpdate > 1000 && context.getProperty("LoadTestRunner") == null) {
                    String newLabel = this.getLabel();
                    if (!UISupport.isHeadless()) {
                        final String finalOldLabel = oldLabel;
                        final String finalNewLabel = newLabel;
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                WsdlDelayTestStep.this.notifyPropertyChanged(WsdlTestStep.LABEL_PROPERTY, finalOldLabel, finalNewLabel);
                            }
                        });
                    }
                    oldLabel = newLabel;
                    lastUpdate = this.timeWaited;
                }
                Thread.sleep(Math.min(100, this.delay - this.timeWaited));
                this.timeWaited = this.delay - (int)(stopTime - System.currentTimeMillis());
            }
        }
        catch (InterruptedException e) {
            SoapUI.logError(e);
        }
        result.stopTimer();
        result.setStatus(this.canceled ? TestStepResult.TestStepStatus.CANCELED : TestStepResult.TestStepStatus.OK);
        this.timeWaited = 0;
        this.running = false;
        if (context.getProperty("LoadTestRunner") == null) {
            this.notifyPropertyChanged(WsdlTestStep.LABEL_PROPERTY, oldLabel, this.getLabel());
        }
        return result;
    }

    public boolean cancel() {
        this.canceled = true;
        return true;
    }
}

