/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps;

import com.eviware.soapui.config.TestStepConfig;
import com.eviware.soapui.impl.wsdl.AbstractWsdlModelItem;
import com.eviware.soapui.impl.wsdl.WsdlTestSuite;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequest;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.PanelBuilder;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.propertyexpansion.MutablePropertyExpansion;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansion;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionUtils;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.model.testsuite.TestCaseRunContext;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.support.UISupport;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WsdlTestStep
extends AbstractWsdlModelItem<TestStepConfig>
implements TestStep {
    private final WsdlTestCase testCase;
    private final boolean forLoadTest;
    private final boolean hasEditor;

    protected WsdlTestStep(WsdlTestCase testCase, TestStepConfig config, boolean hasEditor, boolean forLoadTest) {
        super(config, testCase, null);
        this.testCase = testCase;
        this.hasEditor = hasEditor;
        this.forLoadTest = forLoadTest;
    }

    public boolean hasEditor() {
        return this.hasEditor;
    }

    public boolean isForLoadTest() {
        return this.forLoadTest;
    }

    protected PanelBuilder<?> createPanelBuilder() {
        return null;
    }

    @Override
    public WsdlTestCase getTestCase() {
        return this.testCase;
    }

    public void resetConfigOnMove(TestStepConfig config) {
        this.setConfig(config);
    }

    @Override
    public boolean cancel() {
        return false;
    }

    @Override
    public String getLabel() {
        String name = this.getName();
        if (this.isDisabled()) {
            return name + " (disabled)";
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setName(String name) {
        if (this.getName().equals(name)) {
            return;
        }
        UISupport.setHourglassCursor();
        try {
            PropertyExpansion[] propertyExpansions;
            ArrayList<MutablePropertyExpansion> result = new ArrayList<MutablePropertyExpansion>();
            ArrayList<MutablePropertyExpansion> properties = new ArrayList<MutablePropertyExpansion>();
            for (PropertyExpansion pe : propertyExpansions = PropertyExpansionUtils.getPropertyExpansions(this.getTestCase(), true, true)) {
                MutablePropertyExpansion mpe = (MutablePropertyExpansion)pe;
                ModelItem modelItem = mpe.getProperty().getModelItem();
                if (modelItem != this && (!(modelItem instanceof WsdlTestRequest) || ((WsdlTestRequest)modelItem).getTestStep() != this)) continue;
                properties.add(mpe);
            }
            String oldLabel = this.getLabel();
            super.setName(name);
            String label = this.getLabel();
            if (!oldLabel.equals(label)) {
                this.notifyPropertyChanged(LABEL_PROPERTY, oldLabel, label);
            }
            for (MutablePropertyExpansion mpe : properties) {
                try {
                    mpe.update();
                    result.add(mpe);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            UISupport.resetCursor();
        }
    }

    public boolean dependsOn(AbstractWsdlModelItem<?> modelItem) {
        return false;
    }

    public String getTestStepTitle() {
        return this.getTestCase().getTestSuite().getName() + "#" + this.getTestCase().getName();
    }

    public WsdlTestStep clone(WsdlTestCase targetTestCase, String name) {
        this.beforeSave();
        TestStepConfig newConfig = (TestStepConfig)((TestStepConfig)this.getConfig()).copy();
        newConfig.setName(name);
        WsdlTestStep result = targetTestCase.addTestStep(newConfig);
        ModelSupport.unsetIds(result);
        return result;
    }

    @Override
    public void finish(TestCaseRunner testRunner, TestCaseRunContext testRunContext) {
    }

    @Override
    public void prepare(TestCaseRunner testRunner, TestCaseRunContext testRunContext) throws Exception {
    }

    public Collection<Interface> getRequiredInterfaces() {
        return new ArrayList<Interface>();
    }

    @Override
    public boolean isDisabled() {
        return ((TestStepConfig)this.getConfig()).getDisabled();
    }

    public void setDisabled(boolean disabled) {
        String oldLabel = this.getLabel();
        boolean oldDisabled = this.isDisabled();
        if (oldDisabled == disabled) {
            return;
        }
        if (disabled) {
            ((TestStepConfig)this.getConfig()).setDisabled(disabled);
        } else if (((TestStepConfig)this.getConfig()).isSetDisabled()) {
            ((TestStepConfig)this.getConfig()).unsetDisabled();
        }
        this.notifyPropertyChanged(DISABLED_PROPERTY, oldDisabled, disabled);
        String label = this.getLabel();
        this.notifyPropertyChanged(LABEL_PROPERTY, oldLabel, label);
    }

    @Override
    public ModelItem getModelItem() {
        return this;
    }

    @Override
    public String getPropertiesLabel() {
        return "Custom Properties";
    }

    public String getDefaultSourcePropertyName() {
        return null;
    }

    public String getDefaultTargetPropertyName() {
        return null;
    }

    public void afterCopy(WsdlTestSuite oldTestSuite, WsdlTestCase oldTestCase) {
    }
}

