/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps.actions;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.panels.request.StringToStringMapTableModel;
import com.eviware.soapui.impl.wsdl.support.MessageExchangeRequestMessageEditor;
import com.eviware.soapui.impl.wsdl.support.MessageExchangeResponseMessageEditor;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.MessageExchange;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.model.testsuite.AssertedXPath;
import com.eviware.soapui.model.testsuite.RequestAssertedMessageExchange;
import com.eviware.soapui.model.testsuite.ResponseAssertedMessageExchange;
import com.eviware.soapui.support.DescriptionPanel;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.ui.desktop.DesktopPanel;
import com.eviware.soapui.ui.support.DefaultDesktopPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShowMessageExchangeAction
extends AbstractAction {
    private DefaultDesktopPanel desktopPanel;
    private final MessageExchange messageExchange;
    private final String ownerName;
    private MessageExchangeResponseMessageEditor responseMessageEditor;
    private MessageExchangeRequestMessageEditor requestMessageEditor;

    public ShowMessageExchangeAction(MessageExchange messageExchange, String ownerName) {
        super("Show Message Exchange");
        this.ownerName = ownerName;
        this.messageExchange = messageExchange;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            UISupport.showDesktopPanel(this.buildFrame());
        }
        catch (Exception ex) {
            SoapUI.logError(ex);
        }
    }

    private DesktopPanel buildFrame() {
        if (this.desktopPanel == null) {
            this.desktopPanel = new MessageExchangeDesktopPanel("Message Viewer", "Message for " + this.ownerName, this.buildContent());
        }
        return this.desktopPanel;
    }

    private JComponent buildContent() {
        JTabbedPane messageTabs = new JTabbedPane();
        messageTabs.addTab("Request Message", this.buildRequestTab());
        messageTabs.addTab("Response Message", this.buildResponseTab());
        messageTabs.addTab("Properties", this.buildPropertiesTab());
        String[] messages = this.messageExchange.getMessages();
        if (messages != null && messages.length > 0) {
            messageTabs.addTab("Messages", this.buildMessagesTab());
        }
        if (this.getAssertedXPaths().size() > 0) {
            messageTabs.addTab("XPath Assertions", this.buildAssertionsTab());
        }
        messageTabs.setPreferredSize(new Dimension(500, 400));
        JPanel tabPanel = UISupport.createTabPanel(messageTabs, true);
        DescriptionPanel descriptionPanel = UISupport.buildDescription("MessageExchange Results", "See the request/response message below", null);
        tabPanel.add((Component)descriptionPanel, "North");
        return tabPanel;
    }

    private Component buildAssertionsTab() {
        List<AssertedXPath> assertedXPaths = this.getAssertedXPaths();
        DefaultTableModel tm = new DefaultTableModel(assertedXPaths.size(), 2);
        tm.setColumnIdentifiers(new String[]{"Label", "XPath"});
        JXTable table = new JXTable((TableModel)tm);
        table.setHorizontalScrollEnabled(true);
        table.getColumn(0).setPreferredWidth(100);
        for (int c = 0; c < assertedXPaths.size(); ++c) {
            tm.setValueAt(assertedXPaths.get(c).getLabel(), c, 0);
            tm.setValueAt(assertedXPaths.get(c).getPath(), c, 1);
        }
        return new JScrollPane((Component)table);
    }

    private List<AssertedXPath> getAssertedXPaths() {
        AssertedXPath[] xpaths;
        ArrayList<AssertedXPath> assertedXPaths = new ArrayList<AssertedXPath>();
        if (this.messageExchange instanceof RequestAssertedMessageExchange && (xpaths = ((RequestAssertedMessageExchange)this.messageExchange).getAssertedXPathsForRequest()) != null && xpaths.length > 0) {
            assertedXPaths.addAll(Arrays.asList(xpaths));
        }
        if (this.messageExchange instanceof ResponseAssertedMessageExchange && (xpaths = ((ResponseAssertedMessageExchange)this.messageExchange).getAssertedXPathsForResponse()) != null && xpaths.length > 0) {
            assertedXPaths.addAll(Arrays.asList(xpaths));
        }
        return assertedXPaths;
    }

    private Component buildPropertiesTab() {
        StringToStringMap properties = new StringToStringMap();
        if (this.messageExchange != null && this.messageExchange.getProperties() != null) {
            properties.putAll(this.messageExchange.getProperties());
            properties.put("Timestamp", new Date(this.messageExchange.getTimestamp()).toString());
            properties.put("Time Taken", String.valueOf(this.messageExchange.getTimeTaken()));
        }
        JTable table = new JTable(new StringToStringMapTableModel(properties, "Name", "Value", false));
        return new JScrollPane(table);
    }

    private Component buildMessagesTab() {
        String[] messages = this.messageExchange.getMessages();
        return messages == null || messages.length == 0 ? new JLabel("No messages to display") : new JScrollPane(new JList<String>(messages));
    }

    private Component buildResponseTab() {
        this.responseMessageEditor = new MessageExchangeResponseMessageEditor(this.messageExchange);
        return this.responseMessageEditor;
    }

    private Component buildRequestTab() {
        this.requestMessageEditor = new MessageExchangeRequestMessageEditor(this.messageExchange);
        return this.requestMessageEditor;
    }

    private final class MessageExchangeDesktopPanel
    extends DefaultDesktopPanel {
        private MessageExchangeDesktopPanel(String title, String description, JComponent component) {
            super(title, description, component);
        }

        public boolean onClose(boolean canCancel) {
            ShowMessageExchangeAction.this.requestMessageEditor.release();
            ShowMessageExchangeAction.this.responseMessageEditor.release();
            ShowMessageExchangeAction.this.desktopPanel = null;
            return super.onClose(canCancel);
        }

        public boolean dependsOn(ModelItem modelItem) {
            return ModelSupport.dependsOn(ShowMessageExchangeAction.this.messageExchange.getModelItem(), modelItem);
        }
    }
}

