/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps.assertions.soap;

import com.eviware.soapui.config.TestAssertionConfig;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.panels.assertions.AssertionListEntry;
import com.eviware.soapui.impl.wsdl.submit.WsdlMessageExchange;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlContext;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlValidator;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlMessageAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.AbstractTestAssertionFactory;
import com.eviware.soapui.model.TestPropertyHolder;
import com.eviware.soapui.model.iface.MessageExchange;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.testsuite.Assertable;
import com.eviware.soapui.model.testsuite.AssertionError;
import com.eviware.soapui.model.testsuite.AssertionException;
import com.eviware.soapui.model.testsuite.ResponseAssertion;

public class SoapResponseAssertion
extends WsdlMessageAssertion
implements ResponseAssertion {
    public static final String ID = "SOAP Response";
    public static final String LABEL = "SOAP Response";
    public static final String DESCRIPTION = "Validates that the last received response is a valid SOAP Response. Applicable to SOAP TestRequest Steps only.";

    public SoapResponseAssertion(TestAssertionConfig assertionConfig, Assertable assertable) {
        super(assertionConfig, assertable, false, false, false, true);
    }

    protected String internalAssertResponse(MessageExchange messageExchange, SubmitContext context) throws AssertionException {
        WsdlContext wsdlContext = ((WsdlMessageExchange)messageExchange).getOperation().getInterface().getWsdlContext();
        WsdlValidator validator = new WsdlValidator(wsdlContext);
        try {
            AssertionError[] errors = validator.assertResponse((WsdlMessageExchange)messageExchange, true);
            if (errors.length > 0) {
                throw new AssertionException(errors);
            }
        }
        catch (AssertionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AssertionException(new AssertionError(e.getMessage()));
        }
        return "Response Envelope OK";
    }

    protected String internalAssertProperty(TestPropertyHolder source, String propertyName, MessageExchange messageExchange, SubmitContext context) throws AssertionException {
        return null;
    }

    protected String internalAssertRequest(MessageExchange messageExchange, SubmitContext context) throws AssertionException {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    extends AbstractTestAssertionFactory {
        public Factory() {
            super("SOAP Response", "SOAP Response", SoapResponseAssertion.class, WsdlRequest.class);
        }

        @Override
        public String getCategory() {
            return "Compliance, Status and Standards";
        }

        @Override
        public Class<? extends WsdlMessageAssertion> getAssertionClassType() {
            return SoapResponseAssertion.class;
        }

        @Override
        public AssertionListEntry getAssertionListEntry() {
            return new AssertionListEntry("SOAP Response", "SOAP Response", SoapResponseAssertion.DESCRIPTION);
        }
    }
}

