/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.integration.impl;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.integration.TestCaseEditIntegration;
import com.eviware.soapui.integration.impl.CajoClient;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.project.Project;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.model.testsuite.TestSuite;
import com.eviware.soapui.model.workspace.Workspace;
import com.eviware.soapui.support.SoapUIException;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import java.awt.Frame;
import java.io.File;
import java.util.List;

public class TestCaseEditIntegrationImpl
implements TestCaseEditIntegration {
    public void editTestCase(String project, String testSuite, String testCase) {
    }

    public void test() {
        CajoClient.getInstance().setLoadUIPath();
    }

    public String getSoapUIPath() {
        String path;
        String os = System.getProperty("os.name");
        if (os == null) {
            return null;
        }
        String ext = os.indexOf("Windows") >= 0 ? "bat" : (os.indexOf("Mac OS X") >= 0 ? "command" : "sh");
        String pro = "";
        Frame mainFrame = UISupport.getMainFrame();
        if (mainFrame != null && mainFrame.getTitle().toLowerCase().indexOf("pro") > -1) {
            pro = "-pro";
        }
        if ((path = System.getProperty("soapui.home")) == null) {
            return null;
        }
        File pathFile = new File(path);
        path = pathFile.getAbsolutePath();
        File f = new File(path = path + File.separator + "bin" + File.separator + "soapui" + pro + "." + ext);
        if (f.exists()) {
            return f.getAbsolutePath();
        }
        return null;
    }

    public void printLog(String log) {
        SoapUI.log(log);
    }

    public void openProject(String[] parameters) {
        if (parameters != null && parameters.length == 1) {
            String projectFilePath = parameters[0];
            try {
                Workspace workspace = SoapUI.getWorkspace();
                Project project = this.findProject(projectFilePath, workspace);
                project = this.openProject(projectFilePath, workspace, project);
                this.showModelItem(project);
                this.bringToFront();
            }
            catch (Exception e) {
                SoapUI.logError(e);
            }
        }
    }

    public void openTestCase(String[] parameters) {
        if (!this.isValid(parameters)) {
            return;
        }
        String projectFilePath = parameters[0];
        String testSuiteName = parameters[1];
        String testCaseName = parameters[2];
        try {
            Workspace workspace = SoapUI.getWorkspace();
            Project project = this.findProject(projectFilePath, workspace);
            project = this.openProject(projectFilePath, workspace, project);
            TestSuite testSuite = project.getTestSuiteByName(testSuiteName);
            TestCase testCase = testSuite.getTestCaseByName(testCaseName);
            this.showModelItem(testCase);
            this.bringToFront();
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
    }

    public void bringToFront() {
        UISupport.getMainFrame().setVisible(true);
        UISupport.getMainFrame().setAlwaysOnTop(true);
        UISupport.getMainFrame().setAlwaysOnTop(false);
    }

    private Project openProject(String projectFilePath, Workspace workspace, Project project) throws SoapUIException {
        if (project != null) {
            if (!project.isOpen()) {
                project = workspace.openProject(project);
            }
        } else {
            project = workspace.importProject(projectFilePath);
        }
        if (project == null) {
            throw new SoapUIException("Cannot open project on path: " + projectFilePath);
        }
        return project;
    }

    private void showModelItem(ModelItem modelItem) throws SoapUIException {
        if (modelItem != null) {
            UISupport.selectAndShow(modelItem);
        }
    }

    private Project findProject(String projectFile, Workspace workspace) {
        Project project = null;
        List<? extends Project> projectList = workspace.getProjectList();
        for (Project project2 : projectList) {
            if (!project2.getPath().equalsIgnoreCase(projectFile)) continue;
            project = workspace.getProjectByName(project2.getName());
            break;
        }
        return project;
    }

    private boolean isValid(String[] parameters) {
        if (parameters != null && parameters.length == 3) {
            for (String parameter : parameters) {
                if (!StringUtils.isNullOrEmpty(parameter)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

