/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.monitor;

import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.model.mock.MockRunner;
import com.eviware.soapui.model.mock.MockService;
import com.eviware.soapui.model.project.Project;
import com.eviware.soapui.model.support.LoadTestRunListenerAdapter;
import com.eviware.soapui.model.support.MockRunListenerAdapter;
import com.eviware.soapui.model.support.ProjectListenerAdapter;
import com.eviware.soapui.model.support.TestRunListenerAdapter;
import com.eviware.soapui.model.support.TestSuiteListenerAdapter;
import com.eviware.soapui.model.support.WorkspaceListenerAdapter;
import com.eviware.soapui.model.testsuite.LoadTest;
import com.eviware.soapui.model.testsuite.LoadTestRunContext;
import com.eviware.soapui.model.testsuite.LoadTestRunner;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.model.testsuite.TestCaseRunContext;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestRunner;
import com.eviware.soapui.model.testsuite.TestSuite;
import com.eviware.soapui.model.workspace.Workspace;
import com.eviware.soapui.monitor.TestMonitorListener;
import com.eviware.soapui.security.SecurityTest;
import com.eviware.soapui.security.SecurityTestRunContext;
import com.eviware.soapui.security.SecurityTestRunner;
import com.eviware.soapui.security.SecurityTestRunnerImpl;
import com.eviware.soapui.security.support.SecurityTestRunListenerAdapter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class TestMonitor {
    private Set<TestMonitorListener> listeners = new HashSet<TestMonitorListener>();
    private InternalWorkspaceListener workspaceListener = new InternalWorkspaceListener();
    private InternalProjectListener projectListener = new InternalProjectListener();
    private InternalTestSuiteListener testSuiteListener = new InternalTestSuiteListener();
    private InternalTestRunListener testRunListener = new InternalTestRunListener();
    private InternalMockRunListener mockRunListener = new InternalMockRunListener();
    private InternalLoadTestRunListener loadTestRunListener = new InternalLoadTestRunListener();
    private InternalSecurityTestRunListener securityTestRunListener = new InternalSecurityTestRunListener();
    private Set<TestCaseRunner> runningTestCases = new HashSet<TestCaseRunner>();
    private Set<LoadTestRunner> runningLoadTests = new HashSet<LoadTestRunner>();
    private Set<SecurityTestRunner> runningSecurityTests = new HashSet<SecurityTestRunner>();
    private Set<MockRunner> runningMockServices = new HashSet<MockRunner>();
    private Map<String, TestRunner.Status> runStatusHistory = new HashMap<String, TestRunner.Status>();

    public TestRunner.Status getLastRunStatus(TestCase testCase) {
        return this.runStatusHistory.get(testCase.getId());
    }

    protected void notifyLoadTestStarted(LoadTestRunner runner) {
        this.runningLoadTests.add(runner);
        if (this.listeners.isEmpty()) {
            return;
        }
        TestMonitorListener[] l = this.listeners.toArray(new TestMonitorListener[this.listeners.size()]);
        for (int c = 0; c < l.length; ++c) {
            l[c].loadTestStarted(runner);
        }
    }

    protected void notifySecurityTestStarted(SecurityTestRunner runner) {
        this.runningSecurityTests.add(runner);
        if (this.listeners.isEmpty()) {
            return;
        }
        TestMonitorListener[] l = this.listeners.toArray(new TestMonitorListener[this.listeners.size()]);
        for (int c = 0; c < l.length; ++c) {
            l[c].securityTestStarted(runner);
        }
    }

    protected void notifySecurityTestFinished(SecurityTestRunner runner) {
        if (this.listeners.isEmpty()) {
            return;
        }
        TestMonitorListener[] l = this.listeners.toArray(new TestMonitorListener[this.listeners.size()]);
        for (int c = 0; c < l.length; ++c) {
            l[c].securityTestFinished(runner);
        }
    }

    protected void notifyLoadTestFinished(LoadTestRunner runner) {
        if (this.listeners.isEmpty()) {
            return;
        }
        TestMonitorListener[] l = this.listeners.toArray(new TestMonitorListener[this.listeners.size()]);
        for (int c = 0; c < l.length; ++c) {
            l[c].loadTestFinished(runner);
        }
    }

    protected void notifyTestCaseStarted(TestCaseRunner runner) {
        if (this.listeners.isEmpty()) {
            return;
        }
        TestMonitorListener[] l = this.listeners.toArray(new TestMonitorListener[this.listeners.size()]);
        for (int c = 0; c < l.length; ++c) {
            l[c].testCaseStarted(runner);
        }
    }

    protected void notifyTestCaseFinished(TestCaseRunner runner) {
        if (this.listeners.isEmpty()) {
            return;
        }
        TestMonitorListener[] l = this.listeners.toArray(new TestMonitorListener[this.listeners.size()]);
        for (int c = 0; c < l.length; ++c) {
            l[c].testCaseFinished(runner);
        }
    }

    protected void notifyMockServiceStarted(MockRunner runner) {
        if (this.listeners.isEmpty()) {
            return;
        }
        TestMonitorListener[] l = this.listeners.toArray(new TestMonitorListener[this.listeners.size()]);
        for (int c = 0; c < l.length; ++c) {
            l[c].mockServiceStarted(runner);
        }
    }

    protected void notifyMockServiceStopped(MockRunner runner) {
        if (this.listeners.isEmpty()) {
            return;
        }
        TestMonitorListener[] l = this.listeners.toArray(new TestMonitorListener[this.listeners.size()]);
        for (int c = 0; c < l.length; ++c) {
            l[c].mockServiceStopped(runner);
        }
    }

    public boolean hasRunningLoadTest(TestCase testCase) {
        Iterator<LoadTestRunner> iterator = this.runningLoadTests.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getLoadTest().getTestCase() != testCase) continue;
            return true;
        }
        return false;
    }

    public boolean hasRunningTestCase(TestCase testCase) {
        Iterator<TestCaseRunner> iterator = this.runningTestCases.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getTestCase() != testCase) continue;
            return true;
        }
        return false;
    }

    public void addTestMonitorListener(TestMonitorListener listener) {
        this.listeners.add(listener);
    }

    public void removeTestMonitorListener(TestMonitorListener listener) {
        this.listeners.remove(listener);
    }

    public LoadTestRunner[] getRunningLoadTest() {
        return this.runningLoadTests.toArray(new LoadTestRunner[this.runningLoadTests.size()]);
    }

    public boolean hasRunningTest(TestCase testCase) {
        return this.hasRunningLoadTest(testCase) || this.hasRunningSecurityTest(testCase) || this.hasRunningTestCase(testCase);
    }

    public void init(Workspace workspace) {
        for (int c = 0; c < workspace.getProjectCount(); ++c) {
            Project project = workspace.getProjectAt(c);
            this.monitorProject(project);
        }
        workspace.addWorkspaceListener(this.workspaceListener);
    }

    public void monitorProject(Project project) {
        int i;
        project.addProjectListener(this.projectListener);
        for (i = 0; i < project.getTestSuiteCount(); ++i) {
            this.monitorTestSuite(project.getTestSuiteAt(i));
        }
        for (i = 0; i < project.getMockServiceCount(); ++i) {
            this.monitorMockService(project.getMockServiceAt(i));
        }
    }

    private void monitorMockService(MockService mockService) {
        mockService.addMockRunListener(this.mockRunListener);
    }

    private void monitorTestSuite(TestSuite testSuite) {
        testSuite.addTestSuiteListener(this.testSuiteListener);
        for (int j = 0; j < testSuite.getTestCaseCount(); ++j) {
            this.monitorTestCase(testSuite.getTestCaseAt(j));
        }
    }

    private void monitorTestCase(TestCase testCase) {
        int v;
        testCase.addTestRunListener(this.testRunListener);
        for (v = 0; v < testCase.getLoadTestCount(); ++v) {
            testCase.getLoadTestAt(v).addLoadTestRunListener(this.loadTestRunListener);
        }
        for (v = 0; v < testCase.getSecurityTestCount(); ++v) {
            testCase.getSecurityTestAt(v).addSecurityTestRunListener(this.securityTestRunListener);
        }
    }

    private void monitorLoadTest(LoadTest loadTest) {
        loadTest.addLoadTestRunListener(this.loadTestRunListener);
    }

    private void monitorSecurityTest(SecurityTest securityTest) {
        securityTest.addSecurityTestRunListener(this.securityTestRunListener);
    }

    public void unmonitorProject(Project project) {
        int c;
        project.removeProjectListener(this.projectListener);
        for (c = 0; c < project.getTestSuiteCount(); ++c) {
            TestSuite testSuite = project.getTestSuiteAt(c);
            this.unmonitorTestSuite(testSuite);
        }
        for (c = 0; c < project.getMockServiceCount(); ++c) {
            this.unmonitorMockService(project.getMockServiceAt(c));
        }
    }

    private void unmonitorMockService(MockService mockService) {
        mockService.removeMockRunListener(this.mockRunListener);
    }

    private void unmonitorTestSuite(TestSuite testSuite) {
        testSuite.removeTestSuiteListener(this.testSuiteListener);
        for (int j = 0; j < testSuite.getTestCaseCount(); ++j) {
            TestCase testCase = testSuite.getTestCaseAt(j);
            this.unmonitorTestCase(testCase);
        }
    }

    private void unmonitorTestCase(TestCase testCase) {
        int c;
        testCase.removeTestRunListener(this.testRunListener);
        for (c = 0; c < testCase.getLoadTestCount(); ++c) {
            this.unmonitorLoadTest(testCase.getLoadTestAt(c));
        }
        for (c = 0; c < testCase.getSecurityTestCount(); ++c) {
            this.unmonitorSecurityTest(testCase.getSecurityTestAt(c));
        }
    }

    private void unmonitorLoadTest(LoadTest loadTest) {
        loadTest.removeLoadTestRunListener(this.loadTestRunListener);
    }

    private void unmonitorSecurityTest(SecurityTest securityTest) {
        securityTest.removeSecurityTestRunListener(this.securityTestRunListener);
    }

    public boolean hasRunningTests() {
        return this.runningLoadTests.size() + this.runningTestCases.size() > 0;
    }

    public boolean hasRunningMock(MockService mockService) {
        for (MockRunner runner : this.runningMockServices) {
            if (runner.getMockService() != mockService) continue;
            return true;
        }
        return false;
    }

    public boolean hasRunningTests(WsdlProject project) {
        for (TestCaseRunner testRunner : this.runningTestCases) {
            if (testRunner.getTestCase().getTestSuite().getProject() != project) continue;
            return true;
        }
        for (LoadTestRunner loadTestRunner : this.runningLoadTests) {
            if (loadTestRunner.getLoadTest().getTestCase().getTestSuite().getProject() != project) continue;
            return true;
        }
        return false;
    }

    public void cancelAllTests(String reason) {
        for (TestCaseRunner testRunner : this.runningTestCases) {
            testRunner.cancel(reason);
        }
        for (LoadTestRunner loadTestRunner : this.runningLoadTests) {
            loadTestRunner.cancel(reason);
        }
        for (MockRunner mockRunner : this.runningMockServices) {
            mockRunner.stop();
        }
    }

    public TestCaseRunner getTestRunner(WsdlTestCase testCase) {
        for (TestCaseRunner testRunner : this.runningTestCases) {
            if (testRunner.getTestCase() != testCase) continue;
            return testRunner;
        }
        return null;
    }

    public boolean hasRunningLoadTest(TestSuite testSuite) {
        for (TestCase testCase : testSuite.getTestCaseList()) {
            if (!this.hasRunningLoadTest(testCase)) continue;
            return true;
        }
        return false;
    }

    public boolean hasRunningSecurityTest(TestCase testCase) {
        Iterator<SecurityTestRunner> iterator = this.runningSecurityTests.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getSecurityTest().getTestCase() != testCase) continue;
            return true;
        }
        return false;
    }

    public boolean hasRunningSecurityTest(TestSuite testSuite) {
        for (TestCase testCase : testSuite.getTestCaseList()) {
            if (!this.hasRunningSecurityTest(testCase)) continue;
            return true;
        }
        return false;
    }

    private class InternalSecurityTestRunListener
    extends SecurityTestRunListenerAdapter {
        private InternalSecurityTestRunListener() {
        }

        public void afterRun(TestCaseRunner testRunner, SecurityTestRunContext context) {
            TestMonitor.this.runningSecurityTests.remove((SecurityTestRunnerImpl)testRunner);
            TestMonitor.this.notifySecurityTestFinished((SecurityTestRunnerImpl)testRunner);
        }

        public void beforeRun(TestCaseRunner testRunner, SecurityTestRunContext context) {
            TestMonitor.this.runningSecurityTests.add((SecurityTestRunnerImpl)testRunner);
            TestMonitor.this.notifySecurityTestStarted((SecurityTestRunnerImpl)testRunner);
        }
    }

    private class InternalLoadTestRunListener
    extends LoadTestRunListenerAdapter {
        private InternalLoadTestRunListener() {
        }

        public void afterLoadTest(LoadTestRunner testRunner, LoadTestRunContext context) {
            TestMonitor.this.runningLoadTests.remove(testRunner);
            TestMonitor.this.notifyLoadTestFinished(testRunner);
        }

        public void beforeLoadTest(LoadTestRunner testRunner, LoadTestRunContext context) {
            TestMonitor.this.runningLoadTests.add(testRunner);
            TestMonitor.this.notifyLoadTestStarted(testRunner);
        }
    }

    private class InternalMockRunListener
    extends MockRunListenerAdapter {
        private InternalMockRunListener() {
        }

        public void onMockRunnerStart(MockRunner mockRunner) {
            TestMonitor.this.runningMockServices.add(mockRunner);
            TestMonitor.this.notifyMockServiceStarted(mockRunner);
        }

        public void onMockRunnerStop(MockRunner mockRunner) {
            TestMonitor.this.runningMockServices.remove(mockRunner);
            TestMonitor.this.notifyMockServiceStopped(mockRunner);
        }
    }

    private class InternalTestRunListener
    extends TestRunListenerAdapter {
        private InternalTestRunListener() {
        }

        public void afterRun(TestCaseRunner testRunner, TestCaseRunContext runContext) {
            TestMonitor.this.runStatusHistory.put(testRunner.getTestCase().getId(), testRunner.getStatus());
            TestMonitor.this.runningTestCases.remove(testRunner);
            TestMonitor.this.notifyTestCaseFinished(testRunner);
        }

        public void beforeRun(TestCaseRunner testRunner, TestCaseRunContext runContext) {
            TestMonitor.this.runningTestCases.add(testRunner);
            TestMonitor.this.notifyTestCaseStarted(testRunner);
        }
    }

    private class InternalTestSuiteListener
    extends TestSuiteListenerAdapter {
        private InternalTestSuiteListener() {
        }

        public void testCaseAdded(TestCase testCase) {
            TestMonitor.this.monitorTestCase(testCase);
        }

        public void testCaseRemoved(TestCase testCase) {
            TestMonitor.this.unmonitorTestCase(testCase);
        }

        public void loadTestAdded(LoadTest loadTest) {
            TestMonitor.this.monitorLoadTest(loadTest);
        }

        public void loadTestRemoved(LoadTest loadTest) {
            TestMonitor.this.unmonitorLoadTest(loadTest);
        }

        public void securityTestAdded(SecurityTest securityTest) {
            TestMonitor.this.monitorSecurityTest(securityTest);
        }

        public void securityTestRemoved(SecurityTest securityTest) {
            TestMonitor.this.unmonitorSecurityTest(securityTest);
        }
    }

    private class InternalProjectListener
    extends ProjectListenerAdapter {
        private InternalProjectListener() {
        }

        public void testSuiteRemoved(TestSuite testSuite) {
            TestMonitor.this.unmonitorTestSuite(testSuite);
        }

        public void testSuiteAdded(TestSuite testSuite) {
            TestMonitor.this.monitorTestSuite(testSuite);
        }

        public void mockServiceAdded(MockService mockService) {
            TestMonitor.this.monitorMockService(mockService);
        }

        public void mockServiceRemoved(MockService mockService) {
            TestMonitor.this.unmonitorMockService(mockService);
        }
    }

    private class InternalWorkspaceListener
    extends WorkspaceListenerAdapter {
        private InternalWorkspaceListener() {
        }

        public void projectRemoved(Project project) {
            TestMonitor.this.unmonitorProject(project);
        }

        public void projectAdded(Project project) {
            TestMonitor.this.monitorProject(project);
        }
    }
}

