/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.security.actions;

import com.eviware.soapui.security.SecurityTest;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.x.form.XForm;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormDialogBuilder;
import com.eviware.x.form.XFormFactory;
import com.eviware.x.form.XFormField;
import com.eviware.x.form.XFormFieldListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityTestOptionsAction
extends AbstractSoapUIAction<SecurityTest> {
    private static final String FAIL_ON_ERROR = "Abort on Error";
    private static final String FAIL_SECURITYTEST_ON_ERROR = "Fail SecurityTest on Error";
    public static final String SOAPUI_ACTION_ID = "SecurityTestOptionsAction";
    private XFormDialog dialog;
    private XForm form;

    public SecurityTestOptionsAction() {
        super("Options", "Sets options for this SecurityTest");
    }

    @Override
    public void perform(SecurityTest securityTest, Object param) {
        if (this.dialog == null) {
            XFormDialogBuilder builder = XFormFactory.createDialogBuilder("SecurityTest Options");
            this.form = builder.createForm("Basic");
            this.form.addCheckBox(FAIL_ON_ERROR, "Fail on error").addFormFieldListener(new XFormFieldListener(){

                public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                    SecurityTestOptionsAction.this.form.getFormField(SecurityTestOptionsAction.FAIL_SECURITYTEST_ON_ERROR).setEnabled(!Boolean.parseBoolean(newValue));
                }
            });
            this.form.addCheckBox(FAIL_SECURITYTEST_ON_ERROR, "Fail SecurityTest if it has failed TestSteps");
            this.dialog = builder.buildDialog(builder.buildOkCancelHelpActions("http://www.soapui.org/Security/working-with-security-tests.html"), "Specify general options for this SecurityTest", UISupport.OPTIONS_ICON);
        }
        StringToStringMap values = new StringToStringMap();
        values.put(FAIL_ON_ERROR, String.valueOf(securityTest.getFailOnError()));
        values.put(FAIL_SECURITYTEST_ON_ERROR, String.valueOf(securityTest.getFailSecurityTestOnScanErrors()));
        values = this.dialog.show(values);
        if (this.dialog.getReturnValue() == 1) {
            try {
                securityTest.setFailOnError(Boolean.parseBoolean((String)values.get(FAIL_ON_ERROR)));
                securityTest.setFailSecurityTestOnScanErrors(Boolean.parseBoolean((String)values.get(FAIL_SECURITYTEST_ON_ERROR)));
            }
            catch (Exception e1) {
                UISupport.showErrorMessage(e1.getMessage());
            }
        }
    }
}

