/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.security.assertion;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.TestAssertionConfig;
import com.eviware.soapui.impl.support.AbstractHttpRequest;
import com.eviware.soapui.impl.wsdl.panels.assertions.AssertionListEntry;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlMessageAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.AbstractTestAssertionFactory;
import com.eviware.soapui.model.TestPropertyHolder;
import com.eviware.soapui.model.iface.MessageExchange;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.security.SecurityScan;
import com.eviware.soapui.model.testsuite.Assertable;
import com.eviware.soapui.model.testsuite.AssertionError;
import com.eviware.soapui.model.testsuite.AssertionException;
import com.eviware.soapui.model.testsuite.ResponseAssertion;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.xml.XmlObjectConfigurationBuilder;
import com.eviware.soapui.support.xml.XmlObjectConfigurationReader;
import com.eviware.x.form.XForm;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormDialogBuilder;
import com.eviware.x.form.XFormFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.xmlbeans.XmlObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvalidHttpStatusCodesAssertion
extends WsdlMessageAssertion
implements ResponseAssertion {
    public static final String ID = "Invalid HTTP Status Codes";
    public static final String LABEL = "Invalid HTTP Status Codes";
    private String codes;
    private XFormDialog dialog;
    private static final String CODES = "codes";
    public static final String DESCRIPTION = "Checks that the target TestStep received an HTTP result with a status code not in the list of defined codes. Applicable to any TestStep that receives HTTP messages.";

    public InvalidHttpStatusCodesAssertion(TestAssertionConfig assertionConfig, Assertable assertable) {
        super(assertionConfig, assertable, false, true, false, false);
        this.init();
    }

    private void init() {
        XmlObjectConfigurationReader reader = new XmlObjectConfigurationReader(this.getConfiguration());
        this.codes = reader.readString(CODES, "");
    }

    @Override
    protected String internalAssertResponse(MessageExchange messageExchange, SubmitContext context) throws AssertionException {
        List<String> codeList = this.extractCodes(context);
        String[] statusElements = null;
        try {
            statusElements = messageExchange.getResponseHeaders().get("#status#", "-1").split(" ");
        }
        catch (NullPointerException npe) {
            SoapUI.logError(npe, "Header #status# is missing!");
        }
        if (statusElements.length >= 2) {
            String statusCode = statusElements[1].trim();
            if (codeList.contains(statusCode)) {
                String message = "Response status code: " + statusCode + " is in invalid list of status codes";
                throw new AssertionException(new AssertionError(message));
            }
        } else {
            throw new AssertionException(new AssertionError("Status code extraction error! "));
        }
        return "OK";
    }

    @Override
    protected String internalAssertProperty(TestPropertyHolder source, String propertyName, MessageExchange messageExchange, SubmitContext context) throws AssertionException {
        return null;
    }

    private List<String> extractCodes(SubmitContext context) {
        String expandedCodes = context.expand(this.codes);
        ArrayList<String> codeList = new ArrayList<String>();
        for (String str : expandedCodes.split(",")) {
            codeList.add(str.trim());
        }
        return codeList;
    }

    @Override
    protected String internalAssertRequest(MessageExchange messageExchange, SubmitContext context) throws AssertionException {
        return null;
    }

    protected XmlObject createConfiguration() {
        XmlObjectConfigurationBuilder builder = new XmlObjectConfigurationBuilder();
        builder.add(CODES, this.codes);
        return builder.finish();
    }

    @Override
    public boolean configure() {
        if (this.dialog == null) {
            this.buildDialog();
        }
        StringToStringMap values = new StringToStringMap();
        values.put(CODES, this.codes);
        values = this.dialog.show(values);
        if (this.dialog.getReturnValue() == 1) {
            this.codes = (String)values.get(CODES);
        }
        this.setConfiguration(this.createConfiguration());
        return true;
    }

    private void buildDialog() {
        XFormDialogBuilder builder = XFormFactory.createDialogBuilder("Invalid HTTP status codes Assertion");
        XForm mainForm = builder.createForm("Basic");
        mainForm.addTextField(CODES, "Comma-separated not acceptable status codes", XForm.FieldType.TEXTAREA).setWidth(40);
        this.dialog = builder.buildDialog(builder.buildOkCancelHelpActions("http://www.soapui.org/Security/security-scans-overview.html#3-1-invalid-http-codes"), "Specify codes", UISupport.OPTIONS_ICON);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    extends AbstractTestAssertionFactory {
        public Factory() {
            super("Invalid HTTP Status Codes", "Invalid HTTP Status Codes", InvalidHttpStatusCodesAssertion.class, new Class[]{SecurityScan.class, AbstractHttpRequest.class});
        }

        @Override
        public String getCategory() {
            return "Compliance, Status and Standards";
        }

        @Override
        public Class<? extends WsdlMessageAssertion> getAssertionClassType() {
            return InvalidHttpStatusCodesAssertion.class;
        }

        @Override
        public AssertionListEntry getAssertionListEntry() {
            return new AssertionListEntry("Invalid HTTP Status Codes", "Invalid HTTP Status Codes", InvalidHttpStatusCodesAssertion.DESCRIPTION);
        }
    }
}

